/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateDataLanguageConfigurable;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TemplateLanguageErrorQuickFixProvider
implements ErrorQuickFixProvider {
    @Override
    public void registerErrorQuickFix(@NotNull PsiErrorElement errorElement, @NotNull HighlightInfo highlightInfo) {
        PsiFile psiFile;
        FileViewProvider provider2;
        if (errorElement == null) {
            TemplateLanguageErrorQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (highlightInfo == null) {
            TemplateLanguageErrorQuickFixProvider.$$$reportNull$$$0(1);
        }
        if (!((provider2 = (psiFile = errorElement.getContainingFile()).getViewProvider()) instanceof TemplateLanguageFileViewProvider)) {
            return;
        }
        if (psiFile.getLanguage() != ((TemplateLanguageFileViewProvider)provider2).getTemplateDataLanguage()) {
            return;
        }
        QuickFixAction.registerQuickFixAction(highlightInfo, TemplateLanguageErrorQuickFixProvider.createChangeTemplateDataLanguageFix((PsiElement)errorElement));
    }

    public static IntentionAction createChangeTemplateDataLanguageFix(PsiElement errorElement) {
        PsiFile containingFile = errorElement.getContainingFile();
        final VirtualFile virtualFile2 = containingFile.getVirtualFile();
        final Language language = ((TemplateLanguageFileViewProvider)containingFile.getViewProvider()).getTemplateDataLanguage();
        return new IntentionAction(){

            @NotNull
            @Nls
            public String getText() {
                String string = LangBundle.message((String)"quickfix.change.template.data.language.text", (Object[])new Object[]{language.getDisplayName()});
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = this.getText();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                return true;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
                if (project == null) {
                    1.$$$reportNull$$$0(3);
                }
                TemplateDataLanguageConfigurable configurable2 = new TemplateDataLanguageConfigurable(project);
                ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable2, () -> {
                    if (virtualFile2 != null) {
                        configurable2.selectFile(virtualFile2);
                    }
                });
            }

            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/templateLanguages/TemplateLanguageErrorQuickFixProvider$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/templateLanguages/TemplateLanguageErrorQuickFixProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "errorElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "highlightInfo";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/templateLanguages/TemplateLanguageErrorQuickFixProvider";
        objectArray[2] = "registerErrorQuickFix";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

