/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.CodeFragmentTableCellEditorBase;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.DelegationPanel;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeSignatureDialogBase<ParamInfo extends ParameterInfo, Method extends PsiElement, Visibility, Descriptor extends MethodDescriptor<ParamInfo, Visibility>, ParameterTableModelItem extends ParameterTableModelItemBase<ParamInfo>, ParameterTableModel extends ParameterTableModelBase<ParamInfo, ParameterTableModelItem>>
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance(ChangeSignatureDialogBase.class);
    protected static final String EXIT_SILENTLY = "";
    protected final Descriptor myMethod;
    private final boolean myAllowDelegation;
    protected JPanel myNamePanel;
    protected EditorTextField myNameField;
    protected EditorTextField myReturnTypeField;
    protected JBListTable myParametersList;
    protected TableView<ParameterTableModelItem> myParametersTable;
    protected final ParameterTableModel myParametersTableModel;
    protected final UpdateSignatureListener mySignatureUpdater;
    private MethodSignatureComponent mySignatureArea;
    private final Alarm myUpdateSignatureAlarm;
    protected VisibilityPanelBase<Visibility> myVisibilityPanel;
    @Nullable
    protected PsiCodeFragment myReturnTypeCodeFragment;
    private DelegationPanel myDelegationPanel;
    protected AnActionButton myPropagateParamChangesButton;
    protected Set<Method> myMethodsToPropagateParameters;
    private Tree myParameterPropagationTreeToReuse;
    protected final PsiElement myDefaultValueContext;

    protected abstract LanguageFileType getFileType();

    @NotNull
    protected abstract ParameterTableModel createParametersInfoModel(@NotNull Descriptor var1);

    protected abstract BaseRefactoringProcessor createRefactoringProcessor();

    protected abstract PsiCodeFragment createReturnTypeCodeFragment();

    @Nullable
    protected abstract CallerChooserBase<Method> createCallerChooser(@Nls String var1, Tree var2, Consumer<Set<Method>> var3);

    @Nullable
    @NlsContexts.DialogMessage
    protected abstract String validateAndCommitData();

    protected abstract String calculateSignature();

    protected abstract VisibilityPanelBase<Visibility> createVisibilityControl();

    public ChangeSignatureDialogBase(@NotNull Project project, @NotNull Descriptor method2, boolean allowDelegation, PsiElement defaultValueContext) {
        if (project == null) {
            ChangeSignatureDialogBase.$$$reportNull$$$0(0);
        }
        if (method2 == null) {
            ChangeSignatureDialogBase.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.mySignatureUpdater = new UpdateSignatureListener();
        this.myUpdateSignatureAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myMethodsToPropagateParameters = null;
        this.myMethod = method2;
        this.myDefaultValueContext = defaultValueContext;
        this.myParametersTableModel = this.createParametersInfoModel(method2);
        this.myAllowDelegation = allowDelegation;
        this.setParameterInfos(method2.getParameters());
        this.setTitle(RefactoringBundle.message((String)"changeSignature.refactoring.name"));
        this.init();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        this.doUpdateSignature();
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ChangeSignatureDialogBase.this.myUpdateSignatureAlarm.cancelAllRequests();
            }
        });
    }

    public void setParameterInfos(@NotNull List<? extends ParamInfo> parameterInfos) {
        if (parameterInfos == null) {
            ChangeSignatureDialogBase.$$$reportNull$$$0(2);
        }
        ((ParameterTableModelBase)((Object)this.myParametersTableModel)).setParameterInfos(parameterInfos);
        this.updateSignature();
    }

    protected String getMethodName() {
        if (this.myNameField != null) {
            return this.myNameField.getText().trim();
        }
        return this.myMethod.getName();
    }

    @Nullable
    protected Visibility getVisibility() {
        if (this.myVisibilityPanel != null) {
            return this.myVisibilityPanel.getVisibility();
        }
        return (Visibility)this.myMethod.getVisibility();
    }

    public List<ParamInfo> getParameters() {
        ArrayList<ParameterInfo> result2 = new ArrayList<ParameterInfo>(this.myParametersTableModel.getRowCount());
        for (ParameterTableModelItemBase item : this.myParametersTableModel.getItems()) {
            result2.add((ParameterInfo)item.parameter);
        }
        return result2;
    }

    public boolean isGenerateDelegate() {
        return this.myAllowDelegation && this.myDelegationPanel.isGenerateDelegate();
    }

    public JComponent getPreferredFocusedComponent() {
        JBTable table = this.getTableComponent();
        if (table != null && table.getRowCount() > 0) {
            if (table.getColumnModel().getSelectedColumnCount() == 0) {
                int selectedIdx = this.getSelectedIdx();
                table.getSelectionModel().setSelectionInterval(selectedIdx, selectedIdx);
                table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
            }
            return table;
        }
        if (UIUtil.isFocusable((Component)((Object)this.myNameField))) {
            return this.myNameField;
        }
        if (UIUtil.isFocusable((Component)((Object)this.myReturnTypeField))) {
            return this.myReturnTypeField;
        }
        return super.getPreferredFocusedComponent();
    }

    protected int getSelectedIdx() {
        return 0;
    }

    protected JBTable getTableComponent() {
        return this.myParametersList == null ? this.myParametersTable : this.myParametersList.getTable();
    }

    public boolean placeReturnTypeBeforeName() {
        return true;
    }

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.myNamePanel = new JPanel(new BorderLayout(0, 2));
        this.myNameField = new EditorTextField(this.myMethod.getName());
        JLabel nameLabel = new JLabel(RefactoringBundle.message((String)"changeSignature.name.prompt"));
        nameLabel.setLabelFor((Component)((Object)this.myNameField));
        this.myNameField.setEnabled(this.myMethod.canChangeName());
        if (this.myMethod.canChangeName()) {
            this.myNameField.addDocumentListener(this.mySignatureUpdater);
            this.myNameField.setPreferredWidth(200);
        }
        this.myNamePanel.add((Component)nameLabel, "North");
        this.myNamePanel.add((Component)((Object)this.myNameField), "South");
        JPanel visibilityPanel = this.createVisibilityPanel();
        if (this.myMethod.canChangeVisibility() && this.myVisibilityPanel instanceof ComboBoxVisibilityPanel) {
            ((ComboBoxVisibilityPanel)this.myVisibilityPanel).registerUpDownActionsFor((JComponent)((Object)this.myNameField));
            visibilityPanel.setBorder(new EmptyBorder(0, 0, 0, 8));
            panel2.add((Component)visibilityPanel, gbc);
            ++gbc.gridx;
        }
        gbc.weightx = 1.0;
        if (this.myMethod.canChangeReturnType() != MethodDescriptor.ReadWriteOption.None) {
            JPanel typePanel = new JPanel(new BorderLayout(0, 2));
            typePanel.setBorder(new EmptyBorder(0, 0, 0, 8));
            JLabel typeLabel = new JLabel(RefactoringBundle.message((String)"changeSignature.return.type.prompt"));
            this.myReturnTypeCodeFragment = this.createReturnTypeCodeFragment();
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)this.myReturnTypeCodeFragment);
            this.myReturnTypeField = this.createReturnTypeTextField(document);
            ((ComboBoxVisibilityPanel)this.myVisibilityPanel).registerUpDownActionsFor((JComponent)((Object)this.myReturnTypeField));
            typeLabel.setLabelFor((Component)((Object)this.myReturnTypeField));
            if (this.myMethod.canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite) {
                this.myReturnTypeField.setPreferredWidth(200);
                this.myReturnTypeField.addDocumentListener(this.mySignatureUpdater);
            } else {
                this.myReturnTypeField.setEnabled(false);
            }
            typePanel.add((Component)typeLabel, "North");
            typePanel.add((Component)((Object)this.myReturnTypeField), "South");
            if (this.placeReturnTypeBeforeName()) {
                panel2.add((Component)typePanel, gbc);
                ++gbc.gridx;
                panel2.add((Component)this.myNamePanel, gbc);
            } else {
                panel2.add((Component)this.myNamePanel, gbc);
                ++gbc.gridx;
                panel2.add((Component)typePanel, gbc);
            }
        } else {
            panel2.add((Component)this.myNamePanel, gbc);
        }
        return panel2;
    }

    protected EditorTextField createReturnTypeTextField(Document document) {
        return new EditorTextField(document, this.myProject, (FileType)this.getFileType());
    }

    private DelegationPanel createDelegationPanel() {
        return new DelegationPanel(){

            @Override
            protected void stateModified() {
                ChangeSignatureDialogBase.this.myParametersTableModel.fireTableDataChanged();
                ChangeSignatureDialogBase.this.myParametersTable.repaint();
            }
        };
    }

    protected JComponent createCenterPanel() {
        JPanel main2;
        JPanel panel2 = new JPanel(new BorderLayout());
        JComponent optionsPanel = this.createOptionsPanel();
        JPanel subPanel = new JPanel(new BorderLayout());
        List<Pair<@NlsContexts.TabTitle String, JPanel>> panels = this.createAdditionalPanels();
        if (this.myMethod.canChangeParameters()) {
            JPanel parametersPanel = this.createParametersPanel(!panels.isEmpty());
            if (!panels.isEmpty()) {
                parametersPanel.setBorder((Border)JBUI.Borders.empty());
            }
            subPanel.add((Component)parametersPanel, "Center");
        }
        if (this.myMethod.canChangeVisibility() && !(this.myVisibilityPanel instanceof ComboBoxVisibilityPanel)) {
            subPanel.add(this.myVisibilityPanel, this.myMethod.canChangeParameters() ? "East" : "Center");
        }
        panel2.add((Component)subPanel, "Center");
        if (panels.isEmpty()) {
            main2 = panel2;
        } else {
            TabbedPaneWrapper tabbedPane = new TabbedPaneWrapper(this.getDisposable());
            tabbedPane.addTab(RefactoringBundle.message((String)"parameters.border.title"), panel2);
            for (Pair<String, JPanel> extraPanel : panels) {
                tabbedPane.addTab((String)extraPanel.first, (JComponent)extraPanel.second);
            }
            main2 = new JPanel(new BorderLayout());
            JComponent tabs2 = tabbedPane.getComponent();
            main2.add((Component)tabs2, "Center");
            for (JComponent c : UIUtil.findComponentsOfType((JComponent)tabs2, JComponent.class)) {
                c.setFocusCycleRoot(false);
                c.setFocusTraversalPolicy(null);
            }
        }
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.add((Component)optionsPanel, "North");
        bottom.add((Component)this.createSignaturePanel(), "South");
        main2.add((Component)bottom, "South");
        main2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        return main2;
    }

    protected JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        if (this.myAllowDelegation) {
            this.myDelegationPanel = this.createDelegationPanel();
            panel2.add((Component)this.myDelegationPanel, "West");
        }
        this.myPropagateParamChangesButton = new AnActionButton(RefactoringBundle.message((String)"changeSignature.propagate.parameters.title"), null, AllIcons.Hierarchy.Supertypes){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                Ref chooser2 = new Ref();
                Consumer callback2 = callers -> {
                    ChangeSignatureDialogBase.this.myMethodsToPropagateParameters = callers;
                    ChangeSignatureDialogBase.this.myParameterPropagationTreeToReuse = ((CallerChooserBase)((Object)((Object)chooser2.get()))).getTree();
                };
                try {
                    String message2 = RefactoringBundle.message((String)"changeSignature.parameter.caller.chooser");
                    chooser2.set(ChangeSignatureDialogBase.this.createCallerChooser(message2, ChangeSignatureDialogBase.this.myParameterPropagationTreeToReuse, callback2));
                }
                catch (ProcessCanceledException ex) {
                    return;
                }
                ((CallerChooserBase)((Object)chooser2.get())).show();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/changeSignature/ChangeSignatureDialogBase$3", "actionPerformed"));
            }
        };
        JPanel result2 = new JPanel((LayoutManager)new VerticalFlowLayout(0));
        result2.add(panel2);
        return result2;
    }

    protected JPanel createVisibilityPanel() {
        this.myVisibilityPanel = this.createVisibilityControl();
        this.myVisibilityPanel.setVisibility(this.myMethod.getVisibility());
        this.myVisibilityPanel.addListener(this.mySignatureUpdater);
        return this.myVisibilityPanel;
    }

    protected @NotNull List<Pair<@NlsContexts.TabTitle String, JPanel>> createAdditionalPanels() {
        List<Pair<String, JPanel>> list2 = Collections.emptyList();
        if (list2 == null) {
            ChangeSignatureDialogBase.$$$reportNull$$$0(3);
        }
        return list2;
    }

    protected String getDimensionServiceKey() {
        return "refactoring.ChangeSignatureDialog";
    }

    protected boolean isListTableViewSupported() {
        return false;
    }

    protected JPanel createParametersPanel(boolean hasTabsInDialog) {
        this.myParametersTable = new TableView<ParameterTableModelItem>((ListTableModel)this.myParametersTableModel){

            public void removeEditor() {
                this.clearEditorListeners();
                super.removeEditor();
            }

            public void editingStopped(ChangeEvent e) {
                super.editingStopped(e);
                this.repaint();
            }

            private void clearEditorListeners() {
                TableCellEditor editor = this.getCellEditor();
                if (editor instanceof StringTableCellEditor) {
                    StringTableCellEditor ed = (StringTableCellEditor)editor;
                    ed.clearListeners();
                } else if (editor instanceof CodeFragmentTableCellEditorBase) {
                    ((CodeFragmentTableCellEditorBase)editor).clearListeners();
                }
            }

            public Component prepareEditor(TableCellEditor editor, final int row2, final int column2) {
                DocumentListener listener2 = new DocumentListener(){

                    public void documentChanged(@NotNull DocumentEvent e) {
                        TableCellEditor ed;
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((ed = ChangeSignatureDialogBase.this.myParametersTable.getCellEditor()) != null) {
                            Object editorValue = ed.getCellEditorValue();
                            ((ParameterTableModelBase)((Object)ChangeSignatureDialogBase.this.myParametersTableModel)).setValueAtWithoutUpdate(editorValue, row2, column2);
                            ChangeSignatureDialogBase.this.updateSignature();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/changeSignature/ChangeSignatureDialogBase$4$1", "documentChanged"));
                    }
                };
                if (editor instanceof StringTableCellEditor) {
                    StringTableCellEditor ed = (StringTableCellEditor)editor;
                    ed.addDocumentListener(listener2);
                } else if (editor instanceof CodeFragmentTableCellEditorBase) {
                    ((CodeFragmentTableCellEditorBase)editor).addDocumentListener(listener2);
                }
                return super.prepareEditor(editor, row2, column2);
            }
        };
        this.myParametersTable.setShowGrid(false);
        this.myParametersTable.setCellSelectionEnabled(true);
        this.myParametersTable.getSelectionModel().setSelectionMode(0);
        this.myParametersTable.getSelectionModel().setSelectionInterval(0, 0);
        this.myParametersTable.setSurrendersFocusOnKeystroke(true);
        this.myPropagateParamChangesButton.setShortcut((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"alt G"}));
        if (this.isListTableViewSupported()) {
            this.myParametersList = this.createParametersListTable();
            JPanel buttonsPanel = ToolbarDecorator.createDecorator((JTable)this.myParametersList.getTable()).addExtraAction(this.myPropagateParamChangesButton).createPanel();
            this.myParametersList.getTable().getModel().addTableModelListener(this.mySignatureUpdater);
            return buttonsPanel;
        }
        JPanel buttonsPanel = ToolbarDecorator.createDecorator((JTable)this.getTableComponent()).addExtraAction(this.myPropagateParamChangesButton).createPanel();
        this.myPropagateParamChangesButton.setEnabled(false);
        this.myPropagateParamChangesButton.setVisible(false);
        this.myParametersTableModel.addTableModelListener((TableModelListener)this.mySignatureUpdater);
        this.customizeParametersTable(this.myParametersTable);
        return buttonsPanel;
    }

    protected ParametersListTable createParametersListTable() {
        return new ParametersListTable(){

            @Override
            protected JBTableRowRenderer getRowRenderer(int row2) {
                return new JBTableRowRenderer(){

                    @Override
                    public JComponent getRowRendererComponent(JTable table, int row2, boolean selected2, boolean focused) {
                        JComponent presentation2 = ChangeSignatureDialogBase.this.getRowPresentation(this.getRowItem(row2), selected2, focused);
                        LOG.assertTrue(presentation2 != null);
                        return presentation2;
                    }
                };
            }

            @Override
            @NotNull
            protected JBTableRowEditor getRowEditor(ParameterTableModelItemBase<ParamInfo> item) {
                JBTableRowEditor editor = ChangeSignatureDialogBase.this.getTableEditor((JTable)this.getTable(), item);
                LOG.assertTrue(editor != null);
                JBTableRowEditor jBTableRowEditor = editor;
                if (jBTableRowEditor == null) {
                    5.$$$reportNull$$$0(0);
                }
                return jBTableRowEditor;
            }

            @Override
            protected boolean isRowEmpty(int row2) {
                return ChangeSignatureDialogBase.this.isEmptyRow(this.getRowItem(row2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/ChangeSignatureDialogBase$5", "getRowEditor"));
            }
        };
    }

    @Deprecated
    @Nullable
    protected JBTableRowEditor getTableEditor(JTable table, ParameterTableModelItemBase<ParamInfo> item) {
        return null;
    }

    @Deprecated
    protected boolean isEmptyRow(ParameterTableModelItemBase<ParamInfo> row2) {
        return false;
    }

    @Deprecated
    @Nullable
    protected JComponent getRowPresentation(ParameterTableModelItemBase<ParamInfo> item, boolean selected2, boolean focused) {
        return null;
    }

    protected void customizeParametersTable(TableView<ParameterTableModelItem> table) {
    }

    private JComponent createSignaturePanel() {
        this.mySignatureArea = this.createSignaturePreviewComponent();
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)SeparatorFactory.createSeparator((String)RefactoringBundle.message((String)"signature.preview.border.title"), null), "North");
        panel2.add((Component)((Object)this.mySignatureArea), "Center");
        this.mySignatureArea.setPreferredSize(new Dimension(-1, 130));
        this.mySignatureArea.setMinimumSize(new Dimension(-1, 130));
        this.mySignatureArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Component c;
                Container root = ChangeSignatureDialogBase.findTraversalRoot(ChangeSignatureDialogBase.this.getContentPane());
                if (root != null && (c = root.getFocusTraversalPolicy().getComponentAfter(root, (Component)((Object)ChangeSignatureDialogBase.this.mySignatureArea))) != null) {
                    IdeFocusManager.findInstance().requestFocus(c, true);
                }
            }
        });
        this.updateSignature();
        return panel2;
    }

    private static Container findTraversalRoot(Container container) {
        Container root;
        Container current2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getCurrentFocusCycleRoot();
        if (current2 == container) {
            root = container;
        } else {
            root = container.getFocusCycleRootAncestor();
            if (root == null) {
                root = container;
            }
        }
        if (root != current2) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(root);
        }
        return root;
    }

    protected MethodSignatureComponent createSignaturePreviewComponent() {
        return new MethodSignatureComponent(this.calculateSignature(), this.getProject(), (FileType)this.getFileType());
    }

    protected void updateSignature() {
        if (this.mySignatureArea == null || this.myPropagateParamChangesButton == null) {
            return;
        }
        Runnable updateRunnable = () -> {
            this.myUpdateSignatureAlarm.cancelAllRequests();
            this.myUpdateSignatureAlarm.addRequest(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                PsiDocumentManager.getInstance((Project)this.myProject).performLaterWhenAllCommitted(() -> this.updateSignatureAlarmFired());
            }, 100, ModalityState.stateForComponent((Component)((Object)this.mySignatureArea)));
        };
        SwingUtilities.invokeLater(updateRunnable);
    }

    protected void updateSignatureAlarmFired() {
        this.doUpdateSignature();
        this.updatePropagateButtons();
    }

    private void doUpdateSignature() {
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments());
        this.mySignatureArea.setSignature(this.calculateSignature());
    }

    protected void updatePropagateButtons() {
        if (this.myPropagateParamChangesButton != null) {
            this.myPropagateParamChangesButton.setEnabled(!this.isGenerateDelegate() && this.mayPropagateParameters());
        }
    }

    protected boolean mayPropagateParameters() {
        List<ParamInfo> infos = this.getParameters();
        if (infos.size() <= this.myMethod.getParametersCount()) {
            return false;
        }
        for (int i2 = 0; i2 < this.myMethod.getParametersCount(); ++i2) {
            if (((ParameterInfo)infos.get(i2)).getOldIndex() == i2) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doAction() {
        String message2;
        if (this.myParametersTable != null) {
            TableUtil.stopEditing(this.myParametersTable);
        }
        if ((message2 = this.validateAndCommitData()) != null) {
            if (message2 != EXIT_SILENTLY) {
                CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)message2, (String)this.getHelpId(), (Project)this.myProject);
            }
            return;
        }
        if (this.myMethodsToPropagateParameters != null && !this.mayPropagateParameters()) {
            Messages.showWarningDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"changeSignature.parameters.wont.propagate"), (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"));
            this.myMethodsToPropagateParameters = null;
        }
        this.invokeRefactoring(this.createRefactoringProcessor());
    }

    protected String getHelpId() {
        return "refactoring.changeSignature";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterInfos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/ChangeSignatureDialogBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/ChangeSignatureDialogBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalPanels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setParameterInfos";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected abstract class ParametersListTable
    extends JBListTable {
        public ParametersListTable() {
            super((JBTable)ChangeSignatureDialogBase.this.myParametersTable, ChangeSignatureDialogBase.this.getDisposable());
        }

        @Override
        protected final JBTableRowEditor getRowEditor(final int row2) {
            JBTableRowEditor editor = this.getRowEditor((ParameterTableModelItemBase)this.getRowItem(row2));
            editor.addDocumentListener(new JBTableRowEditor.RowDocumentListener(){

                @Override
                public void documentChanged(@NotNull DocumentEvent e, int column2) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (String.class.equals((Object)ChangeSignatureDialogBase.this.myParametersTableModel.getColumnClass(column2))) {
                        ((ParameterTableModelBase)((Object)ChangeSignatureDialogBase.this.myParametersTableModel)).setValueAtWithoutUpdate(e.getDocument().getText(), row2, column2);
                    }
                    ChangeSignatureDialogBase.this.updateSignature();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/changeSignature/ChangeSignatureDialogBase$ParametersListTable$1", "documentChanged"));
                }
            });
            return editor;
        }

        @NotNull
        protected abstract JBTableRowEditor getRowEditor(ParameterTableModelItemBase<ParamInfo> var1);

        @Override
        protected abstract boolean isRowEmpty(int var1);

        protected ParameterTableModelItem getRowItem(int row2) {
            return (ParameterTableModelItemBase)ChangeSignatureDialogBase.this.myParametersTable.getItems().get(row2);
        }
    }

    protected class UpdateSignatureListener
    implements ChangeListener,
    DocumentListener,
    TableModelListener {
        protected UpdateSignatureListener() {
        }

        private void update() {
            ChangeSignatureDialogBase.this.updateSignature();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.update();
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            if (event == null) {
                UpdateSignatureListener.$$$reportNull$$$0(0);
            }
            this.update();
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.update();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/changeSignature/ChangeSignatureDialogBase$UpdateSignatureListener", "documentChanged"));
        }
    }
}

