/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.deployment;

import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.impl.runtime.ServerConnectionImpl;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentImpl;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalDeploymentImpl<D extends DeploymentConfiguration>
extends DeploymentImpl<D> {
    private final ServerRuntimeInstance<D> myServerInstance;
    private DeploymentImpl myRemoteDeployment;

    public LocalDeploymentImpl(@NotNull ServerRuntimeInstance<D> instance, @NotNull ServerConnectionImpl<D> connection, @NotNull DeploymentStatus status, @Nullable @Nls String statusText2, @Nullable DeploymentRuntime runtime, @NotNull DeploymentTask<D> deploymentTask) {
        if (instance == null) {
            LocalDeploymentImpl.$$$reportNull$$$0(0);
        }
        if (connection == null) {
            LocalDeploymentImpl.$$$reportNull$$$0(1);
        }
        if (status == null) {
            LocalDeploymentImpl.$$$reportNull$$$0(2);
        }
        if (deploymentTask == null) {
            LocalDeploymentImpl.$$$reportNull$$$0(3);
        }
        super(connection, instance.getDeploymentName(deploymentTask.getSource(), deploymentTask.getConfiguration()), status, statusText2, runtime, deploymentTask);
        this.myServerInstance = instance;
    }

    public void setRemoteDeployment(DeploymentImpl remoteDeployment) {
        this.myRemoteDeployment = remoteDeployment;
        String presentableName = null;
        if (remoteDeployment != null) {
            DeploymentRuntime deploymentRuntime = remoteDeployment.getRuntime();
            DeploymentTask<D> task2 = this.getDeploymentTask();
            if (deploymentRuntime != null) {
                presentableName = this.myServerInstance.getRuntimeDeploymentName(deploymentRuntime, task2.getSource(), task2.getConfiguration());
            }
        }
        this.setPresentableName(presentableName);
    }

    @Override
    @NotNull
    public DeploymentTask<D> getDeploymentTask() {
        DeploymentTask deploymentTask = Objects.requireNonNull(super.getDeploymentTask());
        if (deploymentTask == null) {
            LocalDeploymentImpl.$$$reportNull$$$0(4);
        }
        return deploymentTask;
    }

    private boolean isLocalState() {
        return this.myRemoteDeployment == null || super.getStatus().isTransition();
    }

    @Override
    @NotNull
    public DeploymentStatus getStatus() {
        DeploymentStatus deploymentStatus = this.isLocalState() ? super.getStatus() : this.myRemoteDeployment.getStatus();
        if (deploymentStatus == null) {
            LocalDeploymentImpl.$$$reportNull$$$0(5);
        }
        return deploymentStatus;
    }

    @Override
    @NotNull
    public String getStatusText() {
        String string = this.isLocalState() ? super.getStatusText() : this.myRemoteDeployment.getStatusText();
        if (string == null) {
            LocalDeploymentImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public DeploymentRuntime getRemoteRuntime() {
        return this.isLocalState() ? null : this.myRemoteDeployment.getRuntime();
    }

    @Override
    public boolean changeState(@NotNull DeploymentStatus oldStatus, @NotNull DeploymentStatus newStatus, @Nullable String statusText2, @Nullable DeploymentRuntime runtime) {
        boolean result2;
        if (oldStatus == null) {
            LocalDeploymentImpl.$$$reportNull$$$0(7);
        }
        if (newStatus == null) {
            LocalDeploymentImpl.$$$reportNull$$$0(8);
        }
        if ((result2 = super.changeState(oldStatus, newStatus, statusText2, runtime)) && this.myRemoteDeployment != null) {
            this.myRemoteDeployment.changeState(this.myRemoteDeployment.getStatus(), newStatus, statusText2, this.myRemoteDeployment.getRuntime());
        }
        return result2;
    }

    public boolean hasRemoteDeloyment() {
        return this.myRemoteDeployment != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentTask";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/runtime/deployment/LocalDeploymentImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldStatus";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/deployment/LocalDeploymentImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentTask";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "changeState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

