/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.remoteServer.util.Column;
import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class JTableWrapper<T, C extends Column<T>> {
    private static final int COLUMN_HEADER_MARGIN_WIDTH = 2;
    private final C[] myColumns;
    private final JTableWrapperModel myTableModel;
    private final JBTable myTable;
    private List<T> myInputRows;

    public JTableWrapper(JBTable table, C[] columns) {
        this.myTable = table;
        this.myColumns = columns;
        this.myTableModel = this.createTableModel();
        for (C column2 : this.myColumns) {
            this.myTableModel.addColumn(((Column)column2).getName());
        }
        this.myTable.setModel((TableModel)this.myTableModel);
        this.packColumns();
        this.myTable.getSelectionModel().setSelectionMode(0);
    }

    private void packColumns() {
        TableColumn col;
        int iColumn;
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.myTable.getColumnModel();
        int[] colMinWidths = new int[this.myColumns.length];
        for (iColumn = 0; iColumn < this.myColumns.length; ++iColumn) {
            col = colModel.getColumn(iColumn);
            colMinWidths[iColumn] = col.getMinWidth();
            if (!((Column)this.myColumns[iColumn]).needPack()) {
                col.setWidth(col.getMinWidth());
                continue;
            }
            TableCellRenderer renderer2 = col.getHeaderRenderer();
            if (renderer2 == null) {
                renderer2 = this.myTable.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer2.getTableCellRendererComponent((JTable)this.myTable, col.getHeaderValue(), false, false, 0, 0);
            int colWidth = comp.getPreferredSize().width;
            for (int iRow = 0; iRow < this.myTable.getRowCount(); ++iRow) {
                renderer2 = this.myTable.getCellRenderer(iRow, iColumn);
                comp = renderer2.getTableCellRendererComponent((JTable)this.myTable, this.myTable.getValueAt(iRow, iColumn), false, false, iRow, iColumn);
                colWidth = Math.max(colWidth, comp.getPreferredSize().width);
            }
            col.setMaxWidth(colWidth += 4);
            col.setMinWidth(colWidth);
        }
        for (iColumn = 0; iColumn < this.myColumns.length; ++iColumn) {
            col = colModel.getColumn(iColumn);
            col.setMinWidth(colMinWidths[iColumn]);
        }
    }

    public C[] getColumns() {
        return this.myColumns;
    }

    private DefaultTableModel getTableModel() {
        return this.myTableModel;
    }

    private void setInput(Iterable<Collection<Object>> input) {
        this.getTableModel().setRowCount(0);
        for (Collection<Object> row2 : input) {
            this.getTableModel().addRow(row2.toArray());
        }
        this.packColumns();
    }

    public void setInputRows(List<T> rows) {
        this.myInputRows = rows;
        ArrayList<Collection<Object>> input = new ArrayList<Collection<Object>>();
        for (T row2 : rows) {
            ArrayList<Object> rowCellValues = new ArrayList<Object>();
            for (Column column2 : this.getColumns()) {
                rowCellValues.add(column2.getColumnValue(row2));
            }
            input.add(rowCellValues);
        }
        this.setInput(input);
    }

    public JBTable getTable() {
        return this.myTable;
    }

    protected JTableWrapperModel createTableModel() {
        return new JTableWrapperModel();
    }

    protected class JTableWrapperModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        protected JTableWrapperModel() {
        }

        @Override
        public boolean isCellEditable(int row2, int column2) {
            return ((Column)JTableWrapper.this.myColumns[column2]).isEditable();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return ((Column)JTableWrapper.this.myColumns[columnIndex]).getValueClass();
        }

        @Override
        public void setValueAt(Object aValue, int row2, int column2) {
            ((Column)JTableWrapper.this.myColumns[column2]).setColumnValue(JTableWrapper.this.myInputRows.get(row2), aValue);
            super.setValueAt(aValue, row2, column2);
        }
    }
}

