/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DocumentBasedReplaceHandler
extends StructuralReplaceHandler {
    private final Project myProject;
    private final Map<ReplacementInfo, RangeMarker> myRangeMarkers = new HashMap<ReplacementInfo, RangeMarker>();

    public DocumentBasedReplaceHandler(Project project) {
        this.myProject = project;
    }

    @Override
    public void replace(@NotNull ReplacementInfo info2, @NotNull ReplaceOptions options2) {
        if (info2 == null) {
            DocumentBasedReplaceHandler.$$$reportNull$$$0(0);
        }
        if (options2 == null) {
            DocumentBasedReplaceHandler.$$$reportNull$$$0(1);
        }
        RangeMarker rangeMarker = this.myRangeMarkers.get(info2);
        Document document = rangeMarker.getDocument();
        document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)info2.getReplacement());
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
    }

    @Override
    public void prepare(@NotNull ReplacementInfo info2) {
        PsiElement firstElement;
        if (info2 == null) {
            DocumentBasedReplaceHandler.$$$reportNull$$$0(2);
        }
        if ((firstElement = StructuralSearchUtil.getPresentableElement(info2.getMatch(0))) == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(firstElement.getContainingFile());
        assert (document != null);
        TextRange range2 = firstElement.getTextRange();
        int startOffset = range2.getStartOffset();
        int endOffset = range2.getEndOffset();
        int count = info2.getMatchesCount();
        for (int i2 = 1; i2 < count; ++i2) {
            PsiElement match = info2.getMatch(i2);
            if (match == null) continue;
            TextRange range1 = match.getTextRange();
            startOffset = Math.min(startOffset, range1.getStartOffset());
            endOffset = Math.max(endOffset, range1.getEndOffset());
        }
        RangeMarker rangeMarker = document.createRangeMarker(startOffset, endOffset);
        rangeMarker.setGreedyToLeft(true);
        rangeMarker.setGreedyToRight(true);
        this.myRangeMarkers.put(info2, rangeMarker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/DocumentBasedReplaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "replace";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

