/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import com.intellij.structuralsearch.XmlStructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.SmartList;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StructuralSearchUtil {
    private static final String REG_EXP_META_CHARS = ".$|()[]{}^?*+\\";
    private static final Pattern ACCENTS = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static final Comparator<? super Configuration> CONFIGURATION_COMPARATOR = Comparator.comparing(Configuration::getCategory, NaturalComparator.INSTANCE).thenComparing(Configuration::getName, NaturalComparator.INSTANCE);
    private static LanguageFileType ourDefaultFileType;
    private static boolean ourUseUniversalMatchingAlgorithm;
    private static Map<String, LanguageFileType> ourNames2FileTypes;
    private static final Map<String, StructuralSearchProfile> cache;
    private static List<Configuration> ourPredefinedConfigurations;

    private StructuralSearchUtil() {
    }

    public static void setUseUniversalMatchingAlgorithm(boolean useUniversalMatchingAlgorithm) {
        ourUseUniversalMatchingAlgorithm = useUniversalMatchingAlgorithm;
        cache.clear();
    }

    @Nullable
    public static StructuralSearchProfile getProfileByPsiElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            StructuralSearchUtil.$$$reportNull$$$0(0);
        }
        return StructuralSearchUtil.getProfileByLanguage(element2.getLanguage());
    }

    @Nullable
    public static StructuralSearchProfile getProfileByFileType(@Nullable LanguageFileType fileType) {
        return fileType == null ? null : StructuralSearchUtil.getProfileByLanguage(fileType.getLanguage());
    }

    @Nullable
    public static StructuralSearchProfile getProfileByLanguage(@NotNull Language language) {
        String id2;
        if (language == null) {
            StructuralSearchUtil.$$$reportNull$$$0(1);
        }
        if (cache.containsKey(id2 = language.getID())) {
            return cache.get(id2);
        }
        for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
            if (!profile.isMyLanguage(language)) continue;
            cache.put(id2, profile);
            return profile;
        }
        cache.put(id2, null);
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isIdentifier(PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element2);
        return profile != null && profile.isIdentifier(element2);
    }

    public static PsiElement getParentIfIdentifier(PsiElement element2) {
        return StructuralSearchUtil.isIdentifier(element2) ? element2.getParent() : element2;
    }

    @Contract(value="!null -> !null")
    public static PsiElement getPresentableElement(PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element2);
        return profile == null ? element2 : profile.getPresentableElement(element2);
    }

    private static StructuralSearchProfile[] getNewStyleProfiles() {
        SmartList list2 = new SmartList();
        for (StructuralSearchProfile profile : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions()) {
            if (!(profile instanceof StructuralSearchProfileBase)) continue;
            list2.add(profile);
        }
        list2.add(new XmlStructuralSearchProfile());
        return list2.toArray(new StructuralSearchProfile[0]);
    }

    private static StructuralSearchProfile[] getProfiles() {
        return ourUseUniversalMatchingAlgorithm ? StructuralSearchUtil.getNewStyleProfiles() : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions();
    }

    @NotNull
    public static LanguageFileType getDefaultFileType() {
        if (ourDefaultFileType == null) {
            for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
                ourDefaultFileType = profile.getDefaultFileType(ourDefaultFileType);
            }
            if (ourDefaultFileType == null) {
                ourDefaultFileType = XmlFileType.INSTANCE;
            }
        }
        LanguageFileType languageFileType = ourDefaultFileType;
        if (languageFileType == null) {
            StructuralSearchUtil.$$$reportNull$$$0(2);
        }
        return languageFileType;
    }

    public static boolean isTypedVariable(@NotNull String name) {
        if (name == null) {
            StructuralSearchUtil.$$$reportNull$$$0(3);
        }
        return name.length() > 1 && name.charAt(0) == '$' && name.charAt(name.length() - 1) == '$';
    }

    public static Collection<LanguageFileType> getSuitableFileTypes() {
        return Collections.unmodifiableCollection(StructuralSearchUtil.getNames2FileTypes().values());
    }

    @NotNull
    private static Map<String, LanguageFileType> getNames2FileTypes() {
        Map<String, LanguageFileType> names2FileTypes = ourNames2FileTypes;
        if (names2FileTypes != null) {
            Map<String, LanguageFileType> map2 = names2FileTypes;
            if (map2 == null) {
                StructuralSearchUtil.$$$reportNull$$$0(4);
            }
            return map2;
        }
        FileType[] fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes();
        Map<String, LanguageFileType> cache2 = Arrays.stream(fileTypes).filter(fileType -> fileType instanceof LanguageFileType).collect(Collectors.toMap(FileType::getName, fileType -> (LanguageFileType)fileType));
        for (Language language : Language.getRegisteredLanguages()) {
            LanguageFileType fileType2 = language.getAssociatedFileType();
            if (fileType2 == null) continue;
            cache2.put(fileType2.getName(), fileType2);
        }
        ourNames2FileTypes = cache2;
        if (ourNames2FileTypes == null) {
            StructuralSearchUtil.$$$reportNull$$$0(5);
        }
        return ourNames2FileTypes;
    }

    public static LanguageFileType getSuitableFileTypeByName(String name) {
        return StructuralSearchUtil.getNames2FileTypes().get(name);
    }

    public static boolean containsRegExpMetaChar(String s) {
        return s.chars().anyMatch(StructuralSearchUtil::isRegExpMetaChar);
    }

    public static boolean isRegExpMetaChar(int ch) {
        return REG_EXP_META_CHARS.indexOf(ch) >= 0;
    }

    @NotNull
    public static String shieldRegExpMetaChars(@NotNull String word) {
        if (word == null) {
            StructuralSearchUtil.$$$reportNull$$$0(6);
        }
        String string = StructuralSearchUtil.shieldRegExpMetaChars(word, new StringBuilder(word.length())).toString();
        if (string == null) {
            StructuralSearchUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static String makeExtremeSpacesOptional(String word) {
        if (word.trim().isEmpty()) {
            return word;
        }
        Object result2 = word;
        if (word.startsWith(" ")) {
            result2 = "(?:\\s|\\b)" + ((String)result2).substring(1);
        }
        if (word.endsWith(" ")) {
            result2 = ((String)result2).substring(0, ((String)result2).length() - 1) + "(?:\\s|\\b)";
        }
        return result2;
    }

    @NotNull
    public static StringBuilder shieldRegExpMetaChars(String word, StringBuilder out) {
        int length = word.length();
        for (int i2 = 0; i2 < length; ++i2) {
            if (StructuralSearchUtil.isRegExpMetaChar(word.charAt(i2))) {
                out.append("\\");
            }
            out.append(word.charAt(i2));
        }
        StringBuilder stringBuilder = out;
        if (stringBuilder == null) {
            StructuralSearchUtil.$$$reportNull$$$0(8);
        }
        return stringBuilder;
    }

    public static Pattern[] createPatterns(String[] prefixes) {
        Pattern[] patterns = new Pattern[prefixes.length];
        for (int i2 = 0; i2 < prefixes.length; ++i2) {
            String s = StructuralSearchUtil.shieldRegExpMetaChars(prefixes[i2]);
            patterns[i2] = Pattern.compile("\\b(" + s + "\\w+)\\b");
        }
        return patterns;
    }

    public static List<Configuration> getPredefinedTemplates() {
        if (ourPredefinedConfigurations == null) {
            ArrayList result2 = new ArrayList();
            for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
                Collections.addAll(result2, profile.getPredefinedTemplates());
            }
            Collections.sort(result2, CONFIGURATION_COMPARATOR);
            ourPredefinedConfigurations = Collections.unmodifiableList(result2);
        }
        return ourPredefinedConfigurations;
    }

    public static boolean isDocCommentOwner(@NotNull PsiElement match) {
        StructuralSearchProfile profile;
        if (match == null) {
            StructuralSearchUtil.$$$reportNull$$$0(9);
        }
        return (profile = StructuralSearchUtil.getProfileByPsiElement(match)) != null && profile.isDocCommentOwner(match);
    }

    public static String getMeaningfulText(PsiElement matchedNode) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(matchedNode);
        return profile != null ? profile.getMeaningfulText(matchedNode) : matchedNode.getText();
    }

    public static String getAlternativeText(@NotNull PsiElement matchedNode, @NotNull String previousText) {
        StructuralSearchProfile profile;
        if (matchedNode == null) {
            StructuralSearchUtil.$$$reportNull$$$0(10);
        }
        if (previousText == null) {
            StructuralSearchUtil.$$$reportNull$$$0(11);
        }
        return (profile = StructuralSearchUtil.getProfileByPsiElement(matchedNode)) != null ? profile.getAlternativeText(matchedNode, previousText) : null;
    }

    @NotNull
    public static String normalizeWhiteSpace(@NotNull String text2) {
        if (text2 == null) {
            StructuralSearchUtil.$$$reportNull$$$0(12);
        }
        text2 = text2.trim();
        StringBuilder result2 = new StringBuilder();
        boolean white = false;
        int length = text2.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c = text2.charAt(i2);
            if (StringUtil.isWhiteSpace((char)c)) {
                if (white) continue;
                result2.append(' ');
                white = true;
                continue;
            }
            white = false;
            result2.append(c);
        }
        String string = result2.toString();
        if (string == null) {
            StructuralSearchUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String stripAccents(@NotNull String input) {
        if (input == null) {
            StructuralSearchUtil.$$$reportNull$$$0(14);
        }
        String string = ACCENTS.matcher(Normalizer.normalize(input, Normalizer.Form.NFD)).replaceAll("");
        if (string == null) {
            StructuralSearchUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String normalize(@NotNull String text2) {
        if (text2 == null) {
            StructuralSearchUtil.$$$reportNull$$$0(16);
        }
        return StructuralSearchUtil.stripAccents(StructuralSearchUtil.normalizeWhiteSpace(text2));
    }

    public static PatternContext findPatternContextByID(@Nullable String id2, @NotNull Language language) {
        if (language == null) {
            StructuralSearchUtil.$$$reportNull$$$0(17);
        }
        return StructuralSearchUtil.findPatternContextByID(id2, StructuralSearchUtil.getProfileByLanguage(language));
    }

    public static PatternContext findPatternContextByID(@Nullable String id2, @Nullable StructuralSearchProfile profile) {
        if (profile == null) {
            return null;
        }
        List<PatternContext> patternContexts = profile.getPatternContexts();
        if (patternContexts.isEmpty()) {
            return null;
        }
        if (id2 == null) {
            return patternContexts.get(0);
        }
        return patternContexts.stream().filter(context2 -> context2.getId().equals(id2)).findFirst().orElse(patternContexts.get(0));
    }

    static {
        cache = new HashMap<String, StructuralSearchProfile>();
        StructuralSearchProfile.EP_NAME.addChangeListener(() -> {
            ourPredefinedConfigurations = null;
            ourDefaultFileType = null;
            ourNames2FileTypes = null;
            cache.clear();
        }, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedNode";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousText";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFileType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames2FileTypes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "shieldRegExpMetaChars";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeWhiteSpace";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "stripAccents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByPsiElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByLanguage";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTypedVariable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shieldRegExpMetaChars";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDocCommentOwner";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "normalizeWhiteSpace";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "stripAccents";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findPatternContextByID";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

