/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.core.CoreBundle;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.ui.FileTypeInfo;
import com.intellij.ui.components.JBLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileTypeChooser
extends ComboBoxAction
implements DumbAware {
    private final List<FileTypeInfo> myFileTypeInfos = FileTypeChooser.createFileTypeInfos();
    private FileTypeInfo mySelectedItem = this.myFileTypeInfos.get(0);
    private Consumer<? super FileTypeInfo> myConsumer;

    FileTypeChooser() {
        this.setSmallVariant(false);
    }

    public void setFileTypeInfoConsumer(@Nullable Consumer<? super FileTypeInfo> consumer) {
        this.myConsumer = consumer;
    }

    private static List<FileTypeInfo> createFileTypeInfos() {
        ArrayList<LanguageFileType> types = new ArrayList<LanguageFileType>();
        for (LanguageFileType fileType : StructuralSearchUtil.getSuitableFileTypes()) {
            if (StructuralSearchUtil.getProfileByFileType(fileType) == null) continue;
            types.add(fileType);
        }
        types.sort((o1, o2) -> o1.getDescription().compareToIgnoreCase(o2.getDescription()));
        ArrayList<FileTypeInfo> infos = new ArrayList<FileTypeInfo>();
        for (LanguageFileType fileType : types) {
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(fileType);
            assert (profile != null);
            Language language = fileType.getLanguage();
            ArrayList<PatternContext> patternContexts = new ArrayList<PatternContext>(profile.getPatternContexts());
            if (!patternContexts.isEmpty()) {
                infos.add(new FileTypeInfo(fileType, language, (PatternContext)patternContexts.get(0), false));
                for (int i2 = 1; i2 < patternContexts.size(); ++i2) {
                    infos.add(new FileTypeInfo(fileType, language, (PatternContext)patternContexts.get(i2), true));
                }
                continue;
            }
            infos.add(new FileTypeInfo(fileType, language, null, false));
            ArrayList<Language> dialects = new ArrayList<Language>(language.getDialects());
            dialects.sort(Comparator.comparing(Language::getDisplayName));
            for (Language dialect : dialects) {
                if (!profile.isMyLanguage(dialect)) continue;
                infos.add(new FileTypeInfo(fileType, dialect, null, true));
            }
        }
        return infos;
    }

    public void setSelectedItem(@Nullable LanguageFileType type, @Nullable Language dialect, @Nullable PatternContext context2) {
        if (type == null) {
            this.setSelectedItem(null);
        } else {
            for (FileTypeInfo info2 : this.myFileTypeInfos) {
                if (!info2.isEqualTo(type, dialect, context2)) continue;
                this.setSelectedItem(info2);
                return;
            }
        }
    }

    private void setSelectedItem(FileTypeInfo info2) {
        this.mySelectedItem = info2;
        if (this.myConsumer != null) {
            this.myConsumer.accept(info2);
        }
    }

    public FileTypeInfo getSelectedItem() {
        return this.mySelectedItem;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FileTypeChooser.$$$reportNull$$$0(0);
        }
        super.update(e);
        Presentation presentation2 = e.getPresentation();
        if (this.mySelectedItem == null) {
            presentation2.setIcon(AllIcons.FileTypes.Unknown);
            presentation2.setText(CoreBundle.message((String)"filetype.unknown.description", (Object[])new Object[0]));
        } else {
            presentation2.setIcon(this.mySelectedItem.getFileType().getIcon());
            presentation2.setText(this.mySelectedItem.getText());
        }
    }

    @NotNull
    protected ComboBoxAction.ComboBoxButton createComboBoxButton(@NotNull Presentation presentation2) {
        if (presentation2 == null) {
            FileTypeChooser.$$$reportNull$$$0(1);
        }
        return new ComboBoxAction.ComboBoxButton(presentation2){

            public int getDisplayedMnemonicIndex() {
                return -1;
            }
        };
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        if (presentation2 == null) {
            FileTypeChooser.$$$reportNull$$$0(2);
        }
        if (place == null) {
            FileTypeChooser.$$$reportNull$$$0(3);
        }
        JPanel panel2 = new JPanel(new BorderLayout(1, 0));
        ComboBoxAction.ComboBoxButton button4 = this.createComboBoxButton(presentation2);
        String text2 = SSRBundle.message("search.dialog.file.type.label", new Object[0]);
        JBLabel label2 = new JBLabel(text2);
        label2.setLabelFor((Component)button4);
        button4.setMnemonic(TextWithMnemonic.parse((String)text2).getMnemonic());
        panel2.add((Component)label2, "West");
        panel2.add((Component)button4, "Center");
        JPanel jPanel2 = panel2;
        if (jPanel2 == null) {
            FileTypeChooser.$$$reportNull$$$0(4);
        }
        return jPanel2;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button4) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        for (FileTypeInfo fileTypeInfo : this.myFileTypeInfos) {
            group2.add((AnAction)new FileTypeInfoAction(fileTypeInfo));
        }
        DefaultActionGroup defaultActionGroup = group2;
        if (defaultActionGroup == null) {
            FileTypeChooser.$$$reportNull$$$0(5);
        }
        return defaultActionGroup;
    }

    protected Condition<AnAction> getPreselectCondition() {
        return action2 -> ((FileTypeInfoAction)((Object)action2)).getFileTypeInfo() == this.mySelectedItem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/FileTypeChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/FileTypeChooser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createComboBoxButton";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FileTypeInfoAction
    extends DumbAwareAction {
        private final FileTypeInfo myFileTypeInfo;

        FileTypeInfoAction(FileTypeInfo fileTypeInfo) {
            this.myFileTypeInfo = fileTypeInfo;
            Presentation presentation2 = this.getTemplatePresentation();
            presentation2.setIcon(fileTypeInfo.isNested() ? null : fileTypeInfo.getFileType().getIcon());
            presentation2.setText((String)(fileTypeInfo.isNested() ? "    " + fileTypeInfo.getText() : fileTypeInfo.getText()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                FileTypeInfoAction.$$$reportNull$$$0(0);
            }
            FileTypeChooser.this.setSelectedItem(this.myFileTypeInfo);
        }

        FileTypeInfo getFileTypeInfo() {
            return this.myFileTypeInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/FileTypeChooser$FileTypeInfoAction", "actionPerformed"));
        }
    }
}

