/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.NullableConsumer;
import com.intellij.util.SmartList;
import java.awt.Component;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LinkComboBox
extends ActionLink {
    private final List<String> myItems = new SmartList();
    private String mySelectedItem;
    private @NlsContexts.Label String myDefaultItem;
    private NullableConsumer<? super String> myConsumer;

    LinkComboBox(@NlsContexts.Label String defaultItem) {
        this.setAutoHideOnDisable(false);
        this.setDefaultItem(defaultItem);
        this.setDropDownLinkIcon();
        this.addActionListener(e -> this.showPopup());
    }

    public void setItemConsumer(@Nullable NullableConsumer<? super String> consumer) {
        this.myConsumer = consumer;
    }

    public void setItems(@NotNull Collection<String> items) {
        if (items == null) {
            LinkComboBox.$$$reportNull$$$0(0);
        }
        if (items.isEmpty()) {
            throw new IllegalArgumentException("items needs to contain at least one item");
        }
        this.myItems.clear();
        this.myItems.addAll(items);
        if (!this.myItems.contains(this.mySelectedItem)) {
            this.setSelectedItem(this.myDefaultItem != null ? this.myDefaultItem : this.myItems.get(0));
        }
    }

    public int getDisplayedMnemonicIndex() {
        return -1;
    }

    public String getSelectedItem() {
        return this.mySelectedItem;
    }

    public void setSelectedItem(@NlsContexts.Label String selectedItem) {
        if (!this.myItems.contains(selectedItem)) {
            throw new IllegalArgumentException("selected item is not contained in items");
        }
        this.mySelectedItem = selectedItem;
        this.setText(selectedItem);
    }

    public void setDefaultItem(@NlsContexts.Label String defaultItem) {
        this.myDefaultItem = defaultItem;
        this.setText(defaultItem);
    }

    void showPopup() {
        if (!this.isEnabled()) {
            return;
        }
        BaseListPopupStep<String> list2 = new BaseListPopupStep<String>(null, this.myItems){

            public PopupStep<?> onChosen(@NlsContexts.Label String selectedValue, boolean finalChoice) {
                LinkComboBox.this.setSelectedItem(selectedValue);
                if (LinkComboBox.this.myConsumer != null) {
                    LinkComboBox.this.myConsumer.consume((Object)selectedValue);
                }
                return super.onChosen((Object)selectedValue, finalChoice);
            }

            public int getDefaultOptionIndex() {
                return LinkComboBox.this.myItems.indexOf(LinkComboBox.this.mySelectedItem);
            }
        };
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)list2);
        popup2.show(new RelativePoint((Component)((Object)this), new Point(JBUIScale.scale((int)-2), this.getHeight() + JBUIScale.scale((int)2))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/structuralsearch/plugin/ui/LinkComboBox", "setItems"));
    }
}

