/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StructuralSearchTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            StructuralSearchTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            StructuralSearchTypedHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            StructuralSearchTypedHandler.$$$reportNull$$$0(2);
        }
        if (editor.getUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY) == null) {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
            if (result2 == null) {
                StructuralSearchTypedHandler.$$$reportNull$$$0(3);
            }
            return result2;
        }
        if (c == '$') {
            SelectionModel selectionModel = editor.getSelectionModel();
            String selectedText = selectionModel.getSelectedText();
            if (!StringUtil.isEmpty((String)selectedText)) {
                boolean multipleCarets;
                if (selectedText.contains("$") || !CodeInsightSettings.getInstance().SURROUND_SELECTION_ON_QUOTE_TYPED) {
                    TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
                    if (result3 == null) {
                        StructuralSearchTypedHandler.$$$reportNull$$$0(4);
                    }
                    return result3;
                }
                Document document = editor.getDocument();
                SmartList rangeMarkers = new SmartList();
                rangeMarkers.add(document.createRangeMarker(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()));
                CaretModel caretModel = editor.getCaretModel();
                boolean bl = multipleCarets = caretModel.getCaretCount() != 1;
                if (!multipleCarets) {
                    PsiTreeUtil.processElements((PsiElement)file2, arg_0 -> StructuralSearchTypedHandler.lambda$beforeSelectionRemoved$0(selectedText, (List)rangeMarkers, document, arg_0));
                }
                String newText = c + selectedText + c;
                boolean ltrSelection = selectionModel.getLeadSelectionOffset() != selectionModel.getSelectionEnd();
                for (Object marker : rangeMarkers) {
                    if (!marker.isValid()) continue;
                    document.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)newText);
                    if (!multipleCarets) continue;
                    int startOffset = marker.getStartOffset() + 1;
                    int endOffset = startOffset + selectedText.length();
                    selectionModel.setSelection(ltrSelection ? startOffset : endOffset, ltrSelection ? endOffset : startOffset);
                    caretModel.moveToOffset(ltrSelection ? endOffset : startOffset);
                }
                if (!multipleCarets && rangeMarkers.size() <= caretModel.getMaxCaretCount()) {
                    SmartList newCaretStates = new SmartList();
                    for (RangeMarker marker : rangeMarkers) {
                        int startOffset = marker.getStartOffset() + 1;
                        int endOffset = startOffset + selectedText.length();
                        LogicalPosition selectionStart = editor.offsetToLogicalPosition(ltrSelection ? startOffset : endOffset);
                        LogicalPosition selectionEnd = editor.offsetToLogicalPosition(ltrSelection ? endOffset : startOffset);
                        LogicalPosition caretPosition = editor.offsetToLogicalPosition(ltrSelection ? endOffset : startOffset);
                        CaretState state = new CaretState(caretPosition, selectionStart, selectionEnd);
                        newCaretStates.add(state);
                    }
                    caretModel.setCaretsAndSelections((List)newCaretStates);
                }
                TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.STOP;
                if (result4 == null) {
                    StructuralSearchTypedHandler.$$$reportNull$$$0(5);
                }
                return result4;
            }
            if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
                boolean nextIsDollar;
                Document document = editor.getDocument();
                CaretModel caretModel = editor.getCaretModel();
                Caret caret = caretModel.getCurrentCaret();
                LogicalPosition position = caret.getLogicalPosition();
                int lineStart = document.getLineStartOffset(position.line);
                int lineEnd = document.getLineEndOffset(position.line);
                int offset = lineStart + position.column;
                CharSequence text2 = document.getCharsSequence();
                boolean bl = nextIsDollar = offset < text2.length() && text2.charAt(offset) == '$';
                if (StructuralSearchTypedHandler.hasOddDollar(text2, lineStart, offset) && nextIsDollar) {
                    caret.setSelection(offset, offset + 1);
                } else if (!StructuralSearchTypedHandler.hasOddDollar(text2, lineStart, lineEnd)) {
                    document.insertString(offset, (CharSequence)"$");
                }
            }
        }
        TypedHandlerDelegate.Result result5 = TypedHandlerDelegate.Result.CONTINUE;
        if (result5 == null) {
            StructuralSearchTypedHandler.$$$reportNull$$$0(6);
        }
        return result5;
    }

    static boolean hasOddDollar(CharSequence text2, int start2, int end) {
        boolean $ = false;
        for (int i2 = start2; i2 < end; ++i2) {
            if (text2.charAt(i2) != '$') continue;
            $ = !$;
        }
        return $;
    }

    private static /* synthetic */ boolean lambda$beforeSelectionRemoved$0(String selectedText, List rangeMarkers, Document document, PsiElement element2) {
        if (StructuralSearchUtil.isIdentifier(element2) && element2.getText().equals(selectedText)) {
            rangeMarkers.add(document.createRangeMarker(element2.getTextRange()));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchTypedHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeSelectionRemoved";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeSelectionRemoved";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

