/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.filters.ShortFilterTextProvider;
import com.intellij.util.SmartList;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SubstitutionShortInfoHandler
implements DocumentListener,
EditorMouseMotionListener,
CaretListener {
    private static final Key<SubstitutionShortInfoHandler> LISTENER_KEY = Key.create((String)"sslistener.key");
    private long modificationTimeStamp;
    private final List<String> variables;
    private final Editor editor;
    private final ShortFilterTextProvider myShortFilterTextProvider;
    private final boolean myCanBeReplace;
    @Nullable
    private final Consumer<? super String> myCurrentVariableCallback;
    public static final Key<Configuration> CURRENT_CONFIGURATION_KEY = Key.create((String)"SS.CurrentConfiguration");
    private final Map<String, Inlay<FilterRenderer>> inlays;

    private SubstitutionShortInfoHandler(@NotNull Editor _editor, ShortFilterTextProvider provider2, boolean canBeReplace, @Nullable Consumer<? super String> currentVariableCallback) {
        if (_editor == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(0);
        }
        this.variables = new SmartList();
        this.inlays = new HashMap<String, Inlay<FilterRenderer>>();
        this.editor = _editor;
        this.myShortFilterTextProvider = provider2;
        this.myCanBeReplace = canBeReplace;
        this.myCurrentVariableCallback = currentVariableCallback;
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        if (e == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(1);
        }
        this.handleInputFocusMovement(e.getLogicalPosition(), false);
    }

    private void handleInputFocusMovement(LogicalPosition position, boolean caret) {
        Object currentVariableName;
        Configuration configuration2 = (Configuration)this.editor.getUserData(CURRENT_CONFIGURATION_KEY);
        if (configuration2 == null) {
            return;
        }
        Document document = this.editor.getDocument();
        int lineCount = document.getLineCount();
        if (position.line >= lineCount) {
            return;
        }
        int lineStart = document.getLineStartOffset(position.line);
        int lineEnd = document.getLineEndOffset(position.line);
        CharSequence patternText = document.getCharsSequence().subSequence(lineStart, lineEnd);
        TextRange variableRange = TemplateImplUtil.findVariableAtOffset(patternText, position.column);
        if (variableRange == null) {
            if (caret) {
                if (this.myCurrentVariableCallback != null) {
                    this.myCurrentVariableCallback.accept("__context__");
                }
                configuration2.setCurrentVariableName("__context__");
            }
            return;
        }
        String variableName = variableRange.subSequence(patternText).toString();
        NamedScriptableDefinition variable = configuration2.findVariable(variableName);
        boolean replacementVariable = variable instanceof ReplacementVariableDefinition || this.myCanBeReplace && variable == null && configuration2 instanceof ReplaceConfiguration;
        Object object = currentVariableName = replacementVariable ? variableName + "$replacement" : variableName;
        if (caret) {
            if (this.myCurrentVariableCallback != null) {
                this.myCurrentVariableCallback.accept((String)currentVariableName);
            }
            configuration2.setCurrentVariableName((String)currentVariableName);
        }
    }

    private void checkModelValidity() {
        Document document = this.editor.getDocument();
        if (this.modificationTimeStamp != document.getModificationStamp()) {
            this.variables.clear();
            this.variables.addAll(TemplateImplUtil.parseVariableNames(document.getCharsSequence()));
            this.modificationTimeStamp = document.getModificationStamp();
            this.updateEditorInlays();
        }
    }

    public void caretPositionChanged(@NotNull CaretEvent e) {
        if (e == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(2);
        }
        this.handleInputFocusMovement(e.getNewPosition(), true);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(3);
        }
        this.handleInputFocusMovement(this.editor.getCaretModel().getLogicalPosition(), true);
        this.updateEditorInlays();
    }

    public List<String> getVariables() {
        this.checkModelValidity();
        return this.variables;
    }

    static SubstitutionShortInfoHandler retrieve(Editor editor) {
        return editor == null ? null : (SubstitutionShortInfoHandler)editor.getUserData(LISTENER_KEY);
    }

    static void install(Editor editor, ShortFilterTextProvider provider2, Disposable disposable2) {
        SubstitutionShortInfoHandler.install(editor, provider2, null, disposable2, false);
    }

    static void install(Editor editor, ShortFilterTextProvider provider2, @Nullable Consumer<? super String> currentVariableCallback, Disposable disposable2, boolean replace) {
        SubstitutionShortInfoHandler handler2 = new SubstitutionShortInfoHandler(editor, provider2, replace, currentVariableCallback);
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)handler2, disposable2);
        editor.getDocument().addDocumentListener((DocumentListener)handler2, disposable2);
        editor.getCaretModel().addCaretListener((CaretListener)handler2, disposable2);
        editor.putUserData(LISTENER_KEY, (Object)handler2);
    }

    static void updateEditorInlays(Editor editor) {
        SubstitutionShortInfoHandler handler2 = SubstitutionShortInfoHandler.retrieve(editor);
        if (handler2 != null) {
            handler2.updateEditorInlays();
        }
    }

    void updateEditorInlays() {
        Project project = this.editor.getProject();
        if (project == null) {
            return;
        }
        String text2 = this.editor.getDocument().getText();
        Template template = TemplateManager.getInstance(project).createTemplate("", "", text2);
        int segmentsCount = template.getSegmentsCount();
        InlayModel inlayModel = this.editor.getInlayModel();
        HashSet<String> variables = new HashSet<String>(this.inlays.keySet());
        Configuration configuration2 = (Configuration)this.editor.getUserData(CURRENT_CONFIGURATION_KEY);
        if (configuration2 == null) {
            return;
        }
        int variableNameLength = 0;
        for (int i2 = 0; i2 < segmentsCount; ++i2) {
            int offset = template.getSegmentOffset(i2);
            String name = template.getSegmentName(i2);
            variableNameLength += name.length() + 2;
            NamedScriptableDefinition namedScriptableDefinition = configuration2.findVariable(name);
            String labelText = this.myShortFilterTextProvider.getShortFilterText(namedScriptableDefinition);
            if (labelText.isEmpty()) continue;
            variables.remove(name);
            Inlay<FilterRenderer> inlay = this.inlays.get(name);
            if (inlay == null) {
                this.inlays.put(name, (Inlay<FilterRenderer>)inlayModel.addInlineElement(offset + variableNameLength, (EditorCustomElementRenderer)new FilterRenderer(labelText)));
                continue;
            }
            FilterRenderer renderer2 = (FilterRenderer)inlay.getRenderer();
            renderer2.setText(labelText);
            inlay.update();
        }
        NamedScriptableDefinition contextVariable = configuration2.findVariable("__context__");
        String labelText = this.myShortFilterTextProvider.getShortFilterText(contextVariable);
        if (!labelText.isEmpty()) {
            variables.remove("__context__");
            Inlay<FilterRenderer> inlay = this.inlays.get("__context__");
            if (inlay == null) {
                this.inlays.put("__context__", (Inlay<FilterRenderer>)inlayModel.addBlockElement(text2.length() + variableNameLength, true, false, 0, (EditorCustomElementRenderer)new FilterRenderer("whole template: " + labelText)));
            } else {
                FilterRenderer filterRenderer = (FilterRenderer)inlay.getRenderer();
                filterRenderer.setText("whole template: " + labelText);
                inlay.update();
            }
        }
        for (String string : variables) {
            Disposer.dispose((Disposable)((Disposable)this.inlays.remove(string)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseMoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "caretPositionChanged";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "documentChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FilterRenderer
    implements EditorCustomElementRenderer {
        private String myText;

        FilterRenderer(String text2) {
            this.myText = text2;
        }

        public void setText(String text2) {
            this.myText = text2;
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                FilterRenderer.$$$reportNull$$$0(0);
            }
            return FilterRenderer.getFontMetrics(inlay.getEditor()).stringWidth(this.myText) + 12;
        }

        private static Font getFont() {
            return UIManager.getFont("Label.font");
        }

        private static FontMetrics getFontMetrics(Editor editor) {
            return editor.getContentComponent().getFontMetrics(FilterRenderer.getFont());
        }

        public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
            Color foregroundColor;
            Editor editor;
            TextAttributes attributes2;
            if (inlay == null) {
                FilterRenderer.$$$reportNull$$$0(1);
            }
            if (g == null) {
                FilterRenderer.$$$reportNull$$$0(2);
            }
            if (r == null) {
                FilterRenderer.$$$reportNull$$$0(3);
            }
            if (textAttributes == null) {
                FilterRenderer.$$$reportNull$$$0(4);
            }
            if ((attributes2 = (editor = inlay.getEditor()).getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT)) == null) {
                return;
            }
            FontMetrics metrics = FilterRenderer.getFontMetrics(editor);
            Color backgroundColor = attributes2.getBackgroundColor();
            if (backgroundColor != null) {
                GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
                GraphicsUtil.paintWithAlpha((Graphics)g, (float)0.55f);
                g.setColor(backgroundColor);
                g.fillRoundRect(r.x + 2, r.y, r.width - 4, r.height, 8, 8);
                config2.restore();
            }
            if ((foregroundColor = attributes2.getForegroundColor()) != null) {
                g.setColor(foregroundColor);
                g.setFont(FilterRenderer.getFont());
                g.drawString(this.myText, r.x + 6, r.y + metrics.getAscent());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler$FilterRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcWidthInPixels";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

