/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ReportValue;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.serialization.SerializationException;
import com.intellij.tasks.BranchInfo;
import com.intellij.tasks.ChangeListInfo;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskListener;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.context.WorkingContextManager;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.TaskProjectConfiguration;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import javax.swing.Timer;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="TaskManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class TaskManagerImpl
extends TaskManager
implements PersistentStateComponent<Config>,
Disposable {
    private static final Logger LOG = Logger.getInstance(TaskManagerImpl.class);
    private static final DecimalFormat LOCAL_TASK_ID_FORMAT = new DecimalFormat("LOCAL-00000");
    public static final Comparator<Task> TASK_UPDATE_COMPARATOR = (o1, o2) -> {
        int i2 = Comparing.compare((Comparable)o2.getUpdated(), (Comparable)o1.getUpdated());
        return i2 == 0 ? Comparing.compare((Comparable)o2.getCreated(), (Comparable)o1.getCreated()) : i2;
    };
    private static final Convertor<Task, String> KEY_CONVERTOR = o -> o.getId();
    private final Project myProject;
    private final Map<String, Task> myIssueCache;
    private final Map<String, LocalTask> myTasks;
    @NotNull
    private LocalTask myActiveTask;
    private Timer myCacheRefreshTimer;
    private volatile boolean myUpdating;
    private final Config myConfig;
    private final ChangeListAdapter myChangeListListener;
    private final List<TaskRepository> myRepositories;
    private final EventDispatcher<TaskListener> myDispatcher;
    private final Set<TaskRepository> myBadRepositories;

    public TaskManagerImpl(@NotNull Project project) {
        if (project == null) {
            TaskManagerImpl.$$$reportNull$$$0(0);
        }
        this.myIssueCache = Collections.synchronizedMap(new LinkedHashMap());
        this.myTasks = Collections.synchronizedMap(new LinkedHashMap<String, LocalTask>(){

            @Override
            public LocalTask put(String key, LocalTask task2) {
                LocalTask result2 = super.put(key, task2);
                if (this.size() > TaskManagerImpl.this.myConfig.taskHistoryLength) {
                    ArrayList list2 = new ArrayList(this.entrySet());
                    list2.sort((o1, o2) -> TASK_UPDATE_COMPARATOR.compare((Task)o2.getValue(), (Task)o1.getValue()));
                    for (Map.Entry oldest : list2) {
                        if (((LocalTask)oldest.getValue()).isDefault()) continue;
                        this.remove(oldest.getKey());
                        break;
                    }
                }
                return result2;
            }
        });
        this.myActiveTask = TaskManagerImpl.createDefaultTask();
        this.myConfig = new Config();
        this.myRepositories = new ArrayList<TaskRepository>();
        this.myDispatcher = EventDispatcher.create(TaskListener.class);
        this.myBadRepositories = ContainerUtil.newConcurrentSet();
        this.myProject = project;
        this.myChangeListListener = new ChangeListAdapter(){

            public void changeListRemoved(ChangeList list2) {
                LocalTask task2 = TaskManagerImpl.this.getAssociatedTask((LocalChangeList)list2);
                if (task2 != null) {
                    for (ChangeListInfo info2 : task2.getChangeLists()) {
                        if (!Objects.equals(info2.id, ((LocalChangeList)list2).getId())) continue;
                        info2.id = "";
                    }
                }
            }

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList, boolean automatic) {
                if (automatic) {
                    return;
                }
                LocalTask associatedTask = TaskManagerImpl.this.getAssociatedTask((LocalChangeList)newDefaultList);
                if (associatedTask != null && !TaskManagerImpl.this.getActiveTask().equals((Object)associatedTask)) {
                    ApplicationManager.getApplication().invokeLater(() -> TaskManagerImpl.this.activateTask((Task)associatedTask, true), TaskManagerImpl.this.myProject.getDisposed());
                }
            }
        };
        project.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (TaskManagerImpl.this.myProject == project) {
                    TaskManagerImpl.this.projectOpened();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/impl/TaskManagerImpl$3", "projectOpened"));
            }
        });
        TaskRepositoryType.addEPListChangeListener((Disposable)this, () -> {
            List<TaskRepository> repositories = this.myRepositories;
            List possibleRepositoryClasses = TaskRepositoryType.getRepositoryClasses();
            boolean removed = repositories.removeIf(repository -> !ContainerUtil.exists((Iterable)possibleRepositoryClasses, clazz -> clazz.isAssignableFrom(repository.getClass())));
            if (removed) {
                this.setRepositories(repositories);
            }
        });
    }

    @TestOnly
    public void prepareForNextTest() {
        this.myTasks.clear();
        LocalTaskImpl defaultTask = TaskManagerImpl.createDefaultTask();
        this.addTask(defaultTask);
        this.myActiveTask = defaultTask;
        this.setRepositories(Collections.emptyList());
    }

    public TaskRepository[] getAllRepositories() {
        return this.myRepositories.toArray(new TaskRepository[0]);
    }

    public <T extends TaskRepository> void setRepositories(@NotNull List<T> repositories) {
        if (repositories == null) {
            TaskManagerImpl.$$$reportNull$$$0(1);
        }
        HashSet<TaskRepository> set2 = new HashSet<TaskRepository>(this.myRepositories);
        repositories.forEach(set2::remove);
        this.myBadRepositories.removeAll(set2);
        this.myIssueCache.clear();
        this.myRepositories.clear();
        this.myRepositories.addAll(repositories);
        List<TaskProjectConfiguration.SharedServer> servers = this.getProjectConfiguration().servers;
        servers.clear();
        block0: for (TaskRepository repository : repositories) {
            if (!repository.isShared() || repository.getUrl() == null) continue;
            TaskRepositoryType type = repository.getRepositoryType();
            for (TaskProjectConfiguration.SharedServer server : servers) {
                if (!repository.getUrl().equals(server.url) || !type.getName().equals(server.type)) continue;
                continue block0;
            }
            TaskProjectConfiguration.SharedServer server = new TaskProjectConfiguration.SharedServer();
            server.type = type.getName();
            server.url = repository.getUrl();
            servers.add(server);
        }
        this.clearNonExistentRepositoriesFromTasks();
    }

    private void clearNonExistentRepositoriesFromTasks() {
        for (LocalTask task2 : this.myTasks.values()) {
            TaskRepository repository = task2.getRepository();
            if (repository == null || this.myRepositories.contains(repository) || !(task2 instanceof LocalTaskImpl)) continue;
            ((LocalTaskImpl)task2).setRepository(null);
        }
    }

    public void removeTask(@NotNull LocalTask task2) {
        if (task2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(2);
        }
        if (task2.isDefault()) {
            return;
        }
        if (this.myActiveTask.equals((Object)task2)) {
            this.activateTask((Task)this.myTasks.get("Default"), true);
        }
        this.myTasks.remove(task2.getId());
        ((TaskListener)this.myDispatcher.getMulticaster()).taskRemoved(task2);
        WorkingContextManager.getInstance(this.myProject).removeContext((Task)task2);
    }

    public void addTaskListener(TaskListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addTaskListener(@NotNull TaskListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            TaskManagerImpl.$$$reportNull$$$0(4);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @NotNull
    public LocalTask getActiveTask() {
        LocalTask localTask = this.myActiveTask;
        if (localTask == null) {
            TaskManagerImpl.$$$reportNull$$$0(5);
        }
        return localTask;
    }

    @Nullable
    public LocalTask findTask(String id2) {
        return this.myTasks.get(id2);
    }

    @NotNull
    public List<Task> getIssues(@Nullable String query2) {
        List<Task> list2 = this.getIssues(query2, true);
        if (list2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    public List<Task> getIssues(@Nullable String query2, boolean forceRequest) {
        return this.getIssues(query2, 0, 50, true, (ProgressIndicator)new EmptyProgressIndicator(), forceRequest);
    }

    public List<Task> getIssues(@Nullable String query2, int offset, int limit, boolean withClosed, @NotNull ProgressIndicator indicator2, boolean forceRequest) {
        List<Task> tasks;
        if (indicator2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(7);
        }
        if ((tasks = this.getIssuesFromRepositories(query2, offset, limit, withClosed, forceRequest, indicator2)) == null) {
            return this.getCachedIssues(withClosed);
        }
        this.myIssueCache.putAll(ContainerUtil.newMapFromValues(tasks.iterator(), KEY_CONVERTOR));
        return ContainerUtil.filter(tasks, task2 -> withClosed || !task2.isClosed());
    }

    public List<Task> getCachedIssues() {
        return this.getCachedIssues(true);
    }

    public List<Task> getCachedIssues(boolean withClosed) {
        return ContainerUtil.filter(this.myIssueCache.values(), task2 -> withClosed || !task2.isClosed());
    }

    private void updateIssue(@NotNull String id2) {
        if (id2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(8);
        }
        for (TaskRepository repository : this.getAllRepositories()) {
            if (repository.extractId(id2) == null) continue;
            try {
                LOG.info("Searching for task '" + id2 + "' in " + repository);
                Task issue = repository.findTask(id2);
                if (issue == null) continue;
                LocalTask localTask = this.findTask(id2);
                if (localTask != null) {
                    localTask.updateFromIssue(issue);
                    return;
                }
                return;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
    }

    public List<LocalTask> getLocalTasks() {
        return this.getLocalTasks(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocalTask> getLocalTasks(boolean withClosed) {
        Map<String, LocalTask> map2 = this.myTasks;
        synchronized (map2) {
            return ContainerUtil.filter(this.myTasks.values(), task2 -> withClosed || !this.isLocallyClosed((LocalTask)task2));
        }
    }

    public LocalTask addTask(@NotNull Task issue) {
        if (issue == null) {
            TaskManagerImpl.$$$reportNull$$$0(9);
        }
        LocalTaskImpl task2 = issue instanceof LocalTaskImpl ? (LocalTaskImpl)issue : new LocalTaskImpl(issue);
        this.addTask(task2);
        return task2;
    }

    public LocalTaskImpl createLocalTask(@NotNull @Nls String summary) {
        if (summary == null) {
            TaskManagerImpl.$$$reportNull$$$0(10);
        }
        return TaskManagerImpl.createTask(LOCAL_TASK_ID_FORMAT.format(this.myConfig.localTasksCounter++), summary);
    }

    private static LocalTaskImpl createTask(@NotNull String id2, @NotNull @Nls String summary) {
        if (id2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(11);
        }
        if (summary == null) {
            TaskManagerImpl.$$$reportNull$$$0(12);
        }
        LocalTaskImpl task2 = new LocalTaskImpl(id2, summary);
        Date date = new Date();
        task2.setCreated(date);
        task2.setUpdated(date);
        return task2;
    }

    public LocalTask activateTask(@NotNull Task origin, boolean clearContext) {
        if (origin == null) {
            TaskManagerImpl.$$$reportNull$$$0(13);
        }
        return this.activateTask(origin, clearContext, false);
    }

    public LocalTask activateTask(@NotNull Task origin, boolean clearContext, boolean newTask) {
        LocalTask activeTask;
        if (origin == null) {
            TaskManagerImpl.$$$reportNull$$$0(14);
        }
        if (origin.equals((Object)(activeTask = this.getActiveTask()))) {
            return activeTask;
        }
        this.saveActiveTask();
        LocalTask task2 = this.doActivate(origin, true);
        Runnable restore2 = () -> {
            WorkingContextManager contextManager = WorkingContextManager.getInstance(this.myProject);
            if (clearContext) {
                contextManager.clearContext();
            }
            contextManager.restoreContext(origin);
        };
        boolean switched = false;
        if (this.isVcsEnabled()) {
            this.restoreVcsContext(task2, newTask);
            if (!newTask) {
                switched = this.switchBranch(task2, restore2);
            }
        }
        if (!switched) {
            restore2.run();
        }
        return task2;
    }

    private void restoreVcsContext(LocalTask task2, boolean newTask) {
        List changeLists = task2.getChangeLists();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        if (changeLists.isEmpty() || !changeListManager.areChangeListsEnabled()) {
            task2.getChangeLists().clear();
            task2.addChangelist(new ChangeListInfo(changeListManager.getDefaultChangeList()));
        } else {
            ChangeListInfo info2 = (ChangeListInfo)changeLists.get(0);
            LocalChangeList changeList = changeListManager.getChangeList(info2.id);
            if (changeList == null) {
                changeList = changeListManager.addChangeList(info2.name, info2.comment);
                info2.id = changeList.getId();
            }
            changeListManager.setDefaultChangeList(changeList);
        }
        this.unshelveChanges(task2);
    }

    private boolean switchBranch(LocalTask task2, Runnable invokeAfter) {
        List branches = task2.getBranches(false);
        MultiMap multiMap = new MultiMap();
        for (BranchInfo branch : branches) {
            multiMap.putValue((Object)branch.repository, (Object)branch);
        }
        block1: for (String repo : multiMap.keySet()) {
            Collection infos = multiMap.get((Object)repo);
            if (infos.size() <= 1) continue;
            List<BranchInfo> existing = this.getAllBranches(repo);
            Iterator iterator2 = infos.iterator();
            while (iterator2.hasNext()) {
                BranchInfo info2 = (BranchInfo)iterator2.next();
                if (existing.contains(info2)) continue;
                iterator2.remove();
                if (infos.size() != 1) continue;
                continue block1;
            }
        }
        VcsTaskHandler.TaskInfo info3 = TaskManagerImpl.fromBranches(new ArrayList<BranchInfo>(multiMap.values()));
        VcsTaskHandler[] handlers = VcsTaskHandler.getAllHandlers((Project)this.myProject);
        boolean switched = false;
        for (VcsTaskHandler handler2 : handlers) {
            switched |= handler2.switchToTask(info3, invokeAfter);
        }
        return switched;
    }

    public void shelveChanges(LocalTask task2, @NotNull String shelfName) {
        Collection changes;
        if (shelfName == null) {
            TaskManagerImpl.$$$reportNull$$$0(15);
        }
        if ((changes = ChangeListManager.getInstance((Project)this.myProject).getDefaultChangeList().getChanges()).isEmpty()) {
            return;
        }
        try {
            ShelveChangesManager.getInstance(this.myProject).shelveChanges(changes, shelfName, true);
            task2.setShelfName(shelfName);
        }
        catch (Exception e) {
            LOG.warn("Can't shelve changes", (Throwable)e);
        }
    }

    private void unshelveChanges(LocalTask task2) {
        String name = task2.getShelfName();
        if (name != null) {
            ShelveChangesManager manager2 = ShelveChangesManager.getInstance(this.myProject);
            for (ShelvedChangeList list2 : manager2.getShelvedChangeLists()) {
                if (!name.equals(list2.DESCRIPTION)) continue;
                manager2.unshelveChangeList(list2, null, list2.getBinaryFiles(), null, true);
                return;
            }
        }
    }

    private List<BranchInfo> getAllBranches(String repo) {
        VcsTaskHandler[] handlers;
        ArrayList<BranchInfo> infos = new ArrayList<BranchInfo>();
        for (VcsTaskHandler handler2 : handlers = VcsTaskHandler.getAllHandlers((Project)this.myProject)) {
            VcsTaskHandler.TaskInfo[] tasks;
            for (VcsTaskHandler.TaskInfo info2 : tasks = handler2.getAllExistingTasks()) {
                infos.addAll(ContainerUtil.filter((Collection)BranchInfo.fromTaskInfo((VcsTaskHandler.TaskInfo)info2, (boolean)false), info1 -> Objects.equals(info1.repository, repo)));
            }
        }
        return infos;
    }

    private static VcsTaskHandler.TaskInfo fromBranches(List<BranchInfo> branches) {
        if (branches.isEmpty()) {
            return new VcsTaskHandler.TaskInfo(null, Collections.emptyList());
        }
        MultiMap map2 = new MultiMap();
        for (BranchInfo branch : branches) {
            map2.putValue((Object)branch.name, (Object)branch.repository);
        }
        Map.Entry next = (Map.Entry)map2.entrySet().iterator().next();
        return new VcsTaskHandler.TaskInfo((String)next.getKey(), (Collection)next.getValue());
    }

    public void createBranch(LocalTask task2, LocalTask previousActive, String name, @Nullable VcsTaskHandler.TaskInfo branchFrom) {
        VcsTaskHandler[] handlers;
        for (VcsTaskHandler handler2 : handlers = VcsTaskHandler.getAllHandlers((Project)this.myProject)) {
            VcsTaskHandler.TaskInfo[] info2 = handler2.getCurrentTasks();
            if (previousActive != null && previousActive.getBranches(false).isEmpty()) {
                TaskManagerImpl.addBranches(previousActive, info2, false);
            }
            TaskManagerImpl.addBranches(task2, info2, true);
            if (info2.length == 0 && branchFrom != null) {
                TaskManagerImpl.addBranches(task2, new VcsTaskHandler.TaskInfo[]{branchFrom}, true);
            }
            TaskManagerImpl.addBranches(task2, new VcsTaskHandler.TaskInfo[]{handler2.startNewTask(name)}, false);
        }
    }

    public void mergeBranch(LocalTask task2) {
        VcsTaskHandler[] handlers;
        VcsTaskHandler.TaskInfo original = TaskManagerImpl.fromBranches(task2.getBranches(true));
        VcsTaskHandler.TaskInfo feature = TaskManagerImpl.fromBranches(task2.getBranches(false));
        for (VcsTaskHandler handler2 : handlers = VcsTaskHandler.getAllHandlers((Project)this.myProject)) {
            handler2.closeTask(feature, original);
        }
    }

    public static void addBranches(LocalTask task2, VcsTaskHandler.TaskInfo[] info2, boolean original) {
        for (VcsTaskHandler.TaskInfo taskInfo : info2) {
            List branchInfos = BranchInfo.fromTaskInfo((VcsTaskHandler.TaskInfo)taskInfo, (boolean)original);
            for (BranchInfo branchInfo : branchInfos) {
                task2.addBranch(branchInfo);
            }
        }
    }

    private void saveActiveTask() {
        WorkingContextManager.getInstance(this.myProject).saveContext((Task)this.myActiveTask);
        this.myActiveTask.setUpdated(new Date());
        String shelfName = this.myActiveTask.getShelfName();
        if (shelfName != null) {
            this.shelveChanges(this.myActiveTask, shelfName);
        }
    }

    private LocalTask doActivate(Task origin, boolean explicitly) {
        LocalTask oldActiveTask;
        LocalTaskImpl task2;
        LocalTaskImpl localTaskImpl = task2 = origin instanceof LocalTaskImpl ? (LocalTaskImpl)origin : new LocalTaskImpl(origin);
        if (explicitly) {
            task2.setUpdated(new Date());
        }
        this.myActiveTask.setActive(false);
        task2.setActive(true);
        this.addTask(task2);
        if (task2.isIssue()) {
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> ProgressManager.getInstance().run((com.intellij.openapi.progress.Task)new Task.Backgroundable(this.myProject, TaskBundle.message("progress.title.updating", task2.getPresentableId())){

                public void run(@NotNull ProgressIndicator indicator2) {
                    if (indicator2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    TaskManagerImpl.this.updateIssue(task2.getId());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/impl/TaskManagerImpl$4", "run"));
                }
            }));
        }
        boolean isChanged = !task2.equals(oldActiveTask = this.myActiveTask);
        this.myActiveTask = task2;
        if (isChanged) {
            ((TaskListener)this.myDispatcher.getMulticaster()).taskDeactivated(oldActiveTask);
            ((TaskListener)this.myDispatcher.getMulticaster()).taskActivated((LocalTask)task2);
        }
        return task2;
    }

    private void addTask(@NotNull LocalTaskImpl task2) {
        if (task2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(16);
        }
        this.myTasks.put(task2.getId(), task2);
        ((TaskListener)this.myDispatcher.getMulticaster()).taskAdded((LocalTask)task2);
    }

    public boolean testConnection(final TaskRepository repository) {
        TestConnectionTask task2 = new TestConnectionTask(TaskBundle.message("dialog.title.test.connection", new Object[0])){

            /*
             * Unable to fully structure code
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                indicator.setText(TaskBundle.message("progress.text.connecting.to", new Object[]{repository.getUrl()}));
                indicator.setFraction(0.0);
                indicator.setIndeterminate(true);
                try {
                    this.myConnection = repository.createCancellableConnection();
                    if (this.myConnection != null) {
                        future = ApplicationManager.getApplication().executeOnPooledThread((Callable)this.myConnection);
                        while (true) lbl-1000:
                        // 2 sources

                        {
                            try {
                                this.myException = (Exception)future.get(100L, TimeUnit.MILLISECONDS);
                                return;
                            }
                            catch (TimeoutException ignore) {
                                try {
                                    indicator.checkCanceled();
                                    continue;
                                }
                                catch (ProcessCanceledException e) {
                                    this.myException = e;
                                    this.myConnection.cancel();
                                    return;
                                }
                            }
                            ** while (true)
                            catch (Exception e) {
                                this.myException = e;
                                return;
                            }
                            break;
                        }
                    }
                    try {
                        repository.testConnection();
                    }
                    catch (Exception e) {
                        TaskManagerImpl.LOG.info((Throwable)e);
                        this.myException = e;
                    }
                }
                catch (Exception e) {
                    this.myException = e;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/impl/TaskManagerImpl$5", "run"));
            }
        };
        ProgressManager.getInstance().run((com.intellij.openapi.progress.Task)task2);
        Exception e = task2.myException;
        if (e == null) {
            this.myBadRepositories.remove(repository);
            Messages.showMessageDialog((Project)this.myProject, (String)TaskBundle.message("dialog.message.connection.successful", new Object[0]), (String)TaskBundle.message("dialog.title.connection", new Object[0]), (Icon)Messages.getInformationIcon());
        } else if (!(e instanceof ProcessCanceledException)) {
            String message2 = e.getMessage();
            if (e instanceof UnknownHostException) {
                message2 = TaskBundle.message("dialog.message.unknown.host", message2);
            }
            if (message2 == null) {
                LOG.error((Throwable)e);
                message2 = TaskBundle.message("dialog.message.unknown.error", new Object[0]);
            }
            Messages.showErrorDialog((Project)this.myProject, (String)StringUtil.capitalize((String)message2), (String)TaskBundle.message("dialog.title.error", new Object[0]));
        }
        return e == null;
    }

    @NotNull
    public Config getState() {
        this.myConfig.tasks = ContainerUtil.map(this.myTasks.values(), task2 -> new LocalTaskImpl((Task)task2));
        this.myConfig.servers = XmlSerializer.serialize((Object)this.getAllRepositories());
        Config config2 = this.myConfig;
        if (config2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(17);
        }
        return config2;
    }

    public void loadState(@NotNull Config config2) {
        if (config2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(18);
        }
        config2.branchNameFormat = TaskUtil.updateToVelocity(config2.branchNameFormat);
        config2.changelistNameFormat = TaskUtil.updateToVelocity(config2.changelistNameFormat);
        XmlSerializerUtil.copyBean((Object)config2, (Object)this.myConfig);
        this.myRepositories.clear();
        Element element2 = config2.servers;
        ArrayList<TaskRepository> repositories = TaskManagerImpl.loadRepositories(element2);
        this.myRepositories.addAll(repositories);
        this.myTasks.clear();
        for (LocalTaskImpl task2 : config2.tasks) {
            String url;
            if (task2.getRepository() == null && (url = task2.getIssueUrl()) != null) {
                for (TaskRepository repository : repositories) {
                    if (repository.getUrl() == null || !url.startsWith(repository.getUrl())) continue;
                    task2.setRepository(repository);
                }
            }
            this.addTask(task2);
        }
    }

    public static ArrayList<TaskRepository> loadRepositories(@NotNull Element element2) {
        if (element2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(19);
        }
        ArrayList<TaskRepository> repositories = new ArrayList<TaskRepository>();
        for (TaskRepositoryType repositoryType : TaskRepositoryType.getRepositoryTypes()) {
            for (Element o : element2.getChildren(repositoryType.getName())) {
                try {
                    TaskRepository repository = (TaskRepository)XmlSerializer.deserialize((Element)o, (Class)repositoryType.getRepositoryClass());
                    repository.setRepositoryType(repositoryType);
                    repository.initializeRepository();
                    repositories.add(repository);
                }
                catch (SerializationException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return repositories;
    }

    @TestOnly
    public void callProjectOpened() {
        this.projectOpened();
    }

    private void projectOpened() {
        TaskProjectConfiguration projectConfiguration = this.getProjectConfiguration();
        block0: for (TaskProjectConfiguration.SharedServer server : projectConfiguration.servers) {
            if (server.type == null || server.url == null) continue;
            for (TaskRepositoryType repositoryType : TaskRepositoryType.getRepositoryTypes()) {
                if (!repositoryType.getName().equals(server.type)) continue;
                for (TaskRepository repository : this.myRepositories) {
                    if (!repositoryType.equals(repository.getRepositoryType()) || !server.url.equals(repository.getUrl())) continue;
                    continue block0;
                }
                TaskRepository repository = repositoryType.createRepository();
                repository.setUrl(server.url);
                repository.setShared(true);
                this.myRepositories.add(repository);
            }
        }
        LocalTask defaultTask = this.findTask("Default");
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        LocalChangeList defaultList = changeListManager.findChangeList(LocalChangeList.getDefaultName());
        if (defaultList != null && defaultTask != null) {
            ChangeListInfo listInfo = new ChangeListInfo(defaultList);
            if (!defaultTask.getChangeLists().contains(listInfo)) {
                defaultTask.addChangelist(listInfo);
            }
        }
        for (LocalTask localTask : this.getLocalTasks()) {
            Iterator iterator2 = localTask.getChangeLists().iterator();
            while (iterator2.hasNext()) {
                ChangeListInfo changeListInfo = (ChangeListInfo)iterator2.next();
                if (changeListManager.getChangeList(changeListInfo.id) != null) continue;
                iterator2.remove();
            }
        }
        changeListManager.addChangeListListener((ChangeListListener)this.myChangeListListener, (Disposable)this.myProject);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> WorkingContextManager.getInstance(this.myProject).pack(200, 50));
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.startRefreshTimer();
        }
    }

    private TaskProjectConfiguration getProjectConfiguration() {
        return (TaskProjectConfiguration)this.myProject.getService(TaskProjectConfiguration.class);
    }

    public void initializeComponent() {
        LocalTask defaultTask = this.findTask("Default");
        if (defaultTask == null) {
            defaultTask = TaskManagerImpl.createDefaultTask();
            this.addTask((Task)defaultTask);
        }
        LocalTask activeTask = null;
        List<LocalTask> tasks = this.getLocalTasks();
        tasks.sort(TASK_UPDATE_COMPARATOR);
        for (LocalTask task2 : tasks) {
            if (activeTask == null) {
                if (!task2.isActive()) continue;
                activeTask = task2;
                continue;
            }
            task2.setActive(false);
        }
        if (activeTask == null) {
            activeTask = defaultTask;
        }
        this.myActiveTask = activeTask;
        this.doActivate((Task)this.myActiveTask, false);
        ((TaskListener)this.myDispatcher.getMulticaster()).taskActivated(this.myActiveTask);
    }

    void startRefreshTimer() {
        this.myCacheRefreshTimer = TimerUtil.createNamedTimer((String)"TaskManager refresh", (int)(this.myConfig.updateInterval * 60 * 1000), (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (TaskManagerImpl.this.myConfig.updateEnabled && !TaskManagerImpl.this.myUpdating) {
                    LOG.debug("Updating issues cache (every " + TaskManagerImpl.this.myConfig.updateInterval + " min)");
                    TaskManagerImpl.this.updateIssues(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/impl/TaskManagerImpl$6", "actionPerformed"));
            }
        });
        this.myCacheRefreshTimer.setInitialDelay(0);
        this.myCacheRefreshTimer.start();
    }

    @NotNull
    private static LocalTaskImpl createDefaultTask() {
        LocalTaskImpl task2 = new LocalTaskImpl("Default", TaskBundle.message("default.task", new Object[0]));
        Date date = new Date();
        task2.setCreated(date);
        task2.setUpdated(date);
        LocalTaskImpl localTaskImpl = task2;
        if (localTaskImpl == null) {
            TaskManagerImpl.$$$reportNull$$$0(20);
        }
        return localTaskImpl;
    }

    public void dispose() {
        if (this.myCacheRefreshTimer != null) {
            this.myCacheRefreshTimer.stop();
        }
    }

    public void updateIssues(@Nullable Runnable onComplete) {
        TaskRepository first = (TaskRepository)ContainerUtil.find((Object[])this.getAllRepositories(), repository -> repository.isConfigured());
        if (first == null) {
            this.myIssueCache.clear();
            if (onComplete != null) {
                onComplete.run();
            }
            return;
        }
        this.myUpdating = true;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doUpdate(onComplete);
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.doUpdate(onComplete));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(@Nullable Runnable onComplete) {
        try {
            List<Task> issues = this.getIssuesFromRepositories(null, 0, this.myConfig.updateIssuesCount, false, false, (ProgressIndicator)new EmptyProgressIndicator());
            if (issues == null) {
                return;
            }
            Map<String, Task> map2 = this.myIssueCache;
            synchronized (map2) {
                this.myIssueCache.clear();
                for (Task task2 : issues) {
                    this.myIssueCache.put(task2.getId(), task2);
                }
            }
            map2 = this.myTasks;
            synchronized (map2) {
                for (Map.Entry entry2 : this.myTasks.entrySet()) {
                    Task issue = this.myIssueCache.get(entry2.getKey());
                    if (issue == null) continue;
                    ((LocalTask)entry2.getValue()).updateFromIssue(issue);
                }
            }
        }
        finally {
            if (onComplete != null) {
                onComplete.run();
            }
            this.myUpdating = false;
        }
    }

    @Nullable
    private List<Task> getIssuesFromRepositories(@Nullable String request, int offset, int limit, boolean withClosed, boolean forceRequest, @NotNull ProgressIndicator cancelled) {
        if (cancelled == null) {
            TaskManagerImpl.$$$reportNull$$$0(21);
        }
        ArrayList<Task> issues = null;
        for (TaskRepository repository : this.getAllRepositories()) {
            if (!repository.isConfigured() || !forceRequest && this.myBadRepositories.contains(repository)) continue;
            try {
                long start2 = System.currentTimeMillis();
                Object[] tasks = repository.getIssues(request, offset, limit, withClosed, cancelled);
                long timeSpent = System.currentTimeMillis() - start2;
                LOG.debug(String.format("Total %s ms to download %d issues from '%s' (pattern '%s')", timeSpent, tasks.length, repository.getUrl(), request));
                this.myBadRepositories.remove(repository);
                if (issues == null) {
                    issues = new ArrayList<Task>(tasks.length);
                }
                if (!repository.isSupported(16) && request != null) {
                    List<Task> filteredTasks = TaskUtil.filterTasks(request, Arrays.asList(tasks));
                    issues.addAll(filteredTasks);
                    continue;
                }
                ContainerUtil.addAll(issues, (Object[])tasks);
            }
            catch (ProcessCanceledException start2) {
            }
            catch (Exception e) {
                String reason = "";
                if (e.getClass() == Exception.class || e instanceof RequestFailedException) {
                    reason = e.getMessage();
                }
                if (e instanceof SocketTimeoutException || e instanceof HttpRequests.HttpStatusException) {
                    LOG.warn("Can't connect to " + repository + ": " + e.getMessage());
                } else {
                    LOG.warn("Cannot connect to " + repository, (Throwable)e);
                }
                this.myBadRepositories.add(repository);
                if (!forceRequest) continue;
                throw new RequestFailedException(repository, reason);
            }
        }
        return issues;
    }

    public boolean isVcsEnabled() {
        return ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss().length > 0;
    }

    public AbstractVcs getActiveVcs() {
        AbstractVcs[] vcss = ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss();
        if (vcss.length == 0) {
            return null;
        }
        for (AbstractVcs vcs : vcss) {
            if (vcs.getType() != VcsType.distributed) continue;
            return vcs;
        }
        return vcss[0];
    }

    public boolean isLocallyClosed(@NotNull LocalTask localTask) {
        if (localTask == null) {
            TaskManagerImpl.$$$reportNull$$$0(22);
        }
        if (!this.isVcsEnabled()) {
            return false;
        }
        List lists = localTask.getChangeLists();
        return lists.isEmpty() || lists.stream().anyMatch(list2 -> StringUtil.isEmpty((String)list2.id));
    }

    @Nullable
    public LocalTask getAssociatedTask(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(23);
        }
        if (TaskManagerImpl.hasChangelist(this.getActiveTask(), list2)) {
            return this.getActiveTask();
        }
        for (LocalTask task2 : this.getLocalTasks()) {
            if (!TaskManagerImpl.hasChangelist(task2, list2)) continue;
            return task2;
        }
        return null;
    }

    private static boolean hasChangelist(LocalTask task2, LocalChangeList list2) {
        for (ChangeListInfo changeListInfo : new ArrayList(task2.getChangeLists())) {
            if (!changeListInfo.id.equals(list2.getId())) continue;
            return true;
        }
        return false;
    }

    public void trackContext(@NotNull LocalChangeList changeList) {
        if (changeList == null) {
            TaskManagerImpl.$$$reportNull$$$0(24);
        }
        ChangeListInfo changeListInfo = new ChangeListInfo(changeList);
        String changeListName = changeList.getName();
        LocalTaskImpl task2 = this.createLocalTask(changeListName);
        task2.addChangelist(changeListInfo);
        this.addTask(task2);
        if (changeList.isDefault()) {
            this.activateTask((Task)task2, false);
        }
    }

    public void createChangeList(@NotNull LocalTask task2, String name) {
        if (task2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(25);
        }
        String comment = TaskUtil.getChangeListComment((Task)task2);
        this.createChangeList(task2, name, comment);
    }

    private void createChangeList(LocalTask task2, String name, @Nullable String comment) {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        LocalChangeList changeList = changeListManager.findChangeList(name);
        if (changeList == null) {
            changeList = changeListManager.addChangeList(name, comment);
        } else {
            LocalTask associatedTask = this.getAssociatedTask(changeList);
            if (associatedTask != null) {
                associatedTask.removeChangelist(new ChangeListInfo(changeList));
            }
            changeListManager.editComment(name, comment);
        }
        task2.addChangelist(new ChangeListInfo(changeList));
        changeListManager.setDefaultChangeList(changeList);
    }

    public String getChangelistName(Task task2) {
        String name = task2.isIssue() && this.myConfig.changelistNameFormat != null ? TaskUtil.formatTask(task2, this.myConfig.changelistNameFormat) : task2.getSummary();
        return StringUtil.shortenTextWithEllipsis((String)name, (int)100, (int)0);
    }

    @NotNull
    public String suggestBranchName(@NotNull Task task2, String separator) {
        if (task2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(26);
        }
        String name = this.constructDefaultBranchName(task2);
        if (task2.isIssue()) {
            String string = name.replace(" ", separator);
            if (string == null) {
                TaskManagerImpl.$$$reportNull$$$0(27);
            }
            return string;
        }
        List words = StringUtil.getWordsIn((String)name);
        String[] strings = ArrayUtilRt.toStringArray((Collection)words);
        String string = StringUtil.join((String[])strings, (int)0, (int)Math.min(2, strings.length), (String)separator);
        if (string == null) {
            TaskManagerImpl.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    public String suggestBranchName(@NotNull Task task2) {
        if (task2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(29);
        }
        String string = this.suggestBranchName(task2, "-");
        if (string == null) {
            TaskManagerImpl.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public String constructDefaultBranchName(@NotNull Task task2) {
        if (task2 == null) {
            TaskManagerImpl.$$$reportNull$$$0(31);
        }
        String string = task2.isIssue() ? TaskUtil.formatTask(task2, this.myConfig.branchNameFormat) : task2.getSummary();
        if (string == null) {
            TaskManagerImpl.$$$reportNull$$$0(32);
        }
        return string;
    }

    @TestOnly
    public ChangeListAdapter getChangeListListener() {
        return this.myChangeListListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 17: 
            case 20: 
            case 27: 
            case 28: 
            case 30: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 17: 
            case 20: 
            case 27: 
            case 28: 
            case 30: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 2: 
            case 16: 
            case 25: 
            case 26: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: 
            case 6: 
            case 17: 
            case 20: 
            case 27: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/impl/TaskManagerImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "summary";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelfName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelled";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTask";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/impl/TaskManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveTask";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssues";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultTask";
                break;
            }
            case 27: 
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestBranchName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "constructDefaultBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRepositories";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTaskListener";
                break;
            }
            case 5: 
            case 6: 
            case 17: 
            case 20: 
            case 27: 
            case 28: 
            case 30: 
            case 32: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIssues";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateIssue";
                break;
            }
            case 9: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addTask";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLocalTask";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "activateTask";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shelveChanges";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadRepositories";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getIssuesFromRepositories";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isLocallyClosed";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedTask";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "trackContext";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createChangeList";
                break;
            }
            case 26: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "suggestBranchName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "constructDefaultBranchName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 17: 
            case 20: 
            case 27: 
            case 28: 
            case 30: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Activity
    implements StartupActivity.DumbAware {
        private Activity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                Activity.$$$reportNull$$$0(0);
            }
            ((TaskManagerImpl)TaskManager.getManager((Project)project)).projectOpened();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/impl/TaskManagerImpl$Activity", "runActivity"));
        }
    }

    private abstract class TestConnectionTask
    extends Task.Modal {
        protected Exception myException;
        @Nullable
        protected TaskRepository.CancellableConnection myConnection;

        TestConnectionTask(String title2) {
            super(TaskManagerImpl.this.myProject, title2, true);
        }

        public void onCancel() {
            if (this.myConnection != null) {
                this.myConnection.cancel();
            }
        }
    }

    public static class Config {
        @Property(surroundWithTag=false)
        @XCollection(elementName="task")
        public List<LocalTaskImpl> tasks = new ArrayList<LocalTaskImpl>();
        public int localTasksCounter = 1;
        @ReportValue
        public int taskHistoryLength = 50;
        public boolean updateEnabled = true;
        @ReportValue
        public int updateInterval = 20;
        @ReportValue
        public int updateIssuesCount = 100;
        public boolean clearContext = true;
        public boolean createChangelist = true;
        public boolean createBranch = true;
        public boolean useBranch = false;
        public boolean shelveChanges = false;
        public boolean commitChanges = true;
        public boolean mergeBranch = true;
        public boolean saveContextOnCommit = true;
        public boolean trackContextForNewChangelist = false;
        public String changelistNameFormat = "${id} ${summary}";
        public String branchNameFormat = "${id}";
        public boolean searchClosedTasks = false;
        @Tag(value="servers")
        public Element servers = new Element("servers");
    }
}

