/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsActions;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolManager;
import com.intellij.tools.ToolsGroup;
import java.util.List;

public abstract class BaseToolKeymapExtension
implements KeymapExtension {
    public KeymapGroup createGroup(Condition<? super AnAction> filtered2, Project project) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        Group rootGroup = new Group(this.getRootGroupName(), this.getRootGroupId(), AllIcons.Nodes.KeymapTools);
        List groups2 = ToolManager.getInstance().getGroups();
        for (ToolsGroup toolsGroup : groups2) {
            String groupName = toolsGroup.getName();
            Group group2 = new Group(groupName, this.getGroupIdPrefix() + groupName, null);
            List<? extends Tool> tools = this.getToolsIdsByGroupName(groupName);
            for (Tool tool : tools) {
                if (filtered2 != null && !filtered2.value((Object)actionManager.getActionOrStub(tool.getActionId()))) continue;
                group2.addGroup(new Group(tool.getName(), tool.getActionId(), null));
            }
            if (group2.getSize() <= 0) continue;
            rootGroup.addGroup(group2);
        }
        return rootGroup;
    }

    protected abstract String getGroupIdPrefix();

    protected abstract String getActionIdPrefix();

    protected abstract List<? extends Tool> getToolsIdsByGroupName(String var1);

    @NlsActions.ActionText
    protected abstract String getRootGroupName();

    protected abstract String getRootGroupId();
}

