/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.CompoundScheme;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.tools.BaseToolManager;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolEditorDialog;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsGroup;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseToolsPanel<T extends Tool>
extends JPanel {
    private final CheckboxTree myTree;
    private final AnActionButton myAddButton;
    private final AnActionButton myCopyButton;
    private final AnActionButton myEditButton;
    private final AnActionButton myMoveUpButton;
    private final AnActionButton myMoveDownButton;
    private final AnActionButton myRemoveButton;
    private boolean myIsModified = false;
    private final CompoundScheme.MutatorHelper<ToolsGroup<T>, T> mutatorHelper = new CompoundScheme.MutatorHelper();

    protected BaseToolsPanel() {
        this.myTree = new CheckboxTree(this.getTreeCellRenderer(), new CheckedTreeNode(null)){

            protected void onDoubleClick(CheckedTreeNode node2) {
                BaseToolsPanel.this.editSelected();
            }

            protected void onNodeStateChanged(CheckedTreeNode node2) {
                BaseToolsPanel.this.myIsModified = true;
            }
        };
        this.myTree.setRootVisible(false);
        this.myTree.getEmptyText().setText(ToolsBundle.message("tools.not.configured", new Object[0]));
        this.myTree.setSelectionModel(new DefaultTreeSelectionModel());
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.setLayout(new BorderLayout());
        this.myCopyButton = new AnActionButton(ToolsBundle.message("tools.copy.button", new Object[0]), PlatformIcons.COPY_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Tool originalTool;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((originalTool = BaseToolsPanel.this.getSelectedTool()) != null) {
                    ToolEditorDialog dlg = BaseToolsPanel.this.createToolEditorDialog(ToolsBundle.message("tools.copy.title", new Object[0]));
                    Tool toolCopy = dlg.createTool();
                    toolCopy.copyFrom(originalTool);
                    dlg.setData(toolCopy, BaseToolsPanel.this.getGroups());
                    if (dlg.showAndGet()) {
                        BaseToolsPanel.this.insertNewTool(dlg.getData(), true);
                    }
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)BaseToolsPanel.this.myTree), true));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tools/BaseToolsPanel$2", "actionPerformed"));
            }
        };
        this.add((Component)ToolbarDecorator.createDecorator((JTree)((Object)this.myTree)).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button4) {
                ToolEditorDialog dlg = BaseToolsPanel.this.createToolEditorDialog(ToolsBundle.message("tools.add.title", new Object[0]));
                Tool tool = dlg.createTool();
                tool.setUseConsole(true);
                tool.setFilesSynchronizedAfterRun(true);
                tool.setShownInMainMenu(true);
                tool.setShownInEditor(true);
                tool.setShownInProjectViews(true);
                tool.setShownInSearchResultsPopup(true);
                tool.setEnabled(true);
                dlg.setData(tool, BaseToolsPanel.this.getGroups());
                if (dlg.showAndGet()) {
                    BaseToolsPanel.this.insertNewTool(dlg.getData(), true);
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)BaseToolsPanel.this.myTree), true));
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button4) {
                BaseToolsPanel.this.removeSelected();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button4) {
                BaseToolsPanel.this.editSelected();
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)BaseToolsPanel.this.myTree), true));
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button4) {
                BaseToolsPanel.this.moveNode(Direction.UP);
                BaseToolsPanel.this.myIsModified = true;
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button4) {
                BaseToolsPanel.this.moveNode(Direction.DOWN);
                BaseToolsPanel.this.myIsModified = true;
            }
        }).addExtraAction(this.myCopyButton).createPanel(), "Center");
        this.myAddButton = ToolbarDecorator.findAddButton((JComponent)this);
        this.myEditButton = ToolbarDecorator.findEditButton((JComponent)this);
        this.myRemoveButton = ToolbarDecorator.findRemoveButton((JComponent)this);
        this.myMoveUpButton = ToolbarDecorator.findUpButton((JComponent)this);
        this.myMoveDownButton = ToolbarDecorator.findDownButton((JComponent)this);
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                BaseToolsPanel.this.update();
            }
        });
        this.setMinimumSize(this.myTree.getEmptyText().getPreferredSize());
    }

    public void reset() {
        this.mutatorHelper.clear();
        for (ToolsGroup<T> group2 : this.getToolManager().getGroups()) {
            this.addGroupNode(this.mutatorHelper.copy(group2));
        }
        if (this.getTreeRoot().getChildCount() > 0) {
            this.myTree.setSelectionInterval(0, 0);
        } else {
            this.myTree.getSelectionModel().clearSelection();
        }
        this.getModel().nodeStructureChanged(null);
        TreeUtil.expand((JTree)((Object)this.myTree), (int)5);
        this.myIsModified = false;
        this.update();
    }

    protected abstract BaseToolManager<T> getToolManager();

    protected CheckboxTree.CheckboxTreeCellRenderer getTreeCellRenderer() {
        return new MyCheckboxTreeCellRenderer();
    }

    @NotNull
    private CheckedTreeNode addGroupNode(@NotNull ToolsGroup<T> group2) {
        if (group2 == null) {
            BaseToolsPanel.$$$reportNull$$$0(0);
        }
        CheckedTreeNode groupNode = new CheckedTreeNode(group2);
        this.getTreeRoot().add((MutableTreeNode)groupNode);
        for (Tool tool : group2.getElements()) {
            this.addToolNode(groupNode, tool);
        }
        CheckedTreeNode checkedTreeNode = groupNode;
        if (checkedTreeNode == null) {
            BaseToolsPanel.$$$reportNull$$$0(1);
        }
        return checkedTreeNode;
    }

    private CheckedTreeNode addToolNode(@NotNull CheckedTreeNode groupNode, @NotNull Tool tool) {
        if (groupNode == null) {
            BaseToolsPanel.$$$reportNull$$$0(2);
        }
        if (tool == null) {
            BaseToolsPanel.$$$reportNull$$$0(3);
        }
        CheckedTreeNode toolNode = new CheckedTreeNode((Object)tool);
        toolNode.setChecked(tool.isEnabled());
        groupNode.add((MutableTreeNode)toolNode);
        this.nodeWasInserted(toolNode);
        return toolNode;
    }

    private CheckedTreeNode getTreeRoot() {
        return (CheckedTreeNode)this.myTree.getModel().getRoot();
    }

    public void apply() {
        this.getToolManager().setTools(this.mutatorHelper.apply(this.getGroupList()));
        this.myIsModified = false;
    }

    @NotNull
    private List<ToolsGroup<T>> getGroupList() {
        MutableTreeNode root = (MutableTreeNode)this.myTree.getModel().getRoot();
        ArrayList<ToolsGroup<T>> result2 = new ArrayList<ToolsGroup<T>>(root.getChildCount());
        for (int i2 = 0; i2 < root.getChildCount(); ++i2) {
            CheckedTreeNode node2 = (CheckedTreeNode)root.getChildAt(i2);
            for (int j = 0; j < node2.getChildCount(); ++j) {
                CheckedTreeNode toolNode = (CheckedTreeNode)node2.getChildAt(j);
                ((Tool)toolNode.getUserObject()).setEnabled(toolNode.isChecked());
            }
            result2.add((ToolsGroup)node2.getUserObject());
        }
        ArrayList<ToolsGroup<T>> arrayList = result2;
        if (arrayList == null) {
            BaseToolsPanel.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public boolean isModified() {
        return this.myIsModified;
    }

    private void moveNode(Direction direction) {
        CheckedTreeNode node2 = this.getSelectedNode();
        if (node2 != null && BaseToolsPanel.isMovingAvailable(node2, direction)) {
            this.moveNode(node2, direction);
            if (node2.getUserObject() instanceof Tool) {
                ToolsGroup group2 = (ToolsGroup)((CheckedTreeNode)node2.getParent()).getUserObject();
                Tool tool = (Tool)node2.getUserObject();
                BaseToolsPanel.moveElementInsideGroup(tool, group2, direction);
            }
            TreePath path2 = new TreePath(node2.getPath());
            this.myTree.getSelectionModel().setSelectionPath(path2);
            this.myTree.expandPath(path2);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myTree), true));
        }
    }

    private static void moveElementInsideGroup(Tool tool, ToolsGroup group2, Direction dir) {
        if (dir == Direction.UP) {
            group2.moveElementUp(tool);
        } else {
            group2.moveElementDown(tool);
        }
    }

    private void moveNode(CheckedTreeNode toolNode, Direction dir) {
        CheckedTreeNode parentNode = (CheckedTreeNode)toolNode.getParent();
        int index2 = parentNode.getIndex((TreeNode)toolNode);
        this.removeNodeFromParent((DefaultMutableTreeNode)toolNode);
        int newIndex = dir.newIndex(index2);
        parentNode.insert((MutableTreeNode)toolNode, newIndex);
        this.getModel().nodesWereInserted((TreeNode)parentNode, new int[]{newIndex});
    }

    private static boolean isMovingAvailable(CheckedTreeNode toolNode, Direction dir) {
        TreeNode parent = toolNode.getParent();
        int index2 = parent.getIndex((TreeNode)toolNode);
        return dir.isAvailable(index2, parent.getChildCount());
    }

    private void insertNewTool(@NotNull Tool newTool, boolean setSelection) {
        ToolsGroup group2;
        CheckedTreeNode groupNode;
        if (newTool == null) {
            BaseToolsPanel.$$$reportNull$$$0(5);
        }
        if ((groupNode = this.findGroupNode(newTool.getGroup())) == null) {
            group2 = new ToolsGroup(newTool.getGroup());
            groupNode = this.addGroupNode(group2);
            this.nodeWasInserted(groupNode);
        } else {
            group2 = (ToolsGroup)groupNode.getUserObject();
        }
        CheckedTreeNode toolNode = this.addToolNode(groupNode, newTool);
        group2.addElement(newTool);
        if (setSelection) {
            TreePath treePath = new TreePath(toolNode.getPath());
            this.myTree.expandPath(treePath);
            this.myTree.getSelectionModel().setSelectionPath(treePath);
        }
        this.myIsModified = true;
    }

    private void nodeWasInserted(CheckedTreeNode groupNode) {
        this.getModel().nodesWereInserted(groupNode.getParent(), new int[]{groupNode.getParent().getChildCount() - 1});
    }

    private DefaultTreeModel getModel() {
        return (DefaultTreeModel)this.myTree.getModel();
    }

    private CheckedTreeNode findGroupNode(String group2) {
        for (int i2 = 0; i2 < this.getTreeRoot().getChildCount(); ++i2) {
            CheckedTreeNode node2 = (CheckedTreeNode)this.getTreeRoot().getChildAt(i2);
            ToolsGroup g = (ToolsGroup)node2.getUserObject();
            if (!Objects.equals(group2, g.getName())) continue;
            return node2;
        }
        return null;
    }

    @Nullable
    public Tool getSelectedTool() {
        CheckedTreeNode node2 = this.getSelectedToolNode();
        if (node2 == null) {
            return null;
        }
        return node2.getUserObject() instanceof Tool ? (Tool)node2.getUserObject() : null;
    }

    @Nullable
    private ToolsGroup getSelectedToolGroup() {
        CheckedTreeNode node2 = this.getSelectedToolNode();
        if (node2 == null) {
            return null;
        }
        return node2.getUserObject() instanceof ToolsGroup ? (ToolsGroup)node2.getUserObject() : null;
    }

    private void update() {
        CheckedTreeNode node2 = this.getSelectedToolNode();
        Tool selectedTool = this.getSelectedTool();
        ToolsGroup selectedGroup = this.getSelectedToolGroup();
        if (selectedTool != null) {
            this.myAddButton.setEnabled(true);
            this.myCopyButton.setEnabled(true);
            this.myEditButton.setEnabled(true);
            this.myMoveDownButton.setEnabled(BaseToolsPanel.isMovingAvailable(node2, Direction.DOWN));
            this.myMoveUpButton.setEnabled(BaseToolsPanel.isMovingAvailable(node2, Direction.UP));
            this.myRemoveButton.setEnabled(true);
        } else if (selectedGroup != null) {
            this.myAddButton.setEnabled(true);
            this.myCopyButton.setEnabled(false);
            this.myEditButton.setEnabled(false);
            this.myMoveDownButton.setEnabled(BaseToolsPanel.isMovingAvailable(node2, Direction.DOWN));
            this.myMoveUpButton.setEnabled(BaseToolsPanel.isMovingAvailable(node2, Direction.UP));
            this.myRemoveButton.setEnabled(true);
        } else {
            this.myAddButton.setEnabled(true);
            this.myCopyButton.setEnabled(false);
            this.myEditButton.setEnabled(false);
            this.myMoveDownButton.setEnabled(false);
            this.myMoveUpButton.setEnabled(false);
            this.myRemoveButton.setEnabled(false);
        }
        this.getModel().nodeStructureChanged(null);
        this.myTree.repaint();
    }

    private void removeSelected() {
        CheckedTreeNode node2 = this.getSelectedToolNode();
        if (node2 != null) {
            int result2 = Messages.showYesNoDialog((Component)this, (String)ToolsBundle.message("tools.delete.confirmation", new Object[0]), (String)ToolsBundle.message("dialog.title.delete.tool", new Object[0]), (Icon)Messages.getWarningIcon());
            if (result2 != 0) {
                return;
            }
            this.myIsModified = true;
            if (node2.getUserObject() instanceof Tool) {
                Tool tool = (Tool)node2.getUserObject();
                CheckedTreeNode parentNode = (CheckedTreeNode)node2.getParent();
                ((ToolsGroup)parentNode.getUserObject()).removeElement(tool);
                this.removeNodeFromParent((DefaultMutableTreeNode)node2);
                if (parentNode.getChildCount() == 0) {
                    this.removeNodeFromParent((DefaultMutableTreeNode)parentNode);
                }
            } else if (node2.getUserObject() instanceof ToolsGroup) {
                this.removeNodeFromParent((DefaultMutableTreeNode)node2);
            }
            this.update();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myTree), true));
        }
    }

    private void removeNodeFromParent(DefaultMutableTreeNode node2) {
        TreeNode parent = node2.getParent();
        int idx = parent.getIndex(node2);
        node2.removeFromParent();
        this.getModel().nodesWereRemoved(parent, new int[]{idx}, new TreeNode[]{node2});
    }

    private void editSelected() {
        Tool selected2;
        CheckedTreeNode node2 = this.getSelectedToolNode();
        if (node2 != null && node2.getUserObject() instanceof Tool && (selected2 = (Tool)node2.getUserObject()) != null) {
            String oldGroupName = selected2.getGroup();
            ToolEditorDialog dlg = this.createToolEditorDialog(ToolsBundle.message("tools.edit.title", new Object[0]));
            dlg.setData(selected2, this.getGroups());
            if (dlg.showAndGet()) {
                selected2.copyFrom(dlg.getData());
                String newGroupName = selected2.getGroup();
                if (!Objects.equals(oldGroupName, newGroupName)) {
                    CheckedTreeNode oldGroupNode = (CheckedTreeNode)node2.getParent();
                    this.removeNodeFromParent((DefaultMutableTreeNode)node2);
                    ((ToolsGroup)oldGroupNode.getUserObject()).removeElement(selected2);
                    if (oldGroupNode.getChildCount() == 0) {
                        this.removeNodeFromParent((DefaultMutableTreeNode)oldGroupNode);
                    }
                    this.insertNewTool(selected2, true);
                } else {
                    this.getModel().nodeChanged((TreeNode)node2);
                }
                this.myIsModified = true;
                this.update();
            }
        }
    }

    protected ToolEditorDialog createToolEditorDialog(@NlsContexts.DialogTitle String title2) {
        return new ToolEditorDialog(this, title2);
    }

    private CheckedTreeNode getSelectedToolNode() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            return (CheckedTreeNode)selectionPath.getLastPathComponent();
        }
        return null;
    }

    private CheckedTreeNode getSelectedNode() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            return (CheckedTreeNode)selectionPath.getLastPathComponent();
        }
        return null;
    }

    private String @Nls [] getGroups() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (ToolsGroup<T> group2 : this.getGroupList()) {
            result2.add(group2.getName());
        }
        return ArrayUtilRt.toStringArray(result2);
    }

    void addSelectionListener(TreeSelectionListener listener2) {
        this.myTree.getSelectionModel().addTreeSelectionListener(listener2);
    }

    @Nullable
    Tool getSingleSelectedTool() {
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length != 1) {
            return null;
        }
        Object toolOrToolGroup = ((CheckedTreeNode)selectionPaths[0].getLastPathComponent()).getUserObject();
        if (toolOrToolGroup instanceof Tool) {
            return (Tool)toolOrToolGroup;
        }
        return null;
    }

    public void selectTool(final String actionId) {
        Object root = this.myTree.getModel().getRoot();
        if (!(root instanceof CheckedTreeNode)) {
            return;
        }
        final ArrayList nodes = new ArrayList();
        new Object(){

            public void collect(CheckedTreeNode node2) {
                if (node2.isLeaf()) {
                    Object userObject = node2.getUserObject();
                    if (userObject instanceof Tool && actionId.equals(((Tool)userObject).getActionId())) {
                        nodes.add(node2);
                    }
                } else {
                    for (int i2 = 0; i2 < node2.getChildCount(); ++i2) {
                        TreeNode child2 = node2.getChildAt(i2);
                        if (!(child2 instanceof CheckedTreeNode)) continue;
                        this.collect((CheckedTreeNode)child2);
                    }
                }
            }
        }.collect((CheckedTreeNode)root);
        if (nodes.isEmpty()) {
            return;
        }
        this.myTree.getSelectionModel().setSelectionPath(new TreePath(((CheckedTreeNode)nodes.get(0)).getPath()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tools/BaseToolsPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tools/BaseToolsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "addGroupNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addGroupNode";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addToolNode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insertNewTool";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class MyCheckboxTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        protected MyCheckboxTreeCellRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (!(value2 instanceof CheckedTreeNode)) {
                return;
            }
            Object object = ((CheckedTreeNode)value2).getUserObject();
            if (object instanceof ToolsGroup) {
                String groupName = ((ToolsGroup)object).getName();
                this.getTextRenderer().append(groupName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            } else if (object instanceof Tool) {
                this.getTextRenderer().append(((Tool)object).getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        }
    }

    static enum Direction {
        UP{

            @Override
            public boolean isAvailable(int index2, int childCount) {
                return index2 != 0;
            }

            @Override
            public int newIndex(int index2) {
                return index2 - 1;
            }
        }
        ,
        DOWN{

            @Override
            public boolean isAvailable(int index2, int childCount) {
                return index2 < childCount - 1;
            }

            @Override
            public int newIndex(int index2) {
                return index2 + 1;
            }
        };


        public abstract boolean isAvailable(int var1, int var2);

        public abstract int newIndex(int var1);
    }
}

