/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ColoredTextBuilderImpl;
import com.intellij.ui.ColoredTextFragmentImpl;
import com.intellij.ui.ColoredTextImpl;
import com.intellij.ui.SimpleTextAttributes;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface ColoredText {
    @NotNull
    public @NotNull List<? extends @NotNull Fragment> fragments();

    @Contract(pure=true)
    @NotNull
    public static ColoredText empty() {
        ColoredText coloredText = ColoredTextImpl.EMPTY;
        if (coloredText == null) {
            ColoredText.$$$reportNull$$$0(0);
        }
        return coloredText;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ColoredText singleFragment(@Nls @NotNull String fragmentText) {
        if (fragmentText == null) {
            ColoredText.$$$reportNull$$$0(1);
        }
        return ColoredText.singleFragment(fragmentText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ColoredText singleFragment(@Nls @NotNull String fragmentText, @NotNull SimpleTextAttributes attributes2) {
        if (fragmentText == null) {
            ColoredText.$$$reportNull$$$0(2);
        }
        if (attributes2 == null) {
            ColoredText.$$$reportNull$$$0(3);
        }
        return new ColoredTextImpl(new ColoredTextFragmentImpl(fragmentText, attributes2));
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static Builder builder() {
        return new ColoredTextBuilderImpl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ColoredText";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ColoredText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "singleFragment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.NonExtendable
    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        default public Builder append(@Nls @NotNull String fragmentText) {
            if (fragmentText == null) {
                Builder.$$$reportNull$$$0(0);
            }
            Builder builder2 = this.append(fragmentText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder2;
        }

        @Contract(value="_, _ -> this")
        @NotNull
        public Builder append(@Nls @NotNull String var1, @NotNull SimpleTextAttributes var2);

        @Contract(value="-> new", pure=true)
        @NotNull
        public ColoredText build();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragmentText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/ColoredText$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/ColoredText$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "append";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @ApiStatus.NonExtendable
    public static interface Fragment {
        @Nls
        @NotNull
        public String fragmentText();

        @NotNull
        public SimpleTextAttributes fragmentAttributes();
    }
}

