/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.awt.AWTEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteringTree<T extends DefaultMutableTreeNode, U> {
    public static final SpeedSearchSupply DUMMY_SEARCH = new SpeedSearchSupply(){

        @Nullable
        public Iterable<TextRange> matchingFragments(@NotNull String text2) {
            if (text2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return null;
        }

        public void refreshSelection() {
        }

        public boolean isPopupActive() {
            return false;
        }

        public void addChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                1.$$$reportNull$$$0(1);
            }
        }

        public void removeChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                1.$$$reportNull$$$0(2);
            }
        }

        public void findAndSelectElement(@NotNull String searchQuery) {
            if (searchQuery == null) {
                1.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchQuery";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/FilteringTree$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchingFragments";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangeListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeChangeListener";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findAndSelectElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final Project myProject;
    private final T myRoot;
    private final Tree myTree;

    public FilteringTree(@NotNull Project project, @NotNull Tree tree, @NotNull T root) {
        if (project == null) {
            FilteringTree.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            FilteringTree.$$$reportNull$$$0(1);
        }
        if (root == null) {
            FilteringTree.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myRoot = root;
        this.myTree = tree;
        this.myTree.setModel(new SearchTreeModel(this.myRoot, DUMMY_SEARCH, o -> this.getText(o), this::createNode, this::getChildren, this.useIdentityHashing()));
        SwingUtilities.invokeLater(() -> this.rebuildTree());
    }

    @NotNull
    public SearchTextField installSearchField() {
        SearchTextField field = new SearchTextField(false){

            protected boolean preprocessEventForTextField(KeyEvent e) {
                if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
                    FilteringTree.this.myTree.dispatchEvent((AWTEvent)e);
                    return true;
                }
                if (e.getKeyCode() == 27 && this.getText().isEmpty()) {
                    UIUtil.requestFocus((JComponent)FilteringTree.this.myTree);
                    return true;
                }
                return false;
            }
        };
        this.getSearchModel().setSpeedSearch(this.createSpeedSearch(field));
        SearchTextField searchTextField2 = field;
        if (searchTextField2 == null) {
            FilteringTree.$$$reportNull$$$0(3);
        }
        return searchTextField2;
    }

    @NotNull
    protected SpeedSearchSupply createSpeedSearch(@NotNull SearchTextField searchTextField2) {
        if (searchTextField2 == null) {
            FilteringTree.$$$reportNull$$$0(4);
        }
        return new FilteringSpeedSearch(searchTextField2);
    }

    public void installSimple() {
        TreeSpeedSearch supply2 = new TreeSpeedSearch(this.myTree, p -> StringUtil.notNullize((String)this.getText(p == null ? null : (U)this.getUserObject((TreeNode)p.getLastPathComponent()))), true){

            @Override
            protected void onSearchFieldUpdated(String pattern) {
                super.onSearchFieldUpdated(pattern);
                if (StringUtil.isNotEmpty((String)pattern) && !this.isPopupActive()) {
                    SwingUtilities.invokeLater(() -> {
                        FilteringTree.this.getSearchModel().refilter();
                        if (StringUtil.isNotEmpty((String)pattern)) {
                            TreeUtil.expandAll((JTree)FilteringTree.this.myTree);
                        }
                    });
                } else {
                    FilteringTree.this.getSearchModel().refilter();
                }
            }
        };
        this.getSearchModel().setSpeedSearch(supply2);
    }

    protected abstract Class<? extends T> getNodeClass();

    @NotNull
    protected abstract T createNode(@NotNull U var1);

    @NotNull
    protected abstract Iterable<U> getChildren(@NotNull U var1);

    @NotNull
    public Tree getTree() {
        Tree tree = this.myTree;
        if (tree == null) {
            FilteringTree.$$$reportNull$$$0(5);
        }
        return tree;
    }

    @NotNull
    public JComponent getComponent() {
        Tree tree = this.myTree;
        if (tree == null) {
            FilteringTree.$$$reportNull$$$0(6);
        }
        return tree;
    }

    protected void rebuildTree() {
    }

    protected void expandTreeOnSearchUpdateComplete(@Nullable String pattern) {
        if (StringUtil.isNotEmpty((String)pattern)) {
            TreeUtil.expandAll((JTree)this.myTree);
        }
    }

    protected void onSpeedSearchUpdateComplete(@Nullable String pattern) {
    }

    protected boolean useIdentityHashing() {
        return true;
    }

    @Nullable
    protected abstract String getText(@Nullable U var1);

    @NotNull
    public SearchTreeModel<T, U> getSearchModel() {
        SearchTreeModel searchTreeModel = (SearchTreeModel)this.myTree.getModel();
        if (searchTreeModel == null) {
            FilteringTree.$$$reportNull$$$0(7);
        }
        return searchTreeModel;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FilteringTree.$$$reportNull$$$0(8);
        }
        return project;
    }

    @NotNull
    public T getRoot() {
        T t = this.myRoot;
        if (t == null) {
            FilteringTree.$$$reportNull$$$0(9);
        }
        return t;
    }

    public void update() {
        this.rebuildTree();
        this.myTree.revalidate();
        this.myTree.repaint();
    }

    @Nullable
    public final U getUserObject(@Nullable TreeNode node2) {
        return (U)(node2 == null || !this.getNodeClass().isAssignableFrom(node2.getClass()) ? null : ((DefaultMutableTreeNode)node2).getUserObject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/FilteringTree";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/FilteringTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "installSearchField";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSpeedSearch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySpeedSearch<Item>
    extends SpeedSearch {
        private boolean myUpdating;
        private final JTextComponent myField;

        protected void onUpdatePattern(@Nullable String text2) {
        }

        MySpeedSearch(@NotNull JComponent comp, @NotNull JTextComponent field) {
            if (comp == null) {
                MySpeedSearch.$$$reportNull$$$0(0);
            }
            if (field == null) {
                MySpeedSearch.$$$reportNull$$$0(1);
            }
            this.myUpdating = false;
            this.myField = field;
            this.myField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!myUpdating) {
                        myUpdating = true;
                        try {
                            String text2 = myField.getText();
                            this.updatePattern(text2);
                            this.onUpdatePattern(text2);
                            this.update();
                        }
                        finally {
                            myUpdating = false;
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/FilteringTree$MySpeedSearch$1", "textChanged"));
                }
            });
            this.setEnabled(true);
            comp.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (this.selectTargetElement(e.getKeyCode())) {
                        e.consume();
                    }
                }
            });
            comp.addKeyListener((KeyListener)((Object)this));
            this.installSupplyTo(comp);
        }

        public void update() {
            String filter = this.getFilter();
            if (!this.myUpdating) {
                this.myUpdating = true;
                try {
                    this.myField.setText(filter);
                }
                finally {
                    this.myUpdating = false;
                }
            }
            this.onSearchFieldUpdated(filter);
            this.updateSelection();
        }

        public void noHits() {
            this.myField.setBackground(LightColors.RED);
        }

        public void updateSelection() {
            Item selection = this.getSelection();
            if (selection != null && this.isMatching(selection)) {
                return;
            }
            JBIterator it = JBIterator.from(this.iterate(selection, true, true)).filter(item -> item != selection && this.isMatching(item));
            if (!it.advance()) {
                return;
            }
            this.select(it.current());
        }

        protected void onSearchFieldUpdated(String pattern) {
        }

        public void select(@NotNull Item item) {
            if (item == null) {
                MySpeedSearch.$$$reportNull$$$0(2);
            }
        }

        @Nullable
        public Item getSelection() {
            return null;
        }

        public boolean isMatching(@NotNull Item item) {
            if (item == null) {
                MySpeedSearch.$$$reportNull$$$0(3);
            }
            return false;
        }

        @NotNull
        public Iterator<Item> iterate(@Nullable Item start2, boolean fwd) {
            return new JBIterator<Item>(){

                protected Item nextImpl() {
                    return this.stop();
                }
            };
        }

        @NotNull
        public Iterator<Item> iterate(final @Nullable Item start2, final boolean fwd, boolean wrap2) {
            if (!wrap2 || start2 == null) {
                Iterator<Item> iterator2 = this.iterate(start2, fwd);
                if (iterator2 == null) {
                    MySpeedSearch.$$$reportNull$$$0(4);
                }
                return iterator2;
            }
            return new JBIterator<Item>(){
                boolean wrapped = false;
                Iterator<Item> it = this.iterate(start2, fwd);

                protected Item nextImpl() {
                    if (this.it.hasNext()) {
                        return this.it.next();
                    }
                    if (this.wrapped) {
                        return this.stop();
                    }
                    this.wrapped = true;
                    this.it = JBIterator.from(this.iterate(null, fwd)).takeWhile(item -> item != start2);
                    return this.it.hasNext() ? this.it.next() : this.stop();
                }
            };
        }

        private boolean selectTargetElement(int keyCode) {
            JBIterator it;
            if (!this.isPopupActive()) {
                return false;
            }
            if (keyCode == 38) {
                it = this.iterate(this.getSelection(), false, UISettings.getInstance().getCycleScrolling());
            } else if (keyCode == 40) {
                it = this.iterate(this.getSelection(), true, UISettings.getInstance().getCycleScrolling());
            } else if (keyCode == 36) {
                it = this.iterate(null, true);
            } else if (keyCode == 35) {
                it = this.iterate(null, false);
            } else {
                return false;
            }
            it = JBIterator.from(it).filter(item -> this.isMatching(item));
            if (it.hasNext()) {
                this.select(it.next());
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comp";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/FilteringTree$MySpeedSearch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/FilteringTree$MySpeedSearch";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "select";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isMatching";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SearchTreeModel<N extends DefaultMutableTreeNode, U>
    extends DefaultTreeModel {
        @NotNull
        private final Function<? super U, String> myNamer;
        @NotNull
        private final Function<? super U, ? extends N> myFactory;
        private final U myRootObject;
        private final Function<? super U, ? extends Iterable<? extends U>> myStructure;
        private final boolean myUseIdentityHashing;
        private SpeedSearchSupply mySpeedSearch;
        private Map<U, N> myNodeCache;
        private final EventDispatcher<Listener<U>> myNodeChanged;

        public SearchTreeModel(@NotNull N root, @NotNull SpeedSearchSupply speedSearch2, @NotNull Function<? super U, String> namer, @NotNull Function<? super U, ? extends N> nodeFactory, @NotNull Function<? super U, ? extends Iterable<? extends U>> structure, boolean useIdentityHashing) {
            if (root == null) {
                SearchTreeModel.$$$reportNull$$$0(0);
            }
            if (speedSearch2 == null) {
                SearchTreeModel.$$$reportNull$$$0(1);
            }
            if (namer == null) {
                SearchTreeModel.$$$reportNull$$$0(2);
            }
            if (nodeFactory == null) {
                SearchTreeModel.$$$reportNull$$$0(3);
            }
            if (structure == null) {
                SearchTreeModel.$$$reportNull$$$0(4);
            }
            super((TreeNode)root);
            this.myNodeChanged = EventDispatcher.create(Listener.class);
            this.myRootObject = Objects.requireNonNull(this.getUserObject(root));
            this.mySpeedSearch = speedSearch2;
            this.myNamer = namer;
            this.myFactory = nodeFactory;
            this.myStructure = structure;
            this.myUseIdentityHashing = useIdentityHashing;
            this.myNodeCache = this.createNodeCache();
            this.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    Object object = this.getUserObject((DefaultMutableTreeNode)e.getTreePath().getLastPathComponent());
                    if (object != null) {
                        ((Listener)myNodeChanged.getMulticaster()).nodeChanged(object);
                    }
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                }
            });
        }

        public void modifyNode(@NotNull U object, @NotNull Runnable r) {
            if (object == null) {
                SearchTreeModel.$$$reportNull$$$0(5);
            }
            if (r == null) {
                SearchTreeModel.$$$reportNull$$$0(6);
            }
            ((Listener)this.myNodeChanged.getMulticaster()).beforeNodeChanged(object);
            try {
                r.run();
            }
            finally {
                ((Listener)this.myNodeChanged.getMulticaster()).nodeChanged(object);
            }
        }

        public void setSpeedSearch(@NotNull SpeedSearchSupply supply2) {
            if (supply2 == null) {
                SearchTreeModel.$$$reportNull$$$0(7);
            }
            this.mySpeedSearch = supply2;
            this.updateStructure();
        }

        public SpeedSearchSupply getSpeedSearch() {
            return this.mySpeedSearch;
        }

        public void addNodeListener(@NotNull Listener<U> listener2) {
            if (listener2 == null) {
                SearchTreeModel.$$$reportNull$$$0(8);
            }
            this.myNodeChanged.addListener(listener2);
        }

        public void updateStructure() {
            Map<U, N> newNodes = this.createNodeCache();
            Iterator iterator2 = ((JBTreeTraverser)JBTreeTraverser.from(this.myStructure).withRoot(this.getRootObject())).iterator();
            while (iterator2.hasNext()) {
                Object node2;
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.myNodeCache.get(node2 = iterator2.next());
                newNodes.put(node2, treeNode == null ? this.createNode(node2) : treeNode);
            }
            ArrayList<DefaultMutableTreeNode> oldNodes = new ArrayList<DefaultMutableTreeNode>();
            for (Map.Entry<U, N> entry2 : this.myNodeCache.entrySet()) {
                if (newNodes.containsKey(entry2.getKey())) continue;
                oldNodes.add((DefaultMutableTreeNode)entry2.getValue());
            }
            this.myNodeCache = newNodes;
            for (DefaultMutableTreeNode node3 : oldNodes) {
                if (node3.getParent() == null) continue;
                this.removeNodeFromParent(node3);
            }
            this.refilter();
        }

        public N getRoot() {
            return (N)((DefaultMutableTreeNode)this.root);
        }

        @NotNull
        public U getRootObject() {
            U u = this.myRootObject;
            if (u == null) {
                SearchTreeModel.$$$reportNull$$$0(9);
            }
            return u;
        }

        @NotNull
        public N getNode(@NotNull U object) {
            N node2;
            if (object == null) {
                SearchTreeModel.$$$reportNull$$$0(10);
            }
            if ((node2 = this.getCachedNode(object)) == null) {
                node2 = this.createNode(object);
                this.myNodeCache.put(object, node2);
            }
            N n = node2;
            if (n == null) {
                SearchTreeModel.$$$reportNull$$$0(11);
            }
            return n;
        }

        @Nullable
        public N getCachedNode(@Nullable U object) {
            if (object == null) {
                return null;
            }
            if (object == this.myRootObject) {
                return (N)this.getRoot();
            }
            return (N)((DefaultMutableTreeNode)this.myNodeCache.get(object));
        }

        @NotNull
        protected N createNode(@NotNull U object) {
            if (object == null) {
                SearchTreeModel.$$$reportNull$$$0(12);
            }
            assert (!(object instanceof DefaultMutableTreeNode));
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myFactory.fun(object);
            if (defaultMutableTreeNode == null) {
                SearchTreeModel.$$$reportNull$$$0(13);
            }
            return (N)defaultMutableTreeNode;
        }

        public void refilter() {
            if (this.mySpeedSearch.isPopupActive()) {
                Object acceptCache = this.myUseIdentityHashing ? new ReferenceOpenHashSet() : new HashSet();
                this.computeAcceptCache(this.myRootObject, (Set<? super U>)acceptCache);
                this.filterChildren(this.myRootObject, arg_0 -> SearchTreeModel.lambda$refilter$0((Set)acceptCache, arg_0));
            } else {
                this.filterChildren(this.myRootObject, x -> true);
            }
        }

        @NotNull
        private Map<U, N> createNodeCache() {
            return this.myUseIdentityHashing ? new IdentityHashMap() : new HashMap();
        }

        private boolean computeAcceptCache(@NotNull U object, @NotNull Set<? super U> cache2) {
            if (object == null) {
                SearchTreeModel.$$$reportNull$$$0(14);
            }
            if (cache2 == null) {
                SearchTreeModel.$$$reportNull$$$0(15);
            }
            boolean isAccepted = false;
            Iterable<U> children2 = this.getChildren(object);
            for (U child2 : children2) {
                isAccepted |= this.computeAcceptCache(child2, cache2);
            }
            String name = (String)this.myNamer.fun(object);
            if (isAccepted |= object == this.myRootObject || name != null && this.accept(name)) {
                for (U child3 : children2) {
                    if (this.myNamer.fun(child3) != null) continue;
                    cache2.add(child3);
                }
                cache2.add(object);
            }
            return isAccepted;
        }

        @NotNull
        public Iterable<? extends U> getChildren(@Nullable U object) {
            Object object2 = object == null ? JBIterable.empty() : (Iterable)this.myStructure.fun(object);
            if (object2 == null) {
                SearchTreeModel.$$$reportNull$$$0(16);
            }
            return object2;
        }

        @NotNull
        public Function<? super U, ? extends Iterable<? extends U>> getStructure() {
            Function<? super U, ? extends Iterable<? extends U>> function = this.myStructure;
            if (function == null) {
                SearchTreeModel.$$$reportNull$$$0(17);
            }
            return function;
        }

        @Nullable
        private static <N extends DefaultMutableTreeNode> N getChildSafe(@NotNull N node2, int i2) {
            if (node2 == null) {
                SearchTreeModel.$$$reportNull$$$0(18);
            }
            return node2.getChildCount() <= i2 ? null : (N)SearchTreeModel.getChild(node2, i2);
        }

        private static <N extends DefaultMutableTreeNode> N getChild(@NotNull N node2, int i2) {
            if (node2 == null) {
                SearchTreeModel.$$$reportNull$$$0(19);
            }
            return (N)((DefaultMutableTreeNode)node2.getChildAt(i2));
        }

        private void filterChildren(@Nullable U object, @NotNull Condition<? super U> filter) {
            if (filter == null) {
                SearchTreeModel.$$$reportNull$$$0(20);
            }
            if (object == null) {
                return;
            }
            N node2 = this.getNode(object);
            this.filterDirectChildren(node2, filter);
            int c = ((DefaultMutableTreeNode)node2).getChildCount();
            for (int i2 = 0; i2 < c; ++i2) {
                this.filterChildren(this.getUserObject(SearchTreeModel.getChild(node2, i2)), filter);
            }
        }

        private void filterDirectChildren(@NotNull N node2, @NotNull Condition<? super U> filter) {
            if (node2 == null) {
                SearchTreeModel.$$$reportNull$$$0(21);
            }
            if (filter == null) {
                SearchTreeModel.$$$reportNull$$$0(22);
            }
            LinkedHashSet<U> accepted = new LinkedHashSet<U>();
            for (U child2 : this.getChildren(this.getUserObject(node2))) {
                if (!filter.value(child2)) continue;
                accepted.add(child2);
            }
            this.removeNotAccepted(node2, accepted);
            this.mergeAcceptedNodes(node2, accepted);
        }

        private void mergeAcceptedNodes(@NotNull N node2, Set<? extends U> accepted) {
            if (node2 == null) {
                SearchTreeModel.$$$reportNull$$$0(23);
            }
            int k = 0;
            N cur = SearchTreeModel.getChildSafe(node2, 0);
            IntArrayList newIds = new IntArrayList();
            for (U child2 : accepted) {
                boolean isCur;
                U curUsrObject = this.getUserObject(cur);
                boolean bl = cur != null && this.myUseIdentityHashing ? curUsrObject == child2 : (isCur = curUsrObject != null && curUsrObject.equals(child2));
                if (isCur) {
                    cur = SearchTreeModel.getChildSafe(node2, k + 1);
                } else {
                    newIds.add(k);
                    ((DefaultMutableTreeNode)node2).insert((MutableTreeNode)this.getNode(child2), k);
                }
                ++k;
            }
            if (newIds.size() > 0) {
                this.nodesWereInserted((TreeNode)node2, newIds.toIntArray());
            }
            if (((DefaultMutableTreeNode)node2).getChildCount() > k) {
                IntArrayList leftIds = new IntArrayList();
                ArrayList<N> leftNodes = new ArrayList<N>();
                for (int i2 = ((DefaultMutableTreeNode)node2).getChildCount() - 1; i2 >= k; --i2) {
                    leftNodes.add(SearchTreeModel.getChild(node2, i2));
                    ((DefaultMutableTreeNode)node2).remove(i2);
                    leftIds.add(i2);
                }
                if (leftIds.size() > 0) {
                    int[] ints = leftIds.toIntArray();
                    for (int i3 = 0; i3 < ints.length; ++i3) {
                        int temp = ints[i3];
                        ints[i3] = ints[ints.length - i3 - 1];
                        ints[ints.length - i3 - 1] = temp;
                    }
                    Collections.reverse(leftNodes);
                    this.nodesWereRemoved((TreeNode)node2, ints, leftNodes.toArray());
                }
            }
        }

        private void removeNotAccepted(@NotNull N node2, Set<U> accepted) {
            if (node2 == null) {
                SearchTreeModel.$$$reportNull$$$0(24);
            }
            IntArrayList removedIds = new IntArrayList();
            ArrayList<N> removedNodes = new ArrayList<N>();
            for (int i2 = ((DefaultMutableTreeNode)node2).getChildCount() - 1; i2 >= 0; --i2) {
                N child2 = SearchTreeModel.getChild(node2, i2);
                if (accepted.contains(this.getUserObject(child2))) continue;
                removedIds.add(i2);
                removedNodes.add(child2);
                ((DefaultMutableTreeNode)node2).remove(i2);
            }
            if (!removedIds.isEmpty()) {
                Collections.reverse(removedNodes);
                int[] ints = removedIds.toIntArray();
                for (int i3 = 0; i3 < ints.length / 2; ++i3) {
                    int temp = ints[i3];
                    ints[i3] = ints[ints.length - i3 - 1];
                    ints[ints.length - i3 - 1] = temp;
                }
                this.nodesWereRemoved((TreeNode)node2, ints, removedNodes.toArray());
            }
        }

        protected boolean accept(@Nullable String name) {
            if (name == null) {
                return true;
            }
            return this.mySpeedSearch.matchingFragments(name) != null;
        }

        @Override
        public boolean isLeaf(Object node2) {
            return this.getRoot() != node2 && super.isLeaf(node2);
        }

        @Nullable
        public final U getUserObject(@Nullable N node2) {
            return (U)(node2 == null ? null : ((DefaultMutableTreeNode)node2).getUserObject());
        }

        private static /* synthetic */ boolean lambda$refilter$0(Set acceptCache, Object x) {
            return acceptCache.contains(x);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 11: 
                case 13: 
                case 16: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 11: 
                case 13: 
                case 16: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "speedSearch";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeFactory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "structure";
                    break;
                }
                case 5: 
                case 10: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supply";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 9: 
                case 11: 
                case 13: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/FilteringTree$SearchTreeModel";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cache";
                    break;
                }
                case 18: 
                case 19: 
                case 21: 
                case 23: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 20: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/FilteringTree$SearchTreeModel";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootObject";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNode";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNode";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStructure";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "modifyNode";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setSpeedSearch";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addNodeListener";
                    break;
                }
                case 9: 
                case 11: 
                case 13: 
                case 16: 
                case 17: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getNode";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "createNode";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "computeAcceptCache";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildSafe";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getChild";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "filterChildren";
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "filterDirectChildren";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "mergeAcceptedNodes";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "removeNotAccepted";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 11: 
                case 13: 
                case 16: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static interface Listener<U>
        extends EventListener {
            public void beforeNodeChanged(U var1);

            public void nodeChanged(U var1);
        }
    }

    protected class FilteringSpeedSearch
    extends MySpeedSearch<T> {
        protected FilteringSpeedSearch(SearchTextField field) {
            if (field == null) {
                FilteringSpeedSearch.$$$reportNull$$$0(0);
            }
            super((JComponent)FilteringTree.this.myTree, (JTextComponent)field.getTextEditor());
        }

        @Override
        protected void onSearchFieldUpdated(String pattern) {
            TreePath[] paths2 = FilteringTree.this.myTree.getSelectionModel().getSelectionPaths();
            FilteringTree.this.getSearchModel().refilter();
            FilteringTree.this.expandTreeOnSearchUpdateComplete(pattern);
            FilteringTree.this.myTree.getSelectionModel().setSelectionPaths(paths2);
            FilteringTree.this.onSpeedSearchUpdateComplete(pattern);
        }

        @Override
        public void select(@NotNull T node2) {
            if (node2 == null) {
                FilteringSpeedSearch.$$$reportNull$$$0(1);
            }
            TreeUtil.selectInTree(node2, (boolean)false, (JTree)FilteringTree.this.myTree);
        }

        @Override
        public boolean isMatching(@NotNull T node2) {
            String text2;
            if (node2 == null) {
                FilteringSpeedSearch.$$$reportNull$$$0(2);
            }
            return (text2 = FilteringTree.this.getText(FilteringTree.this.getUserObject((TreeNode)node2))) != null && this.matchingFragments(text2) != null;
        }

        @Override
        @Nullable
        public T getSelection() {
            return (DefaultMutableTreeNode)ArrayUtil.getFirstElement((Object[])((DefaultMutableTreeNode[])FilteringTree.this.myTree.getSelectedNodes(FilteringTree.this.getNodeClass(), null)));
        }

        @Override
        @NotNull
        public Iterator<T> iterate(@Nullable T start2, boolean fwd) {
            JBTreeTraverser traverser = (JBTreeTraverser)JBTreeTraverser.from(n -> {
                int count = n.getChildCount();
                ArrayList<DefaultMutableTreeNode> children2 = new ArrayList<DefaultMutableTreeNode>(count);
                for (int i2 = 0; i2 < count; ++i2) {
                    DefaultMutableTreeNode c = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)n.getChildAt(fwd ? i2 : count - i2 - 1), FilteringTree.this.getNodeClass());
                    if (c == null) continue;
                    children2.add(c);
                }
                return children2;
            }).expand(Conditions.alwaysTrue());
            if (start2 == null) {
                traverser = (JBTreeTraverser)traverser.withRoot(FilteringTree.this.getRoot());
            } else {
                ArrayList<DefaultMutableTreeNode> roots = new ArrayList<DefaultMutableTreeNode>();
                TreeNode node2 = null;
                Object parent = start2;
                while (parent != null) {
                    int c;
                    int idx = node2 == null ? -1 : parent.getIndex(node2);
                    int n2 = c = fwd ? parent.getChildCount() : idx;
                    for (int i2 = fwd ? idx + 1 : 0; i2 < c; ++i2) {
                        DefaultMutableTreeNode child2 = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)parent.getChildAt(fwd ? i2 : idx - i2 - 1), FilteringTree.this.getNodeClass());
                        if (child2 == null) continue;
                        roots.add(child2);
                    }
                    node2 = (TreeNode)parent;
                    parent = node2.getParent();
                }
                traverser = (JBTreeTraverser)traverser.withRoots(roots);
            }
            Iterator iterator2 = traverser.preOrderDfsTraversal().iterator();
            if (iterator2 == null) {
                FilteringSpeedSearch.$$$reportNull$$$0(3);
            }
            return iterator2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/FilteringTree$FilteringSpeedSearch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/FilteringTree$FilteringSpeedSearch";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "select";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isMatching";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

