/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.TableCell;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;

public class TableExpandableItemsHandler
extends AbstractExpandableItemsHandler<TableCell, JTable> {
    protected TableExpandableItemsHandler(final JTable table) {
        super(table);
        final ListSelectionListener selectionListener2 = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                TableExpandableItemsHandler.this.updateSelection(table);
            }
        };
        table.getSelectionModel().addListSelectionListener(selectionListener2);
        table.getColumnModel().getSelectionModel().addListSelectionListener(selectionListener2);
        table.addPropertyChangeListener("selectionModel", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null) {
                    ((ListSelectionModel)evt.getOldValue()).removeListSelectionListener(selectionListener2);
                }
                if (evt.getNewValue() != null) {
                    ((ListSelectionModel)evt.getNewValue()).addListSelectionListener(selectionListener2);
                }
            }
        });
        table.addPropertyChangeListener("columnModel", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null) {
                    ((TableColumnModel)evt.getOldValue()).getSelectionModel().removeListSelectionListener(selectionListener2);
                }
                if (evt.getNewValue() != null) {
                    ((TableColumnModel)evt.getNewValue()).getSelectionModel().addListSelectionListener(selectionListener2);
                }
            }
        });
        final TableModelListener modelListener2 = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SwingUtilities.invokeLater(() -> TableExpandableItemsHandler.this.updateSelection(table));
            }
        };
        if (table.getModel() != null) {
            table.getModel().addTableModelListener(modelListener2);
        }
        table.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableExpandableItemsHandler.this.updateSelection(table);
                if (evt.getOldValue() != null) {
                    ((TableModel)evt.getOldValue()).removeTableModelListener(modelListener2);
                }
                if (evt.getNewValue() != null) {
                    ((TableModel)evt.getNewValue()).addTableModelListener(modelListener2);
                }
            }
        });
    }

    private void updateSelection(JTable table) {
        int row2 = table.getSelectedRowCount() == 1 ? table.getSelectedRow() : -1;
        int column2 = table.getSelectedColumnCount() == 1 ? table.getSelectedColumn() : -1;
        this.handleSelectionChange(row2 == -1 || column2 == -1 ? null : new TableCell(row2, column2));
    }

    private Rectangle getCellRect(TableCell tableCellKey) {
        return ((JTable)this.myComponent).getCellRect(tableCellKey.row, tableCellKey.column, false);
    }

    @Override
    @Nullable
    public Pair<Component, Rectangle> getCellRendererAndBounds(TableCell key) {
        if (key.row < 0 || key.row >= ((JTable)this.myComponent).getRowCount() || key.column < 0 || key.column >= ((JTable)this.myComponent).getColumnCount() || key.row == ((JTable)this.myComponent).getEditingRow() && key.column == ((JTable)this.myComponent).getEditingColumn() || this.hasDraggingOrResizingColumn()) {
            return null;
        }
        Rectangle cellRect = this.getCellRect(key);
        Component renderer2 = ((JTable)this.myComponent).prepareRenderer(((JTable)this.myComponent).getCellRenderer(key.row, key.column), key.row, key.column);
        AppUIUtil.targetToDevice(renderer2, this.myComponent);
        cellRect.width = renderer2.getPreferredSize().width;
        return Pair.create((Object)renderer2, (Object)cellRect);
    }

    @Override
    public Rectangle getVisibleRect(TableCell key) {
        Rectangle columnVisibleRect = ((JTable)this.myComponent).getVisibleRect();
        Rectangle cellRect = this.getCellRect(key);
        int visibleRight = Math.min(columnVisibleRect.x + columnVisibleRect.width, cellRect.x + cellRect.width);
        columnVisibleRect.x = Math.min(columnVisibleRect.x, cellRect.x);
        columnVisibleRect.width = Math.max(0, visibleRight - columnVisibleRect.x);
        return columnVisibleRect;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        JTableHeader header2 = ((JTable)this.myComponent).getTableHeader();
        if (header2 instanceof ComponentWithExpandableItems) {
            ((ComponentWithExpandableItems)header2).setExpandableItemsEnabled(enabled);
        }
    }

    @Override
    public TableCell getCellKeyForPoint(Point point) {
        int rowIndex = ((JTable)this.myComponent).rowAtPoint(point);
        if (rowIndex == -1) {
            return null;
        }
        int columnIndex = ((JTable)this.myComponent).columnAtPoint(point);
        if (columnIndex == -1) {
            return null;
        }
        return new TableCell(rowIndex, columnIndex);
    }

    private boolean hasDraggingOrResizingColumn() {
        JTableHeader header2 = ((JTable)this.myComponent).getTableHeader();
        return header2 != null && (header2.getResizingColumn() != null || header2.getDraggedColumn() != null);
    }
}

