/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.MessageView;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ErrorTreeView;
import org.jetbrains.annotations.Nullable;

public final class ContentManagerUtil {
    private ContentManagerUtil() {
    }

    @Nullable
    public static ContentManager getContentManagerFromContext(DataContext dataContext, boolean requiresVisibleToolWindow) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        ToolWindow toolWindow = (ToolWindow)JBIterable.of((Object[])((ToolWindow[])PlatformDataKeys.LAST_ACTIVE_TOOL_WINDOWS.getData(dataContext))).first();
        if (requiresVisibleToolWindow && (toolWindow == null || !toolWindow.isVisible())) {
            return null;
        }
        ContentManager fromToolWindow = toolWindow != null ? toolWindow.getContentManagerIfCreated() : null;
        ContentManager fromContext = (ContentManager)PlatformDataKeys.CONTENT_MANAGER.getData(dataContext);
        return fromContext == null ? fromToolWindow : fromContext;
    }

    public static void cleanupContents(Content notToRemove, Project project, String contentName) {
        MessageView messageView = MessageView.SERVICE.getInstance(project);
        for (Content content2 : messageView.getContentManager().getContents()) {
            ErrorTreeView listErrorView;
            if (content2.isPinned() || !contentName.equals(content2.getDisplayName()) || content2 == notToRemove || (listErrorView = (ErrorTreeView)content2.getComponent()) == null || !messageView.getContentManager().removeContent(content2, true)) continue;
            content2.release();
        }
    }
}

