/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.Helpers;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.ItemsContainer;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.NSTLibrary;
import com.intellij.ui.mac.touchbar.StatsCounters;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.ui.mac.touchbar.TBItemAnActionButton;
import com.intellij.ui.mac.touchbar.TBItemButton;
import com.intellij.ui.mac.touchbar.TBItemScrubber;
import com.intellij.ui.mac.touchbar.TouchBarStats;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import java.awt.Window;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TouchBar
implements NSTLibrary.ItemCreator {
    static final Logger LOG = Logger.getInstance(TouchBar.class);
    static final boolean ourCollectStats = Boolean.getBoolean("touchbar.collect.stats");
    @Nullable
    final TouchBarStats myStats;
    @NotNull
    final String myName;
    @NotNull
    final ItemsContainer myItems;
    final ItemListener myItemListener;
    final TBItemButton myCustomEsc;
    String[] myVisibleIds;
    private ID myNativePeer;
    static final TouchBar EMPTY = new TouchBar();

    private TouchBar() {
        this.myName = "EMPTY_STUB_TOUCHBAR";
        this.myItems = new ItemsContainer(this.myName);
        this.myCustomEsc = null;
        this.myNativePeer = ID.NIL;
        this.myItemListener = null;
        this.myStats = null;
    }

    TouchBar(@NotNull String touchbarName) {
        if (touchbarName == null) {
            TouchBar.$$$reportNull$$$0(0);
        }
        this(touchbarName, null, false);
    }

    TouchBar(@NotNull String touchbarName, @Nullable CrossEscInfo crossEscInfo, boolean closeOnItemEvent) {
        if (touchbarName == null) {
            TouchBar.$$$reportNull$$$0(1);
        }
        this.myItemListener = closeOnItemEvent ? (src, eventCode) -> this._closeSelf() : null;
        this.myName = touchbarName;
        this.myStats = ourCollectStats ? TouchBarStats.getStats(touchbarName) : null;
        this.myItems = new ItemsContainer(touchbarName);
        if (crossEscInfo != null) {
            Icon ic2 = AllIcons.Mac.Touchbar.PopoverClose;
            this.myCustomEsc = new TBItemButton(this.myItemListener, null).setIcon(ic2).setWidth(64).setTransparentBg().setAction(() -> {
                ActivityTracker.getInstance().inc();
                this._closeSelf();
                if (crossEscInfo.emulateEsc) {
                    Helpers.emulateKeyPress(27);
                }
            }, false);
            this.myCustomEsc.setUid(touchbarName + "_custom_esc_button");
        } else {
            this.myCustomEsc = null;
        }
        this.myNativePeer = NST.createTouchBar(touchbarName, this, this.myCustomEsc != null ? this.myCustomEsc.getUid() : null);
    }

    boolean isCrossEsc() {
        return this.myCustomEsc != null;
    }

    public String toString() {
        return this.myItems + "_" + this.myNativePeer;
    }

    @Override
    public ID createItem(@NotNull String uid) {
        if (uid == null) {
            TouchBar.$$$reportNull$$$0(2);
        }
        long startNs = this.myStats != null ? System.nanoTime() : 0L;
        ID result2 = this.createItemImpl(uid);
        if (this.myStats != null) {
            this.myStats.incrementCounter(StatsCounters.itemsCreationDurationNs, System.nanoTime() - startNs);
        }
        return result2;
    }

    private ID createItemImpl(@NotNull String uid) {
        TBItem item;
        if (uid == null) {
            TouchBar.$$$reportNull$$$0(3);
        }
        if ((item = this.myCustomEsc != null && uid.equals(this.myCustomEsc.getUid()) ? this.myCustomEsc : this.myItems.findItem(uid)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("can't create item %s | %s", new Object[]{uid, this.myItems.getDescription()});
            }
            return ID.NIL;
        }
        return item.createNativePeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTo(@Nullable Window window) {
        TouchBar touchBar = this;
        synchronized (touchBar) {
            NST.setTouchBar(window, this.myNativePeer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        long startNs = this.myStats != null ? System.nanoTime() : 0L;
        this.myItems.releaseAll();
        TouchBar touchBar = this;
        synchronized (touchBar) {
            if (!this.myNativePeer.equals((Object)ID.NIL)) {
                NST.releaseNativePeer(this.myNativePeer);
                this.myNativePeer = ID.NIL;
            }
        }
        if (this.myStats != null) {
            this.myStats.incrementCounter(StatsCounters.touchbarReleaseDurationNs, System.nanoTime() - startNs);
        }
    }

    @NotNull
    TBItemButton addButton() {
        @NotNull TBItemButton butt = new TBItemButton(this.myItemListener, this.myStats != null ? this.myStats.getActionStats("simple_button") : null);
        this.myItems.addItem(butt);
        TBItemButton tBItemButton = butt;
        if (tBItemButton == null) {
            TouchBar.$$$reportNull$$$0(4);
        }
        return tBItemButton;
    }

    @NotNull
    TBItem addItem(@NotNull TBItem item) {
        if (item == null) {
            TouchBar.$$$reportNull$$$0(5);
        }
        TBItem tBItem = this.addItem(item, null);
        if (tBItem == null) {
            TouchBar.$$$reportNull$$$0(6);
        }
        return tBItem;
    }

    @NotNull
    TBItem addItem(@NotNull TBItem item, @Nullable TBItem positionAnchor) {
        if (item == null) {
            TouchBar.$$$reportNull$$$0(7);
        }
        this.myItems.addItem(item, positionAnchor);
        TBItem tBItem = item;
        if (tBItem == null) {
            TouchBar.$$$reportNull$$$0(8);
        }
        return tBItem;
    }

    @NotNull
    TBItemScrubber addScrubber() {
        int defaultScrubberWidth = 500;
        @NotNull TBItemScrubber scrub = new TBItemScrubber(this.myItemListener, this.myStats, 500);
        this.myItems.addItem(scrub);
        TBItemScrubber tBItemScrubber = scrub;
        if (tBItemScrubber == null) {
            TouchBar.$$$reportNull$$$0(9);
        }
        return tBItemScrubber;
    }

    void addSpacing(boolean large) {
        this.myItems.addSpacing(large);
    }

    void addFlexibleSpacing() {
        this.myItems.addFlexibleSpacing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectVisibleItemsToShow() {
        if (this.myItems.isEmpty()) {
            if (this.myVisibleIds != null && this.myVisibleIds.length > 0) {
                TouchBar touchBar = this;
                synchronized (touchBar) {
                    NST.selectItemsToShow(this.myNativePeer, null, 0);
                }
            }
            this.myVisibleIds = null;
            return;
        }
        Object[] ids = this.myItems.getVisibleIds();
        if (Arrays.equals(ids, this.myVisibleIds)) {
            return;
        }
        this.myVisibleIds = ids;
        TouchBar touchBar = this;
        synchronized (touchBar) {
            NST.selectItemsToShow(this.myNativePeer, (String[])ids, ids.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPrincipal(@NotNull TBItem item) {
        if (item == null) {
            TouchBar.$$$reportNull$$$0(10);
        }
        TouchBar touchBar = this;
        synchronized (touchBar) {
            NST.setPrincipal(this.myNativePeer, item.getUid());
        }
    }

    void _closeSelf() {
        TouchBarsManager.hideTouchbar(this);
    }

    @NotNull
    TBItemAnActionButton createActionButton(@NotNull AnAction action2) {
        if (action2 == null) {
            TouchBar.$$$reportNull$$$0(11);
        }
        TouchBarStats.AnActionStats stats = this.myStats == null ? null : this.myStats.getActionStats(Helpers.getActionId(action2));
        return new TBItemAnActionButton(this.myItemListener, action2, stats);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "touchbarName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uid";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/TouchBar";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/TouchBar";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addButton";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addItem";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addScrubber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createItem";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createItemImpl";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addItem";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setPrincipal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createActionButton";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CrossEscInfo {
        final boolean emulateEsc;
        final boolean persistent;

        CrossEscInfo(boolean emulateEsc, boolean persistent) {
            this.emulateEsc = emulateEsc;
            this.persistent = persistent;
        }
    }
}

