/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mouse;

import com.intellij.ui.JBColor;
import com.intellij.ui.mouse.MouseWheelSmoothScrollOptionsKt;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u001dH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ui/mouse/BezierPainter;", "Ljavax/swing/JComponent;", "x1", "", "y1", "x2", "y2", "(DDDD)V", "controlSize", "", "firstControlPoint", "Ljava/awt/geom/Point2D$Double;", "getFirstControlPoint", "()Ljava/awt/geom/Point2D$Double;", "setFirstControlPoint", "(Ljava/awt/geom/Point2D$Double;)V", "gridColor", "Lcom/intellij/ui/JBColor;", "secondControlPoint", "getSecondControlPoint", "setSecondControlPoint", "fromScreenXY", "point", "Ljava/awt/Point;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "toScreenXY", "Ljava/awt/geom/Point2D;", "intellij.platform.ide.impl"})
final class BezierPainter
extends JComponent {
    private final int controlSize;
    private final JBColor gridColor = new JBColor(new Color(0xF0F0F0), new Color(0x313335));
    @NotNull
    private Point2D.Double firstControlPoint;
    @NotNull
    private Point2D.Double secondControlPoint;

    @NotNull
    public final Point2D.Double getFirstControlPoint() {
        return this.firstControlPoint;
    }

    public final void setFirstControlPoint(@NotNull Point2D.Double double_) {
        Intrinsics.checkNotNullParameter((Object)double_, (String)"<set-?>");
        this.firstControlPoint = double_;
    }

    @NotNull
    public final Point2D.Double getSecondControlPoint() {
        return this.secondControlPoint;
    }

    public final void setSecondControlPoint(@NotNull Point2D.Double double_) {
        Intrinsics.checkNotNullParameter((Object)double_, (String)"<set-?>");
        this.secondControlPoint = double_;
    }

    private final Point toScreenXY(Point2D point) {
        Rectangle rectangle = this.getBounds();
        boolean bl = false;
        boolean bl2 = false;
        Rectangle b = rectangle;
        boolean bl3 = false;
        return new Point((int)(point.getX() * (double)b.width), b.height - (int)(point.getY() * (double)b.height));
    }

    private final Point2D.Double fromScreenXY(Point point) {
        Rectangle rectangle = this.getBounds();
        boolean bl = false;
        boolean bl2 = false;
        Rectangle b = rectangle;
        boolean bl3 = false;
        int n = 0;
        int n2 = point.x;
        int n3 = 0;
        n = Math.max(n, n2);
        n2 = this.getBounds().width;
        n3 = 0;
        double x = (double)Math.min(n, n2) / (double)this.getBounds().width;
        n3 = 0;
        int n4 = point.y;
        boolean bl4 = false;
        n3 = Math.max(n3, n4);
        n4 = this.getBounds().height;
        bl4 = false;
        double y = (double)Math.min(n3, n4) / (double)this.getBounds().height;
        return new Point2D.Double(x, 1.0 - y);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        void x2;
        void x1;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Rectangle bounds2 = this.getBounds();
        Graphics graphics = g.create();
        if (graphics == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setColor(JBColor.background());
        g2d.fillRect(0, 0, bounds2.width, bounds2.height);
        g2d.setColor((Color)this.gridColor);
        int n = 0;
        int n2 = 4;
        while (n <= n2) {
            void i2;
            g2d.drawLine(bounds2.width * i2 / 4, 0, bounds2.width * i2 / 4, bounds2.height);
            g2d.drawLine(0, bounds2.height * i2 / 4, bounds2.width, bounds2.height * i2 / 4);
            ++i2;
        }
        double x0 = 0.0;
        double y0 = bounds2.height;
        Point point = this.toScreenXY(this.firstControlPoint);
        double d = MouseWheelSmoothScrollOptionsKt.access$component1(point);
        double y1 = MouseWheelSmoothScrollOptionsKt.access$component2(point);
        Point point2 = this.toScreenXY(this.secondControlPoint);
        double d2 = MouseWheelSmoothScrollOptionsKt.access$component1(point2);
        double y2 = MouseWheelSmoothScrollOptionsKt.access$component2(point2);
        double x3 = bounds2.width;
        double y3 = 0.0;
        CubicCurve2D.Double bez = new CubicCurve2D.Double(x0, y0, (double)x1, y1, (double)x2, y2, x3, y3);
        g2d.setColor(JBColor.foreground());
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.draw(bez);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(this.isEnabled() ? new Color(151, 118, 169) : (JBColor.isBright() ? (Color)JBColor.LIGHT_GRAY : (Color)JBColor.GRAY));
        g2d.fillOval((int)x1 - this.controlSize / 2, (int)y1 - this.controlSize / 2, this.controlSize, this.controlSize);
        g2d.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
        g2d.setColor(this.isEnabled() ? new Color(208, 167, 8) : (JBColor.isBright() ? (Color)JBColor.LIGHT_GRAY : (Color)JBColor.GRAY));
        g2d.fillOval((int)x2 - this.controlSize / 2, (int)y2 - this.controlSize / 2, this.controlSize, this.controlSize);
        g2d.drawLine((int)x2, (int)y2, (int)x3, (int)y3);
    }

    public BezierPainter(double x1, double y1, double x2, double y2) {
        this.controlSize = 10;
        this.firstControlPoint = new Point2D.Double(x1, y1);
        this.secondControlPoint = new Point2D.Double(x2, y2);
        MouseAdapter value2 = new MouseAdapter(this){
            private int i;
            final /* synthetic */ BezierPainter this$0;

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point point = e.getPoint();
                switch (this.i) {
                    case 1: {
                        Point point2 = point;
                        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"point");
                        this.this$0.setFirstControlPoint(BezierPainter.access$fromScreenXY(this.this$0, point2));
                        break;
                    }
                    case 2: {
                        Point point3 = point;
                        Intrinsics.checkNotNullExpressionValue((Object)point3, (String)"point");
                        this.this$0.setSecondControlPoint(BezierPainter.access$fromScreenXY(this.this$0, point3));
                        break;
                    }
                }
                this.this$0.repaint();
            }

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point point = e.getPoint();
                boolean bl = false;
                boolean bl2 = false;
                Point $this$with = point;
                boolean bl3 = false;
                Point point2 = $this$with;
                Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"this");
                int n = this.intersects(point2, this.this$0.getFirstControlPoint()) ? 1 : (this.i = this.intersects($this$with, this.this$0.getSecondControlPoint()) ? 2 : 0);
                if (this.i != 0) {
                    this.this$0.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    this.this$0.setCursor(Cursor.getDefaultCursor());
                }
            }

            private final boolean intersects(Point $this$intersects, Point2D.Double point) {
                Point xy = BezierPainter.access$toScreenXY(this.this$0, point);
                return xy.x - BezierPainter.access$getControlSize$p(this.this$0) / 2 <= $this$intersects.x && $this$intersects.x <= xy.x + BezierPainter.access$getControlSize$p(this.this$0) / 2 && xy.y - BezierPainter.access$getControlSize$p(this.this$0) / 2 <= $this$intersects.y && $this$intersects.y <= xy.y + BezierPainter.access$getControlSize$p(this.this$0) / 2;
            }
            {
                this.this$0 = this$0;
            }
        };
        this.addMouseMotionListener(value2);
        this.addMouseListener(value2);
    }

    public static final /* synthetic */ Point2D.Double access$fromScreenXY(BezierPainter $this, Point point) {
        return $this.fromScreenXY(point);
    }

    public static final /* synthetic */ Point access$toScreenXY(BezierPainter $this, Point2D point) {
        return $this.toScreenXY(point);
    }

    public static final /* synthetic */ int access$getControlSize$p(BezierPainter $this) {
        return $this.controlSize;
    }
}

