/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.ui.popup.TreePopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupDispatcher;
import com.intellij.ui.popup.async.AsyncPopupImpl;
import com.intellij.ui.popup.async.AsyncPopupStep;
import com.intellij.ui.popup.list.ComboBoxPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.tree.TreePopupImpl;
import com.intellij.ui.popup.util.MnemonicsSearch;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WizardPopup
extends AbstractPopup
implements ActionListener,
ElementFilter {
    private static final Logger LOG = Logger.getInstance(WizardPopup.class);
    private static final Dimension MAX_SIZE = new Dimension(Integer.MAX_VALUE, 600);
    protected static final int STEP_X_PADDING = 2;
    private final WizardPopup myParent;
    protected final PopupStep<Object> myStep;
    protected WizardPopup myChild;
    private final Timer myAutoSelectionTimer;
    private final MnemonicsSearch myMnemonicsSearch;
    private Object myParentValue;
    private Point myLastOwnerPoint;
    private Window myOwnerWindow;
    private MyComponentAdapter myOwnerListener;
    private final ActionMap myActionMap;
    private final InputMap myInputMap;
    private boolean myKeyPressedReceived;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public WizardPopup(@NotNull PopupStep<Object> aStep) {
        if (aStep == null) {
            WizardPopup.$$$reportNull$$$0(0);
        }
        this((Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext()), null, aStep);
    }

    public WizardPopup(@Nullable Project project, @Nullable JBPopup aParent, @NotNull PopupStep<Object> aStep) {
        if (aStep == null) {
            WizardPopup.$$$reportNull$$$0(1);
        }
        this.myAutoSelectionTimer = TimerUtil.createNamedTimer((String)"Wizard auto-selection", (int)Registry.intValue((String)"ide.popup.auto.delay", (int)500), (ActionListener)this);
        this.myActionMap = new ActionMap();
        this.myInputMap = new InputMap();
        this.myParent = (WizardPopup)aParent;
        this.myStep = aStep;
        this.mySpeedSearch.setEnabled(this.myStep.isSpeedSearchEnabled());
        JComponent content2 = this.createContent();
        content2.putClientProperty("JBPopup", this);
        JComponent popupComponent = this.createPopupComponent(content2);
        this.init(project, popupComponent, this.getPreferredFocusableComponent(), true, true, true, null, this.isResizable(), aStep.getTitle(), null, true, Collections.emptySet(), false, null, null, null, false, null, true, false, true, null, 0.0f, null, true, false, new Component[0], null, 2, true, Collections.emptyList(), null, null, false, true, true, null, true, null);
        this.registerAction("disposeAll", 27, 1, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WizardPopup.this.mySpeedSearch.isHoldingFilter()) {
                    WizardPopup.this.mySpeedSearch.reset();
                } else {
                    WizardPopup.this.disposeAll();
                }
            }
        });
        AbstractAction goBackAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardPopup.this.goBack();
            }
        };
        this.registerAction("goBack3", 27, 0, goBackAction);
        this.myMnemonicsSearch = new MnemonicsSearch(this){

            protected void select(Object value2) {
                WizardPopup.this.onSelectByMnemonic(value2);
            }
        };
    }

    @NotNull
    protected JComponent createPopupComponent(JComponent content2) {
        JScrollPane scrollPane = this.createScrollPane(content2);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getHorizontalScrollBar().setBorder(null);
        scrollPane.getActionMap().get("unitScrollLeft").setEnabled(false);
        scrollPane.getActionMap().get("unitScrollRight").setEnabled(false);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            WizardPopup.$$$reportNull$$$0(2);
        }
        return jScrollPane;
    }

    @NotNull
    protected JScrollPane createScrollPane(JComponent content2) {
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)content2);
        if (jScrollPane == null) {
            WizardPopup.$$$reportNull$$$0(3);
        }
        return jScrollPane;
    }

    private void disposeAll() {
        WizardPopup root = PopupDispatcher.getActiveRoot();
        this.disposeAllParents(null);
        root.getStep().canceled();
    }

    public void goBack() {
        if (this.mySpeedSearch.isHoldingFilter()) {
            this.mySpeedSearch.reset();
            return;
        }
        if (this.myParent != null) {
            this.myParent.disposeChildren();
        } else {
            this.disposeAll();
        }
    }

    protected abstract JComponent createContent();

    @Override
    public void dispose() {
        this.myAutoSelectionTimer.stop();
        super.dispose();
        PopupDispatcher.unsetShowing(this);
        PopupDispatcher.clearRootIfNeeded(this);
        if (this.myOwnerWindow != null && this.myOwnerListener != null) {
            this.myOwnerWindow.removeComponentListener(this.myOwnerListener);
        }
    }

    public void disposeChildren() {
        if (this.myChild != null) {
            this.myChild.disposeChildren();
            Disposer.dispose((Disposable)this.myChild);
            this.myChild = null;
        }
    }

    @Override
    public void show(@NotNull Component owner, int aScreenX, int aScreenY, boolean considerForcedXY) {
        if (owner == null) {
            WizardPopup.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(!this.isDisposed());
        Rectangle targetBounds = new Rectangle(new Point(aScreenX, aScreenY), this.getContent().getPreferredSize());
        if (this.getParent() != null) {
            Rectangle parentBounds = this.getParent().getBounds();
            parentBounds.x += 2;
            parentBounds.width -= 4;
            ScreenUtil.moveToFit((Rectangle)targetBounds, (Rectangle)ScreenUtil.getScreenRectangle((int)(parentBounds.x + parentBounds.width / 2), (int)(parentBounds.y + parentBounds.height / 2)), null);
            if (parentBounds.intersects(targetBounds)) {
                targetBounds.x = this.getParent().getBounds().x - targetBounds.width - 2;
            }
        } else {
            ScreenUtil.moveToFit((Rectangle)targetBounds, (Rectangle)ScreenUtil.getScreenRectangle((int)(aScreenX + 1), (int)(aScreenY + 1)), null);
        }
        if (this.getParent() == null) {
            PopupDispatcher.setActiveRoot(this);
        } else {
            PopupDispatcher.setShowing(this);
        }
        LOG.assertTrue(!this.isDisposed(), (Object)("Disposed popup, parent=" + this.getParent()));
        super.show(owner, targetBounds.x, targetBounds.y, true);
    }

    @Override
    protected void afterShow() {
        super.afterShow();
        this.registerAutoMove();
    }

    private void registerAutoMove() {
        if (this.myOwner != null) {
            this.myOwnerWindow = SwingUtilities.getWindowAncestor(this.myOwner);
            if (this.myOwnerWindow != null) {
                this.myLastOwnerPoint = this.myOwnerWindow.getLocationOnScreen();
                this.myOwnerListener = new MyComponentAdapter();
                this.myOwnerWindow.addComponentListener(this.myOwnerListener);
            }
        }
    }

    private void processParentWindowMoved() {
        if (this.isDisposed()) {
            return;
        }
        Point newOwnerPoint = this.myOwnerWindow.getLocationOnScreen();
        int deltaX = this.myLastOwnerPoint.x - newOwnerPoint.x;
        int deltaY = this.myLastOwnerPoint.y - newOwnerPoint.y;
        this.myLastOwnerPoint = newOwnerPoint;
        Window wnd = SwingUtilities.getWindowAncestor(this.getContent());
        if (!wnd.isShowing()) {
            return;
        }
        Point current2 = wnd.getLocationOnScreen();
        this.setLocation(new Point(current2.x - deltaX, current2.y - deltaY));
    }

    protected abstract JComponent getPreferredFocusableComponent();

    @Override
    public void cancel(InputEvent e) {
        super.cancel(e);
        this.disposeChildren();
        Disposer.dispose((Disposable)this);
        this.getStep().canceled();
    }

    @Override
    public boolean isCancelKeyEnabled() {
        return super.isCancelKeyEnabled() && !this.mySpeedSearch.isHoldingFilter();
    }

    protected void disposeAllParents(InputEvent e) {
        this.myDisposeEvent = e;
        Disposer.dispose((Disposable)this);
        if (this.myParent != null) {
            this.myParent.disposeAllParents(null);
        }
    }

    public final void registerAction(@NonNls String aActionName, int aKeyCode, @JdkConstants.InputEventMask int aModifier, Action aAction) {
        this.myInputMap.put(KeyStroke.getKeyStroke(aKeyCode, aModifier), aActionName);
        this.myActionMap.put(aActionName, aAction);
    }

    protected String getActionForKeyStroke(KeyStroke keyStroke) {
        return (String)this.myInputMap.get(keyStroke);
    }

    public final void registerAction(@NonNls String aActionName, KeyStroke keyStroke, Action aAction) {
        this.myInputMap.put(keyStroke, aActionName);
        this.myActionMap.put(aActionName, aAction);
    }

    protected abstract InputMap getInputMap();

    protected abstract ActionMap getActionMap();

    protected final void setParentValue(Object parentValue) {
        this.myParentValue = parentValue;
    }

    @Override
    @NotNull
    protected AbstractPopup.MyContentPanel createContentPanel(boolean resizable, @NotNull PopupBorder border, boolean isToDrawMacCorner) {
        if (border == null) {
            WizardPopup.$$$reportNull$$$0(5);
        }
        return new MyContainer(border);
    }

    protected boolean isResizable() {
        return false;
    }

    public WizardPopup getParent() {
        return this.myParent;
    }

    public PopupStep getStep() {
        return this.myStep;
    }

    public final boolean dispatch(KeyEvent event) {
        KeyStroke stroke;
        if (event.getID() == 401) {
            this.myKeyPressedReceived = true;
            stroke = KeyStroke.getKeyStroke(event.getKeyCode(), event.getModifiers(), false);
            if (this.proceedKeyEvent(event, stroke)) {
                return true;
            }
        } else if (!this.myKeyPressedReceived && !(this instanceof ComboBoxPopup)) {
            return false;
        }
        if (event.getID() == 402) {
            stroke = KeyStroke.getKeyStroke(event.getKeyCode(), event.getModifiers(), true);
            return this.proceedKeyEvent(event, stroke);
        }
        this.myMnemonicsSearch.processKeyEvent(event);
        this.mySpeedSearch.processKeyEvent(event);
        if (event.isConsumed()) {
            return true;
        }
        this.process(event);
        return event.isConsumed();
    }

    private boolean proceedKeyEvent(KeyEvent event, KeyStroke stroke) {
        Action action2;
        if (this.myInputMap.get(stroke) != null && (action2 = this.myActionMap.get(this.myInputMap.get(stroke))) != null && action2.isEnabled()) {
            action2.actionPerformed(new ActionEvent(this.getContent(), event.getID(), "", event.getWhen(), event.getModifiers()));
            event.consume();
            return true;
        }
        return false;
    }

    protected void process(KeyEvent aEvent) {
    }

    public Rectangle getBounds() {
        JComponent content2 = this.isDisposed() ? null : this.getContent();
        return content2 == null ? null : new Rectangle(content2.getLocationOnScreen(), content2.getSize());
    }

    protected WizardPopup createPopup(WizardPopup parent, PopupStep step2, Object parentValue) {
        if (step2 instanceof AsyncPopupStep) {
            return new AsyncPopupImpl(this.getProject(), parent, (AsyncPopupStep)step2, parentValue);
        }
        if (step2 instanceof ListPopupStep) {
            return new ListPopupImpl(this.getProject(), parent, (ListPopupStep)step2, parentValue);
        }
        if (step2 instanceof TreePopupStep) {
            return new TreePopupImpl(this.getProject(), parent, (TreePopupStep<Object>)((TreePopupStep)step2), parentValue);
        }
        throw new IllegalArgumentException(step2.getClass().toString());
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        this.myAutoSelectionTimer.stop();
        if (this.getStep().isAutoSelectionEnabled()) {
            this.onAutoSelectionTimer();
        }
    }

    protected final void restartTimer() {
        if (!this.myAutoSelectionTimer.isRunning()) {
            this.myAutoSelectionTimer.start();
        } else {
            this.myAutoSelectionTimer.restart();
        }
    }

    protected final void stopTimer() {
        this.myAutoSelectionTimer.stop();
    }

    protected void onAutoSelectionTimer() {
    }

    public boolean shouldBeShowing(Object value2) {
        if (!this.myStep.isSpeedSearchEnabled()) {
            return true;
        }
        SpeedSearchFilter<Object> filter = this.myStep.getSpeedSearchFilter();
        if (filter == null) {
            return true;
        }
        if (!filter.canBeHidden(value2)) {
            return true;
        }
        if (!this.mySpeedSearch.isHoldingFilter()) {
            return true;
        }
        String text2 = filter.getIndexedString(value2);
        return this.mySpeedSearch.shouldBeShowing(text2);
    }

    public SpeedSearch getSpeedSearch() {
        return this.mySpeedSearch;
    }

    protected void onSelectByMnemonic(Object value2) {
    }

    protected abstract void onChildSelectedFor(Object var1);

    protected final void notifyParentOnChildSelection() {
        if (this.myParent == null || this.myParentValue == null) {
            return;
        }
        this.myParent.onChildSelectedFor(this.myParentValue);
    }

    @Override
    public final void setFinalRunnable(Runnable runnable2) {
        if (this.getParent() == null) {
            super.setFinalRunnable(runnable2);
        } else {
            this.getParent().setFinalRunnable(runnable2);
        }
    }

    @Override
    public void setOk(boolean ok) {
        if (this.getParent() == null) {
            super.setOk(ok);
        } else {
            this.getParent().setOk(ok);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aStep";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/WizardPopup";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "border";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/WizardPopup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createScrollPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createContentPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyComponentAdapter
    extends ComponentAdapter {
        private MyComponentAdapter() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            WizardPopup.this.processParentWindowMoved();
        }
    }

    private static final class MyContainer
    extends AbstractPopup.MyContentPanel {
        private MyContainer(@NotNull PopupBorder border) {
            if (border == null) {
                MyContainer.$$$reportNull$$$0(0);
            }
            super(border);
            this.setOpaque(true);
            this.setFocusCycleRoot(true);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.isPreferredSizeSet()) {
                return super.getPreferredSize();
            }
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            Point p = null;
            if (focusOwner != null && focusOwner.isShowing()) {
                p = focusOwner.getLocationOnScreen();
            }
            return MyContainer.computeNotBiggerDimension(super.getPreferredSize().getSize(), p);
        }

        private static Dimension computeNotBiggerDimension(Dimension ofContent, Point locationOnScreen) {
            int resultHeight;
            int n = resultHeight = ofContent.height > WizardPopup.MAX_SIZE.height + 50 ? WizardPopup.MAX_SIZE.height : ofContent.height;
            if (locationOnScreen != null) {
                Rectangle r = ScreenUtil.getScreenRectangle((Point)locationOnScreen);
                resultHeight = Math.min(ofContent.height, r.height - r.height / 4);
            }
            int resultWidth = Math.min(ofContent.width, WizardPopup.MAX_SIZE.width);
            if (ofContent.height > WizardPopup.MAX_SIZE.height) {
                resultWidth = (int)((double)resultWidth + ScrollPaneFactory.createScrollPane().getVerticalScrollBar().getPreferredSize().getWidth());
            }
            return new Dimension(resultWidth, resultHeight);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "border", "com/intellij/ui/popup/WizardPopup$MyContainer", "<init>"));
        }
    }
}

