/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.contentQueue.IndexUpdateRunner;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistory;
import com.intellij.util.indexing.diagnostic.ScanningStatistics;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileBasedIndexProjectHandler {
    private static final Logger LOG = Logger.getInstance(FileBasedIndexProjectHandler.class);
    @ApiStatus.Internal
    public static final int ourMinFilesToStartDumbMode = Registry.intValue((String)"ide.dumb.mode.minFilesToStart", (int)20);
    private static final int ourMinFilesSizeToStartDumbMode = Registry.intValue((String)"ide.dumb.mode.minFilesSizeToStart", (int)0x100000);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    @Nullable
    public static DumbModeTask createChangedFilesIndexingTask(@NotNull Project project) {
        FileBasedIndex i2;
        if (project == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(0);
        }
        if (!((i2 = FileBasedIndex.getInstance()) instanceof FileBasedIndexImpl) || !IndexInfrastructure.hasIndices()) {
            return null;
        }
        if (project.isDisposed()) {
            return null;
        }
        if (!FileBasedIndexProjectHandler.mightHaveManyChangedFilesInProject(project)) {
            return null;
        }
        return new ProjectChangedFilesIndexingTask(project);
    }

    public static void scheduleReindexingInDumbMode(@NotNull Project project) {
        DumbModeTask task2;
        if (project == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(1);
        }
        if ((task2 = FileBasedIndexProjectHandler.createChangedFilesIndexingTask(project)) != null) {
            DumbService.getInstance((Project)project).queueTask(task2);
        }
    }

    @ApiStatus.Internal
    public static boolean mightHaveManyChangedFilesInProject(Project project) {
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (!(fileBasedIndex instanceof FileBasedIndexImpl)) {
            return false;
        }
        final long start2 = System.currentTimeMillis();
        return !((FileBasedIndexImpl)fileBasedIndex).processChangedFiles(project, (Processor<? super VirtualFile>)new Processor<VirtualFile>(){
            int filesInProjectToBeIndexed;
            long sizeOfFilesToBeIndexed;

            public boolean process(VirtualFile file2) {
                ++this.filesInProjectToBeIndexed;
                if (file2.isValid() && !file2.isDirectory()) {
                    this.sizeOfFilesToBeIndexed += file2.getLength();
                }
                return this.filesInProjectToBeIndexed < ourMinFilesToStartDumbMode && this.sizeOfFilesToBeIndexed < (long)ourMinFilesSizeToStartDumbMode && System.currentTimeMillis() < start2 + 100L;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexProjectHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createChangedFilesIndexingTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleReindexingInDumbMode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProjectChangedFilesIndexingTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;

        private ProjectChangedFilesIndexingTask(@NotNull Project project) {
            if (project == null) {
                ProjectChangedFilesIndexingTask.$$$reportNull$$$0(0);
            }
            super((Object)project);
            this.myProject = project;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator2) {
            if (indicator2 == null) {
                ProjectChangedFilesIndexingTask.$$$reportNull$$$0(1);
            }
            indicator2.setIndeterminate(false);
            indicator2.setText(IndexingBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
            long refreshedFilesCalcDuration = System.nanoTime();
            FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
            Collection<VirtualFile> files2 = fileBasedIndex.getFilesToUpdate(this.myProject);
            refreshedFilesCalcDuration = System.nanoTime() - refreshedFilesCalcDuration;
            LOG.info("Reindexing refreshed files of " + this.myProject.getName() + " : " + files2.size() + " to update, calculated in " + TimeUnit.NANOSECONDS.toMillis(refreshedFilesCalcDuration) + "ms");
            if (!files2.isEmpty()) {
                PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
                ProjectChangedFilesIndexingTask.indexChangedFiles(files2, indicator2, fileBasedIndex, this.myProject, refreshedFilesCalcDuration);
                snapshot.logResponsivenessSinceCreation("Reindexing refreshed files of " + this.myProject.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void indexChangedFiles(@NotNull Collection<VirtualFile> files2, @NotNull ProgressIndicator indicator2, @NotNull FileBasedIndexImpl index2, @NotNull Project project, long refreshedFilesCalcDuration) {
            if (files2 == null) {
                ProjectChangedFilesIndexingTask.$$$reportNull$$$0(2);
            }
            if (indicator2 == null) {
                ProjectChangedFilesIndexingTask.$$$reportNull$$$0(3);
            }
            if (index2 == null) {
                ProjectChangedFilesIndexingTask.$$$reportNull$$$0(4);
            }
            if (project == null) {
                ProjectChangedFilesIndexingTask.$$$reportNull$$$0(5);
            }
            ProjectIndexingHistory projectIndexingHistory = new ProjectIndexingHistory(project, "On refresh of " + files2.size() + " files");
            IndexDiagnosticDumper.getInstance().onIndexingStarted(projectIndexingHistory);
            ((FileBasedIndexImpl)FileBasedIndex.getInstance()).fireUpdateStarted(project);
            try {
                int numberOfIndexingThreads = UnindexedFilesUpdater.getNumberOfIndexingThreads();
                LOG.info("Using " + numberOfIndexingThreads + " " + StringUtil.pluralize((String)"thread", (int)numberOfIndexingThreads) + " for indexing");
                IndexUpdateRunner indexUpdateRunner = new IndexUpdateRunner(index2, UnindexedFilesUpdater.GLOBAL_INDEXING_EXECUTOR, numberOfIndexingThreads);
                IndexUpdateRunner.IndexingInterruptedException interruptedException = null;
                Instant indexingStart = Instant.now();
                String fileSetName = "Refreshed files";
                IndexUpdateRunner.FileSet fileSet = new IndexUpdateRunner.FileSet(project, fileSetName, files2);
                try {
                    indexUpdateRunner.indexFiles(project, Collections.singletonList(fileSet), indicator2);
                }
                catch (IndexUpdateRunner.IndexingInterruptedException e) {
                    projectIndexingHistory.getTimes().setWasInterrupted(true);
                    interruptedException = e;
                }
                finally {
                    Instant now = Instant.now();
                    projectIndexingHistory.getTimes().setIndexingDuration(Duration.between(indexingStart, now));
                    projectIndexingHistory.getTimes().setScanFilesDuration(Duration.ofNanos(refreshedFilesCalcDuration));
                    projectIndexingHistory.getTimes().setUpdatingEnd(ZonedDateTime.now(ZoneOffset.UTC));
                    projectIndexingHistory.getTimes().setTotalUpdatingTime(System.nanoTime() - projectIndexingHistory.getTimes().getTotalUpdatingTime());
                }
                ScanningStatistics scanningStatistics = new ScanningStatistics(fileSetName);
                scanningStatistics.setNumberOfScannedFiles(files2.size());
                scanningStatistics.setNumberOfFilesForIndexing(files2.size());
                scanningStatistics.setScanningTime(refreshedFilesCalcDuration);
                projectIndexingHistory.addScanningStatistics(scanningStatistics);
                projectIndexingHistory.addProviderStatistics(fileSet.statistics);
                if (interruptedException != null) {
                    ExceptionUtil.rethrow((Throwable)interruptedException.getCause());
                }
            }
            finally {
                IndexDiagnosticDumper.getInstance().onIndexingFinished(projectIndexingHistory);
                ((FileBasedIndexImpl)FileBasedIndex.getInstance()).fireUpdateFinished(project);
            }
        }

        public String toString() {
            final StringBuilder sampleOfChangedFilePathsToBeIndexed = new StringBuilder();
            ((FileBasedIndexImpl)FileBasedIndex.getInstance()).processChangedFiles(this.myProject, (Processor<? super VirtualFile>)new Processor<VirtualFile>(){
                int filesInProjectToBeIndexed;
                final String projectBasePath;
                {
                    this.projectBasePath = myProject.getBasePath();
                }

                public boolean process(VirtualFile file2) {
                    if (this.filesInProjectToBeIndexed != 0) {
                        sampleOfChangedFilePathsToBeIndexed.append(", ");
                    }
                    String filePath = file2.getPath();
                    Object loggedPath = this.projectBasePath != null ? FileUtil.getRelativePath((String)this.projectBasePath, (String)filePath, (char)'/') : null;
                    loggedPath = loggedPath == null ? filePath : "%project_path%/" + (String)loggedPath;
                    sampleOfChangedFilePathsToBeIndexed.append((String)loggedPath);
                    return ++this.filesInProjectToBeIndexed < ourMinFilesToStartDumbMode;
                }
            });
            return super.toString() + " [" + this.myProject + ", " + sampleOfChangedFilePathsToBeIndexed + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "index";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexProjectHandler$ProjectChangedFilesIndexingTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performInDumbMode";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexChangedFiles";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

