/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexVersion;
import com.intellij.util.io.DataInputOutputUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class IndexingStamp {
    private static final boolean IS_UNIT_TEST = ApplicationManager.getApplication().isUnitTestMode();
    private static final long INDEX_DATA_OUTDATED_STAMP = -2L;
    private static final long HAS_NO_INDEXED_DATA_STAMP = 0L;
    private static final int INDEXING_STAMP_CACHE_CAPACITY = SystemProperties.getIntProperty((String)"index.timestamp.cache.size", (int)100);
    private static final ConcurrentIntObjectMap<Timestamps> ourTimestampsCache = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
    private static final BlockingQueue<Integer> ourFinishedFiles = new ArrayBlockingQueue<Integer>(INDEXING_STAMP_CACHE_CAPACITY);
    private static final ReadWriteLock[] ourLocks = new ReadWriteLock[16];

    private IndexingStamp() {
    }

    @NotNull
    public static FileIndexingState isFileIndexedStateCurrent(int fileId, @NotNull ID<?, ?> indexName) {
        long stamp;
        block8: {
            FileIndexingState fileIndexingState;
            if (indexName == null) {
                IndexingStamp.$$$reportNull$$$0(0);
            }
            try {
                stamp = IndexingStamp.getIndexStamp(fileId, indexName);
                if (stamp != 0L) break block8;
                fileIndexingState = FileIndexingState.NOT_INDEXED;
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof IOException)) {
                    throw e;
                }
                FileIndexingState fileIndexingState2 = FileIndexingState.OUT_DATED;
                if (fileIndexingState2 == null) {
                    IndexingStamp.$$$reportNull$$$0(3);
                }
                return fileIndexingState2;
            }
            if (fileIndexingState == null) {
                IndexingStamp.$$$reportNull$$$0(1);
            }
            return fileIndexingState;
        }
        FileIndexingState fileIndexingState = stamp == IndexVersion.getIndexCreationStamp(indexName) ? FileIndexingState.UP_TO_DATE : FileIndexingState.OUT_DATED;
        if (fileIndexingState == null) {
            IndexingStamp.$$$reportNull$$$0(2);
        }
        return fileIndexingState;
    }

    public static void setFileIndexedStateCurrent(int fileId, @NotNull ID<?, ?> id2) {
        if (id2 == null) {
            IndexingStamp.$$$reportNull$$$0(4);
        }
        IndexingStamp.update(fileId, id2, IndexVersion.getIndexCreationStamp(id2));
    }

    public static void setFileIndexedStateOutdated(int fileId, @NotNull ID<?, ?> id2) {
        if (id2 == null) {
            IndexingStamp.$$$reportNull$$$0(5);
        }
        IndexingStamp.update(fileId, id2, -2L);
    }

    public static void setFileIndexedStateUnindexed(int fileId, @NotNull ID<?, ?> id2) {
        if (id2 == null) {
            IndexingStamp.$$$reportNull$$$0(6);
        }
        IndexingStamp.update(fileId, id2, 0L);
    }

    static void dropTimestampMemoryCaches() {
        IndexingStamp.flushCaches();
        ourTimestampsCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getIndexStamp(int fileId, ID<?, ?> indexName) {
        Lock readLock = IndexingStamp.getStripedLock(fileId).readLock();
        readLock.lock();
        try {
            Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
            long l = stamp.get(indexName);
            return l;
        }
        finally {
            readLock.unlock();
        }
    }

    @TestOnly
    public static void dropIndexingTimeStamps(int fileId) throws IOException {
        ourTimestampsCache.remove(fileId);
        try (com.intellij.util.io.DataOutputStream out = FSRecords.writeAttribute(fileId, Timestamps.PERSISTENCE);){
            new Timestamps(null).writeToStream((DataOutputStream)out);
        }
    }

    @NotNull
    private static Timestamps createOrGetTimeStamp(int id2) {
        assert (id2 > 0);
        Timestamps timestamps = (Timestamps)ourTimestampsCache.get(id2);
        if (timestamps == null) {
            try (DataInputStream stream = FSRecords.readAttributeWithLock(id2, Timestamps.PERSISTENCE);){
                timestamps = new Timestamps(stream);
            }
            catch (IOException e) {
                FSRecords.handleError(e);
                throw new RuntimeException(e);
            }
            ourTimestampsCache.cacheOrGet(id2, (Object)timestamps);
        }
        Timestamps timestamps2 = timestamps;
        if (timestamps2 == null) {
            IndexingStamp.$$$reportNull$$$0(7);
        }
        return timestamps2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(int fileId, @NotNull ID<?, ?> indexName, long indexCreationStamp) {
        if (indexName == null) {
            IndexingStamp.$$$reportNull$$$0(8);
        }
        assert (fileId > 0);
        Lock writeLock = IndexingStamp.getStripedLock(fileId).writeLock();
        writeLock.lock();
        try {
            Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
            stamp.set(indexName, indexCreationStamp);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<ID<?, ?>> getNontrivialFileIndexedStates(int fileId) {
        block6: {
            List<ID<?, ?>> list2;
            Lock readLock = IndexingStamp.getStripedLock(fileId).readLock();
            readLock.lock();
            try {
                Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
                if (stamp.myIndexStamps == null || stamp.myIndexStamps.isEmpty()) break block6;
                List<ID<?, ?>> list3 = List.copyOf(stamp.myIndexStamps.keySet());
                list2 = list3;
            }
            catch (InvalidVirtualFileAccessException invalidVirtualFileAccessException) {
                break block6;
            }
            finally {
                readLock.unlock();
            }
            if (list2 == null) {
                IndexingStamp.$$$reportNull$$$0(9);
            }
            return list2;
        }
        List<ID<?, ?>> list4 = Collections.emptyList();
        if (list4 == null) {
            IndexingStamp.$$$reportNull$$$0(10);
        }
        return list4;
    }

    public static void flushCaches() {
        IndexingStamp.doFlush();
    }

    public static void flushCache(int finishedFile) {
        Lock readLock = IndexingStamp.getStripedLock(finishedFile).readLock();
        readLock.lock();
        try {
            Timestamps timestamps = (Timestamps)ourTimestampsCache.get(finishedFile);
            if (timestamps == null) {
                return;
            }
            if (!timestamps.isDirty()) {
                ourTimestampsCache.remove(finishedFile);
                return;
            }
        }
        finally {
            readLock.unlock();
        }
        while (!ourFinishedFiles.offer(finishedFile)) {
            IndexingStamp.doFlush();
        }
    }

    private static void doFlush() {
        ArrayList files2 = new ArrayList(ourFinishedFiles.size());
        ourFinishedFiles.drainTo(files2);
        if (!files2.isEmpty()) {
            for (Integer file2 : files2) {
                Lock writeLock = IndexingStamp.getStripedLock(file2).writeLock();
                writeLock.lock();
                try {
                    Timestamps timestamp = (Timestamps)ourTimestampsCache.remove(file2.intValue());
                    if (timestamp == null || !timestamp.isDirty()) continue;
                    try (com.intellij.util.io.DataOutputStream sink = FSRecords.writeAttribute(file2, Timestamps.PERSISTENCE);){
                        timestamp.writeToStream((DataOutputStream)sink);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    writeLock.unlock();
                }
            }
        }
    }

    private static ReadWriteLock getStripedLock(int fileId) {
        if (fileId < 0) {
            fileId = -fileId;
        }
        return ourLocks[(fileId & 0xFF) % ourLocks.length];
    }

    static {
        for (int i2 = 0; i2 < ourLocks.length; ++i2) {
            IndexingStamp.ourLocks[i2] = new ReentrantReadWriteLock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexingStamp";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexingStamp";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "isFileIndexedStateCurrent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrGetTimeStamp";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNontrivialFileIndexedStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFileIndexedStateCurrent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFileIndexedStateCurrent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFileIndexedStateOutdated";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFileIndexedStateUnindexed";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Timestamps {
        private static final FileAttribute PERSISTENCE = new FileAttribute("__index_stamps__", 2, false);
        private Object2LongMap<ID<?, ?>> myIndexStamps;
        private boolean myIsDirty = false;

        private Timestamps(@Nullable DataInputStream stream) throws IOException {
            if (stream != null) {
                int[] outdatedIndices = null;
                long dominatingIndexStamp = DataInputOutputUtil.readTIME((DataInput)stream);
                long diff = dominatingIndexStamp - 1040688000000L;
                if (diff > 0L && diff < 32767L) {
                    int numberOfOutdatedIndices = (int)diff;
                    outdatedIndices = new int[numberOfOutdatedIndices];
                    while (numberOfOutdatedIndices > 0) {
                        outdatedIndices[--numberOfOutdatedIndices] = DataInputOutputUtil.readINT((DataInput)stream);
                    }
                    dominatingIndexStamp = DataInputOutputUtil.readTIME((DataInput)stream);
                }
                while (stream.available() > 0) {
                    long stamp;
                    ID id2 = ID.findById((int)DataInputOutputUtil.readINT((DataInput)stream));
                    if (id2 == null || id2 instanceof StubIndexKey || (stamp = IndexVersion.getIndexCreationStamp(id2)) == 0L) continue;
                    if (this.myIndexStamps == null) {
                        this.myIndexStamps = new Object2LongOpenHashMap(5, 0.98f);
                    }
                    if (stamp > dominatingIndexStamp) continue;
                    this.myIndexStamps.put((Object)id2, stamp);
                }
                if (outdatedIndices != null) {
                    for (int outdatedIndexId : outdatedIndices) {
                        ID id3 = ID.findById((int)outdatedIndexId);
                        if (id3 == null || id3 instanceof StubIndexKey || IndexVersion.getIndexCreationStamp(id3) == 0L) continue;
                        long stamp = -2L;
                        if (this.myIndexStamps == null) {
                            this.myIndexStamps = new Object2LongOpenHashMap(5, 0.98f);
                        }
                        if (stamp > dominatingIndexStamp) continue;
                        this.myIndexStamps.put((Object)id3, stamp);
                    }
                }
            }
        }

        private void writeToStream(DataOutputStream stream) throws IOException {
            if (this.myIndexStamps == null || this.myIndexStamps.isEmpty()) {
                DataInputOutputUtil.writeTIME((DataOutput)stream, (long)1040688000000L);
                return;
            }
            long[] data2 = new long[2];
            boolean dominatingStampIndex = false;
            boolean numberOfOutdatedIndex = true;
            ObjectSet entries2 = this.myIndexStamps.object2LongEntrySet();
            for (Object2LongMap.Entry entry2 : entries2) {
                long b = entry2.getLongValue();
                if (b == -2L) {
                    data2[1] = data2[1] + 1L;
                    b = IndexVersion.getIndexCreationStamp((ID)entry2.getKey());
                }
                data2[0] = Math.max(data2[0], b);
                if (!IS_UNIT_TEST || b != 0L) continue;
                FileBasedIndexImpl.LOG.info("Wrong indexing timestamp state: " + this.myIndexStamps);
            }
            if (data2[1] > 0L) {
                assert (data2[1] < 32767L);
                DataInputOutputUtil.writeTIME((DataOutput)stream, (long)(1040688000000L + data2[1]));
                for (Object2LongMap.Entry entry2 : entries2) {
                    if (entry2.getLongValue() != -2L) continue;
                    DataInputOutputUtil.writeINT((DataOutput)stream, (int)((ID)entry2.getKey()).getUniqueId());
                }
            }
            DataInputOutputUtil.writeTIME((DataOutput)stream, (long)data2[0]);
            for (Object2LongMap.Entry entry2 : entries2) {
                if (entry2.getLongValue() == -2L) continue;
                DataInputOutputUtil.writeINT((DataOutput)stream, (int)((ID)entry2.getKey()).getUniqueId());
            }
        }

        private long get(ID<?, ?> id2) {
            return this.myIndexStamps != null ? this.myIndexStamps.getLong(id2) : 0L;
        }

        private void set(ID<?, ?> id2, long tmst) {
            long previous;
            if (this.myIndexStamps == null) {
                this.myIndexStamps = new Object2LongOpenHashMap(5, 0.98f);
            }
            if (tmst == -2L && !this.myIndexStamps.containsKey(id2)) {
                return;
            }
            long l = previous = tmst == 0L ? this.myIndexStamps.removeLong(id2) : this.myIndexStamps.put(id2, tmst);
            if (previous != tmst) {
                this.myIsDirty = true;
            }
        }

        public boolean isDirty() {
            return this.myIsDirty;
        }
    }
}

