/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.JsonSharedIndexDiagnosticEvent;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistory;
import com.intellij.util.indexing.diagnostic.SharedIndexDiagnostic;
import com.intellij.util.indexing.diagnostic.dto.JsonIndexDiagnostic;
import com.intellij.util.indexing.diagnostic.dto.JsonIndexDiagnosticAppInfo;
import com.intellij.util.indexing.diagnostic.dto.JsonProjectIndexingFileCount;
import com.intellij.util.indexing.diagnostic.dto.JsonProjectIndexingHistoryTimes;
import com.intellij.util.indexing.diagnostic.dto.JsonRuntimeInfo;
import com.intellij.util.indexing.diagnostic.presentation.JsonToHtmlConverterKt;
import com.intellij.util.io.PathKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 *2\u00020\u0001:\u0003*+,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J3\u0010\u0016\u001a\u0004\u0018\u0001H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110 2\u0006\u0010!\u001a\u00020\u0011H\u0002J\u000e\u0010\"\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010#\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010!\u001a\u00020\u0011H\u0002J!\u0010%\u001a\u00020\n2\u0017\u0010&\u001a\u0013\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\n0'\u00a2\u0006\u0002\b)H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper;", "Lcom/intellij/openapi/Disposable;", "()V", "isDisposed", "", "deleteOutdatedDiagnostics", "", "Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ExistingDiagnostic;", "existingDiagnostics", "dispose", "", "dumpProjectIndexingHistoryToLogSubdirectory", "projectIndexingHistory", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory;", "fastReadAppInfo", "Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnosticAppInfo;", "jsonFile", "Ljava/nio/file/Path;", "fastReadFileCount", "Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingFileCount;", "fastReadIndexingHistoryTimes", "Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingHistoryTimes;", "fastReadJsonField", "T", "propertyName", "", "type", "Ljava/lang/Class;", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "fastReadRuntimeInfo", "Lcom/intellij/util/indexing/diagnostic/dto/JsonRuntimeInfo;", "getFilesForNewJsonAndHtmlDiagnostics", "Lkotlin/Pair;", "indexDiagnosticDirectory", "onIndexingFinished", "onIndexingStarted", "parseExistingDiagnostics", "runAllListenersSafely", "block", "Lkotlin/Function1;", "Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ProjectIndexingHistoryListener;", "Lkotlin/ExtensionFunctionType;", "Companion", "ExistingDiagnostic", "ProjectIndexingHistoryListener", "intellij.platform.lang.impl"})
public final class IndexDiagnosticDumper
implements Disposable {
    private boolean isDisposed;
    @NotNull
    private static final DateTimeFormatter diagnosticTimestampFormat;
    private static final String fileNamePrefix = "diagnostic-";
    @TestOnly
    private static boolean shouldDumpInUnitTestMode;
    private static final Logger LOG;
    @NotNull
    private static final Lazy jacksonMapper$delegate;
    @NotNull
    private static final Lazy indexingDiagnosticDir$delegate;
    @NotNull
    public static final Companion Companion;

    public final void onIndexingStarted(@NotNull ProjectIndexingHistory projectIndexingHistory) {
        Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
        this.runAllListenersSafely((Function1<? super ProjectIndexingHistoryListener, Unit>)((Function1)new Function1<ProjectIndexingHistoryListener, Unit>(projectIndexingHistory){
            final /* synthetic */ ProjectIndexingHistory $projectIndexingHistory;

            public final void invoke(@NotNull ProjectIndexingHistoryListener $this$runAllListenersSafely) {
                Intrinsics.checkNotNullParameter((Object)$this$runAllListenersSafely, (String)"$receiver");
                $this$runAllListenersSafely.onStartedIndexing(this.$projectIndexingHistory);
            }
            {
                this.$projectIndexingHistory = projectIndexingHistory;
                super(1);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onIndexingFinished(@NotNull ProjectIndexingHistory projectIndexingHistory) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
                try {
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                    if (!application.isUnitTestMode() || shouldDumpInUnitTestMode) break block4;
                    this.runAllListenersSafely((Function1<? super ProjectIndexingHistoryListener, Unit>)((Function1)new Function1<ProjectIndexingHistoryListener, Unit>(projectIndexingHistory){
                        final /* synthetic */ ProjectIndexingHistory $projectIndexingHistory;

                        public final void invoke(@NotNull ProjectIndexingHistoryListener $this$runAllListenersSafely) {
                            Intrinsics.checkNotNullParameter((Object)$this$runAllListenersSafely, (String)"$this$runAllListenersSafely");
                            $this$runAllListenersSafely.onFinishedIndexing(this.$projectIndexingHistory);
                        }
                        {
                            this.$projectIndexingHistory = projectIndexingHistory;
                            super(1);
                        }
                    }));
                    return;
                }
                catch (Throwable throwable) {
                    this.runAllListenersSafely((Function1<? super ProjectIndexingHistoryListener, Unit>)((Function1)new /* invalid duplicate definition of identical inner class */));
                    throw throwable;
                }
            }
            if (!projectIndexingHistory.getTimes().getWasInterrupted() || IndexDiagnosticDumper.Companion.getShouldDumpDiagnosticsForInterruptedUpdaters()) break block5;
            this.runAllListenersSafely((Function1<? super ProjectIndexingHistoryListener, Unit>)((Function1)new /* invalid duplicate definition of identical inner class */));
            return;
        }
        NonUrgentExecutor.getInstance().execute(new Runnable(this, projectIndexingHistory){
            final /* synthetic */ IndexDiagnosticDumper this$0;
            final /* synthetic */ ProjectIndexingHistory $projectIndexingHistory;

            public final void run() {
                IndexDiagnosticDumper.access$dumpProjectIndexingHistoryToLogSubdirectory(this.this$0, this.$projectIndexingHistory);
            }
            {
                this.this$0 = indexDiagnosticDumper;
                this.$projectIndexingHistory = projectIndexingHistory;
            }
        });
        this.runAllListenersSafely((Function1<? super ProjectIndexingHistoryListener, Unit>)((Function1)new /* invalid duplicate definition of identical inner class */));
    }

    private final void runAllListenersSafely(Function1<? super ProjectIndexingHistoryListener, Unit> block) {
        List listeners2 = (List)ProgressManager.getInstance().computeInNonCancelableSection((ThrowableComputable)runAllListenersSafely.listeners.1.INSTANCE);
        for (ProjectIndexingHistoryListener listener2 : listeners2) {
            try {
                block.invoke((Object)listener2);
            }
            catch (Exception e) {
                if (e instanceof ControlFlowException) continue;
                LOG.error((Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void dumpProjectIndexingHistoryToLogSubdirectory(ProjectIndexingHistory projectIndexingHistory) {
        try {
            void diagnosticJson;
            boolean bl = !this.isDisposed;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Path indexDiagnosticDirectory = Companion.getProjectDiagnosticDirectory(projectIndexingHistory.getProject());
            Pair<Path, Path> pair = this.getFilesForNewJsonAndHtmlDiagnostics(indexDiagnosticDirectory);
            Path path2 = (Path)pair.component1();
            Path diagnosticHtml = (Path)pair.component2();
            JsonIndexDiagnostic jsonIndexDiagnostic = JsonIndexDiagnostic.Companion.generateForHistory(projectIndexingHistory);
            Companion.getJacksonMapper().writerWithDefaultPrettyPrinter().writeValue(diagnosticJson.toFile(), (Object)jsonIndexDiagnostic);
            PathKt.write$default((Path)diagnosticHtml, (CharSequence)JsonToHtmlConverterKt.generateHtml(jsonIndexDiagnostic), null, (boolean)false, (int)6, null);
            List<ExistingDiagnostic> existingDiagnostics = this.parseExistingDiagnostics(indexDiagnosticDirectory);
            List<ExistingDiagnostic> survivedDiagnostics = this.deleteOutdatedDiagnostics(existingDiagnostics);
            List<JsonSharedIndexDiagnosticEvent> sharedIndexEvents = SharedIndexDiagnostic.INSTANCE.readEvents(projectIndexingHistory.getProject());
            Path path3 = indexDiagnosticDirectory.resolve("report.html");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"indexDiagnosticDirectory.resolve(\"report.html\")");
            String string = projectIndexingHistory.getProject().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectIndexingHistory.project.name");
            PathKt.write$default((Path)path3, (CharSequence)JsonToHtmlConverterKt.createAggregateHtml(string, survivedDiagnostics, sharedIndexEvents), null, (boolean)false, (int)6, null);
        }
        catch (Exception e) {
            LOG.warn("Failed to dump index diagnostic", (Throwable)e);
        }
    }

    private final Pair<Path, Path> getFilesForNewJsonAndHtmlDiagnostics(Path indexDiagnosticDirectory) {
        Path diagnosticJson = null;
        Path diagnosticHtml = null;
        LocalDateTime nowTime = LocalDateTime.now();
        while (true) {
            String timestamp = nowTime.format(diagnosticTimestampFormat);
            Intrinsics.checkNotNullExpressionValue((Object)indexDiagnosticDirectory.resolve(fileNamePrefix + timestamp + ".json"), (String)"indexDiagnosticDirectory\u2026mePrefix$timestamp.json\")");
            Intrinsics.checkNotNullExpressionValue((Object)indexDiagnosticDirectory.resolve(fileNamePrefix + timestamp + ".html"), (String)"indexDiagnosticDirectory\u2026mePrefix$timestamp.html\")");
            if (!PathKt.exists((Path)diagnosticJson) && !PathKt.exists((Path)diagnosticHtml)) break;
            nowTime = nowTime.plusNanos(TimeUnit.MILLISECONDS.toNanos(1L));
        }
        return TuplesKt.to((Object)diagnosticJson, (Object)diagnosticHtml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final <T> T fastReadJsonField(Path jsonFile, String propertyName, Class<T> type) {
        try {
            Object object = jsonFile;
            Unit unit = new Unit[]{};
            Charset charset = Charsets.UTF_8;
            int n = 8192;
            boolean bl = false;
            Unit unit2 = unit;
            object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(unit2, ((OpenOption[])unit2).length)), charset), n);
            boolean bl2 = false;
            n = 0;
            Throwable throwable = null;
            try {
                BufferedReader reader = (BufferedReader)object;
                boolean bl3 = false;
                Closeable closeable = (Closeable)Companion.getJacksonMapper().getFactory().createParser((Reader)reader);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    JsonParser parser = (JsonParser)closeable;
                    boolean bl6 = false;
                    while (parser.nextToken() != null) {
                        JsonParser jsonParser = parser;
                        Intrinsics.checkNotNullExpressionValue((Object)jsonParser, (String)"parser");
                        String property2 = jsonParser.getCurrentName();
                        if (!Intrinsics.areEqual((Object)property2, (Object)propertyName)) continue;
                        parser.nextToken();
                        Object object2 = Companion.getJacksonMapper().readValue(parser, type);
                        Object object3 = object2;
                        return (T)object3;
                    }
                    Unit unit3 = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                unit = Unit.INSTANCE;
                return null;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to parse project indexing time", (Throwable)e);
        }
        return null;
    }

    private final JsonProjectIndexingHistoryTimes fastReadIndexingHistoryTimes(Path jsonFile) {
        return this.fastReadJsonField(jsonFile, "times", JsonProjectIndexingHistoryTimes.class);
    }

    private final JsonProjectIndexingFileCount fastReadFileCount(Path jsonFile) {
        return this.fastReadJsonField(jsonFile, "fileCount", JsonProjectIndexingFileCount.class);
    }

    private final JsonIndexDiagnosticAppInfo fastReadAppInfo(Path jsonFile) {
        return this.fastReadJsonField(jsonFile, "appInfo", JsonIndexDiagnosticAppInfo.class);
    }

    private final JsonRuntimeInfo fastReadRuntimeInfo(Path jsonFile) {
        return this.fastReadJsonField(jsonFile, "runtimeInfo", JsonRuntimeInfo.class);
    }

    private final List<ExistingDiagnostic> deleteOutdatedDiagnostics(List<ExistingDiagnostic> existingDiagnostics) {
        Iterable $this$sortedByDescending$iv = existingDiagnostics;
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        List sortedDiagnostics = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                ExistingDiagnostic it = (ExistingDiagnostic)b;
                boolean bl2 = false;
                Comparable comparable = it.getIndexingTimes().getUpdatingStart().getInstant();
                it = (ExistingDiagnostic)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                ZonedDateTime zonedDateTime = it.getIndexingTimes().getUpdatingStart().getInstant();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)zonedDateTime);
            }
        });
        List survivedDiagnostics = CollectionsKt.take((Iterable)sortedDiagnostics, (int)IndexDiagnosticDumper.Companion.getIndexingDiagnosticsLimitOfFiles());
        List outdatedDiagnostics = CollectionsKt.drop((Iterable)sortedDiagnostics, (int)IndexDiagnosticDumper.Companion.getIndexingDiagnosticsLimitOfFiles());
        for (ExistingDiagnostic diagnostic : outdatedDiagnostics) {
            PathKt.delete$default((Path)diagnostic.getJsonFile(), (boolean)false, (int)1, null);
            PathKt.delete$default((Path)diagnostic.getHtmlFile(), (boolean)false, (int)1, null);
        }
        return survivedDiagnostics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<ExistingDiagnostic> parseExistingDiagnostics(Path indexDiagnosticDirectory) {
        List list2;
        AutoCloseable autoCloseable = Files.list(indexDiagnosticDirectory);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Stream files2 = (Stream)autoCloseable;
            boolean bl3 = false;
            Stream stream = files2;
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"files");
            list2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)parseExistingDiagnostics.1.1.INSTANCE), (Function1)((Function1)new Function1<Path, ExistingDiagnostic>(this){
                final /* synthetic */ IndexDiagnosticDumper this$0;
                {
                    this.this$0 = indexDiagnosticDumper;
                    super(1);
                }

                @Nullable
                public final ExistingDiagnostic invoke(Path jsonFile) {
                    Path htmlFile;
                    Path path2 = jsonFile;
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"jsonFile");
                    JsonProjectIndexingHistoryTimes jsonProjectIndexingHistoryTimes = IndexDiagnosticDumper.access$fastReadIndexingHistoryTimes(this.this$0, path2);
                    if (jsonProjectIndexingHistoryTimes == null) {
                        return null;
                    }
                    JsonProjectIndexingHistoryTimes times = jsonProjectIndexingHistoryTimes;
                    JsonIndexDiagnosticAppInfo jsonIndexDiagnosticAppInfo = IndexDiagnosticDumper.access$fastReadAppInfo(this.this$0, jsonFile);
                    if (jsonIndexDiagnosticAppInfo == null) {
                        return null;
                    }
                    JsonIndexDiagnosticAppInfo appInfo = jsonIndexDiagnosticAppInfo;
                    JsonRuntimeInfo jsonRuntimeInfo = IndexDiagnosticDumper.access$fastReadRuntimeInfo(this.this$0, jsonFile);
                    if (jsonRuntimeInfo == null) {
                        return null;
                    }
                    JsonRuntimeInfo runtimeInfo = jsonRuntimeInfo;
                    JsonProjectIndexingFileCount fileCount = IndexDiagnosticDumper.access$fastReadFileCount(this.this$0, jsonFile);
                    Path path3 = htmlFile = jsonFile.resolveSibling(PathsKt.getNameWithoutExtension((Path)jsonFile) + ".html");
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"htmlFile");
                    if (!PathKt.exists((Path)path3)) {
                        return null;
                    }
                    return new ExistingDiagnostic(jsonFile, htmlFile, times, appInfo, runtimeInfo, fileCount);
                }
            })));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list2;
    }

    public synchronized void dispose() {
        this.isDisposed = true;
    }

    static {
        Companion = new Companion(null);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss.SSS");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"DateTimeFormatter.ofPatt\u2026yyyy-MM-dd-HH-mm-ss.SSS\")");
        diagnosticTimestampFormat = dateTimeFormatter;
        Logger logger = Logger.getInstance(IndexDiagnosticDumper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Index\u2026nosticDumper::class.java)");
        LOG = logger;
        jacksonMapper$delegate = LazyKt.lazy((Function0)Companion.jacksonMapper.2.INSTANCE);
        indexingDiagnosticDir$delegate = LazyKt.lazy((Function0)Companion.indexingDiagnosticDir.2.INSTANCE);
    }

    public static final /* synthetic */ void access$dumpProjectIndexingHistoryToLogSubdirectory(IndexDiagnosticDumper $this, ProjectIndexingHistory projectIndexingHistory) {
        $this.dumpProjectIndexingHistoryToLogSubdirectory(projectIndexingHistory);
    }

    public static final /* synthetic */ JsonProjectIndexingHistoryTimes access$fastReadIndexingHistoryTimes(IndexDiagnosticDumper $this, Path jsonFile) {
        return $this.fastReadIndexingHistoryTimes(jsonFile);
    }

    public static final /* synthetic */ JsonIndexDiagnosticAppInfo access$fastReadAppInfo(IndexDiagnosticDumper $this, Path jsonFile) {
        return $this.fastReadAppInfo(jsonFile);
    }

    public static final /* synthetic */ JsonRuntimeInfo access$fastReadRuntimeInfo(IndexDiagnosticDumper $this, Path jsonFile) {
        return $this.fastReadRuntimeInfo(jsonFile);
    }

    public static final /* synthetic */ JsonProjectIndexingFileCount access$fastReadFileCount(IndexDiagnosticDumper $this, Path jsonFile) {
        return $this.fastReadFileCount(jsonFile);
    }

    @JvmStatic
    @NotNull
    public static final IndexDiagnosticDumper getInstance() {
        return Companion.getInstance();
    }

    private static final boolean getShouldDumpDiagnosticsForInterruptedUpdaters() {
        return IndexDiagnosticDumper.Companion.getShouldDumpDiagnosticsForInterruptedUpdaters();
    }

    private static final int getIndexingDiagnosticsLimitOfFiles() {
        return IndexDiagnosticDumper.Companion.getIndexingDiagnosticsLimitOfFiles();
    }

    public static final boolean getShouldDumpPathsOfIndexedFiles() {
        return Companion.getShouldDumpPathsOfIndexedFiles();
    }

    public static final boolean getShouldDumpInUnitTestMode() {
        Companion companion = Companion;
        return shouldDumpInUnitTestMode;
    }

    public static final void setShouldDumpInUnitTestMode(boolean bl) {
        Companion companion = Companion;
        shouldDumpInUnitTestMode = bl;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ProjectIndexingHistoryListener;", "", "onFinishedIndexing", "", "projectIndexingHistory", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory;", "onStartedIndexing", "Companion", "intellij.platform.lang.impl"})
    public static interface ProjectIndexingHistoryListener {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public void onStartedIndexing(@NotNull ProjectIndexingHistory var1);

        public void onFinishedIndexing(@NotNull ProjectIndexingHistory var1);

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onStartedIndexing(@NotNull ProjectIndexingHistoryListener $this, @NotNull ProjectIndexingHistory projectIndexingHistory) {
                Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ProjectIndexingHistoryListener$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ProjectIndexingHistoryListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "intellij.platform.lang.impl"})
        public static final class Companion {
            @NotNull
            private static final ExtensionPointName<ProjectIndexingHistoryListener> EP_NAME;
            static final /* synthetic */ Companion $$INSTANCE;

            @NotNull
            public final ExtensionPointName<ProjectIndexingHistoryListener> getEP_NAME() {
                return EP_NAME;
            }

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
                ExtensionPointName extensionPointName = ExtensionPointName.create((String)"com.intellij.projectIndexingHistoryListener");
                Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026IndexingHistoryListener\")");
                EP_NAME = extensionPointName;
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\fH\u00c6\u0003JG\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ExistingDiagnostic;", "", "jsonFile", "Ljava/nio/file/Path;", "htmlFile", "indexingTimes", "Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingHistoryTimes;", "appInfo", "Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnosticAppInfo;", "runtimeInfo", "Lcom/intellij/util/indexing/diagnostic/dto/JsonRuntimeInfo;", "fileCount", "Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingFileCount;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingHistoryTimes;Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnosticAppInfo;Lcom/intellij/util/indexing/diagnostic/dto/JsonRuntimeInfo;Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingFileCount;)V", "getAppInfo", "()Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnosticAppInfo;", "getFileCount", "()Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingFileCount;", "getHtmlFile", "()Ljava/nio/file/Path;", "getIndexingTimes", "()Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingHistoryTimes;", "getJsonFile", "getRuntimeInfo", "()Lcom/intellij/util/indexing/diagnostic/dto/JsonRuntimeInfo;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    public static final class ExistingDiagnostic {
        @NotNull
        private final Path jsonFile;
        @NotNull
        private final Path htmlFile;
        @NotNull
        private final JsonProjectIndexingHistoryTimes indexingTimes;
        @NotNull
        private final JsonIndexDiagnosticAppInfo appInfo;
        @NotNull
        private final JsonRuntimeInfo runtimeInfo;
        @Nullable
        private final JsonProjectIndexingFileCount fileCount;

        @NotNull
        public final Path getJsonFile() {
            return this.jsonFile;
        }

        @NotNull
        public final Path getHtmlFile() {
            return this.htmlFile;
        }

        @NotNull
        public final JsonProjectIndexingHistoryTimes getIndexingTimes() {
            return this.indexingTimes;
        }

        @NotNull
        public final JsonIndexDiagnosticAppInfo getAppInfo() {
            return this.appInfo;
        }

        @NotNull
        public final JsonRuntimeInfo getRuntimeInfo() {
            return this.runtimeInfo;
        }

        @Nullable
        public final JsonProjectIndexingFileCount getFileCount() {
            return this.fileCount;
        }

        public ExistingDiagnostic(@NotNull Path jsonFile, @NotNull Path htmlFile, @NotNull JsonProjectIndexingHistoryTimes indexingTimes, @NotNull JsonIndexDiagnosticAppInfo appInfo, @NotNull JsonRuntimeInfo runtimeInfo, @Nullable JsonProjectIndexingFileCount fileCount) {
            Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
            Intrinsics.checkNotNullParameter((Object)htmlFile, (String)"htmlFile");
            Intrinsics.checkNotNullParameter((Object)indexingTimes, (String)"indexingTimes");
            Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
            Intrinsics.checkNotNullParameter((Object)runtimeInfo, (String)"runtimeInfo");
            this.jsonFile = jsonFile;
            this.htmlFile = htmlFile;
            this.indexingTimes = indexingTimes;
            this.appInfo = appInfo;
            this.runtimeInfo = runtimeInfo;
            this.fileCount = fileCount;
        }

        @NotNull
        public final Path component1() {
            return this.jsonFile;
        }

        @NotNull
        public final Path component2() {
            return this.htmlFile;
        }

        @NotNull
        public final JsonProjectIndexingHistoryTimes component3() {
            return this.indexingTimes;
        }

        @NotNull
        public final JsonIndexDiagnosticAppInfo component4() {
            return this.appInfo;
        }

        @NotNull
        public final JsonRuntimeInfo component5() {
            return this.runtimeInfo;
        }

        @Nullable
        public final JsonProjectIndexingFileCount component6() {
            return this.fileCount;
        }

        @NotNull
        public final ExistingDiagnostic copy(@NotNull Path jsonFile, @NotNull Path htmlFile, @NotNull JsonProjectIndexingHistoryTimes indexingTimes, @NotNull JsonIndexDiagnosticAppInfo appInfo, @NotNull JsonRuntimeInfo runtimeInfo, @Nullable JsonProjectIndexingFileCount fileCount) {
            Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
            Intrinsics.checkNotNullParameter((Object)htmlFile, (String)"htmlFile");
            Intrinsics.checkNotNullParameter((Object)indexingTimes, (String)"indexingTimes");
            Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
            Intrinsics.checkNotNullParameter((Object)runtimeInfo, (String)"runtimeInfo");
            return new ExistingDiagnostic(jsonFile, htmlFile, indexingTimes, appInfo, runtimeInfo, fileCount);
        }

        public static /* synthetic */ ExistingDiagnostic copy$default(ExistingDiagnostic existingDiagnostic, Path path2, Path path3, JsonProjectIndexingHistoryTimes jsonProjectIndexingHistoryTimes, JsonIndexDiagnosticAppInfo jsonIndexDiagnosticAppInfo, JsonRuntimeInfo jsonRuntimeInfo, JsonProjectIndexingFileCount jsonProjectIndexingFileCount, int n, Object object) {
            if ((n & 1) != 0) {
                path2 = existingDiagnostic.jsonFile;
            }
            if ((n & 2) != 0) {
                path3 = existingDiagnostic.htmlFile;
            }
            if ((n & 4) != 0) {
                jsonProjectIndexingHistoryTimes = existingDiagnostic.indexingTimes;
            }
            if ((n & 8) != 0) {
                jsonIndexDiagnosticAppInfo = existingDiagnostic.appInfo;
            }
            if ((n & 0x10) != 0) {
                jsonRuntimeInfo = existingDiagnostic.runtimeInfo;
            }
            if ((n & 0x20) != 0) {
                jsonProjectIndexingFileCount = existingDiagnostic.fileCount;
            }
            return existingDiagnostic.copy(path2, path3, jsonProjectIndexingHistoryTimes, jsonIndexDiagnosticAppInfo, jsonRuntimeInfo, jsonProjectIndexingFileCount);
        }

        @NotNull
        public String toString() {
            return "ExistingDiagnostic(jsonFile=" + this.jsonFile + ", htmlFile=" + this.htmlFile + ", indexingTimes=" + this.indexingTimes + ", appInfo=" + this.appInfo + ", runtimeInfo=" + this.runtimeInfo + ", fileCount=" + this.fileCount + ")";
        }

        public int hashCode() {
            Path path2 = this.jsonFile;
            Path path3 = this.htmlFile;
            JsonProjectIndexingHistoryTimes jsonProjectIndexingHistoryTimes = this.indexingTimes;
            JsonIndexDiagnosticAppInfo jsonIndexDiagnosticAppInfo = this.appInfo;
            JsonRuntimeInfo jsonRuntimeInfo = this.runtimeInfo;
            JsonProjectIndexingFileCount jsonProjectIndexingFileCount = this.fileCount;
            return (((((path2 != null ? ((Object)path2).hashCode() : 0) * 31 + (path3 != null ? ((Object)path3).hashCode() : 0)) * 31 + (jsonProjectIndexingHistoryTimes != null ? ((Object)jsonProjectIndexingHistoryTimes).hashCode() : 0)) * 31 + (jsonIndexDiagnosticAppInfo != null ? ((Object)jsonIndexDiagnosticAppInfo).hashCode() : 0)) * 31 + (jsonRuntimeInfo != null ? ((Object)jsonRuntimeInfo).hashCode() : 0)) * 31 + (jsonProjectIndexingFileCount != null ? ((Object)jsonProjectIndexingFileCount).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ExistingDiagnostic)) break block3;
                    ExistingDiagnostic existingDiagnostic = (ExistingDiagnostic)object;
                    if (!Intrinsics.areEqual((Object)this.jsonFile, (Object)existingDiagnostic.jsonFile) || !Intrinsics.areEqual((Object)this.htmlFile, (Object)existingDiagnostic.htmlFile) || !Intrinsics.areEqual((Object)this.indexingTimes, (Object)existingDiagnostic.indexingTimes) || !Intrinsics.areEqual((Object)this.appInfo, (Object)existingDiagnostic.appInfo) || !Intrinsics.areEqual((Object)this.runtimeInfo, (Object)existingDiagnostic.runtimeInfo) || !Intrinsics.areEqual((Object)this.fileCount, (Object)existingDiagnostic.fileCount)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010)\u001a\u00020*H\u0007J\u000e\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\rR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0012\u001a\u00020\u00138BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u0002\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0011\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\u00020\u001d8BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001f\u0010 R$\u0010!\u001a\u00020\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\"\u0010\u0002\u001a\u0004\b#\u0010 \"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u001d8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b'\u0010\u0002\u001a\u0004\b(\u0010 \u00a8\u00061"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "diagnosticTimestampFormat", "Ljava/time/format/DateTimeFormatter;", "getDiagnosticTimestampFormat", "()Ljava/time/format/DateTimeFormatter;", "fileNamePrefix", "", "indexingDiagnosticDir", "Ljava/nio/file/Path;", "getIndexingDiagnosticDir", "()Ljava/nio/file/Path;", "indexingDiagnosticDir$delegate", "Lkotlin/Lazy;", "indexingDiagnosticsLimitOfFiles", "", "getIndexingDiagnosticsLimitOfFiles$annotations", "getIndexingDiagnosticsLimitOfFiles", "()I", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJacksonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "jacksonMapper$delegate", "shouldDumpDiagnosticsForInterruptedUpdaters", "", "getShouldDumpDiagnosticsForInterruptedUpdaters$annotations", "getShouldDumpDiagnosticsForInterruptedUpdaters", "()Z", "shouldDumpInUnitTestMode", "getShouldDumpInUnitTestMode$annotations", "getShouldDumpInUnitTestMode", "setShouldDumpInUnitTestMode", "(Z)V", "shouldDumpPathsOfIndexedFiles", "getShouldDumpPathsOfIndexedFiles$annotations", "getShouldDumpPathsOfIndexedFiles", "getInstance", "Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper;", "getProjectDiagnosticDirectory", "project", "Lcom/intellij/openapi/project/Project;", "readJsonIndexDiagnostic", "Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnostic;", "file", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IndexDiagnosticDumper getInstance() {
            boolean $i$f$service = false;
            Class<IndexDiagnosticDumper> serviceClass$iv = IndexDiagnosticDumper.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (IndexDiagnosticDumper)object;
        }

        @NotNull
        public final DateTimeFormatter getDiagnosticTimestampFormat() {
            return diagnosticTimestampFormat;
        }

        @JvmStatic
        private static /* synthetic */ void getShouldDumpDiagnosticsForInterruptedUpdaters$annotations() {
        }

        private final boolean getShouldDumpDiagnosticsForInterruptedUpdaters() {
            return SystemProperties.getBooleanProperty((String)"intellij.indexes.diagnostics.should.dump.for.interrupted.index.updaters", (boolean)false);
        }

        @JvmStatic
        private static /* synthetic */ void getIndexingDiagnosticsLimitOfFiles$annotations() {
        }

        private final int getIndexingDiagnosticsLimitOfFiles() {
            return SystemProperties.getIntProperty((String)"intellij.indexes.diagnostics.limit.of.files", (int)20);
        }

        @JvmStatic
        public static /* synthetic */ void getShouldDumpPathsOfIndexedFiles$annotations() {
        }

        public final boolean getShouldDumpPathsOfIndexedFiles() {
            return SystemProperties.getBooleanProperty((String)"intellij.indexes.diagnostics.should.dump.paths.of.indexed.files", (boolean)false);
        }

        @JvmStatic
        public static /* synthetic */ void getShouldDumpInUnitTestMode$annotations() {
        }

        public final boolean getShouldDumpInUnitTestMode() {
            return shouldDumpInUnitTestMode;
        }

        public final void setShouldDumpInUnitTestMode(boolean bl) {
            shouldDumpInUnitTestMode = bl;
        }

        @NotNull
        public final ObjectMapper getJacksonMapper() {
            Lazy lazy = jacksonMapper$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (ObjectMapper)lazy.getValue();
        }

        @NotNull
        public final JsonIndexDiagnostic readJsonIndexDiagnostic(@NotNull Path file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Object object = this.getJacksonMapper().readValue(file2.toFile(), JsonIndexDiagnostic.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jacksonMapper.readValue(\u2026exDiagnostic::class.java)");
            return (JsonIndexDiagnostic)object;
        }

        @NotNull
        public final Path getIndexingDiagnosticDir() {
            Lazy lazy = indexingDiagnosticDir$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Path)lazy.getValue();
        }

        @NotNull
        public final Path getProjectDiagnosticDirectory(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Path directory = ProjectUtil.getProjectCachePath$default((Project)project, (Path)this.getIndexingDiagnosticDir(), (boolean)false, null, (int)6, null);
            PathKt.createDirectories((Path)directory);
            return directory;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

