/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump.paths.providers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePaths;
import com.intellij.util.indexing.diagnostic.dump.paths.providers.PortableFilePathProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/providers/ProjectRelativePortableFilePathProvider;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/providers/PortableFilePathProvider;", "()V", "getLocalOrArchiveRelativeFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$RelativePath;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "rootBasePath", "", "root", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "getRelativePortableFilePath", "intellij.platform.lang.impl"})
public final class ProjectRelativePortableFilePathProvider
implements PortableFilePathProvider {
    @NotNull
    public static final ProjectRelativePortableFilePathProvider INSTANCE;

    @Override
    @Nullable
    public PortableFilePath.RelativePath getRelativePortableFilePath(@NotNull Project project, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        String string = project.getBasePath();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.basePath ?: return null");
        String projectBasePath = string;
        return this.getLocalOrArchiveRelativeFilePath(virtualFile2, project, projectBasePath, PortableFilePath.ProjectRoot.INSTANCE);
    }

    @Nullable
    public final PortableFilePath.RelativePath getLocalOrArchiveRelativeFilePath(@NotNull VirtualFile virtualFile2, @NotNull Project project, @NotNull String rootBasePath, @NotNull PortableFilePath root) {
        String relativePath;
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootBasePath, (String)"rootBasePath");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        VirtualFileSystem virtualFileSystem = virtualFile2.getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"virtualFile.fileSystem");
        VirtualFileSystem fileSystem = virtualFileSystem;
        if (fileSystem instanceof ArchiveFileSystem) {
            VirtualFile virtualFile3 = ((ArchiveFileSystem)fileSystem).getLocalByEntry(virtualFile2);
            if (virtualFile3 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"fileSystem.getLocalByEnt\u2026rtualFile) ?: return null");
            VirtualFile archiveLocalFile = virtualFile3;
            VirtualFile virtualFile4 = ((ArchiveFileSystem)fileSystem).getRootByEntry(virtualFile2);
            if (virtualFile4 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"fileSystem.getRootByEntr\u2026rtualFile) ?: return null");
            VirtualFile archiveRootFile = virtualFile4;
            String string = VfsUtil.getRelativePath((VirtualFile)virtualFile2, (VirtualFile)archiveRootFile);
            if (string == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtil.getRelativePath(\u2026eRootFile) ?: return null");
            String relativePath2 = string;
            PortableFilePath archiveLocalPath = PortableFilePaths.INSTANCE.getPortableFilePath(archiveLocalFile, project);
            PortableFilePath.ArchiveRoot archiveRoot = new PortableFilePath.ArchiveRoot(archiveLocalPath);
            return new PortableFilePath.RelativePath(archiveRoot, relativePath2);
        }
        String string = FileUtil.toSystemIndependentName((String)rootBasePath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemIndependentName(rootBasePath)");
        String systemIndependentBase = string;
        if (VfsUtilCore.isAncestorOrSelf((String)systemIndependentBase, (VirtualFile)virtualFile2) && (relativePath = FileUtil.getRelativePath((String)systemIndependentBase, (String)virtualFile2.getPath(), (char)'/')) != null) {
            return new PortableFilePath.RelativePath(root, relativePath);
        }
        return null;
    }

    private ProjectRelativePortableFilePathProvider() {
    }

    static {
        ProjectRelativePortableFilePathProvider projectRelativePortableFilePathProvider;
        INSTANCE = projectRelativePortableFilePathProvider = new ProjectRelativePortableFilePathProvider();
    }
}

