/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.socketConnection.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.io.socketConnection.AbstractRequest;
import com.intellij.util.io.socketConnection.AbstractResponse;
import com.intellij.util.io.socketConnection.AbstractResponseHandler;
import com.intellij.util.io.socketConnection.AbstractResponseToRequestHandler;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.RequestResponseExternalizerFactory;
import com.intellij.util.io.socketConnection.RequestWriter;
import com.intellij.util.io.socketConnection.SocketConnection;
import com.intellij.util.io.socketConnection.SocketConnectionListener;
import com.intellij.util.io.socketConnection.impl.ResponseProcessor;
import com.intellij.util.io.socketConnection.impl.ServerSocketConnectionImpl;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SocketConnectionBase<Request extends AbstractRequest, Response extends AbstractResponse>
implements SocketConnection<Request, Response> {
    private static final Logger LOG = Logger.getInstance(ServerSocketConnectionImpl.class);
    private final Object myLock;
    private int myPort;
    private final AtomicReference<ConnectionState> myState;
    private boolean myStopping;
    private final EventDispatcher<SocketConnectionListener> myDispatcher;
    private final List<Thread> myThreadsToInterrupt;
    private final RequestResponseExternalizerFactory<Request, Response> myExternalizerFactory;
    private final LinkedBlockingQueue<Request> myRequests;
    private final Int2ObjectMap<TimeoutInfo> myTimeouts;
    private final ResponseProcessor<Response> myResponseProcessor;

    public SocketConnectionBase(@NotNull RequestResponseExternalizerFactory<Request, Response> factory2) {
        if (factory2 == null) {
            SocketConnectionBase.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myPort = -1;
        this.myState = new AtomicReference<ConnectionState>(new ConnectionState(ConnectionStatus.NOT_CONNECTED));
        this.myDispatcher = EventDispatcher.create(SocketConnectionListener.class);
        this.myThreadsToInterrupt = new ArrayList<Thread>();
        this.myRequests = new LinkedBlockingQueue();
        this.myTimeouts = new Int2ObjectOpenHashMap();
        this.myResponseProcessor = new ResponseProcessor(this);
        this.myExternalizerFactory = factory2;
    }

    @Override
    public void sendRequest(@NotNull Request request) {
        if (request == null) {
            SocketConnectionBase.$$$reportNull$$$0(1);
        }
        this.sendRequest(request, null);
    }

    @Override
    public void sendRequest(@NotNull Request request, @Nullable AbstractResponseToRequestHandler<? extends Response> handler2) {
        if (request == null) {
            SocketConnectionBase.$$$reportNull$$$0(2);
        }
        if (handler2 != null) {
            this.myResponseProcessor.registerHandler(request.getId(), handler2);
        }
        try {
            this.myRequests.put(request);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void sendRequest(@NotNull Request request, @Nullable AbstractResponseToRequestHandler<? extends Response> handler2, int timeout, @NotNull Runnable onTimeout) {
        if (request == null) {
            SocketConnectionBase.$$$reportNull$$$0(3);
        }
        if (onTimeout == null) {
            SocketConnectionBase.$$$reportNull$$$0(4);
        }
        this.myTimeouts.put(request.getId(), (Object)new TimeoutInfo(timeout, onTimeout));
        this.sendRequest(request, handler2);
    }

    @Override
    public <R extends Response> void registerHandler(@NotNull Class<R> responseClass, @NotNull AbstractResponseHandler<R> handler2) {
        if (responseClass == null) {
            SocketConnectionBase.$$$reportNull$$$0(5);
        }
        if (handler2 == null) {
            SocketConnectionBase.$$$reportNull$$$0(6);
        }
        this.myResponseProcessor.registerHandler(responseClass, handler2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStopping() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myStopping;
        }
    }

    protected void processRequests(RequestWriter<Request> writer) throws IOException {
        this.addThreadToInterrupt();
        try {
            while (!this.isStopping()) {
                AbstractRequest request = (AbstractRequest)this.myRequests.take();
                LOG.debug("sending request: " + request);
                TimeoutInfo timeoutInfo = (TimeoutInfo)this.myTimeouts.remove(request.getId());
                if (timeoutInfo != null) {
                    this.myResponseProcessor.registerTimeoutHandler(request.getId(), timeoutInfo.myTimeout, timeoutInfo.myOnTimeout);
                }
                writer.writeRequest(request);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setStatus(ConnectionStatus.DISCONNECTED, null);
        this.removeThreadToInterrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addThreadToInterrupt() {
        Object object = this.myLock;
        synchronized (object) {
            this.myThreadsToInterrupt.add(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeThreadToInterrupt() {
        Object object = this.myLock;
        synchronized (object) {
            this.myThreadsToInterrupt.remove(Thread.currentThread());
        }
    }

    public void dispose() {
        LOG.debug("Firefox connection disposed");
    }

    @Override
    public int getPort() {
        return this.myPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(@NotNull ConnectionStatus status, @Nullable String message2) {
        if (status == null) {
            SocketConnectionBase.$$$reportNull$$$0(7);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myState.set(new ConnectionState(status, message2, null));
        }
        ((SocketConnectionListener)this.myDispatcher.getMulticaster()).statusChanged(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public ConnectionState getState() {
        Object object = this.myLock;
        // MONITORENTER : object
        ConnectionState connectionState = this.myState.get();
        // MONITOREXIT : object
        if (connectionState != null) return connectionState;
        SocketConnectionBase.$$$reportNull$$$0(8);
        return connectionState;
    }

    @Override
    public void addListener(@NotNull SocketConnectionListener listener2, @Nullable Disposable parentDisposable) {
        if (listener2 == null) {
            SocketConnectionBase.$$$reportNull$$$0(9);
        }
        if (parentDisposable != null) {
            this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
        } else {
            this.myDispatcher.addListener((EventListener)listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myStopping) {
                return;
            }
            this.myStopping = true;
        }
        LOG.debug("closing connection");
        object = this.myLock;
        synchronized (object) {
            for (Thread thread2 : this.myThreadsToInterrupt) {
                thread2.interrupt();
            }
        }
        this.onClosing();
        this.myResponseProcessor.stopReading();
        Disposer.dispose((Disposable)this);
    }

    protected void onClosing() {
    }

    protected void attachToSocket(Socket socket) throws IOException {
        this.setStatus(ConnectionStatus.CONNECTED, null);
        LOG.debug("connected");
        OutputStream outputStream = socket.getOutputStream();
        InputStream inputStream2 = socket.getInputStream();
        this.myResponseProcessor.startReading(this.myExternalizerFactory.createResponseReader(inputStream2));
        this.processRequests(this.myExternalizerFactory.createRequestWriter(outputStream));
    }

    protected void setPort(int port) {
        this.myPort = port;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onTimeout";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/socketConnection/impl/SocketConnectionBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/socketConnection/impl/SocketConnectionBase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sendRequest";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerHandler";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setStatus";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TimeoutInfo {
        private final int myTimeout;
        private final Runnable myOnTimeout;

        private TimeoutInfo(int timeout, Runnable onTimeout) {
            this.myTimeout = timeout;
            this.myOnTimeout = onTimeout;
        }
    }
}

