/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.vcs.commit.AbstractCommitWorkflow;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandler;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandlerKt;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.AmendCommitAware;
import com.intellij.vcs.commit.AmendCommitHandler;
import com.intellij.vcs.commit.AmendCommitHandlerImplKt;
import com.intellij.vcs.commit.AmendCommitModeListener;
import com.intellij.vcs.commit.AmendData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u00018B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020'H\u0014J\b\u0010,\u001a\u00020'H\u0004J\n\u0010-\u001a\u0004\u0018\u00010.H\u0004J\b\u0010/\u001a\u00020\u0015H\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020.01H\u0002J\b\u00102\u001a\u00020'H\u0004J\b\u00103\u001a\u00020'H\u0002J\u0018\u00103\u001a\u00020'2\u0006\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000fH\u0004J\u0010\u00106\u001a\u00020'2\u0006\u00107\u001a\u00020\u000fH\u0002R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00158V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u001d8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\n \b*\u0004\u0018\u00010!0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/vcs/commit/AmendCommitHandlerImpl;", "Lcom/intellij/vcs/commit/AmendCommitHandler;", "workflowHandler", "Lcom/intellij/vcs/commit/AbstractCommitWorkflowHandler;", "(Lcom/intellij/vcs/commit/AbstractCommitWorkflowHandler;)V", "amendCommitEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/vcs/commit/AmendCommitModeListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "getCommitContext", "()Lcom/intellij/openapi/vcs/changes/CommitContext;", "initialMessage", "", "getInitialMessage", "()Ljava/lang/String;", "setInitialMessage", "(Ljava/lang/String;)V", "value", "", "isAmendCommitMode", "()Z", "setAmendCommitMode", "(Z)V", "isAmendCommitModeTogglingEnabled", "setAmendCommitModeTogglingEnabled", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "vcsManager", "Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "workflow", "Lcom/intellij/vcs/commit/AbstractCommitWorkflow;", "getWorkflow", "()Lcom/intellij/vcs/commit/AbstractCommitWorkflow;", "addAmendCommitModeListener", "", "listener", "parent", "Lcom/intellij/openapi/Disposable;", "amendCommitModeToggled", "fireAmendCommitModeToggled", "getSingleRoot", "Lcom/intellij/openapi/vcs/VcsRoot;", "isAmendCommitModeSupported", "resolveAmendRoots", "", "restoreBeforeAmendMessage", "setAmendMessage", "beforeAmendMessage", "amendMessage", "setCommitMessageAndFocus", "message", "LoadCommitMessagesTask", "intellij.platform.vcs.impl"})
public class AmendCommitHandlerImpl
implements AmendCommitHandler {
    private final EventDispatcher<AmendCommitModeListener> amendCommitEventDispatcher;
    private final ProjectLevelVcsManager vcsManager;
    @Nullable
    private String initialMessage;
    private boolean isAmendCommitModeTogglingEnabled;
    private final AbstractCommitWorkflowHandler<?, ?> workflowHandler;

    private final AbstractCommitWorkflow getWorkflow() {
        return this.workflowHandler.getWorkflow();
    }

    @NotNull
    protected final CommitContext getCommitContext() {
        return this.getWorkflow().getCommitContext();
    }

    @NotNull
    protected final Project getProject() {
        return this.getWorkflow().getProject();
    }

    @Nullable
    public final String getInitialMessage() {
        return this.initialMessage;
    }

    public final void setInitialMessage(@Nullable String string) {
        this.initialMessage = string;
    }

    public boolean isAmendCommitMode() {
        return AbstractCommitWorkflowKt.isAmendCommitMode(this.getCommitContext());
    }

    public void setAmendCommitMode(boolean value2) {
        boolean oldValue = this.isAmendCommitMode();
        AbstractCommitWorkflowKt.setAmendCommitMode(this.getCommitContext(), value2);
        if (oldValue == value2) {
            return;
        }
        this.amendCommitModeToggled();
    }

    protected void amendCommitModeToggled() {
        this.fireAmendCommitModeToggled();
        if (this.isAmendCommitMode()) {
            this.setAmendMessage();
        } else {
            this.restoreBeforeAmendMessage();
        }
        this.workflowHandler.updateDefaultCommitActionName();
    }

    protected final void fireAmendCommitModeToggled() {
        ((AmendCommitModeListener)this.amendCommitEventDispatcher.getMulticaster()).amendCommitModeToggled();
    }

    public boolean isAmendCommitModeTogglingEnabled() {
        return this.isAmendCommitModeTogglingEnabled;
    }

    public void setAmendCommitModeTogglingEnabled(boolean bl) {
        this.isAmendCommitModeTogglingEnabled = bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAmendCommitModeSupported() {
        AmendCommitAware it;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        if (!this.getWorkflow().isDefaultCommitEnabled()) return false;
        Iterable $this$mapNotNull$iv = this.getWorkflow().getVcses();
        boolean $i$f$mapNotNull = false;
        Object object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CheckinEnvironment checkinEnvironment;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            AbstractVcs it2 = (AbstractVcs)element$iv$iv;
            boolean bl2 = false;
            if (it2.getCheckinEnvironment() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            CheckinEnvironment it$iv$iv = checkinEnvironment;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapNotNullTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AmendCommitAware)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$any$iv = (List)destination$iv$iv;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        object = $this$any$iv.iterator();
        do {
            if (!object.hasNext()) return false;
            Object element$iv = object.next();
            it = (AmendCommitAware)element$iv;
            boolean bl = false;
        } while (!it.isAmendCommitSupported());
        return true;
    }

    public void addAmendCommitModeListener(@NotNull AmendCommitModeListener listener2, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.amendCommitEventDispatcher.addListener((EventListener)listener2, parent);
    }

    private final void setAmendMessage() {
        block2: {
            String amendMessage;
            String beforeAmendMessage = this.workflowHandler.getCommitMessage();
            if (this.initialMessage != null && !Intrinsics.areEqual((Object)beforeAmendMessage, (Object)this.initialMessage)) break block2;
            Collection<VcsRoot> roots = this.resolveAmendRoots();
            List<String> list2 = new LoadCommitMessagesTask(this.getProject(), roots).load();
            if (list2 == null) {
                return;
            }
            List<String> messages = list2;
            String string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)messages), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            String string2 = amendMessage = !StringsKt.isBlank((CharSequence)charSequence) ? string : null;
            if (string2 != null) {
                string = string2;
                bl = false;
                bl2 = false;
                it = string;
                boolean bl5 = false;
                this.setAmendMessage(beforeAmendMessage, it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<VcsRoot> resolveAmendRoots() {
        Collection collection;
        Collection collection2 = CollectionsKt.listOfNotNull((Object)this.getSingleRoot());
        boolean bl = false;
        if (collection2.isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            boolean bl2 = false;
            Iterable $this$mapNotNull$iv = AbstractCommitWorkflowHandlerKt.getIncludedPaths(this.workflowHandler.getUi());
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                VcsRoot vcsRoot;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl3 = false;
                FilePath it = (FilePath)element$iv$iv;
                boolean bl4 = false;
                if (this.vcsManager.getVcsRootObjectFor(it) == null) continue;
                boolean bl5 = false;
                boolean bl6 = false;
                VcsRoot it$iv$iv = vcsRoot;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            collection = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            collection = collection2;
        }
        return collection;
    }

    @Nullable
    protected final VcsRoot getSingleRoot() {
        ProjectLevelVcsManager projectLevelVcsManager = this.vcsManager;
        Intrinsics.checkNotNullExpressionValue((Object)projectLevelVcsManager, (String)"vcsManager");
        Object[] objectArray = projectLevelVcsManager.getAllVcsRoots();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"vcsManager.allVcsRoots");
        return (VcsRoot)ArraysKt.singleOrNull((Object[])objectArray);
    }

    protected final void setAmendMessage(@NotNull String beforeAmendMessage, @NotNull String amendMessage) {
        Intrinsics.checkNotNullParameter((Object)beforeAmendMessage, (String)"beforeAmendMessage");
        Intrinsics.checkNotNullParameter((Object)amendMessage, (String)"amendMessage");
        if (!StringUtil.equalsIgnoreWhitespaces((CharSequence)beforeAmendMessage, (CharSequence)amendMessage)) {
            VcsConfiguration.getInstance((Project)this.getProject()).saveCommitMessage(beforeAmendMessage);
            this.setCommitMessageAndFocus(amendMessage);
            AmendCommitHandlerImplKt.access$setAmendData$p(this.getCommitContext(), new AmendData(beforeAmendMessage, amendMessage));
        }
    }

    protected final void restoreBeforeAmendMessage() {
        AmendData amendData = AmendCommitHandlerImplKt.access$getAmendData$p(this.getCommitContext());
        if (amendData == null) {
            return;
        }
        AmendData amendData2 = amendData;
        AmendCommitHandlerImplKt.access$setAmendData$p(this.getCommitContext(), null);
        if (Intrinsics.areEqual((Object)amendData2.getAmendMessage(), (Object)this.workflowHandler.getCommitMessage())) {
            this.setCommitMessageAndFocus(amendData2.getBeforeAmendMessage());
        }
    }

    private final void setCommitMessageAndFocus(String message2) {
        AbstractCommitWorkflowHandler<?, ?> abstractCommitWorkflowHandler = this.workflowHandler;
        boolean bl = false;
        boolean bl2 = false;
        AbstractCommitWorkflowHandler<?, ?> $this$with = abstractCommitWorkflowHandler;
        boolean bl3 = false;
        $this$with.setCommitMessage(message2);
        $this$with.getUi().getCommitMessageUi().focus();
    }

    public AmendCommitHandlerImpl(@NotNull AbstractCommitWorkflowHandler<?, ?> workflowHandler) {
        Intrinsics.checkNotNullParameter(workflowHandler, (String)"workflowHandler");
        this.workflowHandler = workflowHandler;
        EventDispatcher eventDispatcher = EventDispatcher.create(AmendCommitModeListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"EventDispatcher.create(A\u2026ModeListener::class.java)");
        this.amendCommitEventDispatcher = eventDispatcher;
        this.vcsManager = ProjectLevelVcsManager.getInstance((Project)this.getProject());
        this.isAmendCommitModeTogglingEnabled = true;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001B\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\f\u001a\u00020\rH\u0014J\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/commit/AmendCommitHandlerImpl$LoadCommitMessagesTask;", "Lcom/intellij/openapi/progress/Task$WithResult;", "", "", "Lcom/intellij/openapi/vcs/VcsException;", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vcs/VcsRoot;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;)V", "compute", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "load", "intellij.platform.vcs.impl"})
    private static final class LoadCommitMessagesTask
    extends Task.WithResult<List<? extends String>, VcsException> {
        private final Collection<VcsRoot> roots;

        @Nullable
        public final List<String> load() {
            List list2;
            this.queue();
            try {
                list2 = (List)this.getResult();
            }
            catch (VcsException e) {
                Project project = this.getProject();
                StringBuilder stringBuilder = new StringBuilder().append(VcsBundle.message((String)"amend.commit.load.message.error.text", (Object[])new Object[0])).append("\n");
                String string = e.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.message");
                Messages.showErrorDialog((Project)project, (String)stringBuilder.append(StringsKt.capitalize((String)string)).toString(), (String)VcsBundle.message((String)"amend.commit.load.message.error.title", (Object[])new Object[0]));
                AmendCommitHandlerImplKt.access$getLOG$p().info((Throwable)e);
                list2 = null;
            }
            return list2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected List<String> compute(@NotNull ProgressIndicator indicator2) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
            Iterable $this$mapNotNull$iv = this.roots;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                VcsRoot vcsRoot = (VcsRoot)element$iv$iv;
                boolean bl2 = false;
                AbstractVcs abstractVcs = vcsRoot.getVcs();
                Object object = abstractVcs != null ? abstractVcs.getCheckinEnvironment() : null;
                if (!(object instanceof AmendCommitAware)) {
                    object = null;
                }
                if ((AmendCommitAware)object == null) {
                    string = null;
                } else {
                    AmendCommitAware amendAware;
                    VirtualFile virtualFile2 = vcsRoot.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"vcsRoot.path");
                    string = amendAware.getLastCommitMessage(virtualFile2);
                }
                if (string == null) continue;
                String string2 = string;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = string2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public LoadCommitMessagesTask(@NotNull Project project, @NotNull Collection<VcsRoot> roots) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            super(project, VcsBundle.message((String)"amend.commit.load.message.task.title", (Object[])new Object[0]), true);
            this.roots = roots;
        }
    }
}

