/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade.bek;

import com.intellij.openapi.util.Pair;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.impl.facade.bek.BekBranch;
import com.intellij.vcs.log.graph.impl.facade.bek.BekEdgeRestrictions;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.utils.DfsUtilKt;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

class BekBranchCreator {
    @NotNull
    private final LinearGraph myPermanentGraph;
    @NotNull
    private final GraphLayoutImpl myGraphLayout;
    @NotNull
    private final Flags myDoneNodes;
    @NotNull
    private final BekEdgeRestrictions myEdgeRestrictions;

    BekBranchCreator(@NotNull LinearGraph permanentGraph, @NotNull GraphLayoutImpl graphLayout) {
        if (permanentGraph == null) {
            BekBranchCreator.$$$reportNull$$$0(0);
        }
        if (graphLayout == null) {
            BekBranchCreator.$$$reportNull$$$0(1);
        }
        this.myEdgeRestrictions = new BekEdgeRestrictions();
        this.myPermanentGraph = permanentGraph;
        this.myGraphLayout = graphLayout;
        this.myDoneNodes = new BitSetFlags(permanentGraph.nodesCount(), false);
    }

    @NotNull
    public Pair<List<BekBranch>, BekEdgeRestrictions> getResult() {
        ArrayList<BekBranch> bekBranches = new ArrayList<BekBranch>();
        for (int headNode : this.myGraphLayout.getHeadNodeIndex()) {
            List<Integer> nextBranch = this.createNextBranch(headNode);
            bekBranches.add(new BekBranch(this.myPermanentGraph, nextBranch));
        }
        Pair pair = Pair.create(bekBranches, (Object)this.myEdgeRestrictions);
        if (pair == null) {
            BekBranchCreator.$$$reportNull$$$0(2);
        }
        return pair;
    }

    public List<Integer> createNextBranch(int headNode) {
        ArrayList<Integer> nodeIndexes = new ArrayList<Integer>();
        assert (!this.myDoneNodes.get(headNode));
        this.myDoneNodes.set(headNode, true);
        nodeIndexes.add(headNode);
        int startLayout = this.myGraphLayout.getLayoutIndex(headNode);
        DfsUtilKt.walk(headNode, (Function1<? super Integer, Integer>)((Function1)currentNode -> {
            int currentLayout = this.myGraphLayout.getLayoutIndex((int)currentNode);
            List<Integer> downNodes = LinearGraphUtils.getDownNodes(this.myPermanentGraph, currentNode);
            for (int i2 = downNodes.size() - 1; i2 >= 0; --i2) {
                int downNode = downNodes.get(i2);
                if (this.myDoneNodes.get(downNode)) {
                    if (this.myGraphLayout.getLayoutIndex(downNode) >= startLayout) continue;
                    this.myEdgeRestrictions.addRestriction((int)currentNode, downNode);
                    continue;
                }
                if (currentLayout > this.myGraphLayout.getLayoutIndex(downNode)) continue;
                boolean hasUndoneUpNodes = false;
                for (int upNode : LinearGraphUtils.getUpNodes(this.myPermanentGraph, downNode)) {
                    if (this.myDoneNodes.get(upNode) || this.myGraphLayout.getLayoutIndex(upNode) > this.myGraphLayout.getLayoutIndex(downNode)) continue;
                    hasUndoneUpNodes = true;
                    break;
                }
                if (hasUndoneUpNodes) continue;
                this.myDoneNodes.set(downNode, true);
                nodeIndexes.add(downNode);
                return downNode;
            }
            return -1;
        }));
        return nodeIndexes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentGraph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphLayout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/bek/BekBranchCreator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/bek/BekBranchCreator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

