/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class CompareRevisionsFromFileHistoryActionProvider
implements AnActionExtensionProvider {
    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(0);
        }
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        return e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI) != null && filePath != null && !filePath.isDirectory();
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project == null || filePath == null || filePath.isDirectory() || log == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        this.updateActionText(e, log);
        e.getPresentation().setVisible(true);
        if (e.getInputEvent() instanceof KeyEvent) {
            e.getPresentation().setEnabled(true);
        } else {
            Change[] changes = (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES);
            e.getPresentation().setEnabled(changes != null && changes.length == 1 && changes[0] != null);
        }
    }

    protected void updateActionText(@NotNull AnActionEvent e, @NotNull VcsLog log) {
        if (e == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(2);
        }
        if (log == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(3);
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(4);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e, this);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        Change[] changes = (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES);
        if (changes == null || changes.length != 1 || changes[0] == null) {
            return;
        }
        ShowDiffAction.showDiffForChange(project, Arrays.asList(changes));
    }

    public static void setTextAndDescription(@NotNull AnActionEvent e, @NotNull VcsLog log) {
        if (e == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(5);
        }
        if (log == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(6);
        }
        if (log.getSelectedCommits().size() >= 2) {
            e.getPresentation().setText(VcsLogBundle.messagePointer((String)"action.presentation.CompareRevisionsFromFileHistoryActionProvider.text.compare", (Object[])new Object[0]));
            e.getPresentation().setDescription(VcsLogBundle.messagePointer((String)"action.presentation.CompareRevisionsFromFileHistoryActionProvider.description.compare", (Object[])new Object[0]));
        } else {
            e.getPresentation().setText(VcsLogBundle.messagePointer((String)"action.presentation.CompareRevisionsFromFileHistoryActionProvider.text.show.diff", (Object[])new Object[0]));
            e.getPresentation().setDescription(VcsLogBundle.messagePointer((String)"action.presentation.CompareRevisionsFromFileHistoryActionProvider.description.show.diff", (Object[])new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/ui/actions/history/CompareRevisionsFromFileHistoryActionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isActive";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateActionText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setTextAndDescription";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ShowStandaloneDiff
    extends CompareRevisionsFromFileHistoryActionProvider {
        ShowStandaloneDiff() {
        }
    }

    static class ShowDiff
    extends CompareRevisionsFromFileHistoryActionProvider {
        ShowDiff() {
        }

        @Override
        protected void updateActionText(@NotNull AnActionEvent e, @NotNull VcsLog log) {
            if (e == null) {
                ShowDiff.$$$reportNull$$$0(0);
            }
            if (log == null) {
                ShowDiff.$$$reportNull$$$0(1);
            }
            ShowDiff.setTextAndDescription(e, log);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "log";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/actions/history/CompareRevisionsFromFileHistoryActionProvider$ShowDiff";
            objectArray[2] = "updateActionText";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

