/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.details.commit;

import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.util.ui.HtmlPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanelKt;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.List;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u0016\u0010\u0017\u001a\u00020\u000e2\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/vcs/log/ui/details/commit/ContainingBranchesPanel;", "Lcom/intellij/util/ui/HtmlPanel;", "()V", "branches", "", "", "expanded", "", "getBackground", "Ljava/awt/Color;", "getBody", "getBodyFont", "Ljava/awt/Font;", "hyperlinkUpdate", "", "e", "Ljavax/swing/event/HyperlinkEvent;", "setBounds", "x", "", "y", "w", "h", "setBranches", "intellij.platform.vcs.log.impl"})
final class ContainingBranchesPanel
extends HtmlPanel {
    private List<String> branches;
    private boolean expanded;

    @Override
    public void setBounds(int x, int y, int w, int h) {
        int oldWidth = this.getWidth();
        super.setBounds(x, y, w, h);
        if (w != oldWidth) {
            this.update();
        }
    }

    @Override
    public void hyperlinkUpdate(@NotNull HyperlinkEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) && CommitPresentationUtil.isShowHideBranches(e)) {
            this.expanded = !this.expanded;
            this.update();
        }
    }

    public final void setBranches(@Nullable List<String> branches) {
        this.branches = branches;
        this.expanded = false;
        this.setVisible(true);
        this.update();
    }

    @Override
    @NotNull
    protected String getBody() {
        String string;
        Insets insets = this.getInsets();
        String string2 = CommitPresentationUtil.getBranchesText(this.branches, this.expanded, this.getWidth() - insets.left - insets.right, this.getFontMetrics(this.getBodyFont()));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getBranchesText(branches\u2026getFontMetrics(bodyFont))");
        String text2 = string2;
        if (this.expanded) {
            string = text2;
        } else {
            String string3 = HtmlChunk.raw((String)text2).wrapWith("nobr").toString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"HtmlChunk.raw(text).wrapWith(\"nobr\").toString()");
        }
        return string;
    }

    @Override
    @NotNull
    public Color getBackground() {
        return CommitDetailsPanelKt.getCommitDetailsBackground();
    }

    @Override
    @NotNull
    protected Font getBodyFont() {
        Font font = FontUtil.getCommitMetadataFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"FontUtil.getCommitMetadataFont()");
        return font;
    }

    public ContainingBranchesPanel() {
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)14, (int)14, (int)14));
        this.setVisible(false);
    }
}

