/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.comparison.TrimUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import com.intellij.vcs.commit.message.SubjectLimitInspection;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommitPresentationUtil {
    @NotNull
    private static final Pattern HASH_PATTERN = Pattern.compile("[0-9a-f]{7,40}", 2);
    @NotNull
    @NlsSafe
    private static final String GO_TO_HASH = "go-to-hash:";
    @NotNull
    @NlsSafe
    private static final String SHOW_HIDE_BRANCHES = "show-hide-branches";
    @NlsSafe
    private static final String ELLIPSIS = "...";
    private static final int BIG_CUT_SIZE = 10;
    private static final double EPSILON = 1.5;

    public static boolean isShowHideBranches(@NotNull HyperlinkEvent e) {
        if (e == null) {
            CommitPresentationUtil.$$$reportNull$$$0(0);
        }
        return SHOW_HIDE_BRANCHES.equals(e.getDescription());
    }

    public static boolean isGoToHash(@NotNull HyperlinkEvent e) {
        if (e == null) {
            CommitPresentationUtil.$$$reportNull$$$0(1);
        }
        return e.getDescription().startsWith(GO_TO_HASH);
    }

    @NotNull
    public static String getAuthorPresentation(@NotNull VcsShortCommitDetails details) {
        if (details == null) {
            CommitPresentationUtil.$$$reportNull$$$0(2);
        }
        String authorString = VcsUserUtil.getShortPresentation(details.getAuthor());
        String string = authorString + (VcsUserUtil.isSamePerson(details.getAuthor(), details.getCommitter()) ? "" : "*");
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String escapeMultipleSpaces(@NotNull @Nls String text2) {
        if (text2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(4);
        }
        @Nls StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            if (text2.charAt(i2) == ' ') {
                if (i2 == text2.length() - 1 || text2.charAt(i2 + 1) != ' ') {
                    result2.append(' ');
                    continue;
                }
                result2.append("&nbsp;");
                continue;
            }
            result2.append(text2.charAt(i2));
        }
        String string = result2.toString();
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static @NotNull Set<@NlsSafe String> findHashes(@NotNull @NlsSafe String text2) {
        if (text2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(6);
        }
        HashSet<String> result2 = new HashSet<String>();
        Matcher matcher = HASH_PATTERN.matcher(text2);
        while (matcher.find()) {
            result2.add(matcher.group());
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            CommitPresentationUtil.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    @NlsSafe
    private static String replaceHashes(@NotNull @NlsSafe String s, @NotNull Set<@NlsSafe String> resolvedHashes) {
        if (s == null) {
            CommitPresentationUtil.$$$reportNull$$$0(8);
        }
        if (resolvedHashes == null) {
            CommitPresentationUtil.$$$reportNull$$$0(9);
        }
        Matcher matcher = HASH_PATTERN.matcher(s);
        StringBuilder result2 = new StringBuilder();
        while (matcher.find()) {
            String hash = matcher.group();
            if (resolvedHashes.contains(hash)) {
                hash = HtmlChunk.link((String)(GO_TO_HASH + hash), (String)hash).toString();
            }
            matcher.appendReplacement(result2, hash);
        }
        matcher.appendTail(result2);
        String string = result2.toString();
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static @NotNull Set<@NlsSafe String> findHashes(@NotNull Project project, @NotNull @NlsSafe String message2) {
        if (project == null) {
            CommitPresentationUtil.$$$reportNull$$$0(11);
        }
        if (message2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(12);
        }
        HashSet<String> unresolvedHashes = new HashSet<String>();
        IssueLinkHtmlRenderer.formatTextWithLinks(project, message2, (Convertor<? super String, String>)((Convertor)s -> {
            unresolvedHashes.addAll(CommitPresentationUtil.findHashes(s));
            return s;
        }));
        HashSet<String> hashSet = unresolvedHashes;
        if (hashSet == null) {
            CommitPresentationUtil.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @NotNull
    @NlsSafe
    private static String formatCommitText(@NotNull Project project, @NotNull @NlsSafe String fullMessage, @NotNull Set<@NlsSafe String> resolvedHashes) {
        if (project == null) {
            CommitPresentationUtil.$$$reportNull$$$0(14);
        }
        if (fullMessage == null) {
            CommitPresentationUtil.$$$reportNull$$$0(15);
        }
        if (resolvedHashes == null) {
            CommitPresentationUtil.$$$reportNull$$$0(16);
        }
        fullMessage = VcsUtil.trimCommitMessageToSaneSize((String)fullMessage);
        Font font = FontUtil.getCommitMessageFont();
        Convertor convertor = s -> CommitPresentationUtil.replaceHashes(s, resolvedHashes);
        int separator = fullMessage.indexOf("\n\n");
        Object subject = separator > 0 ? fullMessage.substring(0, separator) : fullMessage;
        Object description2 = fullMessage.substring(((String)subject).length());
        if (((String)subject).contains("\n")) {
            return CommitPresentationUtil.formatText(project, fullMessage, font, font.getStyle(), (Convertor<? super String, String>)convertor);
        }
        if (CommitPresentationUtil.isSubjectMarginEnabled(project)) {
            int margin = CommitMessageInspectionProfile.getSubjectRightMargin(project);
            if ((double)((String)subject).length() > (double)margin * 1.5) {
                int placeToCut;
                for (int i2 = placeToCut = margin - ELLIPSIS.length(); i2 >= Math.max(margin - 10, 10); --i2) {
                    if (((String)subject).charAt(i2) != ' ') continue;
                    placeToCut = i2;
                    break;
                }
                Object tail = ((String)subject).substring(placeToCut);
                if (TrimUtil.isPunctuation(((String)(subject = ((String)subject).substring(0, placeToCut))).charAt(placeToCut - 1))) {
                    tail = StringUtil.trimStart((String)tail, (String)" ");
                } else {
                    subject = (String)subject + ELLIPSIS;
                    tail = ELLIPSIS + (String)tail;
                }
                description2 = "\n\n" + (String)tail + (String)description2;
            }
        }
        String string = "<b>" + CommitPresentationUtil.formatText(project, (String)subject, font, 1, (Convertor<? super String, String>)convertor) + "</b>" + CommitPresentationUtil.formatText(project, (String)description2, font, font.getStyle(), (Convertor<? super String, String>)convertor);
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static boolean isSubjectMarginEnabled(@NotNull Project project) {
        if (project == null) {
            CommitPresentationUtil.$$$reportNull$$$0(18);
        }
        return CommitMessageInspectionProfile.getInstance(project).isToolEnabled(SubjectLimitInspection.class);
    }

    @NotNull
    private static String formatText(@NotNull Project project, @NotNull @Nls String text2, @NotNull Font font, int style, @NotNull Convertor<? super String, String> convertor) {
        if (project == null) {
            CommitPresentationUtil.$$$reportNull$$$0(19);
        }
        if (text2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(20);
        }
        if (font == null) {
            CommitPresentationUtil.$$$reportNull$$$0(21);
        }
        if (convertor == null) {
            CommitPresentationUtil.$$$reportNull$$$0(22);
        }
        String string = FontUtil.getHtmlWithFonts(CommitPresentationUtil.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks(project, text2, convertor)), style, font);
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @Nls
    private static String getAuthorAndCommitterText(@NotNull VcsUser author, long authorTime, @NotNull VcsUser committer, long l) {
        void commitTime;
        if (author == null) {
            CommitPresentationUtil.$$$reportNull$$$0(24);
        }
        if (committer == null) {
            CommitPresentationUtil.$$$reportNull$$$0(25);
        }
        String authorText = VcsLogBundle.message((String)"vcs.log.details.author.on.date.at.time", (Object[])new Object[]{CommitPresentationUtil.getAuthorName(author), DateFormatUtil.formatDate((long)authorTime), DateFormatUtil.formatTime((long)authorTime)});
        HtmlBuilder builder2 = new HtmlBuilder().appendRaw(authorText);
        if (!VcsUserUtil.isSamePerson(author, committer)) {
            builder2.br().append(CommitPresentationUtil.getCommitterHtml(committer, commitTime != authorTime ? Long.valueOf((long)commitTime) : null));
        } else if (authorTime != commitTime) {
            builder2.br().append(CommitPresentationUtil.getCommitterHtml(null, (long)commitTime));
        }
        String string = builder2.toString();
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    private static HtmlChunk getCommitterHtml(@Nullable VcsUser committer, @Nullable Long commitTime) {
        String committed;
        if (committer == null && commitTime == null) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                CommitPresentationUtil.$$$reportNull$$$0(27);
            }
            return htmlChunk;
        }
        String style = "color:#" + ColorUtil.toHex((Color)JBColor.GRAY);
        HtmlChunk.Element graySpan = HtmlChunk.span((String)style);
        if (committer == null) {
            String date = DateFormatUtil.formatDate((long)commitTime);
            String time = DateFormatUtil.formatTime((long)commitTime);
            committed = VcsLogBundle.message((String)"vcs.log.details.committer.info.date.time", (Object[])new Object[]{date, time});
        } else {
            String by = VcsUserUtil.getShortPresentation(committer) + (String)(!committer.getEmail().isEmpty() ? "</span> " + CommitPresentationUtil.getEmailLink(committer) + "<span style=\"" + style + "\">" : "");
            if (commitTime == null) {
                committed = VcsLogBundle.message((String)"vcs.log.details.committer.info.user", (Object[])new Object[]{by});
            } else {
                String date = DateFormatUtil.formatDate((long)commitTime);
                String time = DateFormatUtil.formatTime((long)commitTime);
                committed = VcsLogBundle.message((String)"vcs.log.details.committer.info.user.date.time", (Object[])new Object[]{by, date, time});
            }
        }
        HtmlChunk.Element element2 = new HtmlBuilder().appendRaw(committed).wrapWith(graySpan);
        if (element2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(28);
        }
        return element2;
    }

    @NotNull
    @NlsSafe
    private static String getAuthorName(@NotNull VcsUser user) {
        if (user == null) {
            CommitPresentationUtil.$$$reportNull$$$0(29);
        }
        String username = VcsUserUtil.getShortPresentation(user);
        Object object = user.getEmail().isEmpty() ? username : username + " " + CommitPresentationUtil.getEmailLink(user);
        if (object == null) {
            CommitPresentationUtil.$$$reportNull$$$0(30);
        }
        return object;
    }

    @NotNull
    private static HtmlChunk.Element getEmailLink(@NotNull VcsUser user) {
        if (user == null) {
            CommitPresentationUtil.$$$reportNull$$$0(31);
        }
        HtmlChunk.Element element2 = HtmlChunk.link((String)("mailto:" + user.getEmail()), (String)("<" + user.getEmail() + ">"));
        if (element2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(32);
        }
        return element2;
    }

    @NotNull
    @Nls
    private static String formatCommitHashAndAuthor(@NotNull VcsCommitMetadata commit2) {
        if (commit2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(33);
        }
        return CommitPresentationUtil.formatCommitHashAndAuthor((Hash)commit2.getId(), commit2.getAuthor(), commit2.getAuthorTime(), commit2.getCommitter(), commit2.getCommitTime());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @Nls
    public static String formatCommitHashAndAuthor(@NotNull Hash commitId, @NotNull VcsUser author, long authorTime, @NotNull VcsUser committer, long l) {
        void commitTime;
        if (commitId == null) {
            CommitPresentationUtil.$$$reportNull$$$0(34);
        }
        if (author == null) {
            CommitPresentationUtil.$$$reportNull$$$0(35);
        }
        if (committer == null) {
            CommitPresentationUtil.$$$reportNull$$$0(36);
        }
        Font font = FontUtil.getCommitMetadataFont();
        String string = FontUtil.getHtmlWithFonts(commitId.toShortString() + " " + CommitPresentationUtil.getAuthorAndCommitterText(author, authorTime, committer, (long)commitTime), font.getStyle(), font);
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    @Nls
    public static String getBranchesText(@Nullable List<@NlsSafe String> branches, boolean expanded, int availableWidth, @NotNull FontMetrics metrics) {
        if (metrics == null) {
            CommitPresentationUtil.$$$reportNull$$$0(38);
        }
        if (branches == null) {
            String string = VcsLogBundle.message((String)"vcs.log.details.in.branches.loading", (Object[])new Object[0]);
            if (string == null) {
                CommitPresentationUtil.$$$reportNull$$$0(39);
            }
            return string;
        }
        if (branches.isEmpty()) {
            String string = VcsLogBundle.message((String)"vcs.log.details.in.branches.empty", (Object[])new Object[0]);
            if (string == null) {
                CommitPresentationUtil.$$$reportNull$$$0(40);
            }
            return string;
        }
        String head = VcsLogBundle.message((String)"vcs.log.details.in.branches", (Object[])new Object[]{branches.size()}) + " ";
        if (expanded) {
            String string = new HtmlBuilder().append(head).append((HtmlChunk)HtmlChunk.link((String)SHOW_HIDE_BRANCHES, (String)VcsLogBundle.message((String)"vcs.log.details.in.branches.hide", (Object[])new Object[0]))).br().appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)ContainerUtil.map(branches, s -> HtmlChunk.text((String)s))).toString();
            if (string == null) {
                CommitPresentationUtil.$$$reportNull$$$0(41);
            }
            return string;
        }
        String tail = "\u2026 " + HtmlChunk.link((String)SHOW_HIDE_BRANCHES, (String)VcsLogBundle.message((String)"vcs.log.details.in.branches.show.all", (Object[])new Object[0]));
        int headAndTailWidth = metrics.stringWidth(head) + metrics.stringWidth(StringUtil.removeHtmlTags((String)tail));
        if (availableWidth <= headAndTailWidth) {
            String string = head + tail;
            if (string == null) {
                CommitPresentationUtil.$$$reportNull$$$0(42);
            }
            return string;
        }
        availableWidth -= headAndTailWidth;
        StringBuilder branchesText = new StringBuilder();
        for (int i2 = 0; i2 < branches.size(); ++i2) {
            String branch = branches.get(i2) + (i2 != branches.size() - 1 ? ", " : "");
            int branchWidth = metrics.stringWidth(branch);
            if (branchWidth < availableWidth) {
                branchesText.append(branch);
                availableWidth -= branchWidth;
                continue;
            }
            StringBuilder shortenedBranch = new StringBuilder();
            for (char c : branch.toCharArray()) {
                if (metrics.stringWidth(shortenedBranch.toString() + c) >= availableWidth) break;
                shortenedBranch.append(c);
            }
            branchesText.append((CharSequence)shortenedBranch);
            branchesText.append(tail);
            break;
        }
        String string = head + branchesText;
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    public static CommitPresentation buildPresentation(@NotNull Project project, @NotNull VcsCommitMetadata commit2, @NotNull Set<? super String> unresolvedHashes) {
        if (project == null) {
            CommitPresentationUtil.$$$reportNull$$$0(44);
        }
        if (commit2 == null) {
            CommitPresentationUtil.$$$reportNull$$$0(45);
        }
        if (unresolvedHashes == null) {
            CommitPresentationUtil.$$$reportNull$$$0(46);
        }
        String rawMessage = commit2.getFullMessage();
        String hashAndAuthor = CommitPresentationUtil.formatCommitHashAndAuthor(commit2);
        Set<String> unresolvedHashesForCommit = CommitPresentationUtil.findHashes(project, rawMessage);
        if (unresolvedHashesForCommit.isEmpty()) {
            return new CommitPresentation(project, commit2.getRoot(), rawMessage, hashAndAuthor, (MultiMap<String, CommitId>)MultiMap.empty());
        }
        unresolvedHashes.addAll(unresolvedHashesForCommit);
        return new UnresolvedPresentation(project, commit2.getRoot(), rawMessage, hashAndAuthor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil";
                break;
            }
            case 4: 
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedHashes";
                break;
            }
            case 11: 
            case 14: 
            case 18: 
            case 19: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullMessage";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 24: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "author";
                break;
            }
            case 25: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "committer";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 33: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unresolvedHashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeMultipleSpaces";
                break;
            }
            case 7: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findHashes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceHashes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCommitText";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "formatText";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorAndCommitterText";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitterHtml";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmailLink";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCommitHashAndAuthor";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchesText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isShowHideBranches";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isGoToHash";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAuthorPresentation";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapeMultipleSpaces";
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findHashes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replaceHashes";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "formatCommitText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSubjectMarginEnabled";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "formatText";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAuthorAndCommitterText";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAuthorName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getEmailLink";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "formatCommitHashAndAuthor";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getBranchesText";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "buildPresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CommitPresentation {
        @NotNull
        protected final Project myProject;
        @NotNull
        @NlsSafe
        protected final String myRawMessage;
        @NotNull
        @Nls
        protected final String myHashAndAuthor;
        @NotNull
        protected final VirtualFile myRoot;
        private final @NotNull MultiMap<@NlsSafe String, CommitId> myResolvedHashes;

        public CommitPresentation(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NlsSafe String rawMessage, @NotNull @Nls String hashAndAuthor, @NotNull MultiMap<@NlsSafe String, CommitId> resolvedHashes) {
            if (project == null) {
                CommitPresentation.$$$reportNull$$$0(0);
            }
            if (root == null) {
                CommitPresentation.$$$reportNull$$$0(1);
            }
            if (rawMessage == null) {
                CommitPresentation.$$$reportNull$$$0(2);
            }
            if (hashAndAuthor == null) {
                CommitPresentation.$$$reportNull$$$0(3);
            }
            if (resolvedHashes == null) {
                CommitPresentation.$$$reportNull$$$0(4);
            }
            this.myProject = project;
            this.myRoot = root;
            this.myRawMessage = rawMessage;
            this.myHashAndAuthor = hashAndAuthor;
            this.myResolvedHashes = resolvedHashes;
        }

        @NotNull
        @NlsSafe
        public String getText() {
            String string = CommitPresentationUtil.formatCommitText(this.myProject, this.myRawMessage, this.myResolvedHashes.keySet());
            if (string == null) {
                CommitPresentation.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        @Nls
        public String getHashAndAuthor() {
            String string = this.myHashAndAuthor;
            if (string == null) {
                CommitPresentation.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Nullable
        public CommitId parseTargetCommit(@NotNull HyperlinkEvent e) {
            if (e == null) {
                CommitPresentation.$$$reportNull$$$0(7);
            }
            if (!e.getDescription().startsWith(CommitPresentationUtil.GO_TO_HASH)) {
                return null;
            }
            String hash = e.getDescription().substring(CommitPresentationUtil.GO_TO_HASH.length());
            Collection ids = this.myResolvedHashes.get((Object)hash);
            if (ids.size() <= 1) {
                return (CommitId)ContainerUtil.getFirstItem((Collection)ids);
            }
            for (CommitId id2 : ids) {
                if (!this.myRoot.equals(id2.getRoot())) continue;
                return id2;
            }
            return (CommitId)ContainerUtil.getFirstItem((Collection)ids);
        }

        @NotNull
        public CommitPresentation resolve(@NotNull MultiMap<String, CommitId> resolvedHashes) {
            if (resolvedHashes == null) {
                CommitPresentation.$$$reportNull$$$0(8);
            }
            CommitPresentation commitPresentation = this;
            if (commitPresentation == null) {
                CommitPresentation.$$$reportNull$$$0(9);
            }
            return commitPresentation;
        }

        public boolean isResolved() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rawMessage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hashAndAuthor";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedHashes";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil$CommitPresentation";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil$CommitPresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHashAndAuthor";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "parseTargetCommit";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UnresolvedPresentation
    extends CommitPresentation {
        UnresolvedPresentation(@NotNull Project project, @NotNull VirtualFile root, @NotNull @NlsSafe String rawMessage, @NotNull @Nls String hashAndAuthor) {
            if (project == null) {
                UnresolvedPresentation.$$$reportNull$$$0(0);
            }
            if (root == null) {
                UnresolvedPresentation.$$$reportNull$$$0(1);
            }
            if (rawMessage == null) {
                UnresolvedPresentation.$$$reportNull$$$0(2);
            }
            if (hashAndAuthor == null) {
                UnresolvedPresentation.$$$reportNull$$$0(3);
            }
            super(project, root, rawMessage, hashAndAuthor, (MultiMap<String, CommitId>)MultiMap.empty());
        }

        @Override
        @NotNull
        public CommitPresentation resolve(@NotNull MultiMap<String, CommitId> resolvedHashes) {
            if (resolvedHashes == null) {
                UnresolvedPresentation.$$$reportNull$$$0(4);
            }
            return new CommitPresentation(this.myProject, this.myRoot, this.myRawMessage, this.myHashAndAuthor, resolvedHashes);
        }

        @Override
        public boolean isResolved() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rawMessage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hashAndAuthor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedHashes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil$UnresolvedPresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolve";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

