/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.workspaceModel.storage.PersistentEntityId;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityWithPersistentId;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.ClassConversion;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverter;
import com.intellij.workspaceModel.storage.impl.EntitiesKt;
import com.intellij.workspaceModel.storage.impl.EntityFamily;
import com.intellij.workspaceModel.storage.impl.WithAssertableConsistency;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageImpl;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001b\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\u0006\u0010\u0010\u001a\u00020\u000fR\"\u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00050\u0004X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/workspaceModel/storage/impl/EntitiesBarrel;", "", "()V", "entityFamilies", "", "Lcom/intellij/workspaceModel/storage/impl/EntityFamily;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "getEntityFamilies$intellij_platform_workspaceModel_storage", "()Ljava/util/List;", "assertConsistency", "", "abstractEntityStorage", "Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "get", "clazz", "", "size", "Lcom/intellij/workspaceModel/storage/impl/ImmutableEntitiesBarrel;", "Lcom/intellij/workspaceModel/storage/impl/MutableEntitiesBarrel;", "intellij.platform.workspaceModel.storage"})
public abstract class EntitiesBarrel {
    @NotNull
    public abstract List<EntityFamily<? extends WorkspaceEntity>> getEntityFamilies$intellij_platform_workspaceModel_storage();

    @Nullable
    public EntityFamily<? extends WorkspaceEntity> get(int clazz) {
        return (EntityFamily)CollectionsKt.getOrNull(this.getEntityFamilies$intellij_platform_workspaceModel_storage(), (int)clazz);
    }

    public final int size() {
        return this.getEntityFamilies$intellij_platform_workspaceModel_storage().size();
    }

    /*
     * WARNING - void declaration
     */
    public final void assertConsistency(@NotNull AbstractEntityStorage abstractEntityStorage) {
        Intrinsics.checkNotNullParameter((Object)abstractEntityStorage, (String)"abstractEntityStorage");
        HashSet persistentIds = new HashSet();
        Iterable $this$forEachIndexed$iv = this.getEntityFamilies$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void this_$iv;
            void family;
            Class<?> clazz;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            EntityFamily entityFamily = (EntityFamily)item$iv;
            int i2 = n;
            boolean bl2 = false;
            int $this$findEntityClass$iv = i2;
            boolean $i$f$findEntityClass = false;
            if (ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv) == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
            }
            boolean hasPersistentId = WorkspaceEntityWithPersistentId.class.isAssignableFrom(clazz);
            if (family == null) continue;
            boolean $i$f$assertConsistency = false;
            Iterable $this$forEachIndexed$iv$iv = this_$iv.getEntities$intellij_platform_workspaceModel_storage();
            boolean $i$f$forEachIndexed2 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                void entity$iv;
                int n2 = index$iv$iv++;
                boolean bl3 = false;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)item$iv$iv;
                int idx$iv = n2;
                boolean bl4 = false;
                if (entity$iv == null) continue;
                boolean bl5 = idx$iv == entity$iv.getId();
                boolean bl6 = false;
                if (_Assertions.ENABLED && !bl5) {
                    boolean bl7 = false;
                    String string = "Entity with id " + entity$iv.getId() + " is placed at index " + idx$iv;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                void entityData = entity$iv;
                boolean bl8 = false;
                Class immutableClass = ClassConversion.INSTANCE.entityDataToEntity(entityData.getClass());
                boolean bl9 = Intrinsics.areEqual(clazz, immutableClass);
                boolean bl10 = false;
                if (_Assertions.ENABLED && !bl9) {
                    boolean bl11 = false;
                    String string = StringsKt.trimMargin$default((String)("EntityFamily contains entity data of wrong type:\n            | - EntityFamily class:   " + clazz + "\n            | - entityData class:     " + immutableClass + "\n          "), null, (int)1, null);
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                if (hasPersistentId) {
                    PersistentEntityId<?> persistentId = EntitiesKt.persistentId(entityData, WorkspaceEntityStorageImpl.Companion.getEMPTY());
                    bl10 = persistentId != null;
                    boolean bl12 = false;
                    if (_Assertions.ENABLED && !bl10) {
                        boolean $i$a$-assert-EntitiesBarrel$assertConsistency$1$1$42 = false;
                        String $i$a$-assert-EntitiesBarrel$assertConsistency$1$1$42 = "Persistent id expected for " + clazz;
                        throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-EntitiesBarrel$assertConsistency$1$1$42));
                    }
                    bl10 = !CollectionsKt.contains((Iterable)persistentIds, persistentId);
                    bl12 = false;
                    if (_Assertions.ENABLED && !bl10) {
                        boolean bl13 = false;
                        String string = "Duplicated persistent ids: " + persistentId;
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    PersistentEntityId<?> persistentEntityId = persistentId;
                    Intrinsics.checkNotNull(persistentEntityId);
                    persistentIds.add(persistentEntityId);
                }
                if (!(entityData instanceof WithAssertableConsistency)) continue;
                ((WithAssertableConsistency)entityData).assertConsistency(abstractEntityStorage);
            }
            EntityFamily.access$familyCheck((EntityFamily)this_$iv);
        }
    }

    private EntitiesBarrel() {
    }

    public /* synthetic */ EntitiesBarrel(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

