/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.inline.InlineDebugRenderer;
import com.intellij.xdebugger.impl.inline.InlineWatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import org.jetbrains.annotations.NotNull;

public final class XDebuggerInlayUtil {
    public static final String INLINE_HINTS_DELIMETER = ":";

    public static boolean createLineEndInlay(final XValueNodeImpl valueNode, @NotNull XDebugSession session2, @NotNull VirtualFile file2, @NotNull XSourcePosition position, Document document) {
        if (session2 == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(1);
        }
        if (position == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(2);
        }
        if (valueNode.getValuePresentation() != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                int offset = document.getLineEndOffset(position.getLine());
                Project project = session2.getProject();
                FileEditor editor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file2);
                if (editor instanceof TextEditor) {
                    Editor e = ((TextEditor)editor).getEditor();
                    boolean customNode = valueNode instanceof InlineWatchNodeImpl;
                    final InlineDebugRenderer renderer2 = new InlineDebugRenderer(valueNode, position, session2, e);
                    final Inlay inlay = e.getInlayModel().addAfterLineEndElement(offset, new InlayProperties().disableSoftWrapping(true).priority(customNode ? 0 : -1), (EditorCustomElementRenderer)renderer2);
                    XDebuggerTreeListener loadListener = new XDebuggerTreeListener(){

                        @Override
                        public void nodeLoaded(@NotNull RestorableStateNode node2, @NotNull String name) {
                            if (node2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (name == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (node2 == valueNode) {
                                renderer2.updatePresentation();
                                inlay.update();
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "node";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "name";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/xdebugger/impl/inline/XDebuggerInlayUtil$1";
                            objectArray[2] = "nodeLoaded";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    XDebuggerTree tree = valueNode.getTree();
                    tree.addTreeListener(loadListener);
                    Disposer.register((Disposable)inlay, () -> tree.removeTreeListener(loadListener));
                    if (customNode) {
                        ((InlineWatchNodeImpl)valueNode).inlayCreated((Inlay<InlineDebugRenderer>)inlay);
                    }
                }
            }, session2.getProject().getDisposed());
            return true;
        }
        return false;
    }

    public static void clearInlays(@NotNull Project project) {
        if (project == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            FileEditor[] editors2;
            for (FileEditor editor : editors2 = FileEditorManager.getInstance((Project)project).getAllEditors()) {
                if (!(editor instanceof TextEditor)) continue;
                Editor e = ((TextEditor)editor).getEditor();
                e.getInlayModel().getAfterLineEndElementsInRange(0, e.getDocument().getTextLength(), InlineDebugRenderer.class).forEach(Disposer::dispose);
            }
        }, project.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/inline/XDebuggerInlayUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLineEndInlay";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "clearInlays";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

