/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.util.XmlUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;

final class EscapeEntitiesAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler {
    EscapeEntitiesAction() {
    }

    private static String escape(XmlFile file2, Int2ObjectMap<String> map2, String text2, int start2) {
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            String escape;
            char c = text2.charAt(i2);
            PsiElement element2 = file2.findElementAt(start2 + i2);
            if (element2 != null && EscapeEntitiesAction.isCharacterElement(element2) && (c == '<' || c == '>' || c == '&' || c == '\"' || c == '\'' || c > '\u007f') && (escape = (String)map2.get((int)c)) != null) {
                result2.append("&").append(escape).append(";");
                continue;
            }
            result2.append(c);
        }
        return result2.toString();
    }

    @NotNull
    private static Int2ObjectMap<String> computeMap(XmlFile xmlFile) {
        XmlFile file2 = XmlUtil.findXmlFile((PsiFile)xmlFile, Html5SchemaProvider.getCharsDtdLocation());
        assert (file2 != null);
        Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap();
        XmlUtil.processXmlElements((XmlElement)file2, (PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)arg_0 -> EscapeEntitiesAction.lambda$computeMap$0((Int2ObjectMap)result2, arg_0)), true);
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = result2;
        if (int2ObjectOpenHashMap == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(0);
        }
        return int2ObjectOpenHashMap;
    }

    private static boolean isCharacterElement(PsiElement element2) {
        IElementType type = element2.getNode().getElementType();
        if (type == XmlTokenType.XML_DATA_CHARACTERS) {
            return true;
        }
        if (type == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && element2.getParent().getParent() instanceof XmlAttribute) {
            return true;
        }
        if (type == XmlTokenType.XML_BAD_CHARACTER) {
            return true;
        }
        if (type == XmlTokenType.XML_START_TAG_START) {
            if (element2.getNextSibling() instanceof PsiErrorElement) {
                return true;
            }
            if (element2.getParent() instanceof PsiErrorElement) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(3);
        }
        return file2 instanceof XmlFile;
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        EscapeEntitiesAction escapeEntitiesAction = this;
        if (escapeEntitiesAction == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(4);
        }
        return escapeEntitiesAction;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(7);
        }
        int[] starts = editor.getSelectionModel().getBlockSelectionStarts();
        int[] ends = editor.getSelectionModel().getBlockSelectionEnds();
        Document document = editor.getDocument();
        XmlFile xmlFile = (XmlFile)file2;
        Int2ObjectMap<String> map2 = EscapeEntitiesAction.computeMap(xmlFile);
        for (int i2 = starts.length - 1; i2 >= 0; --i2) {
            String newText;
            int start2 = starts[i2];
            int end = ends[i2];
            String oldText = document.getText(new TextRange(start2, end));
            if (oldText.equals(newText = EscapeEntitiesAction.escape(xmlFile, map2, oldText, start2))) continue;
            document.replaceString(start2, end, (CharSequence)newText);
        }
    }

    private static /* synthetic */ boolean lambda$computeMap$0(Int2ObjectMap result2, PsiElement element2) {
        String value2;
        int key;
        if (element2 instanceof XmlEntityDecl && !result2.containsKey(key = Integer.parseInt((value2 = ((XmlEntityDecl)element2).getValueElement().getValue()).substring(2, value2.length() - 1)))) {
            result2.put(key, (Object)((XmlEntityDecl)element2).getName());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/actions/EscapeEntitiesAction";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMap";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/actions/EscapeEntitiesAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

