/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class XmlSchemaTagsProcessor {
    public static final ThreadLocal<Boolean> PROCESSING_FLAG = new ThreadLocal();
    private final Set<XmlTag> myVisited = new HashSet<XmlTag>();
    protected final XmlNSDescriptorImpl myNsDescriptor;
    private final String[] myTagsToIgnore;

    public XmlSchemaTagsProcessor(XmlNSDescriptorImpl nsDescriptor, String ... tagsToIgnore) {
        this.myNsDescriptor = nsDescriptor;
        this.myTagsToIgnore = (String[])ArrayUtil.append((Object[])tagsToIgnore, (Object)"annotation");
    }

    public final void startProcessing(XmlTag tag2) {
        try {
            PROCESSING_FLAG.set(Boolean.TRUE);
            this.processTag(tag2, null);
        }
        finally {
            PROCESSING_FLAG.set(null);
        }
    }

    private void processTag(XmlTag tag2, @Nullable XmlTag context2) {
        if (this.myVisited.contains(tag2)) {
            return;
        }
        this.myVisited.add(tag2);
        if (!XmlNSDescriptorImpl.checkSchemaNamespace(tag2)) {
            this.processTagWithSubTags(tag2, context2, null);
            return;
        }
        String tagName = tag2.getLocalName();
        if (XmlSchemaTagsProcessor.checkTagName(tagName, "element", "attribute")) {
            XmlAttribute ref = tag2.getAttribute("ref");
            if (ref != null) {
                XmlTag resolved2 = XmlSchemaTagsProcessor.resolveTagReference(ref);
                if (resolved2 != null) {
                    this.tagStarted(resolved2, resolved2.getLocalName(), tag2, tag2);
                }
            } else {
                this.tagStarted(tag2, tag2.getLocalName(), context2, null);
            }
        } else if (XmlSchemaTagsProcessor.checkTagName(tagName, "group")) {
            String value2 = tag2.getAttributeValue("ref");
            if (value2 != null) {
                XmlTag group2 = this.myNsDescriptor.findGroup(value2);
                if (group2 == null) {
                    group2 = XmlSchemaTagsProcessor.resolveTagReference(tag2.getAttribute("ref"));
                }
                this.processTagWithSubTags(group2, tag2, tag2);
            }
        } else if (XmlSchemaTagsProcessor.checkTagName(tagName, "attributeGroup")) {
            XmlTag group3;
            String ref = tag2.getAttributeValue("ref");
            if (ref == null) {
                return;
            }
            XmlTag parentTag = tag2.getParentTag();
            assert (parentTag != null);
            if (XmlNSDescriptorImpl.equalsToSchemaName(parentTag, "attributeGroup") && ref.equals(parentTag.getAttributeValue("name"))) {
                group3 = XmlSchemaTagsProcessor.resolveTagReference(tag2.getAttribute("ref"));
                if (group3 == null) {
                    group3 = this.myNsDescriptor.findAttributeGroup(ref);
                }
            } else {
                group3 = this.myNsDescriptor.findAttributeGroup(ref);
                if (group3 == null) {
                    group3 = XmlSchemaTagsProcessor.resolveTagReference(tag2.getAttribute("ref"));
                }
            }
            this.processTagWithSubTags(group3, tag2, null);
        } else if (XmlSchemaTagsProcessor.checkTagName(tagName, "restriction", "extension")) {
            this.processTagWithSubTags(XmlSchemaTagsProcessor.resolveTagReference(tag2.getAttribute("base")), tag2, null);
            this.processTagWithSubTags(tag2, context2, null);
        } else if (!XmlSchemaTagsProcessor.checkTagName(tagName, this.myTagsToIgnore)) {
            this.processTagWithSubTags(tag2, context2, null);
        }
    }

    private void processTagWithSubTags(@Nullable XmlTag tag2, XmlTag ctx, @Nullable XmlTag ref) {
        XmlTag[] subTags;
        if (tag2 == null) {
            return;
        }
        this.tagStarted(tag2, tag2.getLocalName(), ctx, ref);
        for (XmlTag subTag : subTags = tag2.getSubTags()) {
            this.processTag(subTag, tag2);
        }
        this.tagFinished(tag2);
    }

    protected abstract void tagStarted(XmlTag var1, String var2, XmlTag var3, @Nullable XmlTag var4);

    protected void tagFinished(XmlTag tag2) {
    }

    @Nullable
    public static XmlTag resolveTagReference(@Nullable XmlAttribute ref) {
        PsiElement element2 = XmlSchemaTagsProcessor.resolveReference(ref);
        return element2 instanceof XmlTag ? (XmlTag)element2 : null;
    }

    @Nullable
    static PsiElement resolveReference(@Nullable XmlAttribute ref) {
        PsiReference[] references;
        XmlAttributeValue value2;
        if (ref != null && (value2 = ref.getValueElement()) != null && (references = value2.getReferences()).length > 0) {
            return references[0].resolve();
        }
        return null;
    }

    protected static boolean checkTagName(String tagName, String ... names2) {
        return ArrayUtil.contains((String)tagName, (String[])names2);
    }
}

