/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.paths.DynamicContextProvider;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.xml.util.AnchorReferenceImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnchorPathReferenceProvider
implements PathReferenceProvider {
    public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
        String anchor2;
        if (psiElement == null) {
            AnchorPathReferenceProvider.$$$reportNull$$$0(0);
        }
        if (references == null) {
            AnchorPathReferenceProvider.$$$reportNull$$$0(1);
        }
        TextRange range2 = ElementManipulators.getValueTextRange((PsiElement)psiElement);
        String elementText = psiElement.getText();
        int anchorOffset = elementText.indexOf(35);
        if (anchorOffset == -1) {
            return false;
        }
        boolean dynamic = AnchorPathReferenceProvider.isDynamic(psiElement, anchorOffset + 1, elementText);
        if (dynamic) {
            return false;
        }
        FileReference fileReference = null;
        if (range2.getStartOffset() != anchorOffset && ((fileReference = AnchorPathReferenceProvider.findFileReference(references)) == null || fileReference.resolve() == null)) {
            return false;
        }
        int pos = elementText.indexOf(63, anchorOffset);
        try {
            int endIndex;
            int n = endIndex = pos != -1 ? pos : range2.getEndOffset();
            if (endIndex <= anchorOffset) {
                endIndex = anchorOffset + 1;
            }
            anchor2 = elementText.substring(anchorOffset + 1, endIndex);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new RuntimeException(elementText, e);
        }
        AnchorReferenceImpl anchorReference = new AnchorReferenceImpl(anchor2, fileReference, psiElement, anchorOffset + 1, soft);
        references.add(anchorReference);
        return false;
    }

    private static boolean isDynamic(PsiElement psiElement, int offset, String elementText) {
        for (DynamicContextProvider provider2 : DynamicContextProvider.EP_NAME.getExtensionList()) {
            int dynamicOffset = provider2.getOffset(psiElement, offset, elementText);
            if (dynamicOffset == offset) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static FileReference findFileReference(List<? extends PsiReference> references) {
        FileReference fileReference = null;
        for (PsiReference psiReference : references) {
            if (!(psiReference instanceof FileReference)) continue;
            fileReference = ((FileReference)psiReference).getFileReferenceSet().getLastReference();
            break;
        }
        return fileReference;
    }

    public PathReference getPathReference(@NotNull String path2, @NotNull PsiElement element2) {
        if (path2 == null) {
            AnchorPathReferenceProvider.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            AnchorPathReferenceProvider.$$$reportNull$$$0(3);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/util/AnchorPathReferenceProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferences";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

