/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public final class HTMLControls {
    private static final Logger LOG = Logger.getInstance(HTMLControls.class);
    private static Control[] ourControls;

    public static Control[] getControls() {
        if (ourControls == null) {
            ourControls = HTMLControls.loadControls();
        }
        return ourControls;
    }

    private static Control[] loadControls() {
        Element element2;
        try {
            byte[] bytes;
            try (InputStream stream = HTMLControls.class.getResourceAsStream("HtmlControls.xml");){
                bytes = FileUtilRt.loadBytes((InputStream)stream);
            }
            try (UnsyncByteArrayInputStream bytesStream = new UnsyncByteArrayInputStream(bytes);){
                element2 = JDOMUtil.load((InputStream)CharsetToolkit.inputStreamSkippingBOM((InputStream)bytesStream));
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return new Control[0];
        }
        if (!element2.getName().equals("htmlControls")) {
            LOG.error("HTMLControls storage is broken");
            return new Control[0];
        }
        return HTMLControls.deserialize(element2);
    }

    private static Control[] deserialize(Element element2) {
        ArrayList<Control> controls = new ArrayList<Control>();
        for (Element child2 : element2.getChildren()) {
            if (!"control".equals(child2.getName())) continue;
            Control control2 = new Control(child2.getAttributeValue("name"), TagState.valueOf(StringUtil.toUpperCase((String)child2.getAttributeValue("startTag"))), TagState.valueOf(StringUtil.toUpperCase((String)child2.getAttributeValue("endTag"))), "true".equalsIgnoreCase(child2.getAttributeValue("emptyAllowed")), HTMLControls.autoClosed(child2.getAttributeValue("autoClosedBy")));
            controls.add(control2);
        }
        return controls.toArray(new Control[0]);
    }

    private static Set<String> autoClosed(@Nullable String value2) {
        if (value2 == null) {
            return Collections.emptySet();
        }
        HashSet<String> result2 = new HashSet<String>();
        for (String closingTag : StringUtil.split((String)value2, (String)",")) {
            result2.add(StringUtil.toLowerCase((String)closingTag.trim()));
        }
        return result2;
    }

    public static class Control {
        public final String name;
        public final TagState startTag;
        public final TagState endTag;
        public final boolean emptyAllowed;
        public final Set<String> autoClosedBy;

        public Control(String name, TagState startTag, TagState endTag, boolean emptyAllowed, Set<String> autoClosedBy) {
            this.name = name;
            this.endTag = endTag;
            this.startTag = startTag;
            this.emptyAllowed = emptyAllowed;
            this.autoClosedBy = autoClosedBy;
        }
    }

    public static enum TagState {
        REQUIRED,
        OPTIONAL,
        FORBIDDEN;

    }
}

