/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.UriUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xml.actions.validate.ErrorReporter;
import com.intellij.xml.actions.validate.ValidateXmlActionHandler;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.psi.XmlPsiBundle;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlResourceResolver
implements XMLEntityResolver {
    private static final Logger LOG = Logger.getInstance(XmlResourceResolver.class);
    private final XmlFile myFile;
    private final Project myProject;
    private final Map<String, String> myExternalResourcesMap = new HashMap<String, String>(1);
    private boolean myStopOnUnDeclaredResource;
    @NonNls
    public static final String HONOUR_ALL_SCHEMA_LOCATIONS_PROPERTY_KEY = "idea.xml.honour.all.schema.locations";
    private final ErrorReporter myErrorReporter;

    public XmlResourceResolver(XmlFile _xmlFile, Project _project, ErrorReporter errorReporter) {
        this.myFile = _xmlFile;
        this.myProject = _project;
        this.myErrorReporter = errorReporter;
    }

    public String getPathByPublicId(String baseId) {
        return this.myExternalResourcesMap.get(baseId);
    }

    public String[] getResourcePaths() {
        return ArrayUtilRt.toStringArray(this.myExternalResourcesMap.values());
    }

    @Nullable
    public PsiFile resolve(@Nullable String baseSystemId, String _systemId) {
        VirtualFile file2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: resolveEntity(baseSystemId='" + baseSystemId + "' systemId='" + _systemId + "," + this + "')");
        }
        if (_systemId == null) {
            return null;
        }
        if (this.myStopOnUnDeclaredResource && ExternalResourceManagerEx.getInstanceEx().isIgnoredResource(_systemId)) {
            throw new IgnoredResourceException();
        }
        int length = XmlUtil.getPrefixLength(_systemId);
        String systemId2 = _systemId.substring(length);
        Computable action2 = () -> {
            XmlFile file2;
            String resource;
            XmlTag rootTag;
            PsiFile baseFile = null;
            if (baseSystemId != null) {
                baseFile = this.getBaseFile(baseSystemId);
            }
            if (baseFile == null) {
                baseFile = this.myFile;
            }
            String version2 = null;
            String tagName = null;
            if (baseFile == this.myFile && (rootTag = this.myFile.getRootTag()) != null) {
                tagName = rootTag.getLocalName();
                version2 = rootTag.getAttributeValue("version");
            }
            if ((resource = ((ExternalResourceManagerEx)ExternalResourceManager.getInstance()).getUserResource(this.myProject, systemId2, version2)) != null && (file2 = XmlUtil.findXmlFile((PsiFile)this.myFile, resource)) != null) {
                return file2;
            }
            PsiFile byLocation = XmlResourceResolver.resolveByLocation((PsiFile)this.myFile, systemId2);
            if (byLocation != null) {
                return byLocation;
            }
            PsiFile psiFile = ExternalResourceManager.getInstance().getResourceLocation(systemId2, baseFile, version2);
            if (psiFile == null) {
                psiFile = XmlUtil.findXmlFile(baseFile, systemId2);
            }
            if (psiFile == null && (psiFile = XmlNamespaceIndex.guessSchema(systemId2, tagName, version2, null, (PsiFile)this.myFile)) == null) {
                psiFile = XmlNamespaceIndex.guessDtd(systemId2, (PsiFile)this.myFile);
            }
            if (psiFile == null && baseSystemId != null) {
                String fullUrl = baseSystemId.substring(0, baseSystemId.lastIndexOf(47) + 1) + systemId2;
                psiFile = XmlUtil.findXmlFile(baseFile, fullUrl);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("before relative file checking:" + psiFile + "," + systemId2 + "," + baseSystemId + ")");
            }
            if (psiFile == null && baseSystemId == null) {
                VirtualFile file3;
                String res2;
                File workingFile = new File("");
                String workingDir = workingFile.getAbsoluteFile().getAbsolutePath().replace(File.separatorChar, '/') + "/";
                String relativePath = StringUtil.replace((String)systemId2, (String)workingDir, (String)"");
                if (relativePath.equals(systemId2)) {
                    relativePath = systemId2.substring(systemId2.lastIndexOf(47) + 1);
                }
                if ((res2 = this.myExternalResourcesMap.get(relativePath)) != null && (file3 = VirtualFileManager.getInstance().findFileByUrl(res2)) != null && (psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file3)) != null) {
                    return psiFile;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("next to relative file checking:" + relativePath + "," + this.myExternalResourcesMap.size() + ")");
                }
                for (String path2 : this.getResourcePaths()) {
                    VirtualFile file4;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Finding file by url:" + path2);
                    }
                    if ((file4 = VirtualFileManager.getInstance().findFileByUrl(path2)) == null) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Finding " + relativePath + " relative to:" + file4.getPath());
                    }
                    VirtualFile relativeFile = UriUtil.findRelativeFile((String)relativePath, (VirtualFile)file4);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found " + (relativeFile != null ? relativeFile.getPath() : "null"));
                    }
                    if (relativeFile != null && (psiFile = PsiManager.getInstance((Project)this.myProject).findFile(relativeFile)) != null) break;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("resolveEntity: psiFile='" + (psiFile != null ? psiFile.getVirtualFile() : null) + "'");
            }
            return psiFile;
        };
        PsiFile psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction(action2);
        if (psiFile != null && (file2 = psiFile.getVirtualFile()) != null) {
            String url = file2.getUrl();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding external resource ref:" + systemId2 + "," + url + "," + this);
            }
            this.myExternalResourcesMap.put(systemId2, url);
        }
        return psiFile;
    }

    private PsiFile getBaseFile(String baseSystemId) {
        PsiFile baseFile = this.resolve(null, baseSystemId);
        if (baseFile != null) {
            return baseFile;
        }
        File workingFile = new File("");
        String workingDir = workingFile.getAbsoluteFile().getAbsolutePath().replace(File.separatorChar, '/');
        VirtualFile parent = this.myFile.getVirtualFile().getParent();
        if (parent == null) {
            return null;
        }
        String id2 = StringUtil.replace((String)baseSystemId, (String)workingDir, (String)parent.getPath());
        VirtualFile vFile = UriUtil.findRelative((String)id2, (PsiFileSystemItem)this.myFile);
        if (vFile == null) {
            vFile = UriUtil.findRelative((String)baseSystemId, (PsiFileSystemItem)this.myFile);
        }
        if (vFile == null) {
            try {
                vFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.convertFromUrl((URL)new URL(baseSystemId)));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (vFile != null && !vFile.isDirectory() && !(vFile.getFileSystem() instanceof HttpFileSystem)) {
            baseFile = PsiManager.getInstance((Project)this.myProject).findFile(vFile);
        }
        return baseFile;
    }

    @Nullable
    public XMLInputSource resolveEntity(XMLResourceIdentifier xmlResourceIdentifier) throws XNIException {
        VirtualFile virtualFile2;
        XMLInputSource source;
        PsiFile psiFile;
        String publicId;
        String string = publicId = xmlResourceIdentifier.getLiteralSystemId() != null ? xmlResourceIdentifier.getLiteralSystemId() : xmlResourceIdentifier.getNamespace();
        if (publicId != null && publicId.startsWith("file:")) {
            Path basePath = new File(URI.create(xmlResourceIdentifier.getBaseSystemId())).getParentFile().toPath();
            try {
                Path publicIdPath = new File(URI.create(publicId)).toPath();
                publicId = basePath.relativize(publicIdPath).toString().replace(File.separatorChar, '/');
            }
            catch (Exception publicIdPath) {
                // empty catch block
            }
        }
        if ((psiFile = this.resolve(xmlResourceIdentifier.getBaseSystemId(), publicId)) == null && xmlResourceIdentifier.getLiteralSystemId() != null && xmlResourceIdentifier.getNamespace() != null) {
            publicId = xmlResourceIdentifier.getNamespace();
            psiFile = this.resolve(xmlResourceIdentifier.getBaseSystemId(), publicId);
        }
        if (psiFile == null) {
            if (publicId != null && publicId.contains(":/")) {
                try {
                    this.myErrorReporter.processError(new SAXParseException(XmlPsiBundle.message((String)"xml.inspections.validate.external.resource.is.not.registered", (Object[])new Object[]{publicId}), publicId, null, 0, 0), ValidateXmlActionHandler.ProblemType.ERROR);
                }
                catch (SAXException publicIdPath) {
                    // empty catch block
                }
                source = new XMLInputSource(xmlResourceIdentifier);
                source.setPublicId(publicId);
                source.setCharacterStream((Reader)new StringReader(""));
                return source;
            }
            return null;
        }
        source = new XMLInputSource(xmlResourceIdentifier);
        if (xmlResourceIdentifier.getLiteralSystemId() == null && (virtualFile2 = psiFile.getVirtualFile()) != null) {
            String url = VfsUtilCore.fixIDEAUrl((String)virtualFile2.getUrl());
            source.setBaseSystemId(url);
            source.setSystemId(url);
        }
        source.setPublicId(publicId);
        source.setBaseSystemId(null);
        source.setCharacterStream((Reader)new StringReader(psiFile.getText()));
        return source;
    }

    private static PsiFile resolveByLocation(PsiFile baseFile, String location) {
        XmlAttributeValue element2;
        XmlAttribute attribute;
        XmlTag tag2;
        if (baseFile instanceof XmlFile && (tag2 = ((XmlFile)baseFile).getRootTag()) != null && (attribute = tag2.getAttribute("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance")) != null && (element2 = attribute.getValueElement()) != null) {
            PsiReference[] references;
            for (PsiReference reference2 : references = element2.getReferences()) {
                if (!location.equals(reference2.getCanonicalText())) continue;
                PsiElement resolve2 = reference2.resolve();
                return resolve2 instanceof PsiFile ? (PsiFile)resolve2 : null;
            }
        }
        return null;
    }

    public void setStopOnUnDeclaredResource(boolean stopOnUnDeclaredResource) {
        this.myStopOnUnDeclaredResource = stopOnUnDeclaredResource;
    }

    public static class IgnoredResourceException
    extends RuntimeException {
    }
}

