/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaComplianceChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.inspections.JsonSchemaBasedInspectionBase;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaComplianceInspection
extends JsonSchemaBasedInspectionBase {
    public boolean myCaseInsensitiveEnum = false;

    @Override
    protected PsiElementVisitor doBuildVisitor(final @NotNull JsonValue root, final @Nullable JsonSchemaObject schema2, @NotNull JsonSchemaService service, final @NotNull ProblemsHolder holder, final @NotNull LocalInspectionToolSession session2) {
        if (root == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(0);
        }
        if (service == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(2);
        }
        if (session2 == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(3);
        }
        if (schema2 == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        final JsonComplianceCheckerOptions options2 = new JsonComplianceCheckerOptions(this.myCaseInsensitiveEnum);
        return new JsonElementVisitor(){

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element2 == root) {
                    JsonSchemaComplianceInspection.annotate(element2, schema2, holder, session2, options2);
                }
                super.visitElement(element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/inspections/JsonSchemaComplianceInspection$1", "visitElement"));
            }
        };
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JsonBundle.message("json.schema.inspection.case.insensitive.enum", new Object[0]), "myCaseInsensitiveEnum");
        return optionsPanel;
    }

    private static void annotate(@NotNull PsiElement element2, @NotNull JsonSchemaObject rootSchema, @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session2, JsonComplianceCheckerOptions options2) {
        JsonLikePsiWalker walker;
        if (element2 == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(4);
        }
        if (rootSchema == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(6);
        }
        if (session2 == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(7);
        }
        if ((walker = JsonLikePsiWalker.getWalker(element2, rootSchema)) == null) {
            return;
        }
        new JsonSchemaComplianceChecker(rootSchema, holder, walker, session2, options2).annotate(element2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSchema";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/inspections/JsonSchemaComplianceInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doBuildVisitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

