/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncDefineImpl;
import org.intellij.plugins.relaxNG.inspections.BaseInspection;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.intellij.plugins.relaxNG.xml.dom.RngGrammar;
import org.jetbrains.annotations.NotNull;

public class UnusedDefineInspection
extends BaseInspection {
    @Override
    @NotNull
    public RncElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnusedDefineInspection.$$$reportNull$$$0(0);
        }
        return new MyElementVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/plugins/relaxNG/inspections/UnusedDefineInspection", "buildVisitor"));
    }

    private static final class MyElementVisitor
    extends RncElementVisitor {
        private final ProblemsHolder myHolder;
        private final XmlElementVisitor myXmlVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag2) {
                this.visitXmlTag(tag2);
            }
        };

        MyElementVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        protected void superVisitElement(PsiElement element2) {
            element2.accept((PsiElementVisitor)this.myXmlVisitor);
        }

        @Override
        public void visitDefine(RncDefine pattern) {
            RncGrammar grammar = (RncGrammar)PsiTreeUtil.getParentOfType((PsiElement)pattern, RncGrammar.class);
            PsiFile file2 = pattern.getContainingFile();
            if (grammar != null ? MyElementVisitor.processRncUsages(pattern, new LocalSearchScope((PsiElement)grammar)) : MyElementVisitor.processRncUsages(pattern, new LocalSearchScope((PsiElement)file2))) {
                return;
            }
            PsiElementProcessor.CollectElements collector = new PsiElementProcessor.CollectElements();
            RelaxIncludeIndex.processBackwardDependencies((XmlFile)file2, (PsiElementProcessor<? super XmlFile>)collector);
            if (MyElementVisitor.processRncUsages(pattern, new LocalSearchScope(collector.toArray()))) {
                return;
            }
            ASTNode astNode = ((RncDefineImpl)pattern).getNameNode();
            this.myHolder.registerProblem(astNode.getPsi(), RelaxngBundle.message("relaxng.inspection.unused-define.message", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new MyFix<RncDefine>(pattern)});
        }

        private static boolean processRncUsages(PsiElement tag2, LocalSearchScope scope2) {
            Query query2 = ReferencesSearch.search((PsiElement)tag2, (SearchScope)scope2);
            for (PsiReference reference2 : query2) {
                PsiElement e = reference2.getElement();
                RncDefine t = (RncDefine)PsiTreeUtil.getParentOfType((PsiElement)e, RncDefine.class, (boolean)false);
                if (t != null && PsiTreeUtil.isAncestor((PsiElement)tag2, (PsiElement)t, (boolean)true)) continue;
                return true;
            }
            return false;
        }

        public void visitXmlTag(XmlTag tag2) {
            PsiFile file2 = tag2.getContainingFile();
            if (file2.getFileType() != XmlFileType.INSTANCE) {
                return;
            }
            if (!tag2.getLocalName().equals("define")) {
                return;
            }
            if (!tag2.getNamespace().equals("http://relaxng.org/ns/structure/1.0")) {
                return;
            }
            if (tag2.getAttribute("combine") != null) {
                return;
            }
            XmlAttribute attr = tag2.getAttribute("name");
            if (attr == null) {
                return;
            }
            XmlAttributeValue value2 = attr.getValueElement();
            if (value2 == null) {
                return;
            }
            String s = value2.getValue();
            if (s.length() == 0) {
                return;
            }
            PsiElement parent = value2.getParent();
            if (!(parent instanceof XmlAttribute)) {
                return;
            }
            if (!"name".equals(((XmlAttribute)parent).getName())) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof XmlTag)) {
                return;
            }
            DomElement element2 = DomManager.getDomManager((Project)tag2.getProject()).getDomElement(tag2);
            if (element2 == null) {
                return;
            }
            RngGrammar rngGrammar = (RngGrammar)element2.getParentOfType(RngGrammar.class, true);
            if (rngGrammar != null ? MyElementVisitor.processUsages((PsiElement)tag2, value2, new LocalSearchScope((PsiElement)rngGrammar.getXmlTag())) : MyElementVisitor.processUsages((PsiElement)tag2, value2, new LocalSearchScope((PsiElement)file2))) {
                return;
            }
            PsiElementProcessor.CollectElements collector = new PsiElementProcessor.CollectElements();
            RelaxIncludeIndex.processBackwardDependencies((XmlFile)file2, (PsiElementProcessor<? super XmlFile>)collector);
            if (MyElementVisitor.processUsages((PsiElement)tag2, value2, new LocalSearchScope(collector.toArray()))) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)value2, RelaxngBundle.message("relaxng.inspection.unused-define.message", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new MyFix<XmlTag>(tag2)});
        }

        private static boolean processUsages(PsiElement tag2, XmlAttributeValue value2, LocalSearchScope scope2) {
            Query query2 = ReferencesSearch.search((PsiElement)tag2, (SearchScope)scope2, (boolean)true);
            for (PsiReference reference2 : query2) {
                XmlTag t;
                PsiElement e = reference2.getElement();
                if (e == value2 || (t = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)e, XmlTag.class)) == null || PsiTreeUtil.isAncestor((PsiElement)tag2, (PsiElement)t, (boolean)true)) continue;
                return true;
            }
            return false;
        }

        private static class MyFix<T extends PsiElement>
        implements LocalQuickFix {
            private final T myTag;

            MyFix(T tag2) {
                this.myTag = tag2;
            }

            @NotNull
            public String getFamilyName() {
                String string = RelaxngBundle.message("relaxng.quickfix.remove-define", new Object[0]);
                if (string == null) {
                    MyFix.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                if (project == null) {
                    MyFix.$$$reportNull$$$0(1);
                }
                if (descriptor2 == null) {
                    MyFix.$$$reportNull$$$0(2);
                }
                try {
                    if (this.myTag.isValid()) {
                        this.myTag.delete();
                    }
                }
                catch (IncorrectOperationException e) {
                    Logger.getInstance((String)UnusedDefineInspection.class.getName()).error((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/plugins/relaxNG/inspections/UnusedDefineInspection$MyElementVisitor$MyFix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/plugins/relaxNG/inspections/UnusedDefineInspection$MyElementVisitor$MyFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

