/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.WebBrowserXmlService;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebBrowserUrlProviderKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/builtInWebServer/BuiltInWebBrowserUrlProvider;", "Lcom/intellij/ide/browsers/WebBrowserUrlProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "canHandleElement", "", "request", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "getUrl", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isFileOfMyLanguage", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.platform.builtInServer.impl"})
public class BuiltInWebBrowserUrlProvider
extends WebBrowserUrlProvider
implements DumbAware {
    public boolean canHandleElement(@NotNull OpenInBrowserRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.getVirtualFile() instanceof HttpVirtualFile) {
            return true;
        }
        return request.isPhysicalFile() && this.isFileOfMyLanguage(request.getFile());
    }

    protected boolean isFileOfMyLanguage(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return WebBrowserXmlService.Companion.getInstance().isHtmlOrXmlFile(psiFile);
    }

    @Nullable
    protected Url getUrl(@NotNull OpenInBrowserRequest request, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (file2 instanceof HttpVirtualFile) {
            return Urls.newFromVirtualFile((VirtualFile)file2);
        }
        return (Url)CollectionsKt.firstOrNull(BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls(file2, request.getProject(), null, request.isAppendAccessToken(), request.getReloadMode()));
    }
}

