/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Url;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

public final class Location {
    private final Url url;
    private final Script script;
    private final int line;
    private final int column;

    public Location(@NotNull Url url, int line, int column2) {
        if (url == null) {
            Location.$$$reportNull$$$0(0);
        }
        this.url = url;
        this.line = line;
        this.column = column2;
        this.script = null;
    }

    public Location(@NotNull Script script, int line, int column2) {
        if (script == null) {
            Location.$$$reportNull$$$0(1);
        }
        this.url = script.getUrl();
        this.line = line;
        this.column = column2;
        this.script = script;
    }

    public Location(@NotNull Url url, int line) {
        if (url == null) {
            Location.$$$reportNull$$$0(2);
        }
        this(url, line, -1);
    }

    @NotNull
    public Location withoutColumn() {
        return this.script == null ? new Location(this.url, this.line) : new Location(this.script, this.line, -1);
    }

    @NotNull
    public Url getUrl() {
        Url url = this.url;
        if (url == null) {
            Location.$$$reportNull$$$0(3);
        }
        return url;
    }

    @Nullable
    public Script getScript() {
        return this.script;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return this.column == location.column && this.line == location.line && this.url.equals(location.url);
    }

    public int hashCode() {
        int result2 = this.url.hashCode();
        result2 = 31 * result2 + this.line;
        result2 = 31 * result2 + this.column;
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/debugger/Location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/debugger/Location";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

