/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.format;

import com.google.common.collect.Lists;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColRange;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColReplace;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatChangeSettingsProvider;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatFileUtils;
import com.jetbrains.cidr.lang.editor.OCTypingActionsExtension;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangDaemonFormatProvider
implements ClangFormatChangeSettingsProvider {
    @NonNls
    private static final String ourErrorPreamble = "Problem with access to ClangFormat configuration: ";
    @NonNls
    private static final String ourClangFormatConfigureSourcePrefix = "# ClangFormatConfigureSource: ";
    @NonNls
    public static final String CF_CANCEL_FORMATTING_PREFIX = "// CIDR_CLANG_FORMAT_CANCEL";
    private static boolean ourDebugRangesForFormat = false;
    @NonNls
    private static final String PARSE_START = "Error reading";
    @NonNls
    private static final String WRONG_CFG_START = "Configuration file(s) do(es) not support";
    private static final Pattern CLANG_FORMAT_CONFIGURE_SOURCE = Pattern.compile("^#\\s*ClangFormatConfigureSource:\\s*'([^']*)'\\s*\n.*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    @NonNls
    public String findClangFormatContent(@NotNull Project project, @NotNull VirtualFile vfCodeFile) {
        ClangLanguageService service;
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(0);
        }
        if (vfCodeFile == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(1);
        }
        if (!(service = ClangLanguageServiceProvider.getOrStart((Project)project)).isDummy()) {
            String clangFormatContent;
            block13: {
                String string2;
                SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), "cf_" + vfCodeFile.getPath());
                service.notifyDocumentOpened(vfCodeFile, (OpenRequestId)openRequestId);
                CompletableFuture future = service.requestClangFormatConfiguration(vfCodeFile);
                try {
                    clangFormatContent = (String)CidrConcurrentUtilsKt.waitCancelAware((Future)future, (String)".clang-format content");
                    if (clangFormatContent != null && !clangFormatContent.isEmpty()) break block13;
                    string2 = CFC_NO_CONTEXT_FUTURE;
                }
                catch (ExecutionException e) {
                    String clangFormatFileWithErrorURL;
                    OpenFileDescriptor fileDescriptor;
                    CidrLogService.logOnce((Level)Level.WARNING, (String)e.getMessage(), (Throwable)e);
                    @NotNull Throwable cause = e.getCause() != null ? e.getCause() : e;
                    @NotNull String message = cause.getMessage() != null ? cause.getMessage() : cause.getClass().toString();
                    ProcessedMessage pe = ClangDaemonFormatProvider.processMessage(StringUtil.notNullize((String)message, (String)e.toString()));
                    if (!pe.getClangFormatURLs().isEmpty() && (fileDescriptor = ClangDaemonFormatProvider.createOpenFileDescriptor(project, clangFormatFileWithErrorURL = pe.getClangFormatURLs().get(0))) != null) {
                        String string5 = ClangDaemonFormatProvider.getCFSourceCommentLine(fileDescriptor.getFile()) + ClangFormatFileUtils.getErrorStyleFor(message);
                        String string = string5;
                        if (string != null) return string;
                        ClangDaemonFormatProvider.$$$reportNull$$$0(4);
                        return string;
                    }
                    if (!pe.getFilteredMessage().isEmpty()) {
                        String string7 = ClangFormatFileUtils.getErrorStyleFor(ourErrorPreamble + message);
                        String string = string7;
                        if (string != null) return string;
                        ClangDaemonFormatProvider.$$$reportNull$$$0(5);
                        return string;
                    }
                }
                service.notifyDocumentClosed(vfCodeFile, (OpenRequestId)openRequestId);
                String string = string2;
                if (string != null) return string;
                ClangDaemonFormatProvider.$$$reportNull$$$0(2);
                return string;
            }
            String string4 = clangFormatContent;
            String string = string4;
            if (string != null) return string;
            ClangDaemonFormatProvider.$$$reportNull$$$0(3);
            return string;
        }
        String string = CFC_WRONG_CONTEXT_FUTURE_RESPOND;
        if (string != null) return string;
        ClangDaemonFormatProvider.$$$reportNull$$$0(6);
        return string;
    }

    public static boolean isClangdCommunicationError(@NotNull String optionsOrErrorAsYAML) {
        if (optionsOrErrorAsYAML == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(7);
        }
        return CFC_NO_CONTEXT_FUTURE.equals(optionsOrErrorAsYAML) || CFC_WRONG_CONTEXT_FUTURE_RESPOND.equals(optionsOrErrorAsYAML);
    }

    @NotNull
    @NonNls
    public static String getCFSourceCommentLine(@NotNull VirtualFile cfvFile) {
        if (cfvFile == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(8);
        }
        String string = "# ClangFormatConfigureSource: 'clang-format-file://" + cfvFile.getCanonicalPath() + "'\n";
        if (string == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public boolean applyCollectedSettings(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile codeFile, @NotNull Map<String, Object> formattingOptionValue) {
        if (settings == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(10);
        }
        if (codeFile == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(11);
        }
        if (formattingOptionValue == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(12);
        }
        boolean isModified = false;
        CommonCodeStyleSettings.IndentOptions indentOptions = ClangFormatFileUtils.getOverriddenIndentOptions(settings);
        OCCodeStyleSettings oc = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        CommonCodeStyleSettings common = settings.getCommonSettings(codeFile.getLanguage());
        isModified |= common.IF_BRACE_FORCE != 0 || common.DOWHILE_BRACE_FORCE != 0 || common.WHILE_BRACE_FORCE != 0 || common.FOR_BRACE_FORCE != 0;
        common.FOR_BRACE_FORCE = 0;
        common.WHILE_BRACE_FORCE = 0;
        common.DOWHILE_BRACE_FORCE = 0;
        common.IF_BRACE_FORCE = 0;
        oc.BLOCK_BRACE_PLACEMENT = 1;
        isModified |= oc.BLOCK_BRACE_PLACEMENT != 1;
        boolean customBraceStyle = true;
        for (Map.Entry<String, Object> entry : formattingOptionValue.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            try {
                if ("AfterClass".equals(key)) {
                    int CLASS_BRACE_STYLE = ClangDaemonFormatProvider.getBraceStyle(ClangDaemonFormatProvider._boolean(value), false);
                    isModified |= CLASS_BRACE_STYLE != common.CLASS_BRACE_STYLE;
                    common.CLASS_BRACE_STYLE = CLASS_BRACE_STYLE;
                    continue;
                }
                if ("AfterFunction".equals(key)) {
                    int FUNCTION_BRACE_PLACEMENT = ClangDaemonFormatProvider.getBraceStyle(ClangDaemonFormatProvider._boolean(value), false);
                    isModified |= FUNCTION_BRACE_PLACEMENT != oc.FUNCTION_BRACE_PLACEMENT;
                    oc.FUNCTION_BRACE_PLACEMENT = FUNCTION_BRACE_PLACEMENT;
                    continue;
                }
                if ("AfterControlStatement".equals(key)) {
                    int BRACE_STYLE = ClangDaemonFormatProvider.getBraceStyle(ClangDaemonFormatProvider._boolean(value), ClangDaemonFormatProvider._boolean(formattingOptionValue.get("IndentBraces")));
                    isModified |= BRACE_STYLE != common.BRACE_STYLE;
                    common.BRACE_STYLE = BRACE_STYLE;
                    continue;
                }
                if ("AfterNamespace".equals(key)) {
                    int NAMESPACE_BRACE_PLACEMENT = ClangDaemonFormatProvider.getBraceStyle(ClangDaemonFormatProvider._boolean(value), false);
                    isModified |= NAMESPACE_BRACE_PLACEMENT != oc.NAMESPACE_BRACE_PLACEMENT;
                    oc.NAMESPACE_BRACE_PLACEMENT = NAMESPACE_BRACE_PLACEMENT;
                    continue;
                }
                if ("BeforeElse".equals(key)) {
                    boolean vBeforeElse = ClangDaemonFormatProvider._boolean(value);
                    isModified |= vBeforeElse != common.ELSE_ON_NEW_LINE;
                    common.ELSE_ON_NEW_LINE = vBeforeElse;
                    continue;
                }
                if ("BeforeCatch".equals(key)) {
                    boolean vBeforeCatch = ClangDaemonFormatProvider._boolean(value);
                    isModified |= vBeforeCatch != common.CATCH_ON_NEW_LINE;
                    common.CATCH_ON_NEW_LINE = vBeforeCatch;
                    continue;
                }
                if ("ColumnLimit".equals(key)) {
                    int vColumnLimit = ClangDaemonFormatProvider._int(value);
                    boolean vKeepLineBreaks = false;
                    if (vColumnLimit == 0) {
                        vColumnLimit = 1000;
                        vKeepLineBreaks = true;
                    }
                    isModified |= vColumnLimit != common.RIGHT_MARGIN || vKeepLineBreaks != common.KEEP_LINE_BREAKS;
                    common.RIGHT_MARGIN = vColumnLimit;
                    common.KEEP_LINE_BREAKS = vKeepLineBreaks;
                    continue;
                }
                if ("MaxEmptyLinesToKeep".equals(key)) {
                    int vMaxEmptyLinesToKeep = ClangDaemonFormatProvider._int(value);
                    isModified |= vMaxEmptyLinesToKeep != common.KEEP_BLANK_LINES_IN_CODE;
                    common.KEEP_BLANK_LINES_IN_CODE = vMaxEmptyLinesToKeep;
                    continue;
                }
                if ("IndentWidth".equals(key)) {
                    int vIndentWidth = ClangDaemonFormatProvider._int(value);
                    isModified |= vIndentWidth != indentOptions.INDENT_SIZE || vIndentWidth != oc.INDENT_CLASS_MEMBERS || vIndentWidth != oc.INDENT_C_STRUCT_MEMBERS || vIndentWidth != oc.INDENT_INTERFACE_MEMBERS || vIndentWidth != oc.INDENT_IMPLEMENTATION_MEMBERS || oc.INDENT_PREPROCESSOR_DIRECTIVE != 0 || oc.INDENT_DIRECTIVE_AS_CODE || !oc.INDENT_INTERFACE_MEMBERS_EXCEPT_IVARS_BLOCK;
                    oc.INDENT_INTERFACE_MEMBERS = oc.INDENT_IMPLEMENTATION_MEMBERS = vIndentWidth;
                    oc.INDENT_C_STRUCT_MEMBERS = oc.INDENT_IMPLEMENTATION_MEMBERS;
                    oc.INDENT_CLASS_MEMBERS = oc.INDENT_IMPLEMENTATION_MEMBERS;
                    indentOptions.INDENT_SIZE = oc.INDENT_IMPLEMENTATION_MEMBERS;
                    oc.INDENT_INTERFACE_MEMBERS_EXCEPT_IVARS_BLOCK = true;
                    oc.INDENT_DIRECTIVE_AS_CODE = false;
                    oc.INDENT_PREPROCESSOR_DIRECTIVE = 0;
                    continue;
                }
                if ("ObjCBlockIndentWidth".equals(key)) {
                    int vObjCBlockIndentWidth = ClangDaemonFormatProvider._int(value);
                    isModified |= vObjCBlockIndentWidth != oc.INDENT_INSIDE_CODE_BLOCK;
                    oc.INDENT_INSIDE_CODE_BLOCK = vObjCBlockIndentWidth;
                    continue;
                }
                if ("ContinuationIndentWidth".equals(key)) {
                    int vContinuationIndentWidth = ClangDaemonFormatProvider._int(value);
                    isModified |= vContinuationIndentWidth != indentOptions.CONTINUATION_INDENT_SIZE;
                    indentOptions.CONTINUATION_INDENT_SIZE = vContinuationIndentWidth;
                    continue;
                }
                if ("TabWidth".equals(key)) {
                    int vTabWidth = ClangDaemonFormatProvider._int(value);
                    isModified |= vTabWidth != indentOptions.TAB_SIZE;
                    indentOptions.TAB_SIZE = vTabWidth;
                    continue;
                }
                if ("UseTab".equals(key)) {
                    Boolean vUseTab = null;
                    vUseTab = "Never".equals(value) || "false".equals(value) ? Boolean.FALSE : Boolean.TRUE;
                    if (vUseTab == null) continue;
                    isModified |= !vUseTab.equals(indentOptions.USE_TAB_CHARACTER);
                    indentOptions.USE_TAB_CHARACTER = vUseTab;
                    continue;
                }
                if ("AccessModifierOffset".equals(key)) {
                    int vAccessModifierOffset = ClangDaemonFormatProvider._int(value) + ClangDaemonFormatProvider._int(formattingOptionValue.get("IndentWidth"));
                    isModified |= vAccessModifierOffset != oc.INDENT_VISIBILITY_KEYWORDS;
                    oc.INDENT_VISIBILITY_KEYWORDS = vAccessModifierOffset;
                    continue;
                }
                if ("IndentCaseLabels".equals(key)) {
                    boolean vIndentCaseLabels = ClangDaemonFormatProvider._boolean(value);
                    isModified |= vIndentCaseLabels != common.INDENT_CASE_FROM_SWITCH;
                    common.INDENT_CASE_FROM_SWITCH = vIndentCaseLabels;
                    continue;
                }
                if (!"NamespaceIndentation".equals(key)) continue;
                String vNamespaceIndentation = ClangDaemonFormatProvider._str(value);
                int INDENT_NAMESPACE_MEMBERS = oc.INDENT_NAMESPACE_MEMBERS;
                if ("None".equals(vNamespaceIndentation)) {
                    INDENT_NAMESPACE_MEMBERS = 0;
                } else if ("Inner".equals(vNamespaceIndentation)) {
                    INDENT_NAMESPACE_MEMBERS = 0;
                } else if ("All".equals(vNamespaceIndentation)) {
                    INDENT_NAMESPACE_MEMBERS = ClangDaemonFormatProvider._int(formattingOptionValue.get("IndentWidth"));
                }
                isModified |= INDENT_NAMESPACE_MEMBERS != oc.INDENT_NAMESPACE_MEMBERS;
                oc.INDENT_NAMESPACE_MEMBERS = INDENT_NAMESPACE_MEMBERS;
            }
            catch (UnsupportedOperationException t) {
                OCLog.LOG.info("No option:" + key);
            }
            catch (Throwable t) {
                OCLog.LOG.warn("Problem option with " + key + ":" + t.getMessage());
            }
        }
        return isModified;
    }

    @Contract(pure=true)
    private static int getBraceStyle(boolean wrapAfter, boolean indentBrace) {
        return !wrapAfter ? 1 : (indentBrace ? 4 : 2);
    }

    private static String _str(@Nullable Object value) {
        if (value == null) {
            throw new UnsupportedOperationException();
        }
        return value.toString();
    }

    private static int _int(@Nullable Object value) {
        if (value == null) {
            throw new UnsupportedOperationException();
        }
        return Integer.parseInt((String)value);
    }

    private static boolean _boolean(@Nullable Object value) {
        if (value == null) {
            throw new UnsupportedOperationException();
        }
        return Boolean.parseBoolean((String)value);
    }

    @Override
    public boolean isApplicable(@NotNull Project project, @NotNull FileType fileType) {
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(13);
        }
        if (fileType == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(14);
        }
        return OCLanguageUtils.isSupported((FileType)fileType);
    }

    @Override
    public boolean isActive(@NotNull Project project, @NotNull FileType fileType) {
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(15);
        }
        if (fileType == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(16);
        }
        return this.isApplicable(project, fileType) && ClangUtils.isClangdOn((Project)project);
    }

    @Nullable
    private static String styleForFormatting(@Nullable String style, @NotNull Project project) {
        String errorParsingMessageFromStyle;
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(17);
        }
        if ((errorParsingMessageFromStyle = ClangDaemonFormatProvider.getErrorParsingMessageFromStyle(style)) != null) {
            ClangDaemonFormatProvider.reportClangFormatError(errorParsingMessageFromStyle, project, MessageType.ERROR);
            return null;
        }
        return ClangDaemonFormatProvider.makeStyleLanguageAgnostic(style);
    }

    @NotNull
    private static String styleToKeepLineBreaks(@NotNull String style) {
        int index;
        if (style == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(18);
        }
        if ((index = ((String)style).indexOf("ColumnLimit:")) >= 0) {
            int lineEnd = ((String)style).indexOf("\n", index);
            style = ((String)style).substring(0, index) + "ColumnLimit: 0" + (lineEnd == -1 ? "" : ((String)style).substring(lineEnd));
        } else {
            style = (String)style + "ColumnLimit: 0\n";
        }
        Object object = style = (String)style + "KeepLineBreaksForNonEmptyLines: true\n";
        if (object == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(19);
        }
        return object;
    }

    private static void handleFormatException(@NotNull Exception e, @NotNull Project project) {
        if (e == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(20);
        }
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(21);
        }
        String message = StringUtil.notNullize((String)(e.getCause() != null ? e.getCause().getMessage() : e.getMessage()));
        ClangDaemonFormatProvider.reportClangFormatError(message, project, MessageType.ERROR);
    }

    @Override
    @Nullable(value="return null if cannot guaranty the consistency of Psi and document before or after formatting procedure")
    public @Nullable(value="return null if cannot guaranty the consistency of Psi and document before or after formatting procedure") TextRange format(@NotNull PsiFile source, @NotNull TextRange range, @Nullable String style, boolean canChangeWhiteSpacesOnly, boolean keepLineBreaks, boolean enableBulkUpdate) {
        if (source == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(22);
        }
        if (range == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(23);
        }
        Project project = source.getProject();
        VirtualFile virtualFile = source.getViewProvider().getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        OCLog.LOG.assertTrue(document != null);
        String origText = document.getText();
        if (ourDebugRangesForFormat) {
            ClangDaemonFormatProvider.outDebugString("Format range: " + source.getName() + ClangDaemonFormatProvider.selectedRangeInContext(origText, range));
        }
        if ((style = ClangDaemonFormatProvider.styleForFormatting(style, project)) == null) {
            return range;
        }
        if (keepLineBreaks) {
            style = ClangDaemonFormatProvider.styleToKeepLineBreaks(style);
        }
        try {
            List replaces = (List)CidrConcurrentUtilsKt.waitCancelAware((Future)ClangLanguageServiceProvider.getIfStarted((Project)project).formatRange(virtualFile, range, style), (String)"formatRange");
            if (replaces == null || replaces.isEmpty()) {
                ClangDaemonFormatProvider.generateCancelFormatForTestFile(origText);
                return source.getTextRange();
            }
            if (!ApplicationManager.getApplication().isDispatchThread() && PsiManagerEx.getInstanceEx((Project)project).getFileManager().findCachedViewProvider(virtualFile) == null) {
                return null;
            }
            return this.processFormatPatch(range, canChangeWhiteSpacesOnly, project, document, origText, replaces, enableBulkUpdate);
        }
        catch (ProcessCanceledException cancel) {
            throw cancel;
        }
        catch (Exception e) {
            ClangDaemonFormatProvider.handleFormatException(e, project);
            return range;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TextRange processFormatPatch(@NotNull TextRange range, boolean canChangeWhiteSpacesOnly, @NotNull Project project, @NotNull Document document, @NotNull String origText, @NotNull List<ClangLineColReplace> replaces, boolean enableBulkUpdate) {
        boolean forceBulkUpdate;
        if (range == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(24);
        }
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(25);
        }
        if (document == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(26);
        }
        if (origText == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(27);
        }
        if (replaces == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(28);
        }
        Ref start = Ref.create((Object)Integer.MAX_VALUE);
        Ref end = Ref.create((Object)Integer.MIN_VALUE);
        Ref delta = Ref.create((Object)0);
        boolean bl = forceBulkUpdate = !document.isInBulkUpdate() && enableBulkUpdate;
        if (forceBulkUpdate) {
            document.setInBulkUpdate(true);
        }
        try {
            replaces.stream().sorted(Comparator.comparingInt(o -> -o.getRange().getStart().getOffset(document))).map(replace -> {
                ClangLineColRange replaceRange = replace.getRange();
                TextRange mappedRange = TextRange.create((int)replaceRange.getStart().getOffset(document), (int)replaceRange.getEnd().getOffset(document));
                if (ourDebugRangesForFormat) {
                    ClangDaemonFormatProvider.outDebugString("map" + ClangDaemonFormatProvider.selectedRangeInContext(origText, mappedRange) + " to >>>" + replace.getReplace() + "<<<");
                }
                return Pair.create((Object)replace.getReplace(), (Object)mappedRange);
            }).collect(Collectors.toList()).forEach(replaceRange -> {
                if (!(!range.intersects((TextRange)replaceRange.second) || range.getEndOffset() != origText.length() && ((TextRange)replaceRange.second).getStartOffset() == range.getEndOffset() || canChangeWhiteSpacesOnly && !StringUtil.isEmptyOrSpaces((String)((String)replaceRange.first)))) {
                    String replaceText = (String)replaceRange.first;
                    int startOffset = ((TextRange)replaceRange.second).getStartOffset();
                    int endOffset = ((TextRange)replaceRange.second).getEndOffset();
                    start.set((Object)Math.min((Integer)start.get(), startOffset));
                    end.set((Object)Math.max((Integer)end.get(), endOffset));
                    int oldLength = endOffset - startOffset;
                    int newLength = replaceText.length();
                    int diff = newLength - oldLength;
                    delta.set((Object)((Integer)delta.get() + diff));
                    if (ourDebugRangesForFormat) {
                        ClangDaemonFormatProvider.outDebugString("Replace:" + ClangDaemonFormatProvider.selectedRangeInContext(origText, (TextRange)replaceRange.second) + "\n to >>>" + replaceText + "<<<");
                    }
                    document.replaceString(startOffset, endOffset, (CharSequence)replaceText);
                }
            });
        }
        finally {
            if (forceBulkUpdate) {
                document.setInBulkUpdate(false);
            }
        }
        ClangDaemonFormatProvider.generateCancelFormatForTestFile(origText);
        if ((Integer)start.get() != Integer.MAX_VALUE && (Integer)start.get() != Integer.MIN_VALUE) {
            TextRange diffRangeInModifiedDoc = TextRange.create((int)((Integer)start.get()), (int)((Integer)end.get() + (Integer)delta.get()));
            return ClangDaemonFormatProvider.psiAndDocumentAreSynchronized(PsiDocumentManager.getInstance((Project)project), document) ? TextRange.create((int)Integer.min(range.getStartOffset(), diffRangeInModifiedDoc.getStartOffset()), (int)Integer.max(range.getEndOffset() + (Integer)delta.get(), diffRangeInModifiedDoc.getEndOffset())) : null;
        }
        return range;
    }

    private static void generateCancelFormatForTestFile(@NotNull String origText) {
        ProgressIndicator formatProgress;
        if (origText == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(29);
        }
        if (origText.startsWith(CF_CANCEL_FORMATTING_PREFIX) && (formatProgress = ProgressManager.getInstance().getProgressIndicator()) != null) {
            formatProgress.cancel();
        }
    }

    @NotNull
    private static String indentationFromList(@NotNull Document document, @NotNull List<ClangLineColReplace> replaces, int lineStartOffset) {
        if (document == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(30);
        }
        if (replaces == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(31);
        }
        for (ClangLineColReplace replace : Lists.reverse(replaces)) {
            int offsetStart = replace.getRange().getStart().getOffset(document);
            int offsetEnd = replace.getRange().getEnd().getOffset(document);
            if (lineStartOffset <= offsetStart || lineStartOffset > offsetEnd) continue;
            String replaceString = replace.getReplace();
            int firstSpace = replaceString.lastIndexOf(10) + 1;
            String string = replaceString.substring(firstSpace, CharArrayUtil.shiftForward((CharSequence)replaceString, (int)firstSpace, (String)" \t"));
            if (string == null) {
                ClangDaemonFormatProvider.$$$reportNull$$$0(32);
            }
            return string;
        }
        return "";
    }

    @Override
    public String indent(@NotNull PsiFile source, int lineStartOffset, @Nullable String style) {
        if (source == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(33);
        }
        Project project = source.getProject();
        VirtualFile virtualFile = source.getViewProvider().getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        OCLog.LOG.assertTrue(document != null);
        style = ClangDaemonFormatProvider.styleForFormatting(style, project);
        if (style == null) {
            return null;
        }
        String indentString = null;
        try {
            CompletableFuture future = ClangLanguageServiceProvider.getIfStarted((Project)project).indentLine(virtualFile, lineStartOffset, style);
            List replaces = (List)CidrConcurrentUtilsKt.waitCancelAware((Future)future, (String)"indentLine");
            if (replaces == null || replaces.isEmpty()) {
                return null;
            }
            indentString = ClangDaemonFormatProvider.indentationFromList(document, replaces, lineStartOffset);
        }
        catch (ProcessCanceledException cancel) {
            throw cancel;
        }
        catch (Exception e) {
            ClangDaemonFormatProvider.handleFormatException(e, project);
        }
        return indentString;
    }

    @Contract(value="null -> null")
    private static String makeStyleLanguageAgnostic(@Nullable String style) {
        if (style == null) {
            return null;
        }
        String[] lines = StringUtil.splitByLinesKeepSeparators((String)style);
        if (Arrays.stream(lines).filter(line -> line.startsWith("---")).count() > 1L) {
            return style;
        }
        return Arrays.stream(lines).filter(line -> !line.startsWith("---") && !line.startsWith("...") && !line.startsWith("Language:")).collect(Collectors.joining());
    }

    @Contract(value="null -> null")
    public static String getErrorParsingMessageFromStyle(@Nullable String style) {
        if (style == null) {
            return null;
        }
        String[] lines = StringUtil.splitByLines((String)style);
        if (lines.length == 1) {
            return ClangFormatFileUtils.getErrorMessageFromYAMLine(lines[0]);
        }
        if ((lines.length == 2 || lines.length == 3) && lines[0].startsWith(ourClangFormatConfigureSourcePrefix)) {
            return ClangFormatFileUtils.getErrorMessageFromYAMLine(lines[1] + (String)(lines.length == 2 ? "" : " - " + lines[2]));
        }
        return null;
    }

    private static boolean psiAndDocumentAreSynchronized(@NotNull PsiDocumentManager psiDocumentManager, @NotNull Document document) {
        if (psiDocumentManager == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(34);
        }
        if (document == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(35);
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed() && OCTypingActionsExtension.INSIDE_TYPING_ACTION_HINT.get((UserDataHolder)document) != Boolean.TRUE) {
            psiDocumentManager.commitDocument(document);
            return true;
        }
        return psiDocumentManager.isCommitted(document);
    }

    private static void outDebugString(@NotNull @NonNls String message) {
        if (message == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(36);
        }
        assert (ourDebugRangesForFormat);
        System.out.println("=============================== " + message);
    }

    @NotNull
    private static String selectedRangeInContext(@NotNull @NonNls String text, @NotNull TextRange range) {
        if (text == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(37);
        }
        if (range == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(38);
        }
        String string = "\n'" + text.substring(0, range.getStartOffset()) + ">>>" + range.substring(text) + "<<<" + text.substring(range.getEndOffset()) + "'";
        if (string == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(39);
        }
        return string;
    }

    public static void reportClangFormatError(@NotNull String message, final @NotNull Project project, MessageType messageType) {
        Application application;
        if (message == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(40);
        }
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(41);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode()) {
            throw new RuntimeException(message);
        }
        if (application.isInternal() || application.isHeadlessEnvironment()) {
            OCLog.LOG.warn("Problem while ClangFormat procedure:" + message);
            if (application.isHeadlessEnvironment()) {
                return;
            }
        }
        ProcessedMessage pe = ClangDaemonFormatProvider.processMessage(message);
        UIUtil.invokeLaterIfNeeded(() -> {
            BalloonLayout layout;
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(pe.getFilteredMessage(), messageType, new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    OpenFileDescriptor descriptor;
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (descriptor = ClangDaemonFormatProvider.createOpenFileDescriptor(project, e.getDescription())) != null) {
                        new OpenFileHyperlinkInfo(descriptor).navigate(project);
                    }
                }
            }).setFadeoutTime(0L).setShowCallout(false).setAnimationCycle(0).setHideOnClickOutside(true).setHideOnKeyOutside(true).setHideOnLinkClick(true).setCloseButtonEnabled(true).createBalloon();
            Disposer.register((Disposable)project, (Disposable)balloon);
            Frame window = WindowManager.getInstance().getFrame(project);
            if (window == null) {
                window = JOptionPane.getRootFrame();
            }
            if (window instanceof IdeFrame && (layout = ((IdeFrame)window).getBalloonLayout()) != null) {
                balloon.show((PositionTracker)new PositionTracker<Balloon>((Component)((IdeFrame)window).getComponent()){

                    public RelativePoint recalculateLocation(@NotNull Balloon object) {
                        if (object == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        Component c = this.getComponent();
                        int y = c.getHeight() - 45;
                        return new RelativePoint(c, new Point(c.getWidth() - 150, y));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/jetbrains/cidr/lang/daemon/clang/format/ClangDaemonFormatProvider$2", "recalculateLocation"));
                    }
                }, Balloon.Position.above);
            }
        });
    }

    @Contract(value="_, null -> null")
    public static OpenFileDescriptor createOpenFileDescriptor(@NotNull Project project, @Nullable String url) {
        VirtualFile vtClangFormat;
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(42);
        }
        if (url == null) {
            return null;
        }
        int pos = url.lastIndexOf(58);
        int col = 0;
        int line = 0;
        if (pos > 1) {
            String num1 = url.substring(pos + 1);
            if ((pos = (url = url.substring(0, pos)).lastIndexOf(58)) > 1) {
                String num2 = url.substring(pos + 1);
                url = url.substring(0, pos);
                line = ClangDaemonFormatProvider._int(num2);
                col = ClangDaemonFormatProvider._int(num1);
            } else {
                line = ClangDaemonFormatProvider._int(num1);
            }
        }
        if ((vtClangFormat = VfsUtil.findFile((Path)Paths.get(url, new String[0]), (boolean)false)) != null) {
            return new OpenFileDescriptor(project, vtClangFormat, line - 1, col);
        }
        return null;
    }

    @NotNull
    public static ProcessedMessage processMessage(@NotNull String message) {
        int pos;
        if (message == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(43);
        }
        if (message.startsWith(PARSE_START)) {
            int pos2 = message.indexOf(": ");
            String messageEnd = message.substring(pos2);
            String fileName = message.substring(PARSE_START.length(), pos2).trim();
            ProcessedMessage processedMessage = ProcessedMessage.createProcessedMessage(Collections.singletonList(fileName), new HtmlBuilder().append(PARSE_START).append(" ").appendLink(fileName, fileName).append(messageEnd).wrapWithHtmlBody().toString());
            if (processedMessage == null) {
                ClangDaemonFormatProvider.$$$reportNull$$$0(44);
            }
            return processedMessage;
        }
        if (message.startsWith(WRONG_CFG_START) && (pos = message.indexOf(":")) > 0) {
            StringBuffer sb = new StringBuffer(message.substring(0, pos + 1));
            List paths = StringUtil.split((String)message.substring(pos + 1), (String)",");
            boolean[] first = new boolean[]{true};
            SmartList clangFormatURLs = new SmartList();
            paths.forEach(arg_0 -> ClangDaemonFormatProvider.lambda$processMessage$6((List)clangFormatURLs, first, sb, arg_0));
            ProcessedMessage processedMessage = ProcessedMessage.createProcessedMessage((List<String>)clangFormatURLs, "<html><body>" + sb.toString() + "</body></html>");
            if (processedMessage == null) {
                ClangDaemonFormatProvider.$$$reportNull$$$0(45);
            }
            return processedMessage;
        }
        ProcessedMessage processedMessage = ProcessedMessage.createProcessedMessage(ContainerUtil.emptyList(), message);
        if (processedMessage == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(46);
        }
        return processedMessage;
    }

    private static int _int(String num2) {
        try {
            return Integer.parseInt(num2);
        }
        catch (NumberFormatException ignore) {
            return 0;
        }
    }

    @Override
    @Nullable
    public VirtualFile extractClangFormatFile(@NotNull String clangFormatExtendedContext) {
        String formatSource;
        if (clangFormatExtendedContext == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(47);
        }
        return (formatSource = ClangDaemonFormatProvider.extractClangFormatSource(clangFormatExtendedContext)) == null ? null : ClangFormatFileUtils.getClangFormatFile(formatSource, false);
    }

    @Nullable
    public static String extractClangFormatSource(@NotNull String clangFormatExtendedContext) {
        Matcher matcher;
        if (clangFormatExtendedContext == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(48);
        }
        return (matcher = CLANG_FORMAT_CONFIGURE_SOURCE.matcher(clangFormatExtendedContext)).find() ? matcher.group(1) : null;
    }

    private static /* synthetic */ void lambda$processMessage$6(List clangFormatURLs, boolean[] first, StringBuffer sb, String fileName) {
        String trim = fileName.trim();
        clangFormatURLs.add(trim);
        if (first[0]) {
            first[0] = false;
            sb.append(" ");
        } else {
            sb.append(", ");
        }
        sb.append(HtmlChunk.link((String)trim, (String)trim));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 19: 
            case 32: 
            case 39: 
            case 44: 
            case 45: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 19: 
            case 32: 
            case 39: 
            case 44: 
            case 45: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfCodeFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 19: 
            case 32: 
            case 39: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/format/ClangDaemonFormatProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsOrErrorAsYAML";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfvFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingOptionValue";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 22: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 23: 
            case 24: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 26: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origText";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaces";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDocumentManager";
                break;
            }
            case 36: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangFormatExtendedContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/format/ClangDaemonFormatProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findClangFormatContent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCFSourceCommentLine";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "styleToKeepLineBreaks";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "indentationFromList";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "selectedRangeInContext";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "processMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClangFormatContent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 19: 
            case 32: 
            case 39: 
            case 44: 
            case 45: 
            case 46: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isClangdCommunicationError";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCFSourceCommentLine";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyCollectedSettings";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "styleForFormatting";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "styleToKeepLineBreaks";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "handleFormatException";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processFormatPatch";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "generateCancelFormatForTestFile";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "indentationFromList";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "indent";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "psiAndDocumentAreSynchronized";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "outDebugString";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "selectedRangeInContext";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "reportClangFormatError";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createOpenFileDescriptor";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processMessage";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "extractClangFormatFile";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "extractClangFormatSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 19: 
            case 32: 
            case 39: 
            case 44: 
            case 45: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ProcessedMessage {
        private final List<String> myClangFormatURLs;
        private final @NlsContexts.PopupContent String myFilteredMessage;

        private ProcessedMessage(@NotNull List<String> clangFormatURLs, @NotNull @NlsContexts.PopupContent String message) {
            if (clangFormatURLs == null) {
                ProcessedMessage.$$$reportNull$$$0(0);
            }
            if (message == null) {
                ProcessedMessage.$$$reportNull$$$0(1);
            }
            this.myClangFormatURLs = clangFormatURLs;
            this.myFilteredMessage = message;
        }

        public List<String> getClangFormatURLs() {
            return this.myClangFormatURLs;
        }

        @NlsContexts.PopupContent
        public String getFilteredMessage() {
            return this.myFilteredMessage;
        }

        @NotNull
        @Contract(value="_, _ -> new")
        public static ProcessedMessage createProcessedMessage(@NotNull List<String> clangFormatURLs, @NotNull @NlsContexts.PopupContent String message) {
            if (clangFormatURLs == null) {
                ProcessedMessage.$$$reportNull$$$0(2);
            }
            if (message == null) {
                ProcessedMessage.$$$reportNull$$$0(3);
            }
            return new ProcessedMessage(clangFormatURLs, message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clangFormatURLs";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/format/ClangDaemonFormatProvider$ProcessedMessage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createProcessedMessage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

