/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clangFormat.components;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatFileUtils;
import com.jetbrains.clangFormat.ClangFormatUtils;
import com.jetbrains.clangFormat.settings.ClangFormatSettings;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClangFormatTracker
implements StartupActivity.DumbAware {
    @NonNls
    private static final String clangFormatFirstCheck = "cf.first.check.clang-format";

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            ClangFormatTracker.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ClangFormatTracker.activateClangFormatTracker(project, (Disposable)project);
    }

    public static void activateClangFormatTracker(@NotNull Project project, @NotNull Disposable disposable) {
        if (project == null) {
            ClangFormatTracker.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            ClangFormatTracker.$$$reportNull$$$0(2);
        }
        ClangFormatTracker.notifyClangdAboutFormatActivity(project, true);
        ClangFormatTracker.activateClangdTracker(project, disposable);
        ClangFormatTracker.activateClangFormatFileTracker(project, disposable);
        ClangFormatTracker.checkClangFormatIsOnByDefaultIfClangFormatFileExists(project);
    }

    private static void checkClangFormatIsOnByDefaultIfClangFormatFileExists(@NotNull Project project) {
        VirtualFile clangFormatRootDir;
        if (project == null) {
            ClangFormatTracker.$$$reportNull$$$0(3);
        }
        if ((clangFormatRootDir = ClangFormatUtils.getClangFormatRootDir(project)) != null && ClangFormatTracker.isFirstCheck(project) && !((ClangFormatSettings)CodeStyle.getSettings((Project)project).getCustomSettings(ClangFormatSettings.class)).ENABLED && (ClangFormatFileUtils.hasClangFormatFileInDirectory(clangFormatRootDir, ".clang-format") || ClangFormatFileUtils.hasClangFormatFileInDirectory(clangFormatRootDir, "_clang-format"))) {
            ApplicationManager.getApplication().invokeLater(() -> ClangFormatUtils.setClangFormatEnabled(project, true, true));
        }
    }

    private static boolean isFirstCheck(@NotNull Project project) {
        PropertiesComponent projectProperties;
        if (project == null) {
            ClangFormatTracker.$$$reportNull$$$0(4);
        }
        if (!(projectProperties = PropertiesComponent.getInstance((Project)project)).getBoolean(clangFormatFirstCheck, true)) {
            return false;
        }
        projectProperties.setValue(clangFormatFirstCheck, false, true);
        return true;
    }

    private static void activateClangdTracker(final @NotNull Project project, @NotNull Disposable disposable) {
        if (project == null) {
            ClangFormatTracker.$$$reportNull$$$0(5);
        }
        if (disposable == null) {
            ClangFormatTracker.$$$reportNull$$$0(6);
        }
        CodeStyleSettingsListener listener = event -> ClangFormatTracker.notifyClangdAboutFormatActivity(project, true);
        CodeStyleSettingsManager.getInstance((Project)project).addListener(listener);
        Disposer.register((Disposable)disposable, () -> {
            ClangFormatTracker.notifyClangdAboutFormatActivity(project, false);
            CodeStyleSettingsManager.removeListener((Project)project, (CodeStyleSettingsListener)listener);
        });
        project.getMessageBus().connect(disposable).subscribe(ClangdSettingsListener.TOPIC, (Object)new ClangdSettingsListener(){

            public void onClangdOnChanged(boolean clangdOn) {
                if (!clangdOn && ((ClangFormatSettings)CodeStyle.getSettings((Project)project).getCustomSettings(ClangFormatSettings.class)).ENABLED) {
                    ClangFormatUtils.setClangFormatEnabled(project, false, false);
                } else {
                    ClangFormatUtils.fireClangFormatChanged(project);
                }
            }
        });
        project.getMessageBus().connect(disposable).subscribe(EditorColorsManager.TOPIC, scheme -> {
            FileEditor[] editors = FileEditorManager.getInstance((Project)project).getAllEditors();
            FileDocumentManager documentManager = FileDocumentManager.getInstance();
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
            DocumentationComponent component = QuickDocUtil.getActiveDocComponent((Project)project);
            PsiFile documentedFile = component == null ? null : (component.getElement() == null ? null : component.getElement().getContainingFile());
            for (FileEditor editor : editors) {
                PsiFile file;
                Document document;
                VirtualFile virtualFile = editor.getFile();
                if (virtualFile == null || !ClangFormatFileUtils.isClangFormatConfig(virtualFile) || (document = documentManager.getDocument(virtualFile)) == null || (file = psiDocumentManager.getCachedPsiFile(document)) == null) continue;
                JsonCachedValues.OBJECT_FOR_FILE_KEY.set((UserDataHolder)file, null);
                if (documentedFile != file) continue;
                DocumentationManager.getInstance((Project)project).updateToolwindowContext();
            }
        });
    }

    private static void notifyClangdAboutFormatActivity(@NotNull Project project, boolean pluginOn) {
        if (project == null) {
            ClangFormatTracker.$$$reportNull$$$0(7);
        }
        if (project.isDisposed()) {
            return;
        }
        ClangFormatSettings cf = (ClangFormatSettings)CodeStyle.getSettings((Project)project).getCustomSettings(ClangFormatSettings.class);
        boolean formatViaClangd = cf.ENABLED && pluginOn;
        ClangdSettings clangdSettings = ClangdSettings.getInstance((Project)project);
        clangdSettings.setFormatViaClangd(formatViaClangd);
        if (formatViaClangd && ApplicationManager.getApplication().isUnitTestMode()) {
            clangdSettings.setClangdEnabled(true);
        }
    }

    public static void activateClangFormatFileTracker(final @NotNull Project project, @NotNull Disposable disposable) {
        if (project == null) {
            ClangFormatTracker.$$$reportNull$$$0(8);
        }
        if (disposable == null) {
            ClangFormatTracker.$$$reportNull$$$0(9);
        }
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ("name".equals(event.getPropertyName()) && (ClangFormatFileUtils.isClangFormatName((String)event.getNewValue()) || ClangFormatFileUtils.isClangFormatName((String)event.getOldValue()))) {
                    ClangFormatUtils.fireClangFormatChanged(project);
                }
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.notifyMaybeClangFormatFileChange(event);
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                this.notifyMaybeClangFormatFileChange(event);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(3);
                }
                this.notifyMaybeClangFormatFileChange(event);
            }

            private void notifyMaybeClangFormatFileChange(@NotNull VirtualFileEvent event) {
                VirtualFile vfChangedFile;
                if (event == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (ClangFormatFileUtils.isClangFormatConfig(vfChangedFile = event.getFile())) {
                    ClangFormatUtils.fireClangFormatChanged(project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/clangFormat/components/ClangFormatTracker$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "notifyMaybeClangFormatFileChange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/clangFormat/components/ClangFormatTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "activateClangFormatTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClangFormatIsOnByDefaultIfClangFormatFileExists";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isFirstCheck";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "activateClangdTracker";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyClangdAboutFormatActivity";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "activateClangFormatFileTracker";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

