/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.JdomKt;
import com.jetbrains.lang.makefile.MakeSettings;
import com.jetbrains.lang.makefile.MakefileProjectSettings;
import com.jetbrains.lang.makefile.MakefileRunConfigurationEditor;
import com.jetbrains.lang.makefile.MakefileRunConfigurationFactory;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001+B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0016R\u001a\u0010\n\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u001a\u0010\u001b\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000e\u00a8\u0006,"}, d2={"Lcom/jetbrains/lang/makefile/MakefileRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lcom/intellij/execution/configurations/RunProfileState;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/jetbrains/lang/makefile/MakefileRunConfigurationFactory;", "name", "", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/lang/makefile/MakefileRunConfigurationFactory;Ljava/lang/String;)V", "arguments", "getArguments", "()Ljava/lang/String;", "setArguments", "(Ljava/lang/String;)V", "environmentVariables", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "getEnvironmentVariables", "()Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "setEnvironmentVariables", "(Lcom/intellij/execution/configuration/EnvironmentVariablesData;)V", "filename", "getFilename", "setFilename", "target", "getTarget", "setTarget", "workingDirectory", "getWorkingDirectory", "setWorkingDirectory", "checkConfiguration", "", "getConfigurationEditor", "Lcom/jetbrains/lang/makefile/MakefileRunConfigurationEditor;", "getState", "executor", "Lcom/intellij/execution/Executor;", "executionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "Companion", "intellij.makefile"})
public final class MakefileRunConfiguration
extends LocatableConfigurationBase<RunProfileState> {
    @NotNull
    private String filename;
    @NotNull
    private String target;
    @NotNull
    private String workingDirectory;
    @NotNull
    private EnvironmentVariablesData environmentVariables;
    @NotNull
    private String arguments;
    @Deprecated
    @NotNull
    public static final String MAKEFILE = "makefile";
    @Deprecated
    @NotNull
    public static final String FILENAME = "filename";
    @Deprecated
    @NotNull
    public static final String TARGET = "target";
    @Deprecated
    @NotNull
    public static final String WORKING_DIRECTORY = "workingDirectory";
    @Deprecated
    @NotNull
    public static final String ARGUMENTS = "arguments";
    @NotNull
    private static final Companion Companion = new Companion(null);

    @NotNull
    public final String getFilename() {
        return this.filename;
    }

    public final void setFilename(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.filename = string;
    }

    @NotNull
    public final String getTarget() {
        return this.target;
    }

    public final void setTarget(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.target = string;
    }

    @NotNull
    public final String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final void setWorkingDirectory(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.workingDirectory = string;
    }

    @NotNull
    public final EnvironmentVariablesData getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public final void setEnvironmentVariables(@NotNull EnvironmentVariablesData environmentVariablesData) {
        Intrinsics.checkNotNullParameter((Object)environmentVariablesData, (String)"<set-?>");
        this.environmentVariables = environmentVariablesData;
    }

    @NotNull
    public final String getArguments() {
        return this.arguments;
    }

    public final void setArguments(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.arguments = string;
    }

    public void checkConfiguration() {
    }

    @NotNull
    public MakefileRunConfigurationEditor getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return new MakefileRunConfigurationEditor(project);
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        Element child = JdomKt.getOrCreate((Element)element, (String)MAKEFILE);
        child.setAttribute(FILENAME, this.filename);
        child.setAttribute(TARGET, this.target);
        child.setAttribute(WORKING_DIRECTORY, this.workingDirectory);
        child.setAttribute(ARGUMENTS, this.arguments);
        this.environmentVariables.writeExternal(child);
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        Element child = element.getChild(MAKEFILE);
        if (child != null) {
            String string;
            String string2;
            String string3;
            String string4 = child.getAttributeValue(FILENAME);
            if (string4 == null) {
                string4 = this.filename = "";
            }
            if ((string3 = child.getAttributeValue(TARGET)) == null) {
                string3 = this.target = "";
            }
            if ((string2 = child.getAttributeValue(WORKING_DIRECTORY)) == null) {
                string2 = this.workingDirectory = "";
            }
            if ((string = child.getAttributeValue(ARGUMENTS)) == null) {
                string = "";
            }
            this.arguments = string;
            EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.readExternal((Element)child);
            Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"EnvironmentVariablesData.readExternal(child)");
            this.environmentVariables = environmentVariablesData;
        }
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)executionEnvironment, (String)"executionEnvironment");
        MakeSettings makeSettings = ((MakefileProjectSettings)this.getProject().getService(MakefileProjectSettings.class)).getSettings();
        Object object = makeSettings;
        if (object == null || (object = ((MakeSettings)object).getPath()) == null) {
            object = "/usr/bin/make";
        }
        Object makePath = object;
        return (RunProfileState)new CommandLineState(this, (String)makePath, makeSettings, executionEnvironment, executionEnvironment){
            final /* synthetic */ MakefileRunConfiguration this$0;
            final /* synthetic */ String $makePath;
            final /* synthetic */ MakeSettings $makeSettings;
            final /* synthetic */ ExecutionEnvironment $executionEnvironment;

            @NotNull
            protected ProcessHandler startProcess() {
                Map map;
                String workDirectory;
                ParametersList params = new ParametersList();
                params.addParametersString(this.this$0.getArguments());
                PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.this$0.getProject()));
                Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"PathMacroManager.getInstance(project)");
                PathMacroManager macroManager = pathMacroManager;
                String path = macroManager.expandPath(this.this$0.getFilename());
                params.addAll(new String[]{"-f", path});
                CharSequence charSequence = this.this$0.getTarget();
                boolean bl = false;
                if (charSequence.length() > 0) {
                    params.addParametersString(this.this$0.getTarget());
                }
                CharSequence charSequence2 = this.this$0.getWorkingDirectory();
                boolean bl2 = false;
                String string = workDirectory = charSequence2.length() > 0 ? macroManager.expandPath(this.this$0.getWorkingDirectory()) : new File(path).getParent();
                if (this.this$0.getEnvironmentVariables().isPassParentEnvs()) {
                    Map map2 = EnvironmentUtil.getEnvironmentMap();
                    map = map2;
                    Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"EnvironmentUtil.getEnvironmentMap()");
                } else {
                    map = MapsKt.emptyMap();
                }
                Map parentEnvs = map;
                Map map3 = this.this$0.getEnvironmentVariables().getEnvs();
                Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"environmentVariables.envs");
                Map envs = MapsKt.plus((Map)parentEnvs, (Map)MapsKt.toMutableMap((Map)map3));
                Object[] objectArray = new String[]{this.$makePath};
                Object[] objectArray2 = params.getArray();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"params.array");
                Object[] command = (String[])ArraysKt.plus((Object[])objectArray, (Object[])objectArray2);
                try {
                    ExtensionPointName extensionPointName = LocalTerminalCustomizer.EP_NAME;
                    Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"LocalTerminalCustomizer.EP_NAME");
                    for (LocalTerminalCustomizer customizer : (LocalTerminalCustomizer[])extensionPointName.getExtensions()) {
                        try {
                            Intrinsics.checkNotNullExpressionValue((Object)customizer.customizeCommandAndEnvironment(this.this$0.getProject(), (String[])command, envs), (String)"customizer.customizeComm\u2026t(project, command, envs)");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable customizer) {
                    // empty catch block
                }
                MakeSettings makeSettings = this.$makeSettings;
                GeneralCommandLine generalCommandLine = new PtyCommandLine().withUseCygwinLaunch(makeSettings != null ? makeSettings.getUseCygwin() : false).withExePath(command[0]).withWorkDirectory(workDirectory).withEnvironment(envs).withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.NONE).withParameters(ArraysKt.slice((Object[])command, (IntRange)RangesKt.until((int)1, (int)command.length)));
                Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"PtyCommandLine()\n       \u2026ce(1 until command.size))");
                GeneralCommandLine cmd = generalCommandLine;
                ColoredProcessHandler processHandler = new ColoredProcessHandler(cmd);
                processHandler.setShouldKillProcessSoftly(true);
                ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)processHandler));
                return (ProcessHandler)processHandler;
            }
            {
                this.this$0 = this$0;
                this.$makePath = $captured_local_variable$1;
                this.$makeSettings = $captured_local_variable$2;
                this.$executionEnvironment = $captured_local_variable$3;
                super($super_call_param$4);
            }
        };
    }

    public MakefileRunConfiguration(@NotNull Project project, @NotNull MakefileRunConfigurationFactory factory, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)factory), (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(project, (ConfigurationFactory)factory, name);
        this.filename = "";
        this.target = "";
        this.workingDirectory = "";
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"EnvironmentVariablesData.DEFAULT");
        this.environmentVariables = environmentVariablesData;
        this.arguments = "";
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/lang/makefile/MakefileRunConfiguration$Companion;", "", "()V", "ARGUMENTS", "", "FILENAME", "MAKEFILE", "TARGET", "WORKING_DIRECTORY", "intellij.makefile"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

