/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.AdvancedClangFileFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.AdvancedClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.AdvancedClangIdeFacadeImpl$WhenMappings;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacadeUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClazyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangNamehintConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionGlobalCompletionCacheParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.daemon.clang.namehint.ClangInlayParameterHintsProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyUtil;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCSourceGliderService;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.ClazyInspection;
import com.jetbrains.cidr.lang.inspections.MisraInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.inspections.OCUnusedIncludeDirectiveInspection;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\nH\u0014J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001bH\u0002\u00a8\u0006\""}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/AdvancedClangIdeFacadeImpl;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIdeFacadeImpl;", "descriptor", "", "(Ljava/lang/String;)V", "getClangTidyConfig", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionClangTidyConfigParams;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiFile;", "takeOurClangTidyConfig", "", "getClazyConfig", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/CLionClazyConfigParams;", "getDFAOptions", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionClangDFAConfigParams;", "getFileFacade", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangFileFacade;", "document", "Lcom/intellij/openapi/editor/Document;", "getGlobalCompletionCacheParams", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionGlobalCompletionCacheParams;", "getNamehintConfig", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionClangNamehintConfigParams;", "getOCPsiFile", "Lcom/jetbrains/cidr/lang/psi/OCPsiFile;", "getResolveInfoForFile", "Lcom/jetbrains/cidr/lang/daemon/clang/ClangUtils$ResolveInfo;", "vf", "getUnusedIncludesInspectionMode", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/UnusedIncludesInspectionMode;", "ocFile", "intellij.c.clangdBridge"})
public class AdvancedClangIdeFacadeImpl
extends ClangIdeFacadeImpl {
    @NotNull
    public ClangFileFacade getFileFacade(@NotNull VirtualFile file, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return new AdvancedClangFileFacadeImpl(file, document);
    }

    @Nullable
    protected ClangUtils.ResolveInfo getResolveInfoForFile(@NotNull Project project, @NotNull VirtualFile vf) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vf, (String)"vf");
        OCPsiFile ocFile = this.getOCPsiFile(project, vf);
        if (ocFile != null) {
            return ClangIdeFacadeUtil.Companion.getInstance().getResolveInfoForFile(project, ocFile, vf);
        }
        return super.getResolveInfoForFile(project, vf);
    }

    @Nullable
    public UnusedIncludesInspectionMode getUnusedIncludesInspectionMode(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        OCPsiFile ocFile = this.getOCPsiFile(project, file);
        if (ocFile == null) {
            ClangUtils.warnClangd((Logger)CidrLogService.LOG, (String)("Failed to get OCPsiFile for file " + file.getPath()));
            return null;
        }
        return this.getUnusedIncludesInspectionMode(ocFile);
    }

    @Nullable
    public CLionClazyConfigParams getClazyConfig(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        OCPsiFile ocFile = this.getOCPsiFile(project, file);
        if (ocFile == null) {
            ClangUtils.warnClangd((Logger)CidrLogService.LOG, (String)("Failed to get OCPsiFile for file " + file.getPath()));
            return null;
        }
        ClazyInspection inspection = ClangTidyUtil.getClazyInspection((PsiFile)ocFile, project);
        return inspection != null && ClangTidyUtil.isToolEnabled((LocalInspectionTool)inspection, (PsiFile)ocFile, project) ? new CLionClazyConfigParams(inspection.getClazyChecks()) : null;
    }

    @Nullable
    public ClionClangDFAConfigParams getDFAOptions(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        Optional dfaConfigParams = (Optional)project.getUserData(ClangIdeFacadeImpl.CLANG_DFA_CONFIG);
        if (dfaConfigParams != null) {
            return dfaConfigParams.isEmpty() ? null : (ClionClangDFAConfigParams)dfaConfigParams.get();
        }
        return psiFile != null && OCInspectionUtil.isClangdDFAEnabled((PsiElement)((PsiElement)psiFile)) ? new ClionClangDFAConfigParams(OCSourceGliderService.isGlobalMode((PsiFile)psiFile)) : null;
    }

    @Nullable
    public ClionGlobalCompletionCacheParams getGlobalCompletionCacheParams(@NotNull Project project, @NotNull VirtualFile file) {
        ClangdSettings settings;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ClangdSettings clangdSettings = settings = ClangdSettings.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)clangdSettings, (String)"settings");
        return new ClionGlobalCompletionCacheParams(clangdSettings.getGlobalCompletionCacheEnabled());
    }

    private final OCPsiFile getOCPsiFile(Project project, VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            ClangUtils.warnClangd((Logger)CidrLogService.LOG, (String)("Failed to get PSI file for file: " + file.getPath()));
            return null;
        }
        OCPsiFile ocFile = OCLanguageUtils.asOCPsiFile((PsiFile)psiFile);
        if (ocFile == null) {
            ClangUtils.warnClangd((Logger)CidrLogService.LOG, (String)("PSI file is not OCPsiFile: " + file.getPath()));
            return null;
        }
        return ocFile;
    }

    @Nullable
    public ClionClangTidyConfigParams getClangTidyConfig(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        OCPsiFile ocFile = this.getOCPsiFile(project, file);
        if (ocFile == null) {
            ClangUtils.warnClangd((Logger)CidrLogService.LOG, (String)("Failed to get OCPsiFile for file " + file.getPath()));
            return null;
        }
        ClangTidyInspection inspection = ClangTidyUtil.getInspection((PsiFile)ocFile, project);
        if (inspection == null) {
            ClangUtils.warnClangd((Logger)CidrLogService.LOG, (String)"Failed to get 'preferClangTidyFilesOverIDESettings' option, default one will be used");
        }
        ClangTidyInspection clangTidyInspection = inspection;
        boolean preferClangTidyFilesOverIDESettings = clangTidyInspection != null ? clangTidyInspection.isPreferClangTidyFilesOverIDESettings() : false;
        String clangTidyConfig = this.getClangTidyConfig(project, (PsiFile)ocFile, false);
        String ourClangTidyConfig = this.getClangTidyConfig(project, (PsiFile)ocFile, true);
        return StringUtil.isEmpty((String)clangTidyConfig) && StringUtil.isEmpty((String)ourClangTidyConfig) ? null : new ClionClangTidyConfigParams(ourClangTidyConfig, clangTidyConfig, preferClangTidyFilesOverIDESettings);
    }

    @NotNull
    public ClionClangNamehintConfigParams getNamehintConfig() {
        ClangInlayParameterHintsProvider inlayProvider = ClangInlayParameterHintsProvider.Companion.getInstance();
        return new ClionClangNamehintConfigParams(inlayProvider.isEnabled(), inlayProvider.isShowHintsForEnumConstants().get(), inlayProvider.isShowHintsForConstructorExpressions().get(), inlayProvider.isShowHintsForMacroExpressions().get(), inlayProvider.isShowHintsForNonConstReferences().get());
    }

    private final UnusedIncludesInspectionMode getUnusedIncludesInspectionMode(OCPsiFile ocFile) {
        Class<OCUnusedIncludeDirectiveInspection> inspectionClass = OCUnusedIncludeDirectiveInspection.class;
        if (!OCInspectionUtil.isInspectionEnabled((Project)ocFile.getProject(), inspectionClass)) {
            return UnusedIncludesInspectionMode.Off;
        }
        if (Intrinsics.areEqual(inspectionClass, OCUnusedIncludeDirectiveInspection.class)) {
            HighlightDisplayKey key;
            String shortName = OCInspectionUtil.getInspectionShortName(inspectionClass);
            HighlightDisplayKey highlightDisplayKey = key = shortName != null ? HighlightDisplayKey.find((String)shortName) : null;
            if (key != null) {
                InspectionProjectProfileManager inspectionProjectProfileManager = InspectionProjectProfileManager.getInstance((Project)ocFile.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)inspectionProjectProfileManager, (String)"InspectionProjectProfile\u2026tInstance(ocFile.project)");
                InspectionProfileImpl inspectionProfileImpl = inspectionProjectProfileManager.getCurrentProfile();
                Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"InspectionProjectProfile\u2026e.project).currentProfile");
                InspectionProfile inspectionProfile = (InspectionProfile)inspectionProfileImpl;
                InspectionToolWrapper tool = inspectionProfile.getInspectionTool(key.toString(), ocFile.getProject());
                if (tool != null && tool.getTool() instanceof OCUnusedIncludeDirectiveInspection) {
                    UnusedIncludesInspectionMode unusedIncludesInspectionMode;
                    InspectionProfileEntry inspectionProfileEntry = tool.getTool();
                    if (inspectionProfileEntry == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.cidr.lang.inspections.OCUnusedIncludeDirectiveInspection");
                    }
                    OCUnusedIncludeDirectiveInspection inspection = (OCUnusedIncludeDirectiveInspection)inspectionProfileEntry;
                    if (!inspection.showInHeaders && ocFile.isHeader()) {
                        unusedIncludesInspectionMode = UnusedIncludesInspectionMode.Off;
                    } else {
                        switch (AdvancedClangIdeFacadeImpl$WhenMappings.$EnumSwitchMapping$0[inspection.strategy.ordinal()]) {
                            case 1: {
                                unusedIncludesInspectionMode = UnusedIncludesInspectionMode.RemoveCompletelyUnused;
                                break;
                            }
                            case 2: {
                                unusedIncludesInspectionMode = UnusedIncludesInspectionMode.RemoveNotDirectlyUsed;
                                break;
                            }
                            case 3: {
                                unusedIncludesInspectionMode = UnusedIncludesInspectionMode.RemoveNotRequired;
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    return unusedIncludesInspectionMode;
                }
            }
        }
        return UnusedIncludesInspectionMode.RemoveNotDirectlyUsed;
    }

    private final String getClangTidyConfig(Project project, PsiFile file, boolean takeOurClangTidyConfig) {
        String string;
        List forcedOptions;
        String forcedConfig = (String)project.getUserData(takeOurClangTidyConfig ? ClangIdeFacadeImpl.CLION_CLANG_TIDY_CONFIG : ClangIdeFacadeImpl.CLANG_TIDY_CONFIG);
        List list = forcedOptions = takeOurClangTidyConfig ? (List)project.getUserData(ClangIdeFacadeImpl.CLION_CLANG_TIDY_OPTIONS) : null;
        if (forcedConfig != null) {
            List list2 = forcedOptions;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            return ClangTidyUtil.getClangTidyConfig(forcedConfig, list2);
        }
        if (!ClangUtils.isClangTidyViaClangdOn((Project)project) || ClangTidyUtil.getCustomClangTidyPath() != null) {
            return null;
        }
        if (takeOurClangTidyConfig) {
            List<OurClangTidyInspection> list3 = ClangTidyUtil.getOurInspections(true, file, project);
            Intrinsics.checkNotNullExpressionValue(list3, (String)"ClangTidyUtil.getOurInsp\u2026ions(true, file, project)");
            List<OurClangTidyInspection> ourClangTidyInspections = list3;
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new String[]{"-*"});
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"ContainerUtil.newArrayList(\"-*\")");
            List checks = arrayList;
            List list4 = ContainerUtil.map((Collection)ourClangTidyInspections, (Function)getClangTidyConfig.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"ContainerUtil.map(ourCla\u2026ection -> obj.checkName }");
            checks.addAll(list4);
            List checkOptions = new ArrayList();
            Iterator<OurClangTidyInspection> iterator = ourClangTidyInspections.iterator();
            while (iterator.hasNext()) {
                OurClangTidyInspection inspection;
                OurClangTidyInspection ourClangTidyInspection = inspection = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)ourClangTidyInspection), (String)"inspection");
                List<ClangTidyCheckOption> list5 = ourClangTidyInspection.getClangTidyCheckOptions();
                Intrinsics.checkNotNullExpressionValue(list5, (String)"inspection.clangTidyCheckOptions");
                checkOptions.addAll((Collection)list5);
            }
            MisraInspection misraInspection = ClangTidyUtil.getMisraInspection(file, project);
            if (misraInspection != null && ClangTidyUtil.isToolEnabled((LocalInspectionTool)misraInspection, file, project)) {
                checks.add(misraInspection.getAllMisraChecks());
            }
            string = ClangTidyUtil.getClangTidyConfig(StringUtil.join((Collection)checks, (String)","), checkOptions);
        } else {
            ClangTidyInspection clangTidyInspection = ClangTidyUtil.getInspection(file, project);
            if (clangTidyInspection != null) {
                if (!ClangTidyUtil.isToolEnabled((LocalInspectionTool)clangTidyInspection, file, project)) {
                    return null;
                }
                String string2 = ClangTidyUtil.concatClangTidyChecks(clangTidyInspection.getClangTidyChecks(), "-clion-*");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ClangTidyUtil.concatClan\u2026ngTidyChecks, \"-clion-*\")");
                String checks = string2;
                return ClangTidyUtil.getClangTidyConfig(checks, clangTidyInspection.getClangTidyCheckOptions());
            }
            string = ClangTidyUtil.getClangTidyConfig("-clion-*", ContainerUtil.emptyList());
        }
        return string;
    }

    public AdvancedClangIdeFacadeImpl(@NotNull String descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        super(descriptor);
    }
}

