/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.ExternalResolveUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.psi.impl.OCQualifiedExpressionImpl;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClionXRefAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)ClionXRefAction.class.getName());
    private static final boolean INCLUDE_PARSE_TIME = false;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ClionXRefAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) != null) {
            AtomicLong totalClangTime = new AtomicLong();
            AtomicLong totalClionTime = new AtomicLong();
            Stream<VirtualFile> files = this.getFiles(project, e.getDataContext()).stream().limit(Registry.get((String)"clion.clang.xref.limit").asInteger());
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted((Project)project);
                files.forEach(file -> {
                    PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)project).findFile(file));
                    if (OCLanguageUtils.isSupported((PsiFile)psiFile)) {
                        SimpleOpenRequestId temporaryOpenId = new SimpleOpenRequestId(ClionXRefAction.class, "XRef action for " + file.getPath());
                        try {
                            service.notifyDocumentOpened(file, (OpenRequestId)temporaryOpenId);
                            AtomicInteger clionRefsCounter = new AtomicInteger();
                            Runnable clionXRef = () -> new XRefVisitor(true, clionRefsCounter).visitFile(psiFile);
                            AtomicInteger clangRefsCounter = new AtomicInteger();
                            Runnable clangXRef = () -> new XRefVisitor(false, clangRefsCounter).visitFile(psiFile);
                            LOG.warn("START CLION XREF [" + file.getName() + "] ");
                            WriteAction.runAndWait(() -> {
                                PsiManager.getInstance((Project)project).dropPsiCaches();
                                PsiManager.getInstance((Project)project).dropResolveCaches();
                            });
                            ClangUtils.forceClangdNavigationOff((Project)project);
                            long clionTime = ClionXRefAction.measure(clionXRef);
                            LOG.warn("START CLANG XREF [" + file.getName() + "] ");
                            WriteAction.runAndWait(() -> {
                                PsiManager.getInstance((Project)project).dropPsiCaches();
                                PsiManager.getInstance((Project)project).dropResolveCaches();
                            });
                            long clangTime = (Long)service.computeWithParsed(file, response -> {
                                try {
                                    long result2;
                                    if (response != null) {
                                        LOG.warn("REPARSING FILE [" + file.getName() + "] WITH CLANG (this time is excluded from results)");
                                        response.getDiagnostics().get();
                                        response.getTidyDiagnostics().get();
                                        response.getOurTidyDiagnostics().get();
                                        response.getNamehints().get();
                                        LOG.warn("REPARSING FINISHED");
                                        ClangUtils.forceClangdNavigationOn((Project)project);
                                        result2 = ClionXRefAction.measure(clangXRef);
                                        ClangUtils.stopForcingClangdNavigation((Project)project);
                                    } else {
                                        LOG.warn("Failed to reparse [" + file.getName() + "]");
                                        result2 = clionTime;
                                    }
                                    return result2;
                                }
                                catch (InterruptedException | ExecutionException ex) {
                                    throw new RuntimeException(ex);
                                }
                            });
                            LOG.warn("File [" + file.getName() + "]: clang(" + clangRefsCounter.get() + " refs) " + clangTime + "ms vs clion(" + clionRefsCounter.get() + " refs) " + clionTime + "ms");
                            totalClangTime.addAndGet(clangTime);
                            totalClionTime.addAndGet(clionTime);
                        }
                        catch (Exception ex) {
                            if (!(ex instanceof ControlFlowException)) {
                                LOG.error((Throwable)ex);
                            }
                        }
                        finally {
                            service.notifyDocumentClosed(file, (OpenRequestId)temporaryOpenId);
                        }
                    }
                });
                LOG.warn("Total: clang " + totalClangTime.get() + "ms vs clion " + totalClionTime.get() + "ms");
                if (totalClangTime.get() <= totalClionTime.get()) {
                    LOG.warn("Clang saved " + (totalClionTime.get() - totalClangTime.get()) + "ms");
                } else {
                    LOG.warn("Clang used " + (totalClangTime.get() - totalClionTime.get()) + "ms more");
                }
            });
        }
    }

    @NotNull
    protected Collection<VirtualFile> getFiles(@NotNull Project project, @NotNull DataContext context) {
        if (project == null) {
            ClionXRefAction.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ClionXRefAction.$$$reportNull$$$0(2);
        }
        Collection collection = (Collection)ReadAction.compute(() -> OCSearchScope.getExplicitlySpecifiedProjectSourceFiles((Project)project));
        if (collection == null) {
            ClionXRefAction.$$$reportNull$$$0(3);
        }
        return collection;
    }

    private static long measure(@NotNull Runnable what) {
        if (what == null) {
            ClionXRefAction.$$$reportNull$$$0(4);
        }
        return (Long)ReadAction.compute(() -> {
            long before = System.currentTimeMillis();
            what.run();
            long after = System.currentTimeMillis();
            return after - before;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClionXRefAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClionXRefAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "measure";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class XRefVisitor
    extends PsiRecursiveElementVisitor {
        final AtomicInteger myRefCounter;
        final boolean myTrueResolve;

        private XRefVisitor(boolean trueResolve, @Nullable AtomicInteger refCounter) {
            this.myTrueResolve = trueResolve;
            this.myRefCounter = refCounter;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                XRefVisitor.$$$reportNull$$$0(0);
            }
            OCReferenceElementImpl ref = null;
            if (element instanceof OCReferenceElementImpl) {
                ref = (OCReferenceElementImpl)element;
            } else if (element instanceof OCQualifiedExpressionImpl) {
                ref = element.getReference();
            } else {
                PsiReference elementRef = element.getReference();
                if (elementRef instanceof OCOperatorReference) {
                    ref = elementRef;
                }
            }
            if (ref != null) {
                if (this.myRefCounter != null) {
                    this.myRefCounter.incrementAndGet();
                }
                if (this.myTrueResolve) {
                    ref.resolve();
                } else {
                    ExternalResolveUtils.resolveSymbol((PsiReference)ref);
                }
            }
            super.visitElement(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClionXRefAction$XRefVisitor", "visitElement"));
        }
    }
}

