/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionLineMarker;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionLineMarkerKind;
import com.jetbrains.cidr.lang.daemon.clang.clangd.navigation.ClangNaiveGotoActionSync;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import icons.CidrLangIcons;
import javax.swing.Icon;
import org.eclipse.lsp4j.SymbolKind;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClangLineMarkerInfo
extends LineMarkerInfo<PsiElement> {
    public ClangLineMarkerInfo(@NotNull PsiElement element, @NotNull ClionLineMarker marker) {
        if (element == null) {
            ClangLineMarkerInfo.$$$reportNull$$$0(0);
        }
        if (marker == null) {
            ClangLineMarkerInfo.$$$reportNull$$$0(1);
        }
        super(element, OCElementUtil.getTextRangeWithoutComments((PsiElement)element), ClangLineMarkerInfo.getIcon(marker.getKind()), psiElement -> ClangLineMarkerInfo.getActionName(marker), ClangLineMarkerInfo.createNavigationHandler(element, marker), GutterIconRenderer.Alignment.RIGHT, () -> ClangLineMarkerInfo.getActionName(marker));
    }

    @NotNull
    private static Icon getIcon(@NotNull ClionLineMarkerKind kind) {
        if (kind == null) {
            ClangLineMarkerInfo.$$$reportNull$$$0(2);
        }
        switch (kind) {
            case DECL_DEF: {
                Icon icon = CidrLangIcons.AssocFile;
                if (icon == null) {
                    ClangLineMarkerInfo.$$$reportNull$$$0(3);
                }
                return icon;
            }
            case DIRECT_CHILDREN: 
            case ALL_CHILDREN: {
                Icon icon = AllIcons.Gutter.OverridenMethod;
                if (icon == null) {
                    ClangLineMarkerInfo.$$$reportNull$$$0(4);
                }
                return icon;
            }
            case DIRECT_PARENTS: 
            case ALL_PARENTS: {
                Icon icon = AllIcons.Gutter.OverridingMethod;
                if (icon == null) {
                    ClangLineMarkerInfo.$$$reportNull$$$0(5);
                }
                return icon;
            }
        }
        throw new AssertionError((Object)("Unexpected marker kind: " + kind));
    }

    @Nls
    @NotNull
    private static String getActionName(@NotNull ClionLineMarker marker) {
        if (marker == null) {
            ClangLineMarkerInfo.$$$reportNull$$$0(6);
        }
        CLionSymbolInformation sourceSymbol = marker.getSource();
        CLionSymbolInformation targetSymbol = (CLionSymbolInformation)marker.getTargets().get(0);
        switch (marker.getKind()) {
            case DIRECT_PARENTS: 
            case ALL_PARENTS: {
                switch (sourceSymbol.getKind()) {
                    case Method: {
                        String string = OCBundle.message((String)"goto.super.type.name1", (Object[])new Object[]{StringUtil.decapitalize((String)sourceSymbol.getKind().toString()), "`" + targetSymbol.getContainerName() + "`"});
                        if (string == null) {
                            ClangLineMarkerInfo.$$$reportNull$$$0(7);
                        }
                        return string;
                    }
                    case Constructor: 
                    case Function: {
                        String string = OCBundle.message((String)"goto.super.type.name2", (Object[])new Object[]{targetSymbol.getContainerName()});
                        if (string == null) {
                            ClangLineMarkerInfo.$$$reportNull$$$0(8);
                        }
                        return string;
                    }
                }
                String string = OCBundle.message((String)"goto.super.type.name3", (Object[])new Object[0]);
                if (string == null) {
                    ClangLineMarkerInfo.$$$reportNull$$$0(9);
                }
                return string;
            }
            case DIRECT_CHILDREN: 
            case ALL_CHILDREN: {
                SymbolKind sourceKind = sourceSymbol.getKind();
                if (sourceKind == SymbolKind.Class || sourceKind == SymbolKind.Struct) {
                    String string = OCBundle.message((String)"goto.subclass", (Object[])new Object[0]);
                    if (string == null) {
                        ClangLineMarkerInfo.$$$reportNull$$$0(10);
                    }
                    return string;
                }
                if (sourceKind == SymbolKind.Method) {
                    String string = OCBundle.message((String)"goto.overridden.methods", (Object[])new Object[0]);
                    if (string == null) {
                        ClangLineMarkerInfo.$$$reportNull$$$0(11);
                    }
                    return string;
                }
                String string = OCBundle.message((String)"goto.overridden.functions", (Object[])new Object[0]);
                if (string == null) {
                    ClangLineMarkerInfo.$$$reportNull$$$0(12);
                }
                return string;
            }
        }
        return "";
    }

    @NotNull
    private static GutterIconNavigationHandler<PsiElement> createNavigationHandler(@NotNull PsiElement element, @NotNull ClionLineMarker marker) {
        if (element == null) {
            ClangLineMarkerInfo.$$$reportNull$$$0(13);
        }
        if (marker == null) {
            ClangLineMarkerInfo.$$$reportNull$$$0(14);
        }
        String actionName = ClangLineMarkerInfo.getActionName(marker);
        ClangNaiveGotoActionSync action = new ClangNaiveGotoActionSync(actionName, ClangLineMarkerInfo.getIcon(marker.getKind()), element.getProject(), element, marker.getTargets());
        GutterIconNavigationHandler gutterIconNavigationHandler = (e, elt) -> action.navigate(e, null);
        if (gutterIconNavigationHandler == null) {
            ClangLineMarkerInfo.$$$reportNull$$$0(15);
        }
        return gutterIconNavigationHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/navigation/ClangLineMarkerInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/navigation/ClangLineMarkerInfo";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createNavigationHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createNavigationHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

