/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.PresentableId;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.SshConfigCredentialsHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ui.RemoteSdkUpdatedCallback;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.process.CapturingSshProcessHandler;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.ssh.process.SshProcess;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.RemoteSdkSessionUtil;
import com.jetbrains.plugins.remotesdk.RemoteTransfer;
import com.jetbrains.plugins.remotesdk.SshConfigCredentialsType;
import com.jetbrains.plugins.remotesdk.SshCredentialsType;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsType;
import com.jetbrains.plugins.remotesdk.WebDeploymentCredentialsType;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JTextField;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteSdkUtil {
    private static final Logger LOG = Logger.getInstance(RemoteSdkUtil.class);
    public static final long TEST_CONNECTION_POLL_TIMEOUT = 100L;
    private static final int MAX_CREATE_DIR_ATTEMPTS = 5;
    public static final long TEST_CONNECTION_TIMEOUT = 10L;
    @NlsSafe
    public static final String DEFAULT_PYCHARM_HELPERS_PATH_ON_DOCKER = "/opt/.pycharm_helpers";

    private RemoteSdkUtil() {
    }

    public static void createFromRemoteCredentials(@NotNull WebServerConfig server, @NotNull RemoteCredentials data) {
        if (server == null) {
            RemoteSdkUtil.$$$reportNull$$$0(0);
        }
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(1);
        }
        FileTransferConfig config = server.getFileTransferConfig();
        config.setAccessType(AccessType.SFTP);
        config.setHost(data.getHost());
        config.setLiteralPort(data.getLiteralPort());
        config.setAnonymous(false);
        config.setAuthType(data.getAuthType());
        config.setPrivateKeyFile(data.getPrivateKeyFile());
        WebDeploymentCredentialHelper.saveCredentials((WebServerConfig)server, (String)data.getUserName(), (String)RemoteSdkUtil.getDataPassword(data), (boolean)RemoteSdkUtil.isMemoryOnly(data));
    }

    @Nullable
    private static String getDataPassword(@NotNull RemoteCredentials data) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(2);
        }
        switch (data.getAuthType()) {
            case PASSWORD: {
                return data.getPassword();
            }
            case KEY_PAIR: {
                return data.getPassphrase();
            }
        }
        return null;
    }

    private static boolean isMemoryOnly(@NotNull RemoteCredentials data) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(3);
        }
        switch (data.getAuthType()) {
            case PASSWORD: {
                return !data.isStorePassword();
            }
            case KEY_PAIR: {
                return !data.isStorePassphrase();
            }
        }
        return true;
    }

    @NotNull
    public static List<WebServerConfig> getSftpServerList(@Nullable Project project) {
        List config = GroupedServersConfigManager.getInstance((Project)project).getFlattenedServers();
        Predicate filter = input -> input != null && input.getFileTransferConfig().getAccessType() == AccessType.SFTP;
        ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.filter((Iterable)config, (Predicate)filter));
        if (arrayList == null) {
            RemoteSdkUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public static List<SshConfig> getSshConfigList(@Nullable Project project) {
        List list = SshConfigManager.getInstance((Project)project).getConfigs();
        if (list == null) {
            RemoteSdkUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    public static boolean testConnectionAndCreateHelpersPath(@Nullable Project project, @NotNull RemoteSdkCredentials data, @NlsContexts.DialogTitle String title) throws RemoteCancelledException, FileSystemException {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(6);
        }
        return RemoteSdkUtil.testConnectionAndCreateHelpersPath(project, data, title, null);
    }

    public static boolean testConnection(@Nullable Project project, @NotNull RemoteCredentials data) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(7);
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            return RemoteSdkUtil.testConnectionFromEDT(project, data);
        }
        return RemoteSdkUtil.testConnectionFromNonEDT(project, data);
    }

    private static boolean testConnectionFromEDT(final @Nullable Project project, final @NotNull RemoteCredentials data) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(8);
        }
        @NlsContexts.DialogTitle String title = RemoteSdkBundle.message("connecting.to", String.format("%s@%s:%s", data.getUserName(), data.getHost(), data.getPort()));
        return (Boolean)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Boolean, RuntimeException>(project, title, true){

            @NotNull
            protected Boolean compute(@NotNull ProgressIndicator indicator) throws RuntimeException {
                Boolean bl;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    bl = RemoteSdkUtil.doTestConnection(project, data, 10L, TimeUnit.SECONDS);
                }
                catch (RuntimeException e) {
                    LOG.warn((Throwable)e);
                    Boolean bl2 = false;
                    if (bl2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return bl2;
                }
                if (bl == null) {
                    1.$$$reportNull$$$0(1);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "compute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "compute";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static boolean testConnectionFromNonEDT(@Nullable Project project, @NotNull RemoteCredentials data) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(9);
        }
        Future result = ApplicationManager.getApplication().executeOnPooledThread(() -> RemoteSdkUtil.doTestConnection(project, data, 10L, TimeUnit.SECONDS));
        try {
            return (Boolean)result.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn((Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
        }
        catch (TimeoutException e) {
            LOG.warn((Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean doTestConnection(@Nullable Project project, @NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(10);
        }
        if (timeUnit == null) {
            RemoteSdkUtil.$$$reportNull$$$0(11);
        }
        try {
            void timeUnit2;
            return RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data, (Project)project).connect(timeout, (TimeUnit)timeUnit2).isConnected();
        }
        catch (SshTransportException sshTransportException) {
            return false;
        }
    }

    public static boolean testConnectionAndCreateHelpersPath(final @Nullable Project project, final @NotNull RemoteSdkCredentials data, @NlsContexts.DialogTitle String title, final @Nullable RemoteSdkUpdatedCallback updatedCallback) throws FileSystemException, RemoteCancelledException {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(12);
        }
        final Ref error = new Ref();
        final Ref result = new Ref();
        result.set((Object)false);
        Task.Modal task = new Task.Modal(project, title, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    2.$$$reportNull$$$0(0);
                }
                Semaphore done = new Semaphore();
                done.down();
                EventDispatcher forceDisconnectDispatcher = EventDispatcher.create(ForceDisconnectListener.class);
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        pi.setText(RemoteSdkBundle.message("connecting.to", data.getHost()));
                        RemoteSdkUtil.checkInterpreterAndCreateHelpersDir(project, data, (Ref<? super Exception>)error, (Ref<? super Boolean>)result, updatedCallback);
                    }
                    finally {
                        done.up();
                    }
                });
                try {
                    ProgressIndicatorUtils.awaitWithCheckCanceled((Semaphore)done, (ProgressIndicator)pi);
                }
                finally {
                    ((ForceDisconnectListener)forceDisconnectDispatcher.getMulticaster()).forceDisconnect();
                }
            }

            public void onCancel() {
                error.set((Object)new RemoteCancelledException(RemoteSdkBundle.message("dialog.message.connection.was.canceled", new Object[0])));
            }

            public void onThrowable(@NotNull Throwable err) {
                Exception ex;
                if (err == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((ex = (Exception)ObjectUtils.tryCast((Object)err, Exception.class)) == null) {
                    ex = new Exception(err);
                }
                error.set((Object)ex);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pi";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "err";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ProgressManager.getInstance().run((Task)task));
        } else {
            task.run(ProgressManager.getInstance().getProgressIndicator());
        }
        if (!error.isNull()) {
            Exception exception = (Exception)error.get();
            if (exception instanceof RemoteCancelledException) {
                throw (RemoteCancelledException)exception;
            }
            if (exception instanceof FileSystemException) {
                throw (FileSystemException)exception;
            }
            throw new FileSystemException("Exception:", (Throwable)exception);
        }
        return (Boolean)result.get();
    }

    public static boolean checkInterpreterAndCreateHelpersDir(@Nullable Project project, @NotNull RemoteSdkCredentials sdkCredentials, @NotNull Ref<? super Exception> error, @NotNull Ref<? super Boolean> result, @Nullable RemoteSdkUpdatedCallback updateCallback) {
        if (sdkCredentials == null) {
            RemoteSdkUtil.$$$reportNull$$$0(13);
        }
        if (error == null) {
            RemoteSdkUtil.$$$reportNull$$$0(14);
        }
        if (result == null) {
            RemoteSdkUtil.$$$reportNull$$$0(15);
        }
        try {
            SftpChannel channel = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)sdkCredentials, (Project)project).withConnectionTimeout(0L).openSftpChannel(60);
            return RemoteSdkUtil.checkInterpreterAndCreateHelpersDir(sdkCredentials, error, result, updateCallback, channel);
        }
        catch (Exception e) {
            error.set((Object)new CustomFileSystemException(e.getMessage(), (Throwable)e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkInterpreterAndCreateHelpersDir(@NotNull RemoteSdkCredentials sdkCredentials, @NotNull Ref<? super Exception> error, @NotNull Ref<? super Boolean> result, @Nullable RemoteSdkUpdatedCallback updateCallback, @NotNull SftpChannel sftpChannel) throws SshTransportException {
        if (sdkCredentials == null) {
            RemoteSdkUtil.$$$reportNull$$$0(16);
        }
        if (error == null) {
            RemoteSdkUtil.$$$reportNull$$$0(17);
        }
        if (result == null) {
            RemoteSdkUtil.$$$reportNull$$$0(18);
        }
        if (sftpChannel == null) {
            RemoteSdkUtil.$$$reportNull$$$0(19);
        }
        try {
            String interpreterPath = sdkCredentials.getInterpreterPath();
            String pathForHelpers = sdkCredentials.getHelpersPath();
            if (updateCallback != null) {
                RemoteFileObject fileObject = sftpChannel.file(interpreterPath);
                if (!fileObject.exists() || fileObject.isDir()) {
                    error.set((Object)new CustomFileSystemException("Interpreter '" + interpreterPath + "' doesn't exist on remote server"));
                    boolean bl = false;
                    return bl;
                }
                if (!StringUtil.isEmpty((String)pathForHelpers)) {
                    fileObject = sftpChannel.file(pathForHelpers);
                    if (!fileObject.exists() || !fileObject.isDir()) {
                        error.set((Object)new CustomFileSystemException("Directory '" + pathForHelpers + "' doesn't exist on remote server"));
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    Object path = new RemoteFile(sftpChannel.getHome(), sdkCredentials.getDefaultHelpersName()).getPath();
                    sdkCredentials.setHelpersPath((String)path);
                    int i = 0;
                    while (true) {
                        ProgressManager.checkCanceled();
                        fileObject = sftpChannel.file((String)path);
                        if (fileObject.exists() && fileObject.isDir()) break;
                        try {
                            fileObject.mkdir();
                            sdkCredentials.setHelpersPath((String)path);
                        }
                        catch (Exception e) {
                            path = sdkCredentials.getHelpersPath() + "_" + ++i;
                            if (i <= 5) continue;
                            throw e;
                        }
                        break;
                    }
                    updateCallback.updated(sdkCredentials);
                }
            }
            result.set((Object)true);
            boolean bl = true;
            return bl;
        }
        finally {
            sftpChannel.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ensureCanWriteFile(@NotNull ConnectionOwner connectionOwner, @NotNull RemoteSdkCredentials data, @NotNull String path) {
        boolean bl;
        if (connectionOwner == null) {
            RemoteSdkUtil.$$$reportNull$$$0(20);
        }
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(21);
        }
        if (path == null) {
            RemoteSdkUtil.$$$reportNull$$$0(22);
        }
        SftpChannel sftp = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data).withConnectionTimeout(60L).openSftpChannel(60);
        try {
            RemoteFileObject fileObject = sftp.file(path);
            bl = (fileObject.getPermissions() & 0x80) != 0 && fileObject.getUId() != 0;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    sftp.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    return true;
                }
            }
            sftp.close();
            return bl2;
        }
        sftp.close();
        return bl;
    }

    public static CredentialsDeployable createDeployable(RemoteCredentials data) {
        CredentialsDeployable config = new CredentialsDeployable(data);
        config.setName(RemoteSdkBundle.message("config.name.remote.host", new Object[0]));
        return config;
    }

    public static boolean testConnection(@NotNull Component component, RemoteSdkCredentials data, boolean reportOnSuccess) {
        String error;
        if (component == null) {
            RemoteSdkUtil.$$$reportNull$$$0(23);
        }
        CredentialsDeployable config = RemoteSdkUtil.createDeployable((RemoteCredentials)data);
        String title = WDBundle.message((String)"test.connection", (Object[])new Object[]{config.getAccessType().getTitle()});
        String validationInfo = config.validateFast();
        if (validationInfo != null) {
            error = validationInfo;
        } else {
            try {
                error = RemoteSdkUtil.testConnectionAndCreateHelpersPath(null, data, title) ? null : RemoteSdkBundle.message("error.text.connection.failed", new Object[0]);
            }
            catch (FileSystemException e) {
                error = StringUtil.capitalize((String)PublishUtils.getMessage((Throwable)e, (boolean)false));
            }
            catch (RemoteCancelledException e) {
                error = RemoteSdkBundle.message("error.text.connection.was.cancelled", new Object[0]);
            }
        }
        if (error == null) {
            if (reportOnSuccess) {
                Messages.showInfoMessage((Component)component, (String)WDBundle.message((String)"connection.to.successful", (Object[])new Object[]{data.getHost()}), (String)title);
            }
            return true;
        }
        Messages.showErrorDialog((Component)component, (String)WDBundle.message((String)"connection.to.failed", (Object[])new Object[]{data.getHost(), error}), (String)title);
        return false;
    }

    public static boolean testConnection(@NotNull Component component, @Nullable RemoteCredentials data, boolean reportOnSuccess) {
        if (component == null) {
            RemoteSdkUtil.$$$reportNull$$$0(24);
        }
        if (data == null) {
            return false;
        }
        CredentialsDeployable config = RemoteSdkUtil.createDeployable(data);
        String title = WDBundle.message((String)"test.connection", (Object[])new Object[]{config.getAccessType().getTitle()});
        String validationInfo = config.validateFast();
        Object error = validationInfo != null ? validationInfo : (RemoteSdkUtil.testConnection(null, data) ? null : "");
        if (error == null) {
            if (reportOnSuccess) {
                UIUtil.invokeLaterIfNeeded(() -> Messages.showInfoMessage((Component)component, (String)WDBundle.message((String)"connection.to.successful", (Object[])new Object[]{data.getHost()}), (String)title));
            }
            return true;
        }
        UIUtil.invokeLaterIfNeeded(() -> RemoteSdkUtil.lambda$testConnection$4(component, data, (String)error, title));
        return false;
    }

    public static ServerBrowserDialog showBrowseRemoteDialog(@NotNull @NlsContexts.DialogTitle String title, @NotNull JTextField field, boolean foldersOnly, @NotNull Deployable deployable) {
        if (title == null) {
            RemoteSdkUtil.$$$reportNull$$$0(25);
        }
        if (field == null) {
            RemoteSdkUtil.$$$reportNull$$$0(26);
        }
        if (deployable == null) {
            RemoteSdkUtil.$$$reportNull$$$0(27);
        }
        WebServerConfig.RemotePath initialPath = new WebServerConfig.RemotePath(field.getText());
        @Nullable Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)field));
        ServerBrowserDialog d = project != null ? new ServerBrowserDialog(project, deployable, title, foldersOnly, FileTransferConfig.Origin.Default, initialPath) : new ServerBrowserDialog((Component)field, deployable, title, foldersOnly, FileTransferConfig.Origin.Default, initialPath);
        d.show();
        return d;
    }

    @NotNull
    public static RemoteTransfer.HelpersTransferConfig newHelpersTransferConfigFromRemoteCredentials(final @NotNull RemoteSdkCredentials myRemoteSdkCredentials) {
        if (myRemoteSdkCredentials == null) {
            RemoteSdkUtil.$$$reportNull$$$0(28);
        }
        return new RemoteTransfer.HelpersTransferConfig(){

            @Override
            @NotNull
            public String getHelpersPath() {
                String string = myRemoteSdkCredentials.getHelpersPath();
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public void createFileTransferConfig(@NotNull CredentialsDeployable deployable) {
                if (deployable == null) {
                    3.$$$reportNull$$$0(1);
                }
                deployable.resetCredentials(myRemoteSdkCredentials);
            }

            @Override
            public boolean isHelpersVersionChecked() {
                return myRemoteSdkCredentials.isHelpersVersionChecked();
            }

            @Override
            public void setHelpersVersionChecked(boolean checked) {
                myRemoteSdkCredentials.setHelpersVersionChecked(checked);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "deployable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHelpersPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "createFileTransferConfig";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public static ProcessOutput getProcessOutput(@Nullable Project project, @NotNull RemoteSdkCredentials data, @NonNls GeneralCommandLine command) throws RemoteSdkException {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(29);
        }
        ConnectionBuilder connectionBuilder2 = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data, (Project)project);
        RemoteSdkSessionUtil.checkConnectionInBackground(connectionBuilder2);
        SshExecProcess process2 = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder2, (GeneralCommandLine)command).withChangeDir(false).withAllocatePty(false).start();
        CapturingSshProcessHandler processHandler = new CapturingSshProcessHandler((SshProcess)process2, null, command.getCommandLineString());
        ProcessOutput processOutput = processHandler.runProcess();
        if (processOutput == null) {
            RemoteSdkUtil.$$$reportNull$$$0(30);
        }
        return processOutput;
    }

    @Nullable
    public static String chooseRemoteFile(@NotNull Project project, @NotNull RemoteCredentials credentials, boolean foldersOnly) {
        WebServerConfig.RemotePath path;
        if (project == null) {
            RemoteSdkUtil.$$$reportNull$$$0(31);
        }
        if (credentials == null) {
            RemoteSdkUtil.$$$reportNull$$$0(32);
        }
        CredentialsDeployable deployable = RemoteSdkUtil.createDeployable(credentials);
        ServerBrowserDialog d = new ServerBrowserDialog(project, (Deployable)deployable, RemoteSdkBundle.message("dialog.title.choose.remote.path", new Object[0]), foldersOnly, FileTransferConfig.Origin.Default, null);
        d.show();
        if (d.isOK() && (path = d.getPath()) != null) {
            return path.path;
        }
        return null;
    }

    public static void updateSshConfigData(@Nullable SdkAdditionalData additionalData, final @NotNull SshConfigManager manager) {
        if (manager == null) {
            RemoteSdkUtil.$$$reportNull$$$0(33);
        }
        if (!(additionalData instanceof RemoteSdkAdditionalData)) {
            return;
        }
        ((RemoteSdkAdditionalData)additionalData).switchOnConnectionType(new CredentialsCase[]{new CredentialsCase<SshConfigCredentialsHolder>(){

            public CredentialsType<SshConfigCredentialsHolder> getType() {
                return SshConfigCredentialsType.getInstance();
            }

            public void process(SshConfigCredentialsHolder credentials) {
                PresentableId presentableId = credentials.getSshId();
                if (presentableId == null || !presentableId.hasId()) {
                    return;
                }
                SshUiData data = manager.findCurrentDataById(presentableId.getId());
                credentials.setSshId(data == null ? presentableId : data.getConfig().createPresentableId());
            }
        }});
    }

    public static void fullyLoadCredentials(@NotNull SdkAdditionalData data, final @Nullable Project project) {
        if (data == null) {
            RemoteSdkUtil.$$$reportNull$$$0(34);
        }
        if (!(data instanceof RemoteSdkAdditionalData)) {
            return;
        }
        ((RemoteSdkAdditionalData)data).switchOnConnectionType(new CredentialsCase[]{new CredentialsCase<SshConfigCredentialsHolder>(){

            public CredentialsType<SshConfigCredentialsHolder> getType() {
                return SshConfigCredentialsType.getInstance();
            }

            public void process(SshConfigCredentialsHolder credentials) {
                if (credentials.getSshId() == null || credentials.getSshId().getId() != null || credentials.getSshId().getName() == null) {
                    return;
                }
                SshConfig config = SshConfigManager.getInstance((Project)project).getConfigFromInitialMappingNameToId(credentials.getSshId().getName());
                if (config != null) {
                    credentials.setSshId(config.createPresentableId());
                }
            }
        }});
    }

    public static boolean isSshCredentialType(CredentialsType<?> type) {
        return type == SshCredentialsType.getInstance() || type == SshConfigCredentialsType.getInstance() || type == WebDeploymentCredentialsType.getInstance();
    }

    public static boolean isSshOrVagrantCredentialType(CredentialsType<?> type) {
        return type == VagrantCredentialsType.getInstance() || RemoteSdkUtil.isSshCredentialType(type);
    }

    private static /* synthetic */ void lambda$testConnection$4(Component component, RemoteCredentials data, String error, String title) {
        Messages.showErrorDialog((Component)component, (String)WDBundle.message((String)"connection.to.failed", (Object[])new Object[]{data.getHost(), error}), (String)title);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 21: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 5: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCredentials";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sftpChannel";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionOwner";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myRemoteSdkCredentials";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteSdkUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSftpServerList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSshConfigList";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFromRemoteCredentials";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDataPassword";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMemoryOnly";
                break;
            }
            case 4: 
            case 5: 
            case 30: {
                break;
            }
            case 6: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "testConnectionAndCreateHelpersPath";
                break;
            }
            case 7: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "testConnection";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "testConnectionFromEDT";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "testConnectionFromNonEDT";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doTestConnection";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkInterpreterAndCreateHelpersDir";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "ensureCanWriteFile";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "showBrowseRemoteDialog";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "newHelpersTransferConfigFromRemoteCredentials";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "chooseRemoteFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "updateSshConfigData";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "fullyLoadCredentials";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

