/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteMappingsListener;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.SwingHelper;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.ui.RemoteMappingsHolder;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteMappingsField
extends RemoteMappingsHolder {
    private final TextFieldWithBrowseButton myField;
    @NotNull
    @Nls
    private String myText;
    private final ZipperUpdater myUpdater;
    private final Runnable myTextUpdater;
    private int myPreviousWidth;

    public RemoteMappingsField(@NotNull Project project, String interpreterKindPrefix, @NotNull Consumer<String> errorConsumer, @NotNull Disposable disposable) {
        if (project == null) {
            RemoteMappingsField.$$$reportNull$$$0(0);
        }
        if (errorConsumer == null) {
            RemoteMappingsField.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            RemoteMappingsField.$$$reportNull$$$0(2);
        }
        super(project, interpreterKindPrefix, errorConsumer);
        this.myText = "";
        this.myPreviousWidth = -1;
        this.myTextUpdater = () -> this.recalculateVisibleText();
        this.myUpdater = new ZipperUpdater(300, Alarm.ThreadToUse.SWING_THREAD, disposable);
        this.myField = this.createField();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(disposable);
        connection.subscribe(RemoteMappingsListener.REMOTE_MAPPINGS_CHANGED, (Object)new RemoteMappingsListener(){

            public void mappingsChanged(@NotNull String prefix, @NotNull String serverId) {
                if (prefix == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (serverId == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!serverId.equals(RemoteMappingsField.this.myServerId) || !prefix.equals(RemoteMappingsField.this.myInterpreterKindPrefix)) {
                    return;
                }
                if (RemoteMappingsField.this.myServerId != null && RemoteMappingsField.this.mySdkAdditionalData != null) {
                    RemoteMappingsField.this.updateServerId(RemoteMappingsField.this.myServerId, RemoteMappingsField.this.mySdkAdditionalData);
                }
            }

            public void mappingsChanged() {
                if (RemoteMappingsField.this.myServerId != null && RemoteMappingsField.this.mySdkAdditionalData != null) {
                    RemoteMappingsField.this.updateServerId(RemoteMappingsField.this.myServerId, RemoteMappingsField.this.mySdkAdditionalData);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "serverId";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsField$1";
                objectArray[2] = "mappingsChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public TextFieldWithBrowseButton getField() {
        return this.myField;
    }

    public void clearAndHide() {
        this.clearAndShowDisabled(null, null);
        this.myField.setVisible(false);
    }

    @Override
    protected void setToolTipText(@Nls String toolTipText) {
        ((JTextField)this.myField.getChildComponent()).setToolTipText(toolTipText);
    }

    @Override
    protected void setVisible(boolean visible) {
        this.myField.setVisible(visible);
    }

    @Override
    protected void setEnabled(boolean enabled) {
        this.myField.setEnabled(enabled);
    }

    @Override
    protected void updatePresentation(@Nullable @Nls String text) {
        this.myText = StringUtil.notNullize((String)text, (String)RemoteSdkBundle.message("remote.mappings.field.placeholder", new Object[0]));
        this.myPreviousWidth = -1;
        this.myUpdater.queue(this.myTextUpdater, false, true);
    }

    private void recalculateVisibleText() {
        int width = ((JTextField)this.myField.getChildComponent()).getWidth();
        if (this.myPreviousWidth == width) {
            return;
        }
        this.myPreviousWidth = width;
        if (width == 0) {
            this.myField.setText(this.myText);
        }
        FontMetrics metrics = this.myField.getFontMetrics(this.myField.getFont());
        String truncated = SwingHelper.truncateStringWithEllipsis((String)this.myText, (int)width, (FontMetrics)metrics);
        this.myField.setText(truncated);
    }

    private TextFieldWithBrowseButton createField() {
        TextFieldWithBrowseButton field = new TextFieldWithBrowseButton();
        field.setEditable(false);
        field.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteMappingsField.this.editPathMappings();
            }
        });
        ((JTextField)field.getChildComponent()).setHorizontalAlignment(10);
        ((JTextField)field.getChildComponent()).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                RemoteMappingsField.this.myUpdater.queue(RemoteMappingsField.this.myTextUpdater, false, true);
            }
        });
        return field;
    }

    @Override
    protected String getPresentation() {
        return this.myField.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "errorConsumer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "disposable";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsField";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

