/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.ExecutableFileFormatUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class CidrOSProcessUtil {
    private static final Logger LOG = Logger.getInstance(CidrOSProcessUtil.class);

    @NotNull
    public static ArchitectureType getProcessArchitectureType(int pid) {
        if (SystemInfo.isWindows) {
            return CidrOSProcessUtil.getWindowsProcessArchitectureType(pid);
        }
        if (SystemInfo.isLinux) {
            return CidrOSProcessUtil.getLinuxProcessArchitectureType(pid);
        }
        throw new IllegalStateException("getProcessArchitectureType() is not implemented for macOS processes");
    }

    @NotNull
    public static ArchitectureType getLinuxProcessArchitectureType(int pid) {
        ArchitectureType architectureType;
        if (!SystemInfo.isLinux) {
            throw new IllegalStateException(System.getProperty("os.name") + " is not supported");
        }
        try {
            architectureType = ExecutableFileFormatUtil.readElfMachineType("/proc/" + pid + "/exe");
        }
        catch (IOException e) {
            LOG.warn("Couldn't get executable information of process: pid=" + pid, (Throwable)e);
            ArchitectureType architectureType2 = ArchitectureType.UNKNOWN;
            if (architectureType2 == null) {
                CidrOSProcessUtil.$$$reportNull$$$0(1);
            }
            return architectureType2;
        }
        if (architectureType == null) {
            CidrOSProcessUtil.$$$reportNull$$$0(0);
        }
        return architectureType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ArchitectureType getWindowsProcessArchitectureType(int pid) {
        IntByReference isWow64Ref;
        block7: {
            ArchitectureType architectureType;
            WinNT.HANDLE hProcess = Kernel32.INSTANCE.OpenProcess(4096, false, pid);
            if (hProcess == WinBase.INVALID_HANDLE_VALUE) {
                ArchitectureType architectureType2 = ArchitectureType.UNKNOWN;
                if (architectureType2 == null) {
                    CidrOSProcessUtil.$$$reportNull$$$0(2);
                }
                return architectureType2;
            }
            isWow64Ref = new IntByReference(0);
            try {
                if (Kernel32.INSTANCE.IsWow64Process(hProcess, isWow64Ref)) break block7;
                ArchitectureType architectureType3 = ArchitectureType.UNKNOWN;
                architectureType = architectureType3;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                break block7;
            }
            finally {
                Kernel32.INSTANCE.CloseHandle(hProcess);
            }
            if (architectureType == null) {
                CidrOSProcessUtil.$$$reportNull$$$0(3);
            }
            return architectureType;
        }
        boolean isWow64 = isWow64Ref.getValue() == 1;
        return isWow64 ? ArchitectureType.I386 : CidrOSProcessUtil.getWindowsArch();
    }

    @NotNull
    private static ArchitectureType getWindowsArch() {
        WinBase.SYSTEM_INFO systemInfo = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetNativeSystemInfo(systemInfo);
        int processorArchitecture = systemInfo.processorArchitecture.dwOemID.getLow().intValue();
        if (processorArchitecture == 0) {
            ArchitectureType architectureType = ArchitectureType.I386;
            if (architectureType == null) {
                CidrOSProcessUtil.$$$reportNull$$$0(4);
            }
            return architectureType;
        }
        if (processorArchitecture == 9) {
            ArchitectureType architectureType = ArchitectureType.X86_64;
            if (architectureType == null) {
                CidrOSProcessUtil.$$$reportNull$$$0(5);
            }
            return architectureType;
        }
        if (processorArchitecture == 5) {
            ArchitectureType architectureType = ArchitectureType.ARM;
            if (architectureType == null) {
                CidrOSProcessUtil.$$$reportNull$$$0(6);
            }
            return architectureType;
        }
        if (processorArchitecture == 12) {
            ArchitectureType architectureType = ArchitectureType.ARM64;
            if (architectureType == null) {
                CidrOSProcessUtil.$$$reportNull$$$0(7);
            }
            return architectureType;
        }
        ArchitectureType architectureType = ArchitectureType.UNKNOWN;
        if (architectureType == null) {
            CidrOSProcessUtil.$$$reportNull$$$0(8);
        }
        return architectureType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/cidr/execution/CidrOSProcessUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinuxProcessArchitectureType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowsProcessArchitectureType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowsArch";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

